# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationApplicationLogConfig',
    'ApplicationDriverShapeConfig',
    'ApplicationExecutorShapeConfig',
    'ApplicationParameter',
    'InvokeRunApplicationLogConfig',
    'InvokeRunDriverShapeConfig',
    'InvokeRunExecutorShapeConfig',
    'InvokeRunParameter',
    'PoolConfiguration',
    'PoolConfigurationShapeConfig',
    'PoolPoolMetric',
    'PoolPoolMetricActivelyUsedNodeCount',
    'PoolSchedule',
    'PrivateEndpointScanDetail',
    'RunStatementOutput',
    'RunStatementOutputData',
    'SqlEndpointDriverShapeConfig',
    'SqlEndpointExecutorShapeConfig',
    'SqlEndpointNetworkConfiguration',
    'SqlEndpointNetworkConfigurationAccessControlRule',
    'GetApplicationApplicationLogConfigResult',
    'GetApplicationDriverShapeConfigResult',
    'GetApplicationExecutorShapeConfigResult',
    'GetApplicationParameterResult',
    'GetApplicationsApplicationResult',
    'GetApplicationsApplicationApplicationLogConfigResult',
    'GetApplicationsApplicationDriverShapeConfigResult',
    'GetApplicationsApplicationExecutorShapeConfigResult',
    'GetApplicationsApplicationParameterResult',
    'GetApplicationsFilterResult',
    'GetInvokeRunApplicationLogConfigResult',
    'GetInvokeRunDriverShapeConfigResult',
    'GetInvokeRunExecutorShapeConfigResult',
    'GetInvokeRunParameterResult',
    'GetInvokeRunsFilterResult',
    'GetInvokeRunsRunResult',
    'GetInvokeRunsRunApplicationLogConfigResult',
    'GetInvokeRunsRunDriverShapeConfigResult',
    'GetInvokeRunsRunExecutorShapeConfigResult',
    'GetInvokeRunsRunParameterResult',
    'GetPoolConfigurationResult',
    'GetPoolConfigurationShapeConfigResult',
    'GetPoolPoolMetricResult',
    'GetPoolPoolMetricActivelyUsedNodeCountResult',
    'GetPoolScheduleResult',
    'GetPoolsFilterResult',
    'GetPoolsPoolCollectionResult',
    'GetPoolsPoolCollectionItemResult',
    'GetPoolsPoolCollectionItemConfigurationResult',
    'GetPoolsPoolCollectionItemConfigurationShapeConfigResult',
    'GetPoolsPoolCollectionItemPoolMetricResult',
    'GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult',
    'GetPoolsPoolCollectionItemScheduleResult',
    'GetPrivateEndpointScanDetailResult',
    'GetPrivateEndpointsFilterResult',
    'GetPrivateEndpointsPrivateEndpointCollectionResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult',
    'GetRunLogsFilterResult',
    'GetRunLogsRunLogResult',
    'GetRunStatementOutputResult',
    'GetRunStatementOutputDataResult',
    'GetRunStatementsFilterResult',
    'GetRunStatementsStatementCollectionResult',
    'GetRunStatementsStatementCollectionItemResult',
    'GetRunStatementsStatementCollectionItemOutputResult',
    'GetRunStatementsStatementCollectionItemOutputDataResult',
    'GetSqlEndpointDriverShapeConfigResult',
    'GetSqlEndpointExecutorShapeConfigResult',
    'GetSqlEndpointNetworkConfigurationResult',
    'GetSqlEndpointNetworkConfigurationAccessControlRuleResult',
    'GetSqlEndpointsFilterResult',
    'GetSqlEndpointsSqlEndpointCollectionResult',
    'GetSqlEndpointsSqlEndpointCollectionItemResult',
    'GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult',
]

@pulumi.output_type
class ApplicationApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: (Updatable) The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class ApplicationDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InvokeRunApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class InvokeRunDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PoolConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shapeConfig":
            suggest = "shape_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max: Optional[_builtins.int] = None,
                 min: Optional[_builtins.int] = None,
                 shape: Optional[_builtins.str] = None,
                 shape_config: Optional['outputs.PoolConfigurationShapeConfig'] = None):
        """
        :param _builtins.int max: (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        :param _builtins.int min: (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        :param _builtins.str shape: (Updatable) The compute shape of the resources you would like to provision.
        :param 'PoolConfigurationShapeConfigArgs' shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.int]:
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.int]:
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[_builtins.str]:
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional['outputs.PoolConfigurationShapeConfig']:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_config")


@pulumi.output_type
class PoolConfigurationShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfigurationShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class PoolPoolMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRunsCount":
            suggest = "active_runs_count"
        elif key == "activelyUsedNodeCounts":
            suggest = "actively_used_node_counts"
        elif key == "timeLastMetricsUpdated":
            suggest = "time_last_metrics_updated"
        elif key == "timeLastStarted":
            suggest = "time_last_started"
        elif key == "timeLastStopped":
            suggest = "time_last_stopped"
        elif key == "timeLastUsed":
            suggest = "time_last_used"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_runs_count: Optional[_builtins.str] = None,
                 actively_used_node_counts: Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']] = None,
                 time_last_metrics_updated: Optional[_builtins.str] = None,
                 time_last_started: Optional[_builtins.str] = None,
                 time_last_stopped: Optional[_builtins.str] = None,
                 time_last_used: Optional[_builtins.str] = None):
        """
        :param _builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['PoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param _builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param _builtins.str time_last_started: The last time this pool was started.
        :param _builtins.str time_last_stopped: The last time this pool was stopped.
        :param _builtins.str time_last_used: The last time a run used this pool.
        """
        if active_runs_count is not None:
            pulumi.set(__self__, "active_runs_count", active_runs_count)
        if actively_used_node_counts is not None:
            pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        if time_last_metrics_updated is not None:
            pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        if time_last_started is not None:
            pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped is not None:
            pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_last_used is not None:
            pulumi.set(__self__, "time_last_used", time_last_used)

    @_builtins.property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> Optional[_builtins.str]:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @_builtins.property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']]:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @_builtins.property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> Optional[_builtins.str]:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @_builtins.property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[_builtins.str]:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @_builtins.property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[_builtins.str]:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[_builtins.str]:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class PoolPoolMetricActivelyUsedNodeCount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicalShape":
            suggest = "logical_shape"
        elif key == "poolCount":
            suggest = "pool_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetricActivelyUsedNodeCount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logical_shape: Optional[_builtins.str] = None,
                 pool_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param _builtins.int pool_count: The node count of this compute shape.
        """
        if logical_shape is not None:
            pulumi.set(__self__, "logical_shape", logical_shape)
        if pool_count is not None:
            pulumi.set(__self__, "pool_count", pool_count)

    @_builtins.property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> Optional[_builtins.str]:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @_builtins.property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[_builtins.int]:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class PoolSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "stopTime":
            suggest = "stop_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.int] = None,
                 stop_time: Optional[_builtins.int] = None):
        """
        :param _builtins.str day_of_week: (Updatable) Day of the week SUN-SAT
        :param _builtins.int start_time: (Updatable) Hour of the day to start or stop pool.
        :param _builtins.int stop_time: (Updatable) Hour of the day to stop the pool.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if stop_time is not None:
            pulumi.set(__self__, "stop_time", stop_time)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[_builtins.str]:
        """
        (Updatable) Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.int]:
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[_builtins.int]:
        """
        (Updatable) Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class PrivateEndpointScanDetail(dict):
    def __init__(__self__, *,
                 fqdn: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None):
        """
        :param _builtins.str fqdn: (Updatable) A fully-qualified domain name (FQDN).
        :param _builtins.str port: (Updatable) The port number of the FQDN
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        (Updatable) The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RunStatementOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorName":
            suggest = "error_name"
        elif key == "errorValue":
            suggest = "error_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunStatementOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datas: Optional[Sequence['outputs.RunStatementOutputData']] = None,
                 error_name: Optional[_builtins.str] = None,
                 error_value: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 tracebacks: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['RunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param _builtins.str error_name: The name of the error in the statement output.
        :param _builtins.str error_value: The value of the error in the statement output.
        :param _builtins.str status: Status of the statement output.
        :param Sequence[_builtins.str] tracebacks: The traceback of the statement output.
        """
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if error_name is not None:
            pulumi.set(__self__, "error_name", error_name)
        if error_value is not None:
            pulumi.set(__self__, "error_value", error_value)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tracebacks is not None:
            pulumi.set(__self__, "tracebacks", tracebacks)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.RunStatementOutputData']]:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="errorName")
    def error_name(self) -> Optional[_builtins.str]:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @_builtins.property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> Optional[_builtins.str]:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tracebacks(self) -> Optional[Sequence[_builtins.str]]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class RunStatementOutputData(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param _builtins.str value: The statement code execution output in html format.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SqlEndpointDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[_builtins.float] = None,
                 ocpus: Optional[_builtins.float] = None):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[_builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> Optional[_builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkType":
            suggest = "network_type"
        elif key == "accessControlRules":
            suggest = "access_control_rules"
        elif key == "hostNamePrefix":
            suggest = "host_name_prefix"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "publicEndpointIp":
            suggest = "public_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_type: _builtins.str,
                 access_control_rules: Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']] = None,
                 host_name_prefix: Optional[_builtins.str] = None,
                 nsg_ids: Optional[Sequence[_builtins.str]] = None,
                 private_endpoint_ip: Optional[_builtins.str] = None,
                 public_endpoint_ip: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 vcn_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str network_type: The type of network configuration.
        :param Sequence['SqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param _builtins.str host_name_prefix: The host name prefix.
        :param Sequence[_builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param _builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param _builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param _builtins.str subnet_id: The VCN Subnet OCID.
        :param _builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "network_type", network_type)
        if access_control_rules is not None:
            pulumi.set(__self__, "access_control_rules", access_control_rules)
        if host_name_prefix is not None:
            pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if public_endpoint_ip is not None:
            pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']]:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @_builtins.property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[_builtins.str]:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[_builtins.str]:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> Optional[_builtins.str]:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[_builtins.str]:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class SqlEndpointNetworkConfigurationAccessControlRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipNotation":
            suggest = "ip_notation"
        elif key == "vcnIps":
            suggest = "vcn_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfigurationAccessControlRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_notation: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 vcn_ips: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_notation: The type of IP notation.
        :param _builtins.str value: The associated value of the selected IP notation.
        :param _builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        if ip_notation is not None:
            pulumi.set(__self__, "ip_notation", ip_notation)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vcn_ips is not None:
            pulumi.set(__self__, "vcn_ips", vcn_ips)

    @_builtins.property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> Optional[_builtins.str]:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> Optional[_builtins.str]:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 application_log_configs: Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult'],
                 archive_uri: _builtins.str,
                 arguments: Sequence[_builtins.str],
                 class_name: _builtins.str,
                 compartment_id: _builtins.str,
                 configuration: Mapping[str, _builtins.str],
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 driver_shape: _builtins.str,
                 driver_shape_configs: Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult'],
                 execute: _builtins.str,
                 executor_shape: _builtins.str,
                 executor_shape_configs: Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult'],
                 file_uri: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 idle_timeout_in_minutes: _builtins.str,
                 language: _builtins.str,
                 logs_bucket_uri: _builtins.str,
                 max_duration_in_minutes: _builtins.str,
                 metastore_id: _builtins.str,
                 num_executors: _builtins.int,
                 owner_principal_id: _builtins.str,
                 owner_user_name: _builtins.str,
                 parameters: Sequence['outputs.GetApplicationsApplicationParameterResult'],
                 pool_id: _builtins.str,
                 private_endpoint_id: _builtins.str,
                 spark_version: _builtins.str,
                 state: _builtins.str,
                 terminate_runs_on_deletion: _builtins.bool,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str,
                 warehouse_bucket_uri: _builtins.str):
        """
        :param Sequence['GetApplicationsApplicationApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param _builtins.str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[_builtins.str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param _builtins.str class_name: The class for the application.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: A user-friendly description.
        :param _builtins.str display_name: The query parameter for the Spark application name.
        :param _builtins.str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetApplicationsApplicationDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param _builtins.str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param _builtins.str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetApplicationsApplicationExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param _builtins.str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The application ID.
        :param _builtins.str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param _builtins.str language: The Spark language.
        :param _builtins.str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param _builtins.str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param _builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param _builtins.int num_executors: The number of executor VMs requested.
        :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param _builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetApplicationsApplicationParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param _builtins.str pool_id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param _builtins.str private_endpoint_id: The OCID of a private endpoint.
        :param _builtins.str spark_version: The Spark version utilized to run the application.
        :param _builtins.str state: The current state of this application.
        :param _builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str type: The Spark application processing type.
        :param _builtins.str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        pulumi.set(__self__, "application_log_configs", application_log_configs)
        pulumi.set(__self__, "archive_uri", archive_uri)
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "execute", execute)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "file_uri", file_uri)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "num_executors", num_executors)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "spark_version", spark_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "terminate_runs_on_deletion", terminate_runs_on_deletion)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @_builtins.property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @_builtins.property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> _builtins.str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Sequence[_builtins.str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter(name="className")
    def class_name(self) -> _builtins.str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Mapping[str, _builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-friendly description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> _builtins.str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @_builtins.property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @_builtins.property
    @pulumi.getter
    def execute(self) -> _builtins.str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @_builtins.property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> _builtins.str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @_builtins.property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @_builtins.property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The application ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @_builtins.property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> _builtins.str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> _builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> _builtins.int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> _builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> _builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetApplicationsApplicationParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> _builtins.str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="terminateRunsOnDeletion")
    def terminate_runs_on_deletion(self) -> _builtins.bool:
        return pulumi.get(self, "terminate_runs_on_deletion")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetApplicationsApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationsApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunParameterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInvokeRunsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunsRunResult(dict):
    def __init__(__self__, *,
                 application_id: _builtins.str,
                 application_log_configs: Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult'],
                 archive_uri: _builtins.str,
                 arguments: Sequence[_builtins.str],
                 asynchronous: _builtins.bool,
                 class_name: _builtins.str,
                 compartment_id: _builtins.str,
                 configuration: Mapping[str, _builtins.str],
                 data_read_in_bytes: _builtins.str,
                 data_written_in_bytes: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 driver_shape: _builtins.str,
                 driver_shape_configs: Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult'],
                 execute: _builtins.str,
                 executor_shape: _builtins.str,
                 executor_shape_configs: Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult'],
                 file_uri: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 idle_timeout_in_minutes: _builtins.str,
                 language: _builtins.str,
                 lifecycle_details: _builtins.str,
                 logs_bucket_uri: _builtins.str,
                 max_duration_in_minutes: _builtins.str,
                 metastore_id: _builtins.str,
                 num_executors: _builtins.int,
                 opc_parent_rpt_url: _builtins.str,
                 opc_request_id: _builtins.str,
                 owner_principal_id: _builtins.str,
                 owner_user_name: _builtins.str,
                 parameters: Sequence['outputs.GetInvokeRunsRunParameterResult'],
                 pool_id: _builtins.str,
                 private_endpoint_dns_zones: Sequence[_builtins.str],
                 private_endpoint_id: _builtins.str,
                 private_endpoint_max_host_count: _builtins.int,
                 private_endpoint_nsg_ids: Sequence[_builtins.str],
                 private_endpoint_subnet_id: _builtins.str,
                 run_duration_in_milliseconds: _builtins.str,
                 spark_version: _builtins.str,
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 total_ocpu: _builtins.int,
                 type: _builtins.str,
                 warehouse_bucket_uri: _builtins.str):
        """
        :param _builtins.str application_id: The ID of the application.
        :param Sequence['GetInvokeRunsRunApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param _builtins.str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[_builtins.str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param _builtins.str class_name: The class for the application.
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param _builtins.str data_read_in_bytes: The data read by the run in bytes.
        :param _builtins.str data_written_in_bytes: The data written by the run in bytes.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: The query parameter for the Spark application name.
        :param _builtins.str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetInvokeRunsRunDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param _builtins.str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param _builtins.str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetInvokeRunsRunExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param _builtins.str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The ID of a run.
        :param _builtins.str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param _builtins.str language: The Spark language.
        :param _builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param _builtins.str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param _builtins.str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param _builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param _builtins.int num_executors: The number of executor VMs requested.
        :param _builtins.str opc_request_id: Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param _builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetInvokeRunsRunParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param _builtins.str pool_id: The ID of the pool.
        :param Sequence[_builtins.str] private_endpoint_dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param _builtins.str private_endpoint_id: The OCID of a private endpoint.
        :param _builtins.int private_endpoint_max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[_builtins.str] private_endpoint_nsg_ids: An array of network security group OCIDs.
        :param _builtins.str private_endpoint_subnet_id: The OCID of a subnet.
        :param _builtins.str run_duration_in_milliseconds: The duration of the run in milliseconds.
        :param _builtins.str spark_version: The Spark version utilized to run the application.
        :param _builtins.str state: The LifecycleState of the run.
        :param _builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.int total_ocpu: The total number of oCPU requested by the run.
        :param _builtins.str type: The Spark application processing type.
        :param _builtins.str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_log_configs", application_log_configs)
        pulumi.set(__self__, "archive_uri", archive_uri)
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "asynchronous", asynchronous)
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "data_read_in_bytes", data_read_in_bytes)
        pulumi.set(__self__, "data_written_in_bytes", data_written_in_bytes)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "execute", execute)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "file_uri", file_uri)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "num_executors", num_executors)
        pulumi.set(__self__, "opc_parent_rpt_url", opc_parent_rpt_url)
        pulumi.set(__self__, "opc_request_id", opc_request_id)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "private_endpoint_dns_zones", private_endpoint_dns_zones)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "private_endpoint_max_host_count", private_endpoint_max_host_count)
        pulumi.set(__self__, "private_endpoint_nsg_ids", private_endpoint_nsg_ids)
        pulumi.set(__self__, "private_endpoint_subnet_id", private_endpoint_subnet_id)
        pulumi.set(__self__, "run_duration_in_milliseconds", run_duration_in_milliseconds)
        pulumi.set(__self__, "spark_version", spark_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_ocpu", total_ocpu)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        The ID of the application.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @_builtins.property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> _builtins.str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Sequence[_builtins.str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter
    def asynchronous(self) -> _builtins.bool:
        return pulumi.get(self, "asynchronous")

    @_builtins.property
    @pulumi.getter(name="className")
    def class_name(self) -> _builtins.str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Mapping[str, _builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="dataReadInBytes")
    def data_read_in_bytes(self) -> _builtins.str:
        """
        The data read by the run in bytes.
        """
        return pulumi.get(self, "data_read_in_bytes")

    @_builtins.property
    @pulumi.getter(name="dataWrittenInBytes")
    def data_written_in_bytes(self) -> _builtins.str:
        """
        The data written by the run in bytes.
        """
        return pulumi.get(self, "data_written_in_bytes")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> _builtins.str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @_builtins.property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @_builtins.property
    @pulumi.getter
    def execute(self) -> _builtins.str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @_builtins.property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> _builtins.str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @_builtins.property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @_builtins.property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of a run.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @_builtins.property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> _builtins.str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> _builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> _builtins.int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @_builtins.property
    @pulumi.getter(name="opcParentRptUrl")
    def opc_parent_rpt_url(self) -> _builtins.str:
        return pulumi.get(self, "opc_parent_rpt_url")

    @_builtins.property
    @pulumi.getter(name="opcRequestId")
    def opc_request_id(self) -> _builtins.str:
        """
        Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        """
        return pulumi.get(self, "opc_request_id")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> _builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> _builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetInvokeRunsRunParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="privateEndpointDnsZones")
    def private_endpoint_dns_zones(self) -> Sequence[_builtins.str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "private_endpoint_dns_zones")

    @_builtins.property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> _builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="privateEndpointMaxHostCount")
    def private_endpoint_max_host_count(self) -> _builtins.int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "private_endpoint_max_host_count")

    @_builtins.property
    @pulumi.getter(name="privateEndpointNsgIds")
    def private_endpoint_nsg_ids(self) -> Sequence[_builtins.str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "private_endpoint_nsg_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointSubnetId")
    def private_endpoint_subnet_id(self) -> _builtins.str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "private_endpoint_subnet_id")

    @_builtins.property
    @pulumi.getter(name="runDurationInMilliseconds")
    def run_duration_in_milliseconds(self) -> _builtins.str:
        """
        The duration of the run in milliseconds.
        """
        return pulumi.get(self, "run_duration_in_milliseconds")

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> _builtins.str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the run.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="totalOcpu")
    def total_ocpu(self) -> _builtins.int:
        """
        The total number of oCPU requested by the run.
        """
        return pulumi.get(self, "total_ocpu")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> _builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetInvokeRunsRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: _builtins.str,
                 log_id: _builtins.str):
        """
        :param _builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param _builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter(name="logId")
    def log_id(self) -> _builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunsRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunParameterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param _builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPoolConfigurationResult(dict):
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int,
                 shape: _builtins.str,
                 shape_configs: Sequence['outputs.GetPoolConfigurationShapeConfigResult']):
        """
        :param _builtins.int max: Maximum number of compute instances in the pool for a given compute shape.
        :param _builtins.int min: Minimum number of compute instances in the pool for a given compute shape.
        :param _builtins.str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_configs", shape_configs)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: _builtins.str,
                 actively_used_node_counts: Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: _builtins.str,
                 time_last_started: _builtins.str,
                 time_last_stopped: _builtins.str,
                 time_last_used: _builtins.str):
        """
        :param _builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param _builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param _builtins.str time_last_started: The last time this pool was started.
        :param _builtins.str time_last_stopped: The last time this pool was stopped.
        :param _builtins.str time_last_used: The last time a run used this pool.
        """
        pulumi.set(__self__, "active_runs_count", active_runs_count)
        pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        pulumi.set(__self__, "time_last_started", time_last_started)
        pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        pulumi.set(__self__, "time_last_used", time_last_used)

    @_builtins.property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> _builtins.str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @_builtins.property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @_builtins.property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> _builtins.str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @_builtins.property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> _builtins.str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @_builtins.property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> _builtins.str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> _builtins.str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: _builtins.str,
                 pool_count: _builtins.int):
        """
        :param _builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param _builtins.int pool_count: The node count of this compute shape.
        """
        pulumi.set(__self__, "logical_shape", logical_shape)
        pulumi.set(__self__, "pool_count", pool_count)

    @_builtins.property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> _builtins.str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @_builtins.property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> _builtins.int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 start_time: _builtins.int,
                 stop_time: _builtins.int):
        """
        :param _builtins.str day_of_week: Day of the week SUN-SAT
        :param _builtins.int start_time: Hour of the day to start or stop pool.
        :param _builtins.int stop_time: Hour of the day to stop the pool.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> _builtins.int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPoolsPoolCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPoolsPoolCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPoolsPoolCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPoolsPoolCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 configurations: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 idle_timeout_in_minutes: _builtins.int,
                 lifecycle_details: _builtins.str,
                 owner_principal_id: _builtins.str,
                 owner_user_name: _builtins.str,
                 pool_metrics: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult'],
                 schedules: Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult'],
                 state: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationArgs'] configurations: List of PoolConfig items.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: A user-friendly description. Avoid entering confidential information.
        :param _builtins.str display_name: The query parameter for the Spark application name.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param _builtins.int idle_timeout_in_minutes: Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        :param _builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param _builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricArgs'] pool_metrics: A collection of metrics related to a particular pool.
        :param Sequence['GetPoolsPoolCollectionItemScheduleArgs'] schedules: A list of schedules for pool to auto start and stop.
        :param _builtins.str state: The LifecycleState of the pool.
        :param _builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "pool_metrics", pool_metrics)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult']:
        """
        List of PoolConfig items.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> _builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> _builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter(name="poolMetrics")
    def pool_metrics(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult']:
        """
        A collection of metrics related to a particular pool.
        """
        return pulumi.get(self, "pool_metrics")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult']:
        """
        A list of schedules for pool to auto start and stop.
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the pool.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationResult(dict):
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int,
                 shape: _builtins.str,
                 shape_configs: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']):
        """
        :param _builtins.int max: Maximum number of compute instances in the pool for a given compute shape.
        :param _builtins.int min: Minimum number of compute instances in the pool for a given compute shape.
        :param _builtins.str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_configs", shape_configs)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: _builtins.str,
                 actively_used_node_counts: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: _builtins.str,
                 time_last_started: _builtins.str,
                 time_last_stopped: _builtins.str,
                 time_last_used: _builtins.str):
        """
        :param _builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param _builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param _builtins.str time_last_started: The last time this pool was started.
        :param _builtins.str time_last_stopped: The last time this pool was stopped.
        :param _builtins.str time_last_used: The last time a run used this pool.
        """
        pulumi.set(__self__, "active_runs_count", active_runs_count)
        pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        pulumi.set(__self__, "time_last_started", time_last_started)
        pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        pulumi.set(__self__, "time_last_used", time_last_used)

    @_builtins.property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> _builtins.str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @_builtins.property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @_builtins.property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> _builtins.str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @_builtins.property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> _builtins.str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @_builtins.property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> _builtins.str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @_builtins.property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> _builtins.str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: _builtins.str,
                 pool_count: _builtins.int):
        """
        :param _builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param _builtins.int pool_count: The node count of this compute shape.
        """
        pulumi.set(__self__, "logical_shape", logical_shape)
        pulumi.set(__self__, "pool_count", pool_count)

    @_builtins.property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> _builtins.str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @_builtins.property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> _builtins.int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolsPoolCollectionItemScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 start_time: _builtins.int,
                 stop_time: _builtins.int):
        """
        :param _builtins.str day_of_week: Day of the week SUN-SAT
        :param _builtins.int start_time: Hour of the day to start or stop pool.
        :param _builtins.int stop_time: Hour of the day to stop the pool.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> _builtins.int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPrivateEndpointScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: _builtins.str,
                 port: _builtins.str):
        """
        :param _builtins.str fqdn: A fully-qualified domain name (FQDN).
        :param _builtins.str port: The port number of the FQDN
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 dns_zones: Sequence[_builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 max_host_count: _builtins.int,
                 nsg_ids: Sequence[_builtins.str],
                 owner_principal_id: _builtins.str,
                 owner_user_name: _builtins.str,
                 scan_details: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult'],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: A user-friendly description. Avoid entering confidential information.
        :param _builtins.str display_name: The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        :param Sequence[_builtins.str] dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of a private endpoint.
        :param _builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param _builtins.int max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[_builtins.str] nsg_ids: An array of network security group OCIDs.
        :param _builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param _builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailArgs'] scan_details: An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        :param _builtins.str state: The LifecycleState of the private endpoint.
        :param _builtins.str subnet_id: The OCID of a subnet.
        :param _builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_zones", dns_zones)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_host_count", max_host_count)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "scan_details", scan_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[_builtins.str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "dns_zones")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxHostCount")
    def max_host_count(self) -> _builtins.int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "max_host_count")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> _builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @_builtins.property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> _builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @_builtins.property
    @pulumi.getter(name="scanDetails")
    def scan_details(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult']:
        """
        An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        """
        return pulumi.get(self, "scan_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the private endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: _builtins.str,
                 port: _builtins.str):
        """
        :param _builtins.str fqdn: A fully-qualified domain name (FQDN).
        :param _builtins.str port: The port number of the FQDN
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRunLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunLogsRunLogResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 run_id: _builtins.str,
                 size_in_bytes: _builtins.str,
                 source: _builtins.str,
                 time_created: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str run_id: The unique ID for the run
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "run_id", run_id)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runId")
    def run_id(self) -> _builtins.str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> _builtins.str:
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunStatementOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementOutputDataResult'],
                 error_name: _builtins.str,
                 error_value: _builtins.str,
                 status: _builtins.str,
                 tracebacks: Sequence[_builtins.str]):
        """
        :param Sequence['GetRunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param _builtins.str error_name: The name of the error in the statement output.
        :param _builtins.str error_value: The value of the error in the statement output.
        :param _builtins.str status: Status of the statement output.
        :param Sequence[_builtins.str] tracebacks: The traceback of the statement output.
        """
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "error_name", error_name)
        pulumi.set(__self__, "error_value", error_value)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tracebacks", tracebacks)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="errorName")
    def error_name(self) -> _builtins.str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @_builtins.property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> _builtins.str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tracebacks(self) -> Sequence[_builtins.str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementOutputDataResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param _builtins.str value: The statement code execution output in html format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRunStatementsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunStatementsStatementCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRunStatementsStatementCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemResult(dict):
    def __init__(__self__, *,
                 code: _builtins.str,
                 id: _builtins.str,
                 outputs: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult'],
                 progress: _builtins.float,
                 run_id: _builtins.str,
                 state: _builtins.str,
                 time_completed: _builtins.str,
                 time_created: _builtins.str):
        """
        :param _builtins.str code: The statement code to execute. Example: `println(sc.version)`
        :param _builtins.str id: The statement ID.
        :param Sequence['GetRunStatementsStatementCollectionItemOutputArgs'] outputs: The execution output of a statement.
        :param _builtins.float progress: The execution progress.
        :param _builtins.str run_id: The unique ID for the run
        :param _builtins.str state: The LifecycleState of the statement.
        :param _builtins.str time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param _builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "outputs", outputs)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "run_id", run_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_completed", time_completed)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The statement ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def outputs(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult']:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> _builtins.float:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="runId")
    def run_id(self) -> _builtins.str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The LifecycleState of the statement.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> _builtins.str:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult'],
                 error_name: _builtins.str,
                 error_value: _builtins.str,
                 status: _builtins.str,
                 tracebacks: Sequence[_builtins.str]):
        """
        :param Sequence['GetRunStatementsStatementCollectionItemOutputDataArgs'] datas: An object representing execution output of a statement.
        :param _builtins.str error_name: The name of the error in the statement output.
        :param _builtins.str error_value: The value of the error in the statement output.
        :param _builtins.str status: Status of the statement output.
        :param Sequence[_builtins.str] tracebacks: The traceback of the statement output.
        """
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "error_name", error_name)
        pulumi.set(__self__, "error_value", error_value)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tracebacks", tracebacks)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="errorName")
    def error_name(self) -> _builtins.str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @_builtins.property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> _builtins.str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tracebacks(self) -> Sequence[_builtins.str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputDataResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param _builtins.str value: The statement code execution output in html format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSqlEndpointDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: _builtins.str,
                 network_type: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 private_endpoint_ip: _builtins.str,
                 public_endpoint_ip: _builtins.str,
                 subnet_id: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param Sequence['GetSqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param _builtins.str host_name_prefix: The host name prefix.
        :param _builtins.str network_type: The type of network configuration.
        :param Sequence[_builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param _builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param _builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param _builtins.str subnet_id: The VCN Subnet OCID.
        :param _builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "access_control_rules", access_control_rules)
        pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @_builtins.property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> _builtins.str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> _builtins.str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: _builtins.str,
                 value: _builtins.str,
                 vcn_ips: _builtins.str):
        """
        :param _builtins.str ip_notation: The type of IP notation.
        :param _builtins.str value: The associated value of the selected IP notation.
        :param _builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        pulumi.set(__self__, "ip_notation", ip_notation)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vcn_ips", vcn_ips)

    @_builtins.property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> _builtins.str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> _builtins.str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetSqlEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 driver_shape: _builtins.str,
                 driver_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult'],
                 executor_shape: _builtins.str,
                 executor_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult'],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 jdbc_endpoint_url: _builtins.str,
                 lake_id: _builtins.str,
                 max_executor_count: _builtins.int,
                 metastore_id: _builtins.str,
                 min_executor_count: _builtins.int,
                 network_configurations: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult'],
                 spark_advanced_configurations: Mapping[str, _builtins.str],
                 sql_endpoint_version: _builtins.str,
                 state: _builtins.str,
                 state_message: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 warehouse_bucket_uri: _builtins.str):
        """
        :param _builtins.str compartment_id: The OCID of the compartment in which to query resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of the SQL Endpoint.
        :param _builtins.str display_name: The query parameter for the Spark application name.
        :param _builtins.str driver_shape: The shape of the SQL Endpoint driver instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param _builtins.str executor_shape: The shape of the SQL Endpoint executor instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.str id: The provision identifier that is immutable on creation.
        :param _builtins.str jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param _builtins.str lake_id: The OCID of Oracle Cloud Infrastructure Lake.
        :param _builtins.int max_executor_count: The maximum number of executors.
        :param _builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param _builtins.int min_executor_count: The minimum number of executors.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationArgs'] network_configurations: The network configuration of a SQL Endpoint.
        :param Mapping[str, _builtins.str] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param _builtins.str sql_endpoint_version: The version of SQL Endpoint.
        :param _builtins.str state: A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        :param _builtins.str state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param Mapping[str, _builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param _builtins.str time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param _builtins.str warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "jdbc_endpoint_url", jdbc_endpoint_url)
        pulumi.set(__self__, "lake_id", lake_id)
        pulumi.set(__self__, "max_executor_count", max_executor_count)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "min_executor_count", min_executor_count)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "spark_advanced_configurations", spark_advanced_configurations)
        pulumi.set(__self__, "sql_endpoint_version", sql_endpoint_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment in which to query resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the SQL Endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> _builtins.str:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @_builtins.property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @_builtins.property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> _builtins.str:
        """
        The shape of the SQL Endpoint executor instance.
        """
        return pulumi.get(self, "executor_shape")

    @_builtins.property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provision identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> _builtins.str:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @_builtins.property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> _builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Lake.
        """
        return pulumi.get(self, "lake_id")

    @_builtins.property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> _builtins.int:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> _builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> _builtins.int:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @_builtins.property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configurations")

    @_builtins.property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Mapping[str, _builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @_builtins.property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> _builtins.str:
        """
        The version of SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> _builtins.str:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> _builtins.str:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: _builtins.float,
                 ocpus: _builtins.float):
        """
        :param _builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param _builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: _builtins.str,
                 network_type: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 private_endpoint_ip: _builtins.str,
                 public_endpoint_ip: _builtins.str,
                 subnet_id: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param _builtins.str host_name_prefix: The host name prefix.
        :param _builtins.str network_type: The type of network configuration.
        :param Sequence[_builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param _builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param _builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param _builtins.str subnet_id: The VCN Subnet OCID.
        :param _builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "access_control_rules", access_control_rules)
        pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @_builtins.property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> _builtins.str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> _builtins.str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: _builtins.str,
                 value: _builtins.str,
                 vcn_ips: _builtins.str):
        """
        :param _builtins.str ip_notation: The type of IP notation.
        :param _builtins.str value: The associated value of the selected IP notation.
        :param _builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        pulumi.set(__self__, "ip_notation", ip_notation)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vcn_ips", vcn_ips)

    @_builtins.property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> _builtins.str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> _builtins.str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


