# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceApplicationResult',
    'AwaitableGetWorkspaceApplicationResult',
    'get_workspace_application',
    'get_workspace_application_output',
]

@pulumi.output_type
class GetWorkspaceApplicationResult:
    """
    A collection of values returned by getWorkspaceApplication.
    """
    def __init__(__self__, application_key=None, application_version=None, compartment_id=None, defined_tags=None, dependent_object_metadatas=None, description=None, display_name=None, freeform_tags=None, id=None, identifier=None, key=None, key_map=None, metadatas=None, model_type=None, model_version=None, name=None, object_status=None, object_version=None, parent_reves=None, published_object_metadatas=None, registry_metadatas=None, source_application_infos=None, state=None, time_created=None, time_patched=None, time_updated=None, workspace_id=None):
        if application_key and not isinstance(application_key, str):
            raise TypeError("Expected argument 'application_key' to be a str")
        pulumi.set(__self__, "application_key", application_key)
        if application_version and not isinstance(application_version, int):
            raise TypeError("Expected argument 'application_version' to be a int")
        pulumi.set(__self__, "application_version", application_version)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if dependent_object_metadatas and not isinstance(dependent_object_metadatas, list):
            raise TypeError("Expected argument 'dependent_object_metadatas' to be a list")
        pulumi.set(__self__, "dependent_object_metadatas", dependent_object_metadatas)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if key_map and not isinstance(key_map, dict):
            raise TypeError("Expected argument 'key_map' to be a dict")
        pulumi.set(__self__, "key_map", key_map)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if model_type and not isinstance(model_type, str):
            raise TypeError("Expected argument 'model_type' to be a str")
        pulumi.set(__self__, "model_type", model_type)
        if model_version and not isinstance(model_version, str):
            raise TypeError("Expected argument 'model_version' to be a str")
        pulumi.set(__self__, "model_version", model_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_status and not isinstance(object_status, int):
            raise TypeError("Expected argument 'object_status' to be a int")
        pulumi.set(__self__, "object_status", object_status)
        if object_version and not isinstance(object_version, int):
            raise TypeError("Expected argument 'object_version' to be a int")
        pulumi.set(__self__, "object_version", object_version)
        if parent_reves and not isinstance(parent_reves, list):
            raise TypeError("Expected argument 'parent_reves' to be a list")
        pulumi.set(__self__, "parent_reves", parent_reves)
        if published_object_metadatas and not isinstance(published_object_metadatas, list):
            raise TypeError("Expected argument 'published_object_metadatas' to be a list")
        pulumi.set(__self__, "published_object_metadatas", published_object_metadatas)
        if registry_metadatas and not isinstance(registry_metadatas, list):
            raise TypeError("Expected argument 'registry_metadatas' to be a list")
        pulumi.set(__self__, "registry_metadatas", registry_metadatas)
        if source_application_infos and not isinstance(source_application_infos, list):
            raise TypeError("Expected argument 'source_application_infos' to be a list")
        pulumi.set(__self__, "source_application_infos", source_application_infos)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_patched and not isinstance(time_patched, str):
            raise TypeError("Expected argument 'time_patched' to be a str")
        pulumi.set(__self__, "time_patched", time_patched)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> _builtins.str:
        """
        The source application key to use when creating the application.
        """
        return pulumi.get(self, "application_key")

    @_builtins.property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> _builtins.int:
        """
        The source application version of the application.
        """
        return pulumi.get(self, "application_version")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        OCID of the compartment that this resource belongs to. Defaults to compartment of the Workspace.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationDependentObjectMetadataResult']:
        """
        A list of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the resource that is used to uniquely identify the application
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the object.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Mapping[str, _builtins.str]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationMetadataResult']:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> _builtins.str:
        """
        The object type.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> _builtins.str:
        """
        The object's model version.
        """
        return pulumi.get(self, "model_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> _builtins.int:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> _builtins.int:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @_builtins.property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Sequence['outputs.GetWorkspaceApplicationParentRefResult']:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @_builtins.property
    @pulumi.getter(name="publishedObjectMetadatas")
    def published_object_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationPublishedObjectMetadataResult']:
        """
        A list of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "published_object_metadatas")

    @_builtins.property
    @pulumi.getter(name="registryMetadatas")
    def registry_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationRegistryMetadataResult']:
        return pulumi.get(self, "registry_metadatas")

    @_builtins.property
    @pulumi.getter(name="sourceApplicationInfos")
    def source_application_infos(self) -> Sequence['outputs.GetWorkspaceApplicationSourceApplicationInfoResult']:
        """
        The information about the application.
        """
        return pulumi.get(self, "source_application_infos")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the workspace.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the application was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> _builtins.str:
        """
        The date and time the application was patched, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_patched")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the application was updated, in the timestamp format defined by RFC3339. example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The OCID of the workspace containing the application. This allows cross workspace deployment to publish an application from a different workspace into the current workspace specified in this operation.
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceApplicationResult(GetWorkspaceApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceApplicationResult(
            application_key=self.application_key,
            application_version=self.application_version,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            dependent_object_metadatas=self.dependent_object_metadatas,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            identifier=self.identifier,
            key=self.key,
            key_map=self.key_map,
            metadatas=self.metadatas,
            model_type=self.model_type,
            model_version=self.model_version,
            name=self.name,
            object_status=self.object_status,
            object_version=self.object_version,
            parent_reves=self.parent_reves,
            published_object_metadatas=self.published_object_metadatas,
            registry_metadatas=self.registry_metadatas,
            source_application_infos=self.source_application_infos,
            state=self.state,
            time_created=self.time_created,
            time_patched=self.time_patched,
            time_updated=self.time_updated,
            workspace_id=self.workspace_id)


def get_workspace_application(application_key: Optional[_builtins.str] = None,
                              workspace_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceApplicationResult:
    """
    This data source provides details about a specific Workspace Application resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves an application using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application = oci.DataIntegration.get_workspace_application(application_key=workspace_application_application_key,
        workspace_id=test_workspace["id"])
    ```


    :param _builtins.str application_key: The application key.
    :param _builtins.str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceApplication:getWorkspaceApplication', __args__, opts=opts, typ=GetWorkspaceApplicationResult).value

    return AwaitableGetWorkspaceApplicationResult(
        application_key=pulumi.get(__ret__, 'application_key'),
        application_version=pulumi.get(__ret__, 'application_version'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        dependent_object_metadatas=pulumi.get(__ret__, 'dependent_object_metadatas'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        key=pulumi.get(__ret__, 'key'),
        key_map=pulumi.get(__ret__, 'key_map'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        model_type=pulumi.get(__ret__, 'model_type'),
        model_version=pulumi.get(__ret__, 'model_version'),
        name=pulumi.get(__ret__, 'name'),
        object_status=pulumi.get(__ret__, 'object_status'),
        object_version=pulumi.get(__ret__, 'object_version'),
        parent_reves=pulumi.get(__ret__, 'parent_reves'),
        published_object_metadatas=pulumi.get(__ret__, 'published_object_metadatas'),
        registry_metadatas=pulumi.get(__ret__, 'registry_metadatas'),
        source_application_infos=pulumi.get(__ret__, 'source_application_infos'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_patched=pulumi.get(__ret__, 'time_patched'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_application_output(application_key: Optional[pulumi.Input[_builtins.str]] = None,
                                     workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceApplicationResult]:
    """
    This data source provides details about a specific Workspace Application resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves an application using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application = oci.DataIntegration.get_workspace_application(application_key=workspace_application_application_key,
        workspace_id=test_workspace["id"])
    ```


    :param _builtins.str application_key: The application key.
    :param _builtins.str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataIntegration/getWorkspaceApplication:getWorkspaceApplication', __args__, opts=opts, typ=GetWorkspaceApplicationResult)
    return __ret__.apply(lambda __response__: GetWorkspaceApplicationResult(
        application_key=pulumi.get(__response__, 'application_key'),
        application_version=pulumi.get(__response__, 'application_version'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        dependent_object_metadatas=pulumi.get(__response__, 'dependent_object_metadatas'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        key=pulumi.get(__response__, 'key'),
        key_map=pulumi.get(__response__, 'key_map'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        model_type=pulumi.get(__response__, 'model_type'),
        model_version=pulumi.get(__response__, 'model_version'),
        name=pulumi.get(__response__, 'name'),
        object_status=pulumi.get(__response__, 'object_status'),
        object_version=pulumi.get(__response__, 'object_version'),
        parent_reves=pulumi.get(__response__, 'parent_reves'),
        published_object_metadatas=pulumi.get(__response__, 'published_object_metadatas'),
        registry_metadatas=pulumi.get(__response__, 'registry_metadatas'),
        source_application_infos=pulumi.get(__response__, 'source_application_infos'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_patched=pulumi.get(__response__, 'time_patched'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
