# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTargetDatabaseGroupResult',
    'AwaitableGetTargetDatabaseGroupResult',
    'get_target_database_group',
    'get_target_database_group_output',
]

@pulumi.output_type
class GetTargetDatabaseGroupResult:
    """
    A collection of values returned by getTargetDatabaseGroup.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, matching_criterias=None, membership_count=None, membership_update_time=None, state=None, system_tags=None, target_database_group_id=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if matching_criterias and not isinstance(matching_criterias, list):
            raise TypeError("Expected argument 'matching_criterias' to be a list")
        pulumi.set(__self__, "matching_criterias", matching_criterias)
        if membership_count and not isinstance(membership_count, int):
            raise TypeError("Expected argument 'membership_count' to be a int")
        pulumi.set(__self__, "membership_count", membership_count)
        if membership_update_time and not isinstance(membership_update_time, str):
            raise TypeError("Expected argument 'membership_update_time' to be a str")
        pulumi.set(__self__, "membership_update_time", membership_update_time)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_database_group_id and not isinstance(target_database_group_id, str):
            raise TypeError("Expected argument 'target_database_group_id' to be a str")
        pulumi.set(__self__, "target_database_group_id", target_database_group_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment containing the target database group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the target database group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The name of the target database group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the compartment for including target databases to the target database group. All target databases in the compartment will be members of the target database group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Details for the lifecycle status of the target database group.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="matchingCriterias")
    def matching_criterias(self) -> Sequence['outputs.GetTargetDatabaseGroupMatchingCriteriaResult']:
        """
        Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details. Include: Target databases will be added to the target database group if they match at least one of the include criteria. Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
        """
        return pulumi.get(self, "matching_criterias")

    @_builtins.property
    @pulumi.getter(name="membershipCount")
    def membership_count(self) -> _builtins.int:
        """
        The number of target databases in the specified target database group.
        """
        return pulumi.get(self, "membership_count")

    @_builtins.property
    @pulumi.getter(name="membershipUpdateTime")
    def membership_update_time(self) -> _builtins.str:
        """
        Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.
        """
        return pulumi.get(self, "membership_update_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The lifecycle status of the target database group.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> _builtins.str:
        return pulumi.get(self, "target_database_group_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the target database group was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the target database group was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetTargetDatabaseGroupResult(GetTargetDatabaseGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabaseGroupResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            matching_criterias=self.matching_criterias,
            membership_count=self.membership_count,
            membership_update_time=self.membership_update_time,
            state=self.state,
            system_tags=self.system_tags,
            target_database_group_id=self.target_database_group_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_target_database_group(target_database_group_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabaseGroupResult:
    """
    This data source provides details about a specific Target Database Group resource in Oracle Cloud Infrastructure Data Safe service.

    Returns the details of the specified target database group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_group = oci.DataSafe.get_target_database_group(target_database_group_id=test_target_database_group_oci_data_safe_target_database_group["id"])
    ```


    :param _builtins.str target_database_group_id: The OCID of the specified target database group.
    """
    __args__ = dict()
    __args__['targetDatabaseGroupId'] = target_database_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabaseGroup:getTargetDatabaseGroup', __args__, opts=opts, typ=GetTargetDatabaseGroupResult).value

    return AwaitableGetTargetDatabaseGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        matching_criterias=pulumi.get(__ret__, 'matching_criterias'),
        membership_count=pulumi.get(__ret__, 'membership_count'),
        membership_update_time=pulumi.get(__ret__, 'membership_update_time'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_database_group_id=pulumi.get(__ret__, 'target_database_group_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_target_database_group_output(target_database_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetDatabaseGroupResult]:
    """
    This data source provides details about a specific Target Database Group resource in Oracle Cloud Infrastructure Data Safe service.

    Returns the details of the specified target database group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database_group = oci.DataSafe.get_target_database_group(target_database_group_id=test_target_database_group_oci_data_safe_target_database_group["id"])
    ```


    :param _builtins.str target_database_group_id: The OCID of the specified target database group.
    """
    __args__ = dict()
    __args__['targetDatabaseGroupId'] = target_database_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getTargetDatabaseGroup:getTargetDatabaseGroup', __args__, opts=opts, typ=GetTargetDatabaseGroupResult)
    return __ret__.apply(lambda __response__: GetTargetDatabaseGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        matching_criterias=pulumi.get(__response__, 'matching_criterias'),
        membership_count=pulumi.get(__response__, 'membership_count'),
        membership_update_time=pulumi.get(__response__, 'membership_update_time'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_database_group_id=pulumi.get(__response__, 'target_database_group_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
