# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UnifiedAuditPolicyDefinitionArgs', 'UnifiedAuditPolicyDefinition']

@pulumi.input_type
class UnifiedAuditPolicyDefinitionArgs:
    def __init__(__self__, *,
                 unified_audit_policy_definition_id: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a UnifiedAuditPolicyDefinition resource.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the unified audit policy definition resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the unified audit policy definition resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @unified_audit_policy_definition_id.setter
    def unified_audit_policy_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unified_audit_policy_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the unified audit policy definition.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _UnifiedAuditPolicyDefinitionState:
    def __init__(__self__, *,
                 audit_policy_category: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_seeded: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_statement: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UnifiedAuditPolicyDefinition resources.
        :param pulumi.Input[_builtins.str] audit_policy_category: The category to which the unified audit policy belongs in the target database.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_seeded: Signifies whether the unified audit policy definition is seeded or not.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the unified audit policy definition.
        :param pulumi.Input[_builtins.str] policy_definition_statement: The definition of the unified audit policy to be provisioned in the target database.
        :param pulumi.Input[_builtins.str] policy_name: The unified audit policy name in the target database.
        :param pulumi.Input[_builtins.str] state: The current state of the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the unified audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the unified audit policy definition resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if audit_policy_category is not None:
            pulumi.set(__self__, "audit_policy_category", audit_policy_category)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_seeded is not None:
            pulumi.set(__self__, "is_seeded", is_seeded)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if policy_definition_statement is not None:
            pulumi.set(__self__, "policy_definition_statement", policy_definition_statement)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if unified_audit_policy_definition_id is not None:
            pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)

    @_builtins.property
    @pulumi.getter(name="auditPolicyCategory")
    def audit_policy_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category to which the unified audit policy belongs in the target database.
        """
        return pulumi.get(self, "audit_policy_category")

    @audit_policy_category.setter
    def audit_policy_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_policy_category", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the unified audit policy definition.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Signifies whether the unified audit policy definition is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @is_seeded.setter
    def is_seeded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_seeded", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the unified audit policy definition.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionStatement")
    def policy_definition_statement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The definition of the unified audit policy to be provisioned in the target database.
        """
        return pulumi.get(self, "policy_definition_statement")

    @policy_definition_statement.setter
    def policy_definition_statement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_statement", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unified audit policy name in the target database.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the unified audit policy definition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the unified audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the unified audit policy definition resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @unified_audit_policy_definition_id.setter
    def unified_audit_policy_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unified_audit_policy_definition_id", value)


@pulumi.type_token("oci:DataSafe/unifiedAuditPolicyDefinition:UnifiedAuditPolicyDefinition")
class UnifiedAuditPolicyDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Unified Audit Policy Definition resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the unified audit policy definition.

        ## Import

        UnifiedAuditPolicyDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/unifiedAuditPolicyDefinition:UnifiedAuditPolicyDefinition test_unified_audit_policy_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the unified audit policy definition resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UnifiedAuditPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Unified Audit Policy Definition resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the unified audit policy definition.

        ## Import

        UnifiedAuditPolicyDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/unifiedAuditPolicyDefinition:UnifiedAuditPolicyDefinition test_unified_audit_policy_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param UnifiedAuditPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UnifiedAuditPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UnifiedAuditPolicyDefinitionArgs.__new__(UnifiedAuditPolicyDefinitionArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if unified_audit_policy_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'unified_audit_policy_definition_id'")
            __props__.__dict__["unified_audit_policy_definition_id"] = unified_audit_policy_definition_id
            __props__.__dict__["audit_policy_category"] = None
            __props__.__dict__["is_seeded"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["policy_definition_statement"] = None
            __props__.__dict__["policy_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(UnifiedAuditPolicyDefinition, __self__).__init__(
            'oci:DataSafe/unifiedAuditPolicyDefinition:UnifiedAuditPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_policy_category: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_seeded: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            policy_definition_statement: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            unified_audit_policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UnifiedAuditPolicyDefinition':
        """
        Get an existing UnifiedAuditPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_policy_category: The category to which the unified audit policy belongs in the target database.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the audit policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_seeded: Signifies whether the unified audit policy definition is seeded or not.
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the unified audit policy definition.
        :param pulumi.Input[_builtins.str] policy_definition_statement: The definition of the unified audit policy to be provisioned in the target database.
        :param pulumi.Input[_builtins.str] policy_name: The unified audit policy name in the target database.
        :param pulumi.Input[_builtins.str] state: The current state of the unified audit policy definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the unified audit policy was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] unified_audit_policy_definition_id: The OCID of the unified audit policy definition resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UnifiedAuditPolicyDefinitionState.__new__(_UnifiedAuditPolicyDefinitionState)

        __props__.__dict__["audit_policy_category"] = audit_policy_category
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_seeded"] = is_seeded
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["policy_definition_statement"] = policy_definition_statement
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["unified_audit_policy_definition_id"] = unified_audit_policy_definition_id
        return UnifiedAuditPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditPolicyCategory")
    def audit_policy_category(self) -> pulumi.Output[_builtins.str]:
        """
        The category to which the unified audit policy belongs in the target database.
        """
        return pulumi.get(self, "audit_policy_category")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the unified audit policy definition.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the audit policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the audit policy. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> pulumi.Output[_builtins.bool]:
        """
        Signifies whether the unified audit policy definition is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the unified audit policy definition.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="policyDefinitionStatement")
    def policy_definition_statement(self) -> pulumi.Output[_builtins.str]:
        """
        The definition of the unified audit policy to be provisioned in the target database.
        """
        return pulumi.get(self, "policy_definition_statement")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The unified audit policy name in the target database.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the unified audit policy definition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the unified audit policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the unified audit policy definition resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "unified_audit_policy_definition_id")

