# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MlApplicationInstanceArgs', 'MlApplicationInstance']

@pulumi.input_type
class MlApplicationInstanceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 ml_application_id: pulumi.Input[_builtins.str],
                 ml_application_implementation_id: pulumi.Input[_builtins.str],
                 auth_configuration: Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MlApplicationInstance resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        :param pulumi.Input[_builtins.str] ml_application_implementation_id: (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['MlApplicationInstanceAuthConfigurationArgs'] auth_configuration: AuthN/Z configuration for online prediction
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]] configurations: (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: The name of MlApplicationInstance. System will generate displayName when not provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        pulumi.set(__self__, "ml_application_implementation_id", ml_application_implementation_id)
        if auth_configuration is not None:
            pulumi.set(__self__, "auth_configuration", auth_configuration)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        """
        return pulumi.get(self, "ml_application_id")

    @ml_application_id.setter
    def ml_application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ml_application_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "ml_application_implementation_id")

    @ml_application_implementation_id.setter
    def ml_application_implementation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ml_application_implementation_id", value)

    @_builtins.property
    @pulumi.getter(name="authConfiguration")
    def auth_configuration(self) -> Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']]:
        """
        AuthN/Z configuration for online prediction
        """
        return pulumi.get(self, "auth_configuration")

    @auth_configuration.setter
    def auth_configuration(self, value: Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']]):
        pulumi.set(self, "auth_configuration", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]]:
        """
        (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of MlApplicationInstance. System will generate displayName when not provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class _MlApplicationInstanceState:
    def __init__(__self__, *,
                 auth_configuration: Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_substate: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_implementation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_implementation_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prediction_endpoint_details: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstancePredictionEndpointDetailArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MlApplicationInstance resources.
        :param pulumi.Input['MlApplicationInstanceAuthConfigurationArgs'] auth_configuration: AuthN/Z configuration for online prediction
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]] configurations: (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: The name of MlApplicationInstance. System will generate displayName when not provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] lifecycle_substate: The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all Oracle Cloud Infrastructure resources. The NEEDS_ATTENTION and FAILED substates are deprecated in favor of (NON_)?RECOVERABLE_(PROVIDER|SERVICE)_ISSUE and will be removed in next release.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        :param pulumi.Input[_builtins.str] ml_application_implementation_id: (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] ml_application_implementation_name: The name of Ml Application Implementation (based on mlApplicationImplementationId)
        :param pulumi.Input[_builtins.str] ml_application_name: The name of ML Application (based on mlApplicationId).
        :param pulumi.Input[Sequence[pulumi.Input['MlApplicationInstancePredictionEndpointDetailArgs']]] prediction_endpoint_details: Prediction endpoint related information.
        :param pulumi.Input[_builtins.str] state: The current state of the MlApplicationInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the the MlApplication was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: Time of last MlApplicationInstance update in the format defined by RFC 3339.
        """
        if auth_configuration is not None:
            pulumi.set(__self__, "auth_configuration", auth_configuration)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate is not None:
            pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if ml_application_id is not None:
            pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_implementation_id is not None:
            pulumi.set(__self__, "ml_application_implementation_id", ml_application_implementation_id)
        if ml_application_implementation_name is not None:
            pulumi.set(__self__, "ml_application_implementation_name", ml_application_implementation_name)
        if ml_application_name is not None:
            pulumi.set(__self__, "ml_application_name", ml_application_name)
        if prediction_endpoint_details is not None:
            pulumi.set(__self__, "prediction_endpoint_details", prediction_endpoint_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="authConfiguration")
    def auth_configuration(self) -> Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']]:
        """
        AuthN/Z configuration for online prediction
        """
        return pulumi.get(self, "auth_configuration")

    @auth_configuration.setter
    def auth_configuration(self, value: Optional[pulumi.Input['MlApplicationInstanceAuthConfigurationArgs']]):
        pulumi.set(self, "auth_configuration", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]]:
        """
        (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstanceConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of MlApplicationInstance. System will generate displayName when not provided.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all Oracle Cloud Infrastructure resources. The NEEDS_ATTENTION and FAILED substates are deprecated in favor of (NON_)?RECOVERABLE_(PROVIDER|SERVICE)_ISSUE and will be removed in next release.
        """
        return pulumi.get(self, "lifecycle_substate")

    @lifecycle_substate.setter
    def lifecycle_substate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_substate", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        """
        return pulumi.get(self, "ml_application_id")

    @ml_application_id.setter
    def ml_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "ml_application_implementation_id")

    @ml_application_implementation_id.setter
    def ml_application_implementation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_implementation_id", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationImplementationName")
    def ml_application_implementation_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Ml Application Implementation (based on mlApplicationImplementationId)
        """
        return pulumi.get(self, "ml_application_implementation_name")

    @ml_application_implementation_name.setter
    def ml_application_implementation_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_implementation_name", value)

    @_builtins.property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of ML Application (based on mlApplicationId).
        """
        return pulumi.get(self, "ml_application_name")

    @ml_application_name.setter
    def ml_application_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ml_application_name", value)

    @_builtins.property
    @pulumi.getter(name="predictionEndpointDetails")
    def prediction_endpoint_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstancePredictionEndpointDetailArgs']]]]:
        """
        Prediction endpoint related information.
        """
        return pulumi.get(self, "prediction_endpoint_details")

    @prediction_endpoint_details.setter
    def prediction_endpoint_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MlApplicationInstancePredictionEndpointDetailArgs']]]]):
        pulumi.set(self, "prediction_endpoint_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the MlApplicationInstance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the the MlApplication was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of last MlApplicationInstance update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataScience/mlApplicationInstance:MlApplicationInstance")
class MlApplicationInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_configuration: Optional[pulumi.Input[Union['MlApplicationInstanceAuthConfigurationArgs', 'MlApplicationInstanceAuthConfigurationArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstanceConfigurationArgs', 'MlApplicationInstanceConfigurationArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_implementation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Ml Application Instance resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new MlApplicationInstance.

        ## Example Usage

        ## Import

        MlApplicationInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/mlApplicationInstance:MlApplicationInstance test_ml_application_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MlApplicationInstanceAuthConfigurationArgs', 'MlApplicationInstanceAuthConfigurationArgsDict']] auth_configuration: AuthN/Z configuration for online prediction
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstanceConfigurationArgs', 'MlApplicationInstanceConfigurationArgsDict']]]] configurations: (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: The name of MlApplicationInstance. System will generate displayName when not provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        :param pulumi.Input[_builtins.str] ml_application_implementation_id: (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MlApplicationInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ml Application Instance resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new MlApplicationInstance.

        ## Example Usage

        ## Import

        MlApplicationInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/mlApplicationInstance:MlApplicationInstance test_ml_application_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param MlApplicationInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MlApplicationInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_configuration: Optional[pulumi.Input[Union['MlApplicationInstanceAuthConfigurationArgs', 'MlApplicationInstanceAuthConfigurationArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstanceConfigurationArgs', 'MlApplicationInstanceConfigurationArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ml_application_implementation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MlApplicationInstanceArgs.__new__(MlApplicationInstanceArgs)

            __props__.__dict__["auth_configuration"] = auth_configuration
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            if ml_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'ml_application_id'")
            __props__.__dict__["ml_application_id"] = ml_application_id
            if ml_application_implementation_id is None and not opts.urn:
                raise TypeError("Missing required property 'ml_application_implementation_id'")
            __props__.__dict__["ml_application_implementation_id"] = ml_application_implementation_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_substate"] = None
            __props__.__dict__["ml_application_implementation_name"] = None
            __props__.__dict__["ml_application_name"] = None
            __props__.__dict__["prediction_endpoint_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MlApplicationInstance, __self__).__init__(
            'oci:DataScience/mlApplicationInstance:MlApplicationInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_configuration: Optional[pulumi.Input[Union['MlApplicationInstanceAuthConfigurationArgs', 'MlApplicationInstanceAuthConfigurationArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstanceConfigurationArgs', 'MlApplicationInstanceConfigurationArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_substate: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_implementation_id: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_implementation_name: Optional[pulumi.Input[_builtins.str]] = None,
            ml_application_name: Optional[pulumi.Input[_builtins.str]] = None,
            prediction_endpoint_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstancePredictionEndpointDetailArgs', 'MlApplicationInstancePredictionEndpointDetailArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'MlApplicationInstance':
        """
        Get an existing MlApplicationInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MlApplicationInstanceAuthConfigurationArgs', 'MlApplicationInstanceAuthConfigurationArgsDict']] auth_configuration: AuthN/Z configuration for online prediction
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstanceConfigurationArgs', 'MlApplicationInstanceConfigurationArgsDict']]]] configurations: (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: The name of MlApplicationInstance. System will generate displayName when not provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_enabled: (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[_builtins.str] lifecycle_substate: The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all Oracle Cloud Infrastructure resources. The NEEDS_ATTENTION and FAILED substates are deprecated in favor of (NON_)?RECOVERABLE_(PROVIDER|SERVICE)_ISSUE and will be removed in next release.
        :param pulumi.Input[_builtins.str] ml_application_id: The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        :param pulumi.Input[_builtins.str] ml_application_implementation_id: (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] ml_application_implementation_name: The name of Ml Application Implementation (based on mlApplicationImplementationId)
        :param pulumi.Input[_builtins.str] ml_application_name: The name of ML Application (based on mlApplicationId).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MlApplicationInstancePredictionEndpointDetailArgs', 'MlApplicationInstancePredictionEndpointDetailArgsDict']]]] prediction_endpoint_details: Prediction endpoint related information.
        :param pulumi.Input[_builtins.str] state: The current state of the MlApplicationInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the the MlApplication was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: Time of last MlApplicationInstance update in the format defined by RFC 3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MlApplicationInstanceState.__new__(_MlApplicationInstanceState)

        __props__.__dict__["auth_configuration"] = auth_configuration
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_substate"] = lifecycle_substate
        __props__.__dict__["ml_application_id"] = ml_application_id
        __props__.__dict__["ml_application_implementation_id"] = ml_application_implementation_id
        __props__.__dict__["ml_application_implementation_name"] = ml_application_implementation_name
        __props__.__dict__["ml_application_name"] = ml_application_name
        __props__.__dict__["prediction_endpoint_details"] = prediction_endpoint_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MlApplicationInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authConfiguration")
    def auth_configuration(self) -> pulumi.Output['outputs.MlApplicationInstanceAuthConfiguration']:
        """
        AuthN/Z configuration for online prediction
        """
        return pulumi.get(self, "auth_configuration")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the MlApplicationInstance is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Sequence['outputs.MlApplicationInstanceConfiguration']]:
        """
        (Updatable) Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of MlApplicationInstance. System will generate displayName when not provided.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Defines whether the MlApplicationInstance will be created in ACTIVE (true value) or INACTIVE (false value) lifecycle state.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> pulumi.Output[_builtins.str]:
        """
        The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all Oracle Cloud Infrastructure resources. The NEEDS_ATTENTION and FAILED substates are deprecated in favor of (NON_)?RECOVERABLE_(PROVIDER|SERVICE)_ISSUE and will be removed in next release.
        """
        return pulumi.get(self, "lifecycle_substate")

    @_builtins.property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        """
        return pulumi.get(self, "ml_application_id")

    @_builtins.property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "ml_application_implementation_id")

    @_builtins.property
    @pulumi.getter(name="mlApplicationImplementationName")
    def ml_application_implementation_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Ml Application Implementation (based on mlApplicationImplementationId)
        """
        return pulumi.get(self, "ml_application_implementation_name")

    @_builtins.property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of ML Application (based on mlApplicationId).
        """
        return pulumi.get(self, "ml_application_name")

    @_builtins.property
    @pulumi.getter(name="predictionEndpointDetails")
    def prediction_endpoint_details(self) -> pulumi.Output[Sequence['outputs.MlApplicationInstancePredictionEndpointDetail']]:
        """
        Prediction endpoint related information.
        """
        return pulumi.get(self, "prediction_endpoint_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the MlApplicationInstance.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the the MlApplication was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Time of last MlApplicationInstance update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

