# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTriggersResult',
    'AwaitableGetTriggersResult',
    'get_triggers',
    'get_triggers_output',
]

@pulumi.output_type
class GetTriggersResult:
    """
    A collection of values returned by getTriggers.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, project_id=None, state=None, trigger_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if trigger_collections and not isinstance(trigger_collections, list):
            raise TypeError("Expected argument 'trigger_collections' to be a list")
        pulumi.set(__self__, "trigger_collections", trigger_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the compartment that contains the trigger.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Trigger display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTriggersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the DevOps project to which the trigger belongs to.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the trigger.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="triggerCollections")
    def trigger_collections(self) -> Sequence['outputs.GetTriggersTriggerCollectionResult']:
        """
        The list of trigger_collection.
        """
        return pulumi.get(self, "trigger_collections")


class AwaitableGetTriggersResult(GetTriggersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTriggersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            project_id=self.project_id,
            state=self.state,
            trigger_collections=self.trigger_collections)


def get_triggers(compartment_id: Optional[_builtins.str] = None,
                 display_name: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetTriggersFilterArgs', 'GetTriggersFilterArgsDict']]] = None,
                 id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTriggersResult:
    """
    This data source provides the list of Triggers in Oracle Cloud Infrastructure Devops service.

    Returns a list of triggers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_triggers = oci.DevOps.get_triggers(compartment_id=compartment_id,
        display_name=trigger_display_name,
        id=trigger_id,
        project_id=test_project["id"],
        state=trigger_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique trigger identifier.
    :param _builtins.str project_id: unique project identifier
    :param _builtins.str state: A filter to return only triggers that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getTriggers:getTriggers', __args__, opts=opts, typ=GetTriggersResult).value

    return AwaitableGetTriggersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        trigger_collections=pulumi.get(__ret__, 'trigger_collections'))
def get_triggers_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTriggersFilterArgs', 'GetTriggersFilterArgsDict']]]]] = None,
                        id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTriggersResult]:
    """
    This data source provides the list of Triggers in Oracle Cloud Infrastructure Devops service.

    Returns a list of triggers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_triggers = oci.DevOps.get_triggers(compartment_id=compartment_id,
        display_name=trigger_display_name,
        id=trigger_id,
        project_id=test_project["id"],
        state=trigger_state)
    ```


    :param _builtins.str compartment_id: The OCID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: Unique trigger identifier.
    :param _builtins.str project_id: unique project identifier
    :param _builtins.str state: A filter to return only triggers that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getTriggers:getTriggers', __args__, opts=opts, typ=GetTriggersResult)
    return __ret__.apply(lambda __response__: GetTriggersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state'),
        trigger_collections=pulumi.get(__response__, 'trigger_collections')))
