# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRunbookResult',
    'AwaitableGetRunbookResult',
    'get_runbook',
    'get_runbook_output',
]

@pulumi.output_type
class GetRunbookResult:
    """
    A collection of values returned by getRunbook.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, estimated_time=None, freeform_tags=None, has_draft_version=None, id=None, is_default=None, is_sudo_access_needed=None, latest_version=None, lifecycle_details=None, operation=None, os_type=None, platform=None, resource_region=None, runbook_id=None, runbook_versions=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_time and not isinstance(estimated_time, str):
            raise TypeError("Expected argument 'estimated_time' to be a str")
        pulumi.set(__self__, "estimated_time", estimated_time)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if has_draft_version and not isinstance(has_draft_version, bool):
            raise TypeError("Expected argument 'has_draft_version' to be a bool")
        pulumi.set(__self__, "has_draft_version", has_draft_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if is_sudo_access_needed and not isinstance(is_sudo_access_needed, bool):
            raise TypeError("Expected argument 'is_sudo_access_needed' to be a bool")
        pulumi.set(__self__, "is_sudo_access_needed", is_sudo_access_needed)
        if latest_version and not isinstance(latest_version, str):
            raise TypeError("Expected argument 'latest_version' to be a str")
        pulumi.set(__self__, "latest_version", latest_version)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_versions and not isinstance(runbook_versions, list):
            raise TypeError("Expected argument 'runbook_versions' to be a list")
        pulumi.set(__self__, "runbook_versions", runbook_versions)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the argument.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="estimatedTime")
    def estimated_time(self) -> _builtins.str:
        """
        Estimated time to successfully complete the runbook execution.
        """
        return pulumi.get(self, "estimated_time")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hasDraftVersion")
    def has_draft_version(self) -> _builtins.bool:
        """
        Does this runbook has draft versions?
        """
        return pulumi.get(self, "has_draft_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Is the runbook default? Sets this runbook as the default for the chosen product/product stack for the specified lifecycle operation.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isSudoAccessNeeded")
    def is_sudo_access_needed(self) -> _builtins.bool:
        """
        Does this runbook need SUDO access to execute?
        """
        return pulumi.get(self, "is_sudo_access_needed")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> _builtins.str:
        """
        Latest runbook version
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        The lifecycle operation performed by the runbook.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        The OS for the task.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> _builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> _builtins.str:
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookVersions")
    def runbook_versions(self) -> Sequence['outputs.GetRunbookRunbookVersionResult']:
        """
        Version for the runbook.
        """
        return pulumi.get(self, "runbook_versions")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the runbook.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the runbook.
        """
        return pulumi.get(self, "type")


class AwaitableGetRunbookResult(GetRunbookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            estimated_time=self.estimated_time,
            freeform_tags=self.freeform_tags,
            has_draft_version=self.has_draft_version,
            id=self.id,
            is_default=self.is_default,
            is_sudo_access_needed=self.is_sudo_access_needed,
            latest_version=self.latest_version,
            lifecycle_details=self.lifecycle_details,
            operation=self.operation,
            os_type=self.os_type,
            platform=self.platform,
            resource_region=self.resource_region,
            runbook_id=self.runbook_id,
            runbook_versions=self.runbook_versions,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_runbook(runbook_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookResult:
    """
    This data source provides details about a specific Runbook resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details of a runbook in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook = oci.FleetAppsManagement.get_runbook(runbook_id=test_runbook_oci_fleet_apps_management_runbook["id"])
    ```


    :param _builtins.str runbook_id: Unique Runbook identifier
    """
    __args__ = dict()
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getRunbook:getRunbook', __args__, opts=opts, typ=GetRunbookResult).value

    return AwaitableGetRunbookResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_time=pulumi.get(__ret__, 'estimated_time'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        has_draft_version=pulumi.get(__ret__, 'has_draft_version'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        is_sudo_access_needed=pulumi.get(__ret__, 'is_sudo_access_needed'),
        latest_version=pulumi.get(__ret__, 'latest_version'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        operation=pulumi.get(__ret__, 'operation'),
        os_type=pulumi.get(__ret__, 'os_type'),
        platform=pulumi.get(__ret__, 'platform'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_versions=pulumi.get(__ret__, 'runbook_versions'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_runbook_output(runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookResult]:
    """
    This data source provides details about a specific Runbook resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details of a runbook in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_runbook = oci.FleetAppsManagement.get_runbook(runbook_id=test_runbook_oci_fleet_apps_management_runbook["id"])
    ```


    :param _builtins.str runbook_id: Unique Runbook identifier
    """
    __args__ = dict()
    __args__['runbookId'] = runbook_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getRunbook:getRunbook', __args__, opts=opts, typ=GetRunbookResult)
    return __ret__.apply(lambda __response__: GetRunbookResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_time=pulumi.get(__response__, 'estimated_time'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        has_draft_version=pulumi.get(__response__, 'has_draft_version'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        is_sudo_access_needed=pulumi.get(__response__, 'is_sudo_access_needed'),
        latest_version=pulumi.get(__response__, 'latest_version'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        operation=pulumi.get(__response__, 'operation'),
        os_type=pulumi.get(__response__, 'os_type'),
        platform=pulumi.get(__response__, 'platform'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_versions=pulumi.get(__response__, 'runbook_versions'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
