# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUtilsJavaMigrationAnalysiResult',
    'AwaitableGetUtilsJavaMigrationAnalysiResult',
    'get_utils_java_migration_analysi',
    'get_utils_java_migration_analysi_output',
]

@pulumi.output_type
class GetUtilsJavaMigrationAnalysiResult:
    """
    A collection of values returned by getUtilsJavaMigrationAnalysi.
    """
    def __init__(__self__, analysis_project_name=None, analysis_result_files=None, analysis_result_object_storage_path=None, bucket=None, compartment_id=None, created_bies=None, id=None, input_applications_object_storage_paths=None, java_migration_analysis_id=None, metadata=None, namespace=None, target_jdk_version=None, time_created=None, time_finished=None, time_started=None, work_request_id=None):
        if analysis_project_name and not isinstance(analysis_project_name, str):
            raise TypeError("Expected argument 'analysis_project_name' to be a str")
        pulumi.set(__self__, "analysis_project_name", analysis_project_name)
        if analysis_result_files and not isinstance(analysis_result_files, list):
            raise TypeError("Expected argument 'analysis_result_files' to be a list")
        pulumi.set(__self__, "analysis_result_files", analysis_result_files)
        if analysis_result_object_storage_path and not isinstance(analysis_result_object_storage_path, str):
            raise TypeError("Expected argument 'analysis_result_object_storage_path' to be a str")
        pulumi.set(__self__, "analysis_result_object_storage_path", analysis_result_object_storage_path)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input_applications_object_storage_paths and not isinstance(input_applications_object_storage_paths, list):
            raise TypeError("Expected argument 'input_applications_object_storage_paths' to be a list")
        pulumi.set(__self__, "input_applications_object_storage_paths", input_applications_object_storage_paths)
        if java_migration_analysis_id and not isinstance(java_migration_analysis_id, str):
            raise TypeError("Expected argument 'java_migration_analysis_id' to be a str")
        pulumi.set(__self__, "java_migration_analysis_id", java_migration_analysis_id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if target_jdk_version and not isinstance(target_jdk_version, str):
            raise TypeError("Expected argument 'target_jdk_version' to be a str")
        pulumi.set(__self__, "target_jdk_version", target_jdk_version)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @_builtins.property
    @pulumi.getter(name="analysisProjectName")
    def analysis_project_name(self) -> _builtins.str:
        """
        Name of the analysis project.
        """
        return pulumi.get(self, "analysis_project_name")

    @_builtins.property
    @pulumi.getter(name="analysisResultFiles")
    def analysis_result_files(self) -> Sequence[_builtins.str]:
        """
        The analysis application file names result in the Object Storage.
        """
        return pulumi.get(self, "analysis_result_files")

    @_builtins.property
    @pulumi.getter(name="analysisResultObjectStoragePath")
    def analysis_result_object_storage_path(self) -> _builtins.str:
        """
        Path to the Object Storage analysis application result.
        """
        return pulumi.get(self, "analysis_result_object_storage_path")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Object storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetUtilsJavaMigrationAnalysiCreatedByResult']:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inputApplicationsObjectStoragePaths")
    def input_applications_object_storage_paths(self) -> Sequence[_builtins.str]:
        """
        Object storage paths to the input files applications to be analysed.
        """
        return pulumi.get(self, "input_applications_object_storage_paths")

    @_builtins.property
    @pulumi.getter(name="javaMigrationAnalysisId")
    def java_migration_analysis_id(self) -> _builtins.str:
        return pulumi.get(self, "java_migration_analysis_id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> _builtins.str:
        """
        Additional info reserved for future use.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Object storage namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="targetJdkVersion")
    def target_jdk_version(self) -> _builtins.str:
        """
        Jdk Version of the Java Migration Analysis target.
        """
        return pulumi.get(self, "target_jdk_version")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Java Migration Analysis was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time the Java Migration Analysis was finished, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time the Java Migration Analysis was started, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Work Request.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetUtilsJavaMigrationAnalysiResult(GetUtilsJavaMigrationAnalysiResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUtilsJavaMigrationAnalysiResult(
            analysis_project_name=self.analysis_project_name,
            analysis_result_files=self.analysis_result_files,
            analysis_result_object_storage_path=self.analysis_result_object_storage_path,
            bucket=self.bucket,
            compartment_id=self.compartment_id,
            created_bies=self.created_bies,
            id=self.id,
            input_applications_object_storage_paths=self.input_applications_object_storage_paths,
            java_migration_analysis_id=self.java_migration_analysis_id,
            metadata=self.metadata,
            namespace=self.namespace,
            target_jdk_version=self.target_jdk_version,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_started=self.time_started,
            work_request_id=self.work_request_id)


def get_utils_java_migration_analysi(compartment_id: Optional[_builtins.str] = None,
                                     java_migration_analysis_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUtilsJavaMigrationAnalysiResult:
    """
    This data source provides details about a specific Java Migration Analysi resource in Oracle Cloud Infrastructure Jms Utils service.

    Gets information about a Java Migration Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_migration_analysi = oci.Jms.get_utils_java_migration_analysi(java_migration_analysis_id=test_java_migration_analysi_oci_jms_utils_java_migration_analysi["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str java_migration_analysis_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java Migration Analysis.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['javaMigrationAnalysisId'] = java_migration_analysis_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getUtilsJavaMigrationAnalysi:getUtilsJavaMigrationAnalysi', __args__, opts=opts, typ=GetUtilsJavaMigrationAnalysiResult).value

    return AwaitableGetUtilsJavaMigrationAnalysiResult(
        analysis_project_name=pulumi.get(__ret__, 'analysis_project_name'),
        analysis_result_files=pulumi.get(__ret__, 'analysis_result_files'),
        analysis_result_object_storage_path=pulumi.get(__ret__, 'analysis_result_object_storage_path'),
        bucket=pulumi.get(__ret__, 'bucket'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        id=pulumi.get(__ret__, 'id'),
        input_applications_object_storage_paths=pulumi.get(__ret__, 'input_applications_object_storage_paths'),
        java_migration_analysis_id=pulumi.get(__ret__, 'java_migration_analysis_id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        namespace=pulumi.get(__ret__, 'namespace'),
        target_jdk_version=pulumi.get(__ret__, 'target_jdk_version'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_utils_java_migration_analysi_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            java_migration_analysis_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUtilsJavaMigrationAnalysiResult]:
    """
    This data source provides details about a specific Java Migration Analysi resource in Oracle Cloud Infrastructure Jms Utils service.

    Gets information about a Java Migration Analysis.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_migration_analysi = oci.Jms.get_utils_java_migration_analysi(java_migration_analysis_id=test_java_migration_analysi_oci_jms_utils_java_migration_analysi["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str java_migration_analysis_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java Migration Analysis.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['javaMigrationAnalysisId'] = java_migration_analysis_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getUtilsJavaMigrationAnalysi:getUtilsJavaMigrationAnalysi', __args__, opts=opts, typ=GetUtilsJavaMigrationAnalysiResult)
    return __ret__.apply(lambda __response__: GetUtilsJavaMigrationAnalysiResult(
        analysis_project_name=pulumi.get(__response__, 'analysis_project_name'),
        analysis_result_files=pulumi.get(__response__, 'analysis_result_files'),
        analysis_result_object_storage_path=pulumi.get(__response__, 'analysis_result_object_storage_path'),
        bucket=pulumi.get(__response__, 'bucket'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_bies=pulumi.get(__response__, 'created_bies'),
        id=pulumi.get(__response__, 'id'),
        input_applications_object_storage_paths=pulumi.get(__response__, 'input_applications_object_storage_paths'),
        java_migration_analysis_id=pulumi.get(__response__, 'java_migration_analysis_id'),
        metadata=pulumi.get(__response__, 'metadata'),
        namespace=pulumi.get(__response__, 'namespace'),
        target_jdk_version=pulumi.get(__response__, 'target_jdk_version'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
