# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNamedCredentialsResult',
    'AwaitableGetNamedCredentialsResult',
    'get_named_credentials',
    'get_named_credentials_output',
]

@pulumi.output_type
class GetNamedCredentialsResult:
    """
    A collection of values returned by getNamedCredentials.
    """
    def __init__(__self__, filters=None, ids=None, management_agent_id=None, named_credential_collections=None, names=None, states=None, types=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if named_credential_collections and not isinstance(named_credential_collections, list):
            raise TypeError("Expected argument 'named_credential_collections' to be a list")
        pulumi.set(__self__, "named_credential_collections", named_credential_collections)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNamedCredentialsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Identifier for Named Credential.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> _builtins.str:
        """
        The Management Agent parent resource to associated with this named credential. This is the ManagementAgent resource OCID.
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter(name="namedCredentialCollections")
    def named_credential_collections(self) -> Sequence['outputs.GetNamedCredentialsNamedCredentialCollectionResult']:
        """
        The list of named_credential_collection.
        """
        return pulumi.get(self, "named_credential_collections")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Name of the property
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[Sequence[_builtins.str]]:
        """
        The current state of the named credential
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The type of the Named Credential.
        """
        return pulumi.get(self, "types")


class AwaitableGetNamedCredentialsResult(GetNamedCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamedCredentialsResult(
            filters=self.filters,
            ids=self.ids,
            management_agent_id=self.management_agent_id,
            named_credential_collections=self.named_credential_collections,
            names=self.names,
            states=self.states,
            types=self.types)


def get_named_credentials(filters: Optional[Sequence[Union['GetNamedCredentialsFilterArgs', 'GetNamedCredentialsFilterArgsDict']]] = None,
                          ids: Optional[Sequence[_builtins.str]] = None,
                          management_agent_id: Optional[_builtins.str] = None,
                          names: Optional[Sequence[_builtins.str]] = None,
                          states: Optional[Sequence[_builtins.str]] = None,
                          types: Optional[Sequence[_builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamedCredentialsResult:
    """
    This data source provides the list of Named Credentials in Oracle Cloud Infrastructure Management Agent service.

    A list of Management Agent Data Sources for the given Management Agent Id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credentials = oci.ManagementAgent.get_named_credentials(management_agent_id=test_management_agent["id"],
        ids=[named_credential_id],
        names=[named_credential_name],
        states=[named_credential_state],
        types=[named_credential_type])
    ```


    :param Sequence[_builtins.str] ids: Filter list for these Named credentials identifiers (ocid) values.
    :param _builtins.str management_agent_id: The ManagementAgentID of the agent from which the named credentials are associated.
    :param Sequence[_builtins.str] names: Filter list for these name items.
    :param Sequence[_builtins.str] states: Filter list to return only Management Agents in the particular lifecycle state.
    :param Sequence[_builtins.str] types: Filter list for these type values.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['managementAgentId'] = management_agent_id
    __args__['names'] = names
    __args__['states'] = states
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getNamedCredentials:getNamedCredentials', __args__, opts=opts, typ=GetNamedCredentialsResult).value

    return AwaitableGetNamedCredentialsResult(
        filters=pulumi.get(__ret__, 'filters'),
        ids=pulumi.get(__ret__, 'ids'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        named_credential_collections=pulumi.get(__ret__, 'named_credential_collections'),
        names=pulumi.get(__ret__, 'names'),
        states=pulumi.get(__ret__, 'states'),
        types=pulumi.get(__ret__, 'types'))
def get_named_credentials_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNamedCredentialsFilterArgs', 'GetNamedCredentialsFilterArgsDict']]]]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamedCredentialsResult]:
    """
    This data source provides the list of Named Credentials in Oracle Cloud Infrastructure Management Agent service.

    A list of Management Agent Data Sources for the given Management Agent Id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credentials = oci.ManagementAgent.get_named_credentials(management_agent_id=test_management_agent["id"],
        ids=[named_credential_id],
        names=[named_credential_name],
        states=[named_credential_state],
        types=[named_credential_type])
    ```


    :param Sequence[_builtins.str] ids: Filter list for these Named credentials identifiers (ocid) values.
    :param _builtins.str management_agent_id: The ManagementAgentID of the agent from which the named credentials are associated.
    :param Sequence[_builtins.str] names: Filter list for these name items.
    :param Sequence[_builtins.str] states: Filter list to return only Management Agents in the particular lifecycle state.
    :param Sequence[_builtins.str] types: Filter list for these type values.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['managementAgentId'] = management_agent_id
    __args__['names'] = names
    __args__['states'] = states
    __args__['types'] = types
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getNamedCredentials:getNamedCredentials', __args__, opts=opts, typ=GetNamedCredentialsResult)
    return __ret__.apply(lambda __response__: GetNamedCredentialsResult(
        filters=pulumi.get(__response__, 'filters'),
        ids=pulumi.get(__response__, 'ids'),
        management_agent_id=pulumi.get(__response__, 'management_agent_id'),
        named_credential_collections=pulumi.get(__response__, 'named_credential_collections'),
        names=pulumi.get(__response__, 'names'),
        states=pulumi.get(__response__, 'states'),
        types=pulumi.get(__response__, 'types')))
