# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementAgentDataSourceArgs', 'ManagementAgentDataSource']

@pulumi.input_type
class ManagementAgentDataSourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 management_agent_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 allow_metrics: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 read_data_limit_in_kilobytes: Optional[pulumi.Input[_builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_mins: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ManagementAgentDataSource resource.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[_builtins.str] management_agent_id: Unique Management Agent identifier
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        :param pulumi.Input[_builtins.str] url: (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] allow_metrics: (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param pulumi.Input[_builtins.int] connection_timeout: (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]] metric_dimensions: (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param pulumi.Input[_builtins.str] name: Unique name of the DataSource.
        :param pulumi.Input[_builtins.str] namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param pulumi.Input[_builtins.str] proxy_url: (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param pulumi.Input[_builtins.int] read_data_limit_in_kilobytes: (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_timeout: (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param pulumi.Input[_builtins.int] schedule_mins: (Updatable) Number in minutes. The scraping occurs at the specified interval.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if allow_metrics is not None:
            pulumi.set(__self__, "allow_metrics", allow_metrics)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if read_data_limit_in_kilobytes is not None:
            pulumi.set(__self__, "read_data_limit_in_kilobytes", read_data_limit_in_kilobytes)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if schedule_mins is not None:
            pulumi.set(__self__, "schedule_mins", schedule_mins)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @allow_metrics.setter
    def allow_metrics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_metrics", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]]:
        """
        (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]]):
        pulumi.set(self, "metric_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @proxy_url.setter
    def proxy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_url", value)

    @_builtins.property
    @pulumi.getter(name="readDataLimitInKilobytes")
    def read_data_limit_in_kilobytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit_in_kilobytes")

    @read_data_limit_in_kilobytes.setter
    def read_data_limit_in_kilobytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_data_limit_in_kilobytes", value)

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @schedule_mins.setter
    def schedule_mins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "schedule_mins", value)


@pulumi.input_type
class _ManagementAgentDataSourceState:
    def __init__(__self__, *,
                 allow_metrics: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_key: Optional[pulumi.Input[_builtins.str]] = None,
                 is_daemon_set: Optional[pulumi.Input[_builtins.bool]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 read_data_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 read_data_limit_in_kilobytes: Optional[pulumi.Input[_builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagementAgentDataSource resources.
        :param pulumi.Input[_builtins.str] allow_metrics: (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[_builtins.int] connection_timeout: (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.bool] is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param pulumi.Input[_builtins.str] management_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]] metric_dimensions: (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param pulumi.Input[_builtins.str] name: Unique name of the DataSource.
        :param pulumi.Input[_builtins.str] namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param pulumi.Input[_builtins.str] proxy_url: (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param pulumi.Input[_builtins.int] read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_data_limit_in_kilobytes: (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_timeout: (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param pulumi.Input[_builtins.int] schedule_mins: (Updatable) Number in minutes. The scraping occurs at the specified interval.
        :param pulumi.Input[_builtins.str] state: State of the DataSource.
        :param pulumi.Input[_builtins.str] time_created: The time the DataSource was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the DataSource data was last received. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        :param pulumi.Input[_builtins.str] url: (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if allow_metrics is not None:
            pulumi.set(__self__, "allow_metrics", allow_metrics)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if data_source_key is not None:
            pulumi.set(__self__, "data_source_key", data_source_key)
        if is_daemon_set is not None:
            pulumi.set(__self__, "is_daemon_set", is_daemon_set)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if read_data_limit is not None:
            pulumi.set(__self__, "read_data_limit", read_data_limit)
        if read_data_limit_in_kilobytes is not None:
            pulumi.set(__self__, "read_data_limit_in_kilobytes", read_data_limit_in_kilobytes)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if schedule_mins is not None:
            pulumi.set(__self__, "schedule_mins", schedule_mins)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @allow_metrics.setter
    def allow_metrics(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allow_metrics", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_timeout", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceKey")
    def data_source_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "data_source_key")

    @data_source_key.setter
    def data_source_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_key", value)

    @_builtins.property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @is_daemon_set.setter
    def is_daemon_set(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_daemon_set", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]]:
        """
        (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @metric_dimensions.setter
    def metric_dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceMetricDimensionArgs']]]]):
        pulumi.set(self, "metric_dimensions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @proxy_url.setter
    def proxy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_url", value)

    @_builtins.property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @read_data_limit.setter
    def read_data_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_data_limit", value)

    @_builtins.property
    @pulumi.getter(name="readDataLimitInKilobytes")
    def read_data_limit_in_kilobytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit_in_kilobytes")

    @read_data_limit_in_kilobytes.setter
    def read_data_limit_in_kilobytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_data_limit_in_kilobytes", value)

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_timeout", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @schedule_mins.setter
    def schedule_mins(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "schedule_mins", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the DataSource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the DataSource was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the DataSource data was last received. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("oci:ManagementAgent/managementAgentDataSource:ManagementAgentDataSource")
class ManagementAgentDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_metrics: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceMetricDimensionArgs', 'ManagementAgentDataSourceMetricDimensionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 read_data_limit_in_kilobytes: Optional[pulumi.Input[_builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Management Agent Data Source resource in Oracle Cloud Infrastructure Management Agent service.

        Datasource creation request to given Management Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_agent_data_source = oci.managementagent.ManagementAgentDataSource("test_management_agent_data_source",
            compartment_id=compartment_id,
            management_agent_id=test_management_agent["id"],
            name=management_agent_data_source_name,
            type=management_agent_data_source_type,
            url=management_agent_data_source_url,
            allow_metrics=management_agent_data_source_allow_metrics,
            connection_timeout=management_agent_data_source_connection_timeout,
            metric_dimensions=[{
                "name": management_agent_data_source_metric_dimensions_name,
                "value": management_agent_data_source_metric_dimensions_value,
            }],
            namespace=management_agent_data_source_namespace,
            proxy_url=management_agent_data_source_proxy_url,
            read_data_limit_in_kilobytes=management_agent_data_source_read_data_limit_in_kilobytes,
            read_timeout=management_agent_data_source_read_timeout,
            resource_group=management_agent_data_source_resource_group,
            schedule_mins=management_agent_data_source_schedule_mins)
        ```

        ## Import

        ManagementAgentDataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/managementAgentDataSource:ManagementAgentDataSource test_management_agent_data_source "managementAgents/{managementAgentId}/dataSources/{key}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allow_metrics: (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[_builtins.int] connection_timeout: (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.str] management_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceMetricDimensionArgs', 'ManagementAgentDataSourceMetricDimensionArgsDict']]]] metric_dimensions: (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param pulumi.Input[_builtins.str] name: Unique name of the DataSource.
        :param pulumi.Input[_builtins.str] namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param pulumi.Input[_builtins.str] proxy_url: (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param pulumi.Input[_builtins.int] read_data_limit_in_kilobytes: (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_timeout: (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param pulumi.Input[_builtins.int] schedule_mins: (Updatable) Number in minutes. The scraping occurs at the specified interval.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        :param pulumi.Input[_builtins.str] url: (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementAgentDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Management Agent Data Source resource in Oracle Cloud Infrastructure Management Agent service.

        Datasource creation request to given Management Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_agent_data_source = oci.managementagent.ManagementAgentDataSource("test_management_agent_data_source",
            compartment_id=compartment_id,
            management_agent_id=test_management_agent["id"],
            name=management_agent_data_source_name,
            type=management_agent_data_source_type,
            url=management_agent_data_source_url,
            allow_metrics=management_agent_data_source_allow_metrics,
            connection_timeout=management_agent_data_source_connection_timeout,
            metric_dimensions=[{
                "name": management_agent_data_source_metric_dimensions_name,
                "value": management_agent_data_source_metric_dimensions_value,
            }],
            namespace=management_agent_data_source_namespace,
            proxy_url=management_agent_data_source_proxy_url,
            read_data_limit_in_kilobytes=management_agent_data_source_read_data_limit_in_kilobytes,
            read_timeout=management_agent_data_source_read_timeout,
            resource_group=management_agent_data_source_resource_group,
            schedule_mins=management_agent_data_source_schedule_mins)
        ```

        ## Import

        ManagementAgentDataSources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/managementAgentDataSource:ManagementAgentDataSource test_management_agent_data_source "managementAgents/{managementAgentId}/dataSources/{key}"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementAgentDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementAgentDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_metrics: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceMetricDimensionArgs', 'ManagementAgentDataSourceMetricDimensionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 read_data_limit_in_kilobytes: Optional[pulumi.Input[_builtins.int]] = None,
                 read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_mins: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementAgentDataSourceArgs.__new__(ManagementAgentDataSourceArgs)

            __props__.__dict__["allow_metrics"] = allow_metrics
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_timeout"] = connection_timeout
            if management_agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_agent_id'")
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["metric_dimensions"] = metric_dimensions
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["proxy_url"] = proxy_url
            __props__.__dict__["read_data_limit_in_kilobytes"] = read_data_limit_in_kilobytes
            __props__.__dict__["read_timeout"] = read_timeout
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["schedule_mins"] = schedule_mins
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["data_source_key"] = None
            __props__.__dict__["is_daemon_set"] = None
            __props__.__dict__["read_data_limit"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ManagementAgentDataSource, __self__).__init__(
            'oci:ManagementAgent/managementAgentDataSource:ManagementAgentDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_metrics: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_key: Optional[pulumi.Input[_builtins.str]] = None,
            is_daemon_set: Optional[pulumi.Input[_builtins.bool]] = None,
            management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            metric_dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceMetricDimensionArgs', 'ManagementAgentDataSourceMetricDimensionArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
            read_data_limit: Optional[pulumi.Input[_builtins.int]] = None,
            read_data_limit_in_kilobytes: Optional[pulumi.Input[_builtins.int]] = None,
            read_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_mins: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagementAgentDataSource':
        """
        Get an existing ManagementAgentDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] allow_metrics: (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        :param pulumi.Input[_builtins.str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[_builtins.int] connection_timeout: (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.bool] is_daemon_set: If the Kubernetes cluster type is Daemon set then this will be set to true.
        :param pulumi.Input[_builtins.str] management_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceMetricDimensionArgs', 'ManagementAgentDataSourceMetricDimensionArgsDict']]]] metric_dimensions: (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        :param pulumi.Input[_builtins.str] name: Unique name of the DataSource.
        :param pulumi.Input[_builtins.str] namespace: The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        :param pulumi.Input[_builtins.str] proxy_url: (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        :param pulumi.Input[_builtins.int] read_data_limit: Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_data_limit_in_kilobytes: (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        :param pulumi.Input[_builtins.int] read_timeout: (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        :param pulumi.Input[_builtins.str] resource_group: (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        :param pulumi.Input[_builtins.int] schedule_mins: (Updatable) Number in minutes. The scraping occurs at the specified interval.
        :param pulumi.Input[_builtins.str] state: State of the DataSource.
        :param pulumi.Input[_builtins.str] time_created: The time the DataSource was created. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] time_updated: The time the DataSource data was last received. An RFC3339 formatted datetime string
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        :param pulumi.Input[_builtins.str] url: (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementAgentDataSourceState.__new__(_ManagementAgentDataSourceState)

        __props__.__dict__["allow_metrics"] = allow_metrics
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_timeout"] = connection_timeout
        __props__.__dict__["data_source_key"] = data_source_key
        __props__.__dict__["is_daemon_set"] = is_daemon_set
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["metric_dimensions"] = metric_dimensions
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["proxy_url"] = proxy_url
        __props__.__dict__["read_data_limit"] = read_data_limit
        __props__.__dict__["read_data_limit_in_kilobytes"] = read_data_limit_in_kilobytes
        __props__.__dict__["read_timeout"] = read_timeout
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["schedule_mins"] = schedule_mins
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["url"] = url
        return ManagementAgentDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowMetrics")
    def allow_metrics(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Comma separated metric name list. The complete set of desired scraped metrics. Use this property to limit the set of metrics uploaded if required.
        """
        return pulumi.get(self, "allow_metrics")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number in milliseconds. The timeout for connecting to the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "connection_timeout")

    @_builtins.property
    @pulumi.getter(name="dataSourceKey")
    def data_source_key(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "data_source_key")

    @_builtins.property
    @pulumi.getter(name="isDaemonSet")
    def is_daemon_set(self) -> pulumi.Output[_builtins.bool]:
        """
        If the Kubernetes cluster type is Daemon set then this will be set to true.
        """
        return pulumi.get(self, "is_daemon_set")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> pulumi.Output[Sequence['outputs.ManagementAgentDataSourceMetricDimension']]:
        """
        (Updatable) The names of other user-supplied properties expressed as fixed values to be used as dimensions for every uploaded datapoint.
        """
        return pulumi.get(self, "metric_dimensions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name of the DataSource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle Cloud Infrastructure monitoring namespace to which scraped metrics should be uploaded.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The url of the network proxy that provides access to the Prometheus Exporter's endpoint (url required property).
        """
        return pulumi.get(self, "proxy_url")

    @_builtins.property
    @pulumi.getter(name="readDataLimit")
    def read_data_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit")

    @_builtins.property
    @pulumi.getter(name="readDataLimitInKilobytes")
    def read_data_limit_in_kilobytes(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).
        """
        return pulumi.get(self, "read_data_limit_in_kilobytes")

    @_builtins.property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number in milliseconds. The timeout for reading the response from the Prometheus Exporter's endpoint.
        """
        return pulumi.get(self, "read_timeout")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure monitoring resource group to assign the metric to.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="scheduleMins")
    def schedule_mins(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Number in minutes. The scraping occurs at the specified interval.
        """
        return pulumi.get(self, "schedule_mins")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the DataSource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the DataSource was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the DataSource data was last received. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The type of the DataSource. Support types: PROMETHEUS_EMITTER
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The url through which the Prometheus Exporter publishes its metrics. (http only)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "url")

