# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduledRunsResult',
    'AwaitableGetScheduledRunsResult',
    'get_scheduled_runs',
    'get_scheduled_runs_output',
]

@pulumi.output_type
class GetScheduledRunsResult:
    """
    A collection of values returned by getScheduledRuns.
    """
    def __init__(__self__, filters=None, id=None, schedule_id=None, scheduled_run_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schedule_id and not isinstance(schedule_id, str):
            raise TypeError("Expected argument 'schedule_id' to be a str")
        pulumi.set(__self__, "schedule_id", schedule_id)
        if scheduled_run_collections and not isinstance(scheduled_run_collections, list):
            raise TypeError("Expected argument 'scheduled_run_collections' to be a list")
        pulumi.set(__self__, "scheduled_run_collections", scheduled_run_collections)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScheduledRunsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="scheduleId")
    def schedule_id(self) -> _builtins.str:
        """
        The OCID representing a unique shedule.
        """
        return pulumi.get(self, "schedule_id")

    @_builtins.property
    @pulumi.getter(name="scheduledRunCollections")
    def scheduled_run_collections(self) -> Sequence['outputs.GetScheduledRunsScheduledRunCollectionResult']:
        """
        The list of scheduled_run_collection.
        """
        return pulumi.get(self, "scheduled_run_collections")


class AwaitableGetScheduledRunsResult(GetScheduledRunsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledRunsResult(
            filters=self.filters,
            id=self.id,
            schedule_id=self.schedule_id,
            scheduled_run_collections=self.scheduled_run_collections)


def get_scheduled_runs(filters: Optional[Sequence[Union['GetScheduledRunsFilterArgs', 'GetScheduledRunsFilterArgsDict']]] = None,
                       schedule_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledRunsResult:
    """
    This data source provides the list of Scheduled Runs in Oracle Cloud Infrastructure Metering Computation service.

    Returns the schedule history list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_runs = oci.MeteringComputation.get_scheduled_runs(schedule_id=test_schedule["id"])
    ```


    :param _builtins.str schedule_id: The schedule unique ID.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getScheduledRuns:getScheduledRuns', __args__, opts=opts, typ=GetScheduledRunsResult).value

    return AwaitableGetScheduledRunsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        schedule_id=pulumi.get(__ret__, 'schedule_id'),
        scheduled_run_collections=pulumi.get(__ret__, 'scheduled_run_collections'))
def get_scheduled_runs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetScheduledRunsFilterArgs', 'GetScheduledRunsFilterArgsDict']]]]] = None,
                              schedule_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledRunsResult]:
    """
    This data source provides the list of Scheduled Runs in Oracle Cloud Infrastructure Metering Computation service.

    Returns the schedule history list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_runs = oci.MeteringComputation.get_scheduled_runs(schedule_id=test_schedule["id"])
    ```


    :param _builtins.str schedule_id: The schedule unique ID.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['scheduleId'] = schedule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MeteringComputation/getScheduledRuns:getScheduledRuns', __args__, opts=opts, typ=GetScheduledRunsResult)
    return __ret__.apply(lambda __response__: GetScheduledRunsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        schedule_id=pulumi.get(__response__, 'schedule_id'),
        scheduled_run_collections=pulumi.get(__response__, 'scheduled_run_collections')))
