# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationKmsKey',
    'IndexKey',
    'TableReplica',
    'TableSchema',
    'TableSchemaColumn',
    'TableSchemaIdentity',
    'TableTableLimits',
    'GetConfigurationKmsKeyResult',
    'GetIndexKeyResult',
    'GetIndexesFilterResult',
    'GetIndexesIndexCollectionResult',
    'GetIndexesIndexCollectionKeyResult',
    'GetTableReplicaResult',
    'GetTableSchemaResult',
    'GetTableSchemaColumnResult',
    'GetTableSchemaIdentityResult',
    'GetTableTableLimitResult',
    'GetTablesFilterResult',
    'GetTablesTableCollectionResult',
    'GetTablesTableCollectionReplicaResult',
    'GetTablesTableCollectionSchemaResult',
    'GetTablesTableCollectionSchemaColumnResult',
    'GetTablesTableCollectionSchemaIdentityResult',
    'GetTablesTableCollectionTableLimitResult',
]

@pulumi.output_type
class ConfigurationKmsKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyState":
            suggest = "kms_key_state"
        elif key == "kmsVaultId":
            suggest = "kms_vault_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationKmsKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationKmsKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationKmsKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 kms_key_state: Optional[_builtins.str] = None,
                 kms_vault_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_updated: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: (Updatable) The OCID of the KMS encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the id will be a null string.
        :param _builtins.str kms_key_state: (Updatable) The current state of the encryption key assigned to this Hosted Environment. Oracle-managed keys will always report an ACTIVE state.
        :param _builtins.str kms_vault_id: (Updatable) The OCID of the vault containing the encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the kmsVaultId will be a null string.
        :param _builtins.str time_created: (Updatable) The timestamp when encryption key was first enabled for this Hosted Environment. RFC3339 formatted.
        :param _builtins.str time_updated: (Updatable) The timestamp of the last update to the encryption key status. RFC3339 formatted. 
               
               
               ** IMPORTANT **
               The configuration cannot be deleted.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)
        if kms_vault_id is not None:
            pulumi.set(__self__, "kms_vault_id", kms_vault_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the KMS encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the id will be a null string.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[_builtins.str]:
        """
        (Updatable) The current state of the encryption key assigned to this Hosted Environment. Oracle-managed keys will always report an ACTIVE state.
        """
        return pulumi.get(self, "kms_key_state")

    @_builtins.property
    @pulumi.getter(name="kmsVaultId")
    def kms_vault_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The OCID of the vault containing the encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the kmsVaultId will be a null string.
        """
        return pulumi.get(self, "kms_vault_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        (Updatable) The timestamp when encryption key was first enabled for this Hosted Environment. RFC3339 formatted.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[_builtins.str]:
        """
        (Updatable) The timestamp of the last update to the encryption key status. RFC3339 formatted. 


        ** IMPORTANT **
        The configuration cannot be deleted.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class IndexKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "jsonFieldType":
            suggest = "json_field_type"
        elif key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: _builtins.str,
                 json_field_type: Optional[_builtins.str] = None,
                 json_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str column_name: The name of a column to be included as an index key.
        :param _builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param _builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        if json_field_type is not None:
            pulumi.set(__self__, "json_field_type", json_field_type)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> _builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> Optional[_builtins.str]:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @_builtins.property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[_builtins.str]:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class TableReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityMode":
            suggest = "capacity_mode"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "maxWriteUnits":
            suggest = "max_write_units"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_mode: Optional[_builtins.str] = None,
                 lifecycle_details: Optional[_builtins.str] = None,
                 max_write_units: Optional[_builtins.int] = None,
                 region: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 table_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param _builtins.str region: A customer-facing region identifier
        :param _builtins.str state: The state of a table.
        :param _builtins.str table_id: The OCID of the replica table
        """
        if capacity_mode is not None:
            pulumi.set(__self__, "capacity_mode", capacity_mode)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_write_units is not None:
            pulumi.set(__self__, "max_write_units", max_write_units)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> Optional[_builtins.str]:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[_builtins.str]:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> Optional[_builtins.int]:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        A customer-facing region identifier
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of a table.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the replica table
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class TableSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryKeys":
            suggest = "primary_keys"
        elif key == "shardKeys":
            suggest = "shard_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.TableSchemaColumn']] = None,
                 identities: Optional[Sequence['outputs.TableSchemaIdentity']] = None,
                 primary_keys: Optional[Sequence[_builtins.str]] = None,
                 shard_keys: Optional[Sequence[_builtins.str]] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param Sequence['TableSchemaColumnArgs'] columns: The columns of a table.
        :param Sequence['TableSchemaIdentityArgs'] identities: The identity properties of a table, if any.
        :param Sequence[_builtins.str] primary_keys: A list of column names that make up a key.
        :param Sequence[_builtins.str] shard_keys: A list of column names that make up a key.
        :param _builtins.int ttl: The default Time-to-Live for the table, in days.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if shard_keys is not None:
            pulumi.set(__self__, "shard_keys", shard_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.TableSchemaColumn']]:
        """
        The columns of a table.
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Optional[Sequence['outputs.TableSchemaIdentity']]:
        """
        The identity properties of a table, if any.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "shard_keys")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The default Time-to-Live for the table, in days.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class TableSchemaColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "isAsUuid":
            suggest = "is_as_uuid"
        elif key == "isGenerated":
            suggest = "is_generated"
        elif key == "isNullable":
            suggest = "is_nullable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchemaColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchemaColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchemaColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[_builtins.str] = None,
                 is_as_uuid: Optional[_builtins.bool] = None,
                 is_generated: Optional[_builtins.bool] = None,
                 is_nullable: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str default_value: The column default value.
        :param _builtins.bool is_as_uuid: True if the STRING column was declared AS UUID.
        :param _builtins.bool is_generated: True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        :param _builtins.bool is_nullable: The column nullable flag.
        :param _builtins.str name: Table name.
        :param _builtins.str type: The column type.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if is_as_uuid is not None:
            pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        if is_generated is not None:
            pulumi.set(__self__, "is_generated", is_generated)
        if is_nullable is not None:
            pulumi.set(__self__, "is_nullable", is_nullable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[_builtins.str]:
        """
        The column default value.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> Optional[_builtins.bool]:
        """
        True if the STRING column was declared AS UUID.
        """
        return pulumi.get(self, "is_as_uuid")

    @_builtins.property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> Optional[_builtins.bool]:
        """
        True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        """
        return pulumi.get(self, "is_generated")

    @_builtins.property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> Optional[_builtins.bool]:
        """
        The column nullable flag.
        """
        return pulumi.get(self, "is_nullable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Table name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The column type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableSchemaIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"
        elif key == "isAlways":
            suggest = "is_always"
        elif key == "isNull":
            suggest = "is_null"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSchemaIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSchemaIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSchemaIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[_builtins.str] = None,
                 is_always: Optional[_builtins.bool] = None,
                 is_null: Optional[_builtins.bool] = None):
        """
        :param _builtins.str column_name: The name of the identity column.
        :param _builtins.bool is_always: True if the identity value is GENERATED ALWAYS.
        :param _builtins.bool is_null: True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if is_always is not None:
            pulumi.set(__self__, "is_always", is_always)
        if is_null is not None:
            pulumi.set(__self__, "is_null", is_null)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[_builtins.str]:
        """
        The name of the identity column.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> Optional[_builtins.bool]:
        """
        True if the identity value is GENERATED ALWAYS.
        """
        return pulumi.get(self, "is_always")

    @_builtins.property
    @pulumi.getter(name="isNull")
    def is_null(self) -> Optional[_builtins.bool]:
        """
        True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        return pulumi.get(self, "is_null")


@pulumi.output_type
class TableTableLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadUnits":
            suggest = "max_read_units"
        elif key == "maxStorageInGbs":
            suggest = "max_storage_in_gbs"
        elif key == "maxWriteUnits":
            suggest = "max_write_units"
        elif key == "capacityMode":
            suggest = "capacity_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_units: _builtins.int,
                 max_storage_in_gbs: _builtins.int,
                 max_write_units: _builtins.int,
                 capacity_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.int max_read_units: (Updatable) Maximum sustained read throughput limit for the table.
        :param _builtins.int max_storage_in_gbs: (Updatable) Maximum size of storage used by the table.
        :param _builtins.int max_write_units: (Updatable) Maximum sustained write throughput limit for the table.
               
               
               ** IMPORTANT **
               Any change to a property that is not identified as "Updateable" will force the destruction and recreation of the resource with the new property values.
        :param _builtins.str capacity_mode: (Updatable) The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)
        if capacity_mode is not None:
            pulumi.set(__self__, "capacity_mode", capacity_mode)

    @_builtins.property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> _builtins.int:
        """
        (Updatable) Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @_builtins.property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> _builtins.int:
        """
        (Updatable) Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> _builtins.int:
        """
        (Updatable) Maximum sustained write throughput limit for the table.


        ** IMPORTANT **
        Any change to a property that is not identified as "Updateable" will force the destruction and recreation of the resource with the new property values.
        """
        return pulumi.get(self, "max_write_units")

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> Optional[_builtins.str]:
        """
        (Updatable) The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")


@pulumi.output_type
class GetConfigurationKmsKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 kms_key_state: _builtins.str,
                 kms_vault_id: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str id: The OCID of the KMS encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the id will be a null string.
        :param _builtins.str kms_key_state: The current state of the encryption key assigned to this Hosted Environment. Oracle-managed keys will always report an ACTIVE state.
        :param _builtins.str kms_vault_id: The OCID of the vault containing the encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the kmsVaultId will be a null string.
        :param _builtins.str time_created: The timestamp when encryption key was first enabled for this Hosted Environment. RFC3339 formatted.
        :param _builtins.str time_updated: The timestamp of the last update to the encryption key status. RFC3339 formatted.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kms_key_state", kms_key_state)
        pulumi.set(__self__, "kms_vault_id", kms_vault_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the KMS encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the id will be a null string.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> _builtins.str:
        """
        The current state of the encryption key assigned to this Hosted Environment. Oracle-managed keys will always report an ACTIVE state.
        """
        return pulumi.get(self, "kms_key_state")

    @_builtins.property
    @pulumi.getter(name="kmsVaultId")
    def kms_vault_id(self) -> _builtins.str:
        """
        The OCID of the vault containing the encryption key assigned to this Hosted Environment. If the Hosted Environment is using an Oracle-managed Key (i.e., not a CMEK), then the kmsVaultId will be a null string.
        """
        return pulumi.get(self, "kms_vault_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The timestamp when encryption key was first enabled for this Hosted Environment. RFC3339 formatted.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The timestamp of the last update to the encryption key status. RFC3339 formatted.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetIndexKeyResult(dict):
    def __init__(__self__, *,
                 column_name: _builtins.str,
                 json_field_type: _builtins.str,
                 json_path: _builtins.str):
        """
        :param _builtins.str column_name: The name of a column to be included as an index key.
        :param _builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param _builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "json_field_type", json_field_type)
        pulumi.set(__self__, "json_path", json_path)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> _builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> _builtins.str:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @_builtins.property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> _builtins.str:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class GetIndexesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetIndexesIndexCollectionResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 id: _builtins.str,
                 is_if_not_exists: _builtins.bool,
                 keys: Sequence['outputs.GetIndexesIndexCollectionKeyResult'],
                 lifecycle_details: _builtins.str,
                 name: _builtins.str,
                 state: _builtins.str,
                 table_id: _builtins.str,
                 table_name: _builtins.str,
                 table_name_or_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of a table's compartment. When a table is identified by name, the compartmentId is often needed to provide context for interpreting the name.
        :param Sequence['GetIndexesIndexCollectionKeyArgs'] keys: A set of keys for a secondary index.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
        :param _builtins.str state: Filter list by the lifecycle state of the item.
        :param _builtins.str table_id: the OCID of the table to which this index belongs.
        :param _builtins.str table_name: The name of the table to which this index belongs.
        :param _builtins.str table_name_or_id: A table name within the compartment, or a table OCID.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_if_not_exists", is_if_not_exists)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "table_name_or_id", table_name_or_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of a table's compartment. When a table is identified by name, the compartmentId is often needed to provide context for interpreting the name.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isIfNotExists")
    def is_if_not_exists(self) -> _builtins.bool:
        return pulumi.get(self, "is_if_not_exists")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetIndexesIndexCollectionKeyResult']:
        """
        A set of keys for a secondary index.
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> _builtins.str:
        """
        the OCID of the table to which this index belongs.
        """
        return pulumi.get(self, "table_id")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The name of the table to which this index belongs.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> _builtins.str:
        """
        A table name within the compartment, or a table OCID.
        """
        return pulumi.get(self, "table_name_or_id")


@pulumi.output_type
class GetIndexesIndexCollectionKeyResult(dict):
    def __init__(__self__, *,
                 column_name: _builtins.str,
                 json_field_type: _builtins.str,
                 json_path: _builtins.str):
        """
        :param _builtins.str column_name: The name of a column to be included as an index key.
        :param _builtins.str json_field_type: If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        :param _builtins.str json_path: If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "json_field_type", json_field_type)
        pulumi.set(__self__, "json_path", json_path)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> _builtins.str:
        """
        The name of a column to be included as an index key.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="jsonFieldType")
    def json_field_type(self) -> _builtins.str:
        """
        If the specified column is of type JSON, jsonFieldType contains the type of the field indicated by jsonPath.
        """
        return pulumi.get(self, "json_field_type")

    @_builtins.property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> _builtins.str:
        """
        If the specified column is of type JSON, jsonPath contains a dotted path indicating the field within the JSON object that will be the index key.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class GetTableReplicaResult(dict):
    def __init__(__self__, *,
                 capacity_mode: _builtins.str,
                 lifecycle_details: _builtins.str,
                 max_write_units: _builtins.int,
                 region: _builtins.str,
                 state: _builtins.str,
                 table_id: _builtins.str):
        """
        :param _builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param _builtins.str region: A customer-facing region identifier
        :param _builtins.str state: The state of a table.
        :param _builtins.str table_id: The OCID of the replica table
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_write_units", max_write_units)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> _builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> _builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        A customer-facing region identifier
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of a table.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> _builtins.str:
        """
        The OCID of the replica table
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GetTableSchemaResult(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.GetTableSchemaColumnResult'],
                 identities: Sequence['outputs.GetTableSchemaIdentityResult'],
                 primary_keys: Sequence[_builtins.str],
                 shard_keys: Sequence[_builtins.str],
                 ttl: _builtins.int):
        """
        :param Sequence['GetTableSchemaColumnArgs'] columns: The columns of a table.
        :param Sequence['GetTableSchemaIdentityArgs'] identities: The identity properties of a table, if any.
        :param Sequence[_builtins.str] primary_keys: A list of column names that make up a key.
        :param Sequence[_builtins.str] shard_keys: A list of column names that make up a key.
        :param _builtins.int ttl: The default Time-to-Live for the table, in days.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "shard_keys", shard_keys)
        pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.GetTableSchemaColumnResult']:
        """
        The columns of a table.
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetTableSchemaIdentityResult']:
        """
        The identity properties of a table, if any.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence[_builtins.str]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Sequence[_builtins.str]:
        """
        A list of column names that make up a key.
        """
        return pulumi.get(self, "shard_keys")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        The default Time-to-Live for the table, in days.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetTableSchemaColumnResult(dict):
    def __init__(__self__, *,
                 default_value: _builtins.str,
                 is_as_uuid: _builtins.bool,
                 is_generated: _builtins.bool,
                 is_nullable: _builtins.bool,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str default_value: The column default value.
        :param _builtins.bool is_as_uuid: True if the STRING column was declared AS UUID.
        :param _builtins.bool is_generated: True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        :param _builtins.bool is_nullable: The column nullable flag.
        :param _builtins.str name: The column name.
        :param _builtins.str type: The column type.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        pulumi.set(__self__, "is_generated", is_generated)
        pulumi.set(__self__, "is_nullable", is_nullable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The column default value.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> _builtins.bool:
        """
        True if the STRING column was declared AS UUID.
        """
        return pulumi.get(self, "is_as_uuid")

    @_builtins.property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> _builtins.bool:
        """
        True if the STRING AS UUID column is also GENERATED BY DEFAULT.
        """
        return pulumi.get(self, "is_generated")

    @_builtins.property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> _builtins.bool:
        """
        The column nullable flag.
        """
        return pulumi.get(self, "is_nullable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The column name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The column type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTableSchemaIdentityResult(dict):
    def __init__(__self__, *,
                 column_name: _builtins.str,
                 is_always: _builtins.bool,
                 is_null: _builtins.bool):
        """
        :param _builtins.str column_name: The name of the identity column.
        :param _builtins.bool is_always: True if the identity value is GENERATED ALWAYS.
        :param _builtins.bool is_null: True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "is_always", is_always)
        pulumi.set(__self__, "is_null", is_null)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> _builtins.str:
        """
        The name of the identity column.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> _builtins.bool:
        """
        True if the identity value is GENERATED ALWAYS.
        """
        return pulumi.get(self, "is_always")

    @_builtins.property
    @pulumi.getter(name="isNull")
    def is_null(self) -> _builtins.bool:
        """
        True if the identity value is GENERATED BY DEFAULT ON NULL.
        """
        return pulumi.get(self, "is_null")


@pulumi.output_type
class GetTableTableLimitResult(dict):
    def __init__(__self__, *,
                 capacity_mode: _builtins.str,
                 max_read_units: _builtins.int,
                 max_storage_in_gbs: _builtins.int,
                 max_write_units: _builtins.int):
        """
        :param _builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param _builtins.int max_read_units: Maximum sustained read throughput limit for the table.
        :param _builtins.int max_storage_in_gbs: Maximum size of storage used by the table.
        :param _builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> _builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @_builtins.property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> _builtins.int:
        """
        Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @_builtins.property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> _builtins.int:
        """
        Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> _builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")


@pulumi.output_type
class GetTablesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTablesTableCollectionResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 ddl_statement: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_auto_reclaimable: _builtins.bool,
                 is_multi_region: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 local_replica_initialization_in_percent: _builtins.int,
                 name: _builtins.str,
                 replicas: Sequence['outputs.GetTablesTableCollectionReplicaResult'],
                 schema_state: _builtins.str,
                 schemas: Sequence['outputs.GetTablesTableCollectionSchemaResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 table_limits: Sequence['outputs.GetTablesTableCollectionTableLimitResult'],
                 time_created: _builtins.str,
                 time_of_expiration: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of a table's compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace": {"bar-key": "value"}}`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: Unique identifier that is immutable.
        :param _builtins.bool is_auto_reclaimable: True if this table can be reclaimed after an idle period.
        :param _builtins.bool is_multi_region: True if this table is currently a member of a replication set.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
        :param _builtins.str schema_state: The current state of this table's schema. Available states are MUTABLE - The schema can be changed. The table is not eligible for replication. FROZEN - The schema is immutable. The table is eligible for replication.
        :param _builtins.str state: Filter list by the lifecycle state of the item.
        :param Mapping[str, _builtins.str] system_tags: Read-only system tag. These predefined keys are scoped to namespaces.  At present the only supported namespace is `"orcl-cloud"`; and the only key in that namespace is `"free-tier-retained"`. Example: `{"orcl-cloud"": {"free-tier-retained": "true"}}`
        :param Sequence['GetTablesTableCollectionTableLimitArgs'] table_limits: Throughput and storage limits configuration of a table.
        :param _builtins.str time_created: The time the the table was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_of_expiration: If lifecycleState is INACTIVE, indicates when this table will be automatically removed. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time the the table's metadata was last updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "ddl_statement", ddl_statement)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_reclaimable", is_auto_reclaimable)
        pulumi.set(__self__, "is_multi_region", is_multi_region)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "local_replica_initialization_in_percent", local_replica_initialization_in_percent)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "schema_state", schema_state)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "table_limits", table_limits)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_of_expiration", time_of_expiration)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of a table's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="ddlStatement")
    def ddl_statement(self) -> _builtins.str:
        return pulumi.get(self, "ddl_statement")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier that is immutable.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoReclaimable")
    def is_auto_reclaimable(self) -> _builtins.bool:
        """
        True if this table can be reclaimed after an idle period.
        """
        return pulumi.get(self, "is_auto_reclaimable")

    @_builtins.property
    @pulumi.getter(name="isMultiRegion")
    def is_multi_region(self) -> _builtins.bool:
        """
        True if this table is currently a member of a replication set.
        """
        return pulumi.get(self, "is_multi_region")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="localReplicaInitializationInPercent")
    def local_replica_initialization_in_percent(self) -> _builtins.int:
        return pulumi.get(self, "local_replica_initialization_in_percent")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.GetTablesTableCollectionReplicaResult']:
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="schemaState")
    def schema_state(self) -> _builtins.str:
        """
        The current state of this table's schema. Available states are MUTABLE - The schema can be changed. The table is not eligible for replication. FROZEN - The schema is immutable. The table is eligible for replication.
        """
        return pulumi.get(self, "schema_state")

    @_builtins.property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.GetTablesTableCollectionSchemaResult']:
        return pulumi.get(self, "schemas")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Read-only system tag. These predefined keys are scoped to namespaces.  At present the only supported namespace is `"orcl-cloud"`; and the only key in that namespace is `"free-tier-retained"`. Example: `{"orcl-cloud"": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tableLimits")
    def table_limits(self) -> Sequence['outputs.GetTablesTableCollectionTableLimitResult']:
        """
        Throughput and storage limits configuration of a table.
        """
        return pulumi.get(self, "table_limits")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the the table was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfExpiration")
    def time_of_expiration(self) -> _builtins.str:
        """
        If lifecycleState is INACTIVE, indicates when this table will be automatically removed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_of_expiration")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the the table's metadata was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetTablesTableCollectionReplicaResult(dict):
    def __init__(__self__, *,
                 capacity_mode: _builtins.str,
                 lifecycle_details: _builtins.str,
                 max_write_units: _builtins.int,
                 region: _builtins.str,
                 state: _builtins.str,
                 table_id: _builtins.str):
        """
        :param _builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param _builtins.str lifecycle_details: A message describing the current state in more detail.
        :param _builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        :param _builtins.str state: Filter list by the lifecycle state of the item.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_write_units", max_write_units)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "table_id", table_id)

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> _builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> _builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Filter list by the lifecycle state of the item.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> _builtins.str:
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GetTablesTableCollectionSchemaResult(dict):
    def __init__(__self__, *,
                 columns: Sequence['outputs.GetTablesTableCollectionSchemaColumnResult'],
                 identities: Sequence['outputs.GetTablesTableCollectionSchemaIdentityResult'],
                 primary_keys: Sequence[_builtins.str],
                 shard_keys: Sequence[_builtins.str],
                 ttl: _builtins.int):
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "shard_keys", shard_keys)
        pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.GetTablesTableCollectionSchemaColumnResult']:
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetTablesTableCollectionSchemaIdentityResult']:
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="shardKeys")
    def shard_keys(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "shard_keys")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetTablesTableCollectionSchemaColumnResult(dict):
    def __init__(__self__, *,
                 default_value: _builtins.str,
                 is_as_uuid: _builtins.bool,
                 is_generated: _builtins.bool,
                 is_nullable: _builtins.bool,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: A shell-globbing-style (*?[]) filter for names.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "is_as_uuid", is_as_uuid)
        pulumi.set(__self__, "is_generated", is_generated)
        pulumi.set(__self__, "is_nullable", is_nullable)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="isAsUuid")
    def is_as_uuid(self) -> _builtins.bool:
        return pulumi.get(self, "is_as_uuid")

    @_builtins.property
    @pulumi.getter(name="isGenerated")
    def is_generated(self) -> _builtins.bool:
        return pulumi.get(self, "is_generated")

    @_builtins.property
    @pulumi.getter(name="isNullable")
    def is_nullable(self) -> _builtins.bool:
        return pulumi.get(self, "is_nullable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A shell-globbing-style (*?[]) filter for names.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTablesTableCollectionSchemaIdentityResult(dict):
    def __init__(__self__, *,
                 column_name: _builtins.str,
                 is_always: _builtins.bool,
                 is_null: _builtins.bool):
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "is_always", is_always)
        pulumi.set(__self__, "is_null", is_null)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> _builtins.str:
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="isAlways")
    def is_always(self) -> _builtins.bool:
        return pulumi.get(self, "is_always")

    @_builtins.property
    @pulumi.getter(name="isNull")
    def is_null(self) -> _builtins.bool:
        return pulumi.get(self, "is_null")


@pulumi.output_type
class GetTablesTableCollectionTableLimitResult(dict):
    def __init__(__self__, *,
                 capacity_mode: _builtins.str,
                 max_read_units: _builtins.int,
                 max_storage_in_gbs: _builtins.int,
                 max_write_units: _builtins.int):
        """
        :param _builtins.str capacity_mode: The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        :param _builtins.int max_read_units: Maximum sustained read throughput limit for the table.
        :param _builtins.int max_storage_in_gbs: Maximum size of storage used by the table.
        :param _builtins.int max_write_units: Maximum sustained write throughput limit for the table.
        """
        pulumi.set(__self__, "capacity_mode", capacity_mode)
        pulumi.set(__self__, "max_read_units", max_read_units)
        pulumi.set(__self__, "max_storage_in_gbs", max_storage_in_gbs)
        pulumi.set(__self__, "max_write_units", max_write_units)

    @_builtins.property
    @pulumi.getter(name="capacityMode")
    def capacity_mode(self) -> _builtins.str:
        """
        The capacity mode of the table.  If capacityMode = ON_DEMAND, maxReadUnits and maxWriteUnits are not used, and both will have the value of zero.
        """
        return pulumi.get(self, "capacity_mode")

    @_builtins.property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> _builtins.int:
        """
        Maximum sustained read throughput limit for the table.
        """
        return pulumi.get(self, "max_read_units")

    @_builtins.property
    @pulumi.getter(name="maxStorageInGbs")
    def max_storage_in_gbs(self) -> _builtins.int:
        """
        Maximum size of storage used by the table.
        """
        return pulumi.get(self, "max_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> _builtins.int:
        """
        Maximum sustained write throughput limit for the table.
        """
        return pulumi.get(self, "max_write_units")


