# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetWlmsWlsDomainServerBackupContentResult',
    'AwaitableGetWlmsWlsDomainServerBackupContentResult',
    'get_wlms_wls_domain_server_backup_content',
    'get_wlms_wls_domain_server_backup_content_output',
]

@pulumi.output_type
class GetWlmsWlsDomainServerBackupContentResult:
    """
    A collection of values returned by getWlmsWlsDomainServerBackupContent.
    """
    def __init__(__self__, backup_id=None, content_type=None, id=None, middlewares=None, server_id=None, wls_domain_id=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if middlewares and not isinstance(middlewares, list):
            raise TypeError("Expected argument 'middlewares' to be a list")
        pulumi.set(__self__, "middlewares", middlewares)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The type of content of the backup.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def middlewares(self) -> Sequence['outputs.GetWlmsWlsDomainServerBackupContentMiddlewareResult']:
        """
        The content of the middleware binaries included in a backup.
        """
        return pulumi.get(self, "middlewares")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsWlsDomainServerBackupContentResult(GetWlmsWlsDomainServerBackupContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainServerBackupContentResult(
            backup_id=self.backup_id,
            content_type=self.content_type,
            id=self.id,
            middlewares=self.middlewares,
            server_id=self.server_id,
            wls_domain_id=self.wls_domain_id)


def get_wlms_wls_domain_server_backup_content(backup_id: Optional[_builtins.str] = None,
                                              server_id: Optional[_builtins.str] = None,
                                              wls_domain_id: Optional[_builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainServerBackupContentResult:
    """
    This data source provides details about a specific Wls Domain Server Backup Content resource in Oracle Cloud Infrastructure Wlms service.

    Get details of specific backup for the WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backup_content = oci.oci.get_wlms_wls_domain_server_backup_content(backup_id=test_backup["id"],
        server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param _builtins.str backup_id: The unique identifier of the backup.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomainServerBackupContent:getWlmsWlsDomainServerBackupContent', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupContentResult).value

    return AwaitableGetWlmsWlsDomainServerBackupContentResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        content_type=pulumi.get(__ret__, 'content_type'),
        id=pulumi.get(__ret__, 'id'),
        middlewares=pulumi.get(__ret__, 'middlewares'),
        server_id=pulumi.get(__ret__, 'server_id'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_wls_domain_server_backup_content_output(backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     server_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     wls_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainServerBackupContentResult]:
    """
    This data source provides details about a specific Wls Domain Server Backup Content resource in Oracle Cloud Infrastructure Wlms service.

    Get details of specific backup for the WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backup_content = oci.oci.get_wlms_wls_domain_server_backup_content(backup_id=test_backup["id"],
        server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param _builtins.str backup_id: The unique identifier of the backup.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomainServerBackupContent:getWlmsWlsDomainServerBackupContent', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupContentResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainServerBackupContentResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        content_type=pulumi.get(__response__, 'content_type'),
        id=pulumi.get(__response__, 'id'),
        middlewares=pulumi.get(__response__, 'middlewares'),
        server_id=pulumi.get(__response__, 'server_id'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
