# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOdaPrivateEndpointScanProxiesResult',
    'AwaitableGetOdaPrivateEndpointScanProxiesResult',
    'get_oda_private_endpoint_scan_proxies',
    'get_oda_private_endpoint_scan_proxies_output',
]

@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesResult:
    """
    A collection of values returned by getOdaPrivateEndpointScanProxies.
    """
    def __init__(__self__, filters=None, id=None, oda_private_endpoint_id=None, oda_private_endpoint_scan_proxy_collections=None, state=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oda_private_endpoint_id and not isinstance(oda_private_endpoint_id, str):
            raise TypeError("Expected argument 'oda_private_endpoint_id' to be a str")
        pulumi.set(__self__, "oda_private_endpoint_id", oda_private_endpoint_id)
        if oda_private_endpoint_scan_proxy_collections and not isinstance(oda_private_endpoint_scan_proxy_collections, list):
            raise TypeError("Expected argument 'oda_private_endpoint_scan_proxy_collections' to be a list")
        pulumi.set(__self__, "oda_private_endpoint_scan_proxy_collections", oda_private_endpoint_scan_proxy_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOdaPrivateEndpointScanProxiesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "oda_private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="odaPrivateEndpointScanProxyCollections")
    def oda_private_endpoint_scan_proxy_collections(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult']:
        """
        The list of oda_private_endpoint_scan_proxy_collection.
        """
        return pulumi.get(self, "oda_private_endpoint_scan_proxy_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "state")


class AwaitableGetOdaPrivateEndpointScanProxiesResult(GetOdaPrivateEndpointScanProxiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOdaPrivateEndpointScanProxiesResult(
            filters=self.filters,
            id=self.id,
            oda_private_endpoint_id=self.oda_private_endpoint_id,
            oda_private_endpoint_scan_proxy_collections=self.oda_private_endpoint_scan_proxy_collections,
            state=self.state)


def get_oda_private_endpoint_scan_proxies(filters: Optional[Sequence[Union['GetOdaPrivateEndpointScanProxiesFilterArgs', 'GetOdaPrivateEndpointScanProxiesFilterArgsDict']]] = None,
                                          oda_private_endpoint_id: Optional[_builtins.str] = None,
                                          state: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOdaPrivateEndpointScanProxiesResult:
    """
    This data source provides the list of Oda Private Endpoint Scan Proxies in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of ODA Private Endpoint Scan Proxies that belong to the specified
    ODA Private Endpoint.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoint_scan_proxies = oci.Oda.get_oda_private_endpoint_scan_proxies(oda_private_endpoint_id=test_oda_private_endpoint["id"],
        state=oda_private_endpoint_scan_proxy_state)
    ```


    :param _builtins.str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['odaPrivateEndpointId'] = oda_private_endpoint_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Oda/getOdaPrivateEndpointScanProxies:getOdaPrivateEndpointScanProxies', __args__, opts=opts, typ=GetOdaPrivateEndpointScanProxiesResult).value

    return AwaitableGetOdaPrivateEndpointScanProxiesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oda_private_endpoint_id=pulumi.get(__ret__, 'oda_private_endpoint_id'),
        oda_private_endpoint_scan_proxy_collections=pulumi.get(__ret__, 'oda_private_endpoint_scan_proxy_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_oda_private_endpoint_scan_proxies_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOdaPrivateEndpointScanProxiesFilterArgs', 'GetOdaPrivateEndpointScanProxiesFilterArgsDict']]]]] = None,
                                                 oda_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOdaPrivateEndpointScanProxiesResult]:
    """
    This data source provides the list of Oda Private Endpoint Scan Proxies in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of ODA Private Endpoint Scan Proxies that belong to the specified
    ODA Private Endpoint.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoint_scan_proxies = oci.Oda.get_oda_private_endpoint_scan_proxies(oda_private_endpoint_id=test_oda_private_endpoint["id"],
        state=oda_private_endpoint_scan_proxy_state)
    ```


    :param _builtins.str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['odaPrivateEndpointId'] = oda_private_endpoint_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Oda/getOdaPrivateEndpointScanProxies:getOdaPrivateEndpointScanProxies', __args__, opts=opts, typ=GetOdaPrivateEndpointScanProxiesResult)
    return __ret__.apply(lambda __response__: GetOdaPrivateEndpointScanProxiesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        oda_private_endpoint_id=pulumi.get(__response__, 'oda_private_endpoint_id'),
        oda_private_endpoint_scan_proxy_collections=pulumi.get(__response__, 'oda_private_endpoint_scan_proxy_collections'),
        state=pulumi.get(__response__, 'state')))
