# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseInsightsResult',
    'AwaitableGetDatabaseInsightsResult',
    'get_database_insights',
    'get_database_insights_output',
]

@pulumi.output_type
class GetDatabaseInsightsResult:
    """
    A collection of values returned by getDatabaseInsights.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, database_ids=None, database_insights_collections=None, database_types=None, enterprise_manager_bridge_id=None, exadata_insight_id=None, fields=None, filters=None, id=None, opsi_private_endpoint_id=None, states=None, statuses=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if database_ids and not isinstance(database_ids, list):
            raise TypeError("Expected argument 'database_ids' to be a list")
        pulumi.set(__self__, "database_ids", database_ids)
        if database_insights_collections and not isinstance(database_insights_collections, list):
            raise TypeError("Expected argument 'database_insights_collections' to be a list")
        pulumi.set(__self__, "database_insights_collections", database_insights_collections)
        if database_types and not isinstance(database_types, list):
            raise TypeError("Expected argument 'database_types' to be a list")
        pulumi.set(__self__, "database_types", database_types)
        if enterprise_manager_bridge_id and not isinstance(enterprise_manager_bridge_id, str):
            raise TypeError("Expected argument 'enterprise_manager_bridge_id' to be a str")
        pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if exadata_insight_id and not isinstance(exadata_insight_id, str):
            raise TypeError("Expected argument 'exadata_insight_id' to be a str")
        pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opsi_private_endpoint_id and not isinstance(opsi_private_endpoint_id, str):
            raise TypeError("Expected argument 'opsi_private_endpoint_id' to be a str")
        pulumi.set(__self__, "opsi_private_endpoint_id", opsi_private_endpoint_id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Compartment identifier of the database
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="databaseIds")
    def database_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_ids")

    @_builtins.property
    @pulumi.getter(name="databaseInsightsCollections")
    def database_insights_collections(self) -> Sequence['outputs.GetDatabaseInsightsDatabaseInsightsCollectionResult']:
        """
        The list of database_insights_collection.
        """
        return pulumi.get(self, "database_insights_collections")

    @_builtins.property
    @pulumi.getter(name="databaseTypes")
    def database_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Ops Insights internal representation of the database type.
        """
        return pulumi.get(self, "database_types")

    @_builtins.property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[_builtins.str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @_builtins.property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseInsightsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Database insight identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[Sequence[_builtins.str]]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Indicates the status of a database insight in Operations Insights
        """
        return pulumi.get(self, "statuses")


class AwaitableGetDatabaseInsightsResult(GetDatabaseInsightsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseInsightsResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            database_ids=self.database_ids,
            database_insights_collections=self.database_insights_collections,
            database_types=self.database_types,
            enterprise_manager_bridge_id=self.enterprise_manager_bridge_id,
            exadata_insight_id=self.exadata_insight_id,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            opsi_private_endpoint_id=self.opsi_private_endpoint_id,
            states=self.states,
            statuses=self.statuses)


def get_database_insights(compartment_id: Optional[_builtins.str] = None,
                          compartment_id_in_subtree: Optional[_builtins.bool] = None,
                          database_ids: Optional[Sequence[_builtins.str]] = None,
                          database_types: Optional[Sequence[_builtins.str]] = None,
                          enterprise_manager_bridge_id: Optional[_builtins.str] = None,
                          exadata_insight_id: Optional[_builtins.str] = None,
                          fields: Optional[Sequence[_builtins.str]] = None,
                          filters: Optional[Sequence[Union['GetDatabaseInsightsFilterArgs', 'GetDatabaseInsightsFilterArgsDict']]] = None,
                          id: Optional[_builtins.str] = None,
                          opsi_private_endpoint_id: Optional[_builtins.str] = None,
                          states: Optional[Sequence[_builtins.str]] = None,
                          statuses: Optional[Sequence[_builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseInsightsResult:
    """
    This data source provides the list of Database Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of database insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of database insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_insights = oci.Opsi.get_database_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=database_insight_compartment_id_in_subtree,
        database_ids=test_database["id"],
        database_types=database_insight_database_type,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_insight_id=test_exadata_insight["id"],
        fields=database_insight_fields,
        id=database_insight_id,
        opsi_private_endpoint_id=test_private_endpoint["id"],
        states=database_insight_state,
        statuses=database_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param Sequence[_builtins.str] database_ids: Optional list of database [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated DBaaS entity.
    :param Sequence[_builtins.str] database_types: Filter by one or more database type. Possible values are ADW-S, ATP-S, ADW-D, ATP-D, EXTERNAL-PDB, EXTERNAL-NONCDB.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param _builtins.str exadata_insight_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of exadata insight resource.
    :param Sequence[_builtins.str] fields: Specifies the fields to return in a database summary response. By default all fields are returned if omitted.
    :param _builtins.str id: Optional list of database insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str opsi_private_endpoint_id: Unique Operations Insights PrivateEndpoint identifier
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['databaseIds'] = database_ids
    __args__['databaseTypes'] = database_types
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataInsightId'] = exadata_insight_id
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['opsiPrivateEndpointId'] = opsi_private_endpoint_id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getDatabaseInsights:getDatabaseInsights', __args__, opts=opts, typ=GetDatabaseInsightsResult).value

    return AwaitableGetDatabaseInsightsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        database_ids=pulumi.get(__ret__, 'database_ids'),
        database_insights_collections=pulumi.get(__ret__, 'database_insights_collections'),
        database_types=pulumi.get(__ret__, 'database_types'),
        enterprise_manager_bridge_id=pulumi.get(__ret__, 'enterprise_manager_bridge_id'),
        exadata_insight_id=pulumi.get(__ret__, 'exadata_insight_id'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        opsi_private_endpoint_id=pulumi.get(__ret__, 'opsi_private_endpoint_id'),
        states=pulumi.get(__ret__, 'states'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_database_insights_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 database_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 database_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 enterprise_manager_bridge_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 exadata_insight_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 fields: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseInsightsFilterArgs', 'GetDatabaseInsightsFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opsi_private_endpoint_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 statuses: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseInsightsResult]:
    """
    This data source provides the list of Database Insights in Oracle Cloud Infrastructure Opsi service.

    Gets a list of database insights based on the query parameters specified. Either compartmentId or id query parameter must be specified.
    When both compartmentId and compartmentIdInSubtree are specified, a list of database insights in that compartment and in all sub-compartments will be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_insights = oci.Opsi.get_database_insights(compartment_id=compartment_id,
        compartment_id_in_subtree=database_insight_compartment_id_in_subtree,
        database_ids=test_database["id"],
        database_types=database_insight_database_type,
        enterprise_manager_bridge_id=test_enterprise_manager_bridge["id"],
        exadata_insight_id=test_exadata_insight["id"],
        fields=database_insight_fields,
        id=database_insight_id,
        opsi_private_endpoint_id=test_private_endpoint["id"],
        states=database_insight_state,
        statuses=database_insight_status)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.bool compartment_id_in_subtree: A flag to search all resources within a given compartment and all sub-compartments.
    :param Sequence[_builtins.str] database_ids: Optional list of database [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated DBaaS entity.
    :param Sequence[_builtins.str] database_types: Filter by one or more database type. Possible values are ADW-S, ATP-S, ADW-D, ATP-D, EXTERNAL-PDB, EXTERNAL-NONCDB.
    :param _builtins.str enterprise_manager_bridge_id: Unique Enterprise Manager bridge identifier
    :param _builtins.str exadata_insight_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of exadata insight resource.
    :param Sequence[_builtins.str] fields: Specifies the fields to return in a database summary response. By default all fields are returned if omitted.
    :param _builtins.str id: Optional list of database insight resource [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str opsi_private_endpoint_id: Unique Operations Insights PrivateEndpoint identifier
    :param Sequence[_builtins.str] states: Lifecycle states
    :param Sequence[_builtins.str] statuses: Resource Status
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['databaseIds'] = database_ids
    __args__['databaseTypes'] = database_types
    __args__['enterpriseManagerBridgeId'] = enterprise_manager_bridge_id
    __args__['exadataInsightId'] = exadata_insight_id
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['opsiPrivateEndpointId'] = opsi_private_endpoint_id
    __args__['states'] = states
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Opsi/getDatabaseInsights:getDatabaseInsights', __args__, opts=opts, typ=GetDatabaseInsightsResult)
    return __ret__.apply(lambda __response__: GetDatabaseInsightsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        database_ids=pulumi.get(__response__, 'database_ids'),
        database_insights_collections=pulumi.get(__response__, 'database_insights_collections'),
        database_types=pulumi.get(__response__, 'database_types'),
        enterprise_manager_bridge_id=pulumi.get(__response__, 'enterprise_manager_bridge_id'),
        exadata_insight_id=pulumi.get(__response__, 'exadata_insight_id'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        opsi_private_endpoint_id=pulumi.get(__response__, 'opsi_private_endpoint_id'),
        states=pulumi.get(__response__, 'states'),
        statuses=pulumi.get(__response__, 'statuses')))
