# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventArgs', 'Event']

@pulumi.input_type
class EventArgs:
    def __init__(__self__, *,
                 event_id: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Event resource.
        :param pulumi.Input[_builtins.str] event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "event_id", event_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="eventId")
    def event_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        """
        return pulumi.get(self, "event_id")

    @event_id.setter
    def event_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _EventState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datas: Optional[pulumi.Input[Sequence[pulumi.Input['EventDataArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_details: Optional[pulumi.Input[_builtins.str]] = None,
                 event_id: Optional[pulumi.Input[_builtins.str]] = None,
                 event_summary: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_details: Optional[pulumi.Input[Sequence[pulumi.Input['EventSystemDetailArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_occurred: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Event resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['EventDataArgs']]] datas: Provides additional information for a management station event.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] event_details: Details of an event.
        :param pulumi.Input[_builtins.str] event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        :param pulumi.Input[_builtins.str] event_summary: Summary of the event.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_managed_by_autonomous_linux: Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        :param pulumi.Input[_builtins.str] lifecycle_details: Describes the current state of the event in more detail. For example, the  message can provide actionable information for a resource in the 'FAILED' state.
        :param pulumi.Input[_builtins.str] resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        :param pulumi.Input[_builtins.str] state: The current state of the event.
        :param pulumi.Input[Sequence[pulumi.Input['EventSystemDetailArgs']]] system_details: Provides information about the system architecture and operating system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Event was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_occurred: The date and time that the event occurred.
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the event was updated (in [RFC 3339](https://tools.ietf.org/html/rfc3339) format). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] type: Event type:
               * `KERNEL_OOPS` - Used to identify a kernel panic condition event
               * `KERNEL_CRASH` - Used to identify an internal fatal kernel error that cannot be safely recovered from
               * `EXPLOIT_ATTEMPT` - Used to identify a known exploit detection as identified by Ksplice
               * `SOFTWARE_UPDATE` - Software updates - Packages
               * `KSPLICE_UPDATE` - Ksplice updates
               * `SOFTWARE_SOURCE` - Software source
               * `AGENT` - Agent
               * `MANAGEMENT_STATION` - Management Station
               * `SYSADMIN` - Used to identify attempts on fixing agent errors on the instance
               * `REBOOT` - Reboot
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if event_details is not None:
            pulumi.set(__self__, "event_details", event_details)
        if event_id is not None:
            pulumi.set(__self__, "event_id", event_id)
        if event_summary is not None:
            pulumi.set(__self__, "event_summary", event_summary)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_managed_by_autonomous_linux is not None:
            pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_details is not None:
            pulumi.set(__self__, "system_details", system_details)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_occurred is not None:
            pulumi.set(__self__, "time_occurred", time_occurred)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventDataArgs']]]]:
        """
        Provides additional information for a management station event.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventDataArgs']]]]):
        pulumi.set(self, "datas", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="eventDetails")
    def event_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details of an event.
        """
        return pulumi.get(self, "event_details")

    @event_details.setter
    def event_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_details", value)

    @_builtins.property
    @pulumi.getter(name="eventId")
    def event_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        """
        return pulumi.get(self, "event_id")

    @event_id.setter
    def event_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_id", value)

    @_builtins.property
    @pulumi.getter(name="eventSummary")
    def event_summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Summary of the event.
        """
        return pulumi.get(self, "event_summary")

    @event_summary.setter
    def event_summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_summary", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_managed_by_autonomous_linux", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the current state of the event in more detail. For example, the  message can provide actionable information for a resource in the 'FAILED' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the event.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemDetails")
    def system_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSystemDetailArgs']]]]:
        """
        Provides information about the system architecture and operating system.
        """
        return pulumi.get(self, "system_details")

    @system_details.setter
    def system_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSystemDetailArgs']]]]):
        pulumi.set(self, "system_details", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the Event was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeOccurred")
    def time_occurred(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the event occurred.
        """
        return pulumi.get(self, "time_occurred")

    @time_occurred.setter
    def time_occurred(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_occurred", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the event was updated (in [RFC 3339](https://tools.ietf.org/html/rfc3339) format). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event type:
        * `KERNEL_OOPS` - Used to identify a kernel panic condition event
        * `KERNEL_CRASH` - Used to identify an internal fatal kernel error that cannot be safely recovered from
        * `EXPLOIT_ATTEMPT` - Used to identify a known exploit detection as identified by Ksplice
        * `SOFTWARE_UPDATE` - Software updates - Packages
        * `KSPLICE_UPDATE` - Ksplice updates
        * `SOFTWARE_SOURCE` - Software source
        * `AGENT` - Agent
        * `MANAGEMENT_STATION` - Management Station
        * `SYSADMIN` - Used to identify attempts on fixing agent errors on the instance
        * `REBOOT` - Reboot
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:OsManagementHub/event:Event")
class Event(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Event resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the tags for an event.

        ## Import

        Events can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/event:Event test_event "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Event resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the tags for an event.

        ## Import

        Events can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/event:Event test_event "id"
        ```

        :param str resource_name: The name of the resource.
        :param EventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventArgs.__new__(EventArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if event_id is None and not opts.urn:
                raise TypeError("Missing required property 'event_id'")
            __props__.__dict__["event_id"] = event_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["datas"] = None
            __props__.__dict__["event_details"] = None
            __props__.__dict__["event_summary"] = None
            __props__.__dict__["is_managed_by_autonomous_linux"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_occurred"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(Event, __self__).__init__(
            'oci:OsManagementHub/event:Event',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventDataArgs', 'EventDataArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            event_details: Optional[pulumi.Input[_builtins.str]] = None,
            event_id: Optional[pulumi.Input[_builtins.str]] = None,
            event_summary: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_managed_by_autonomous_linux: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSystemDetailArgs', 'EventSystemDetailArgsDict']]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_occurred: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Event':
        """
        Get an existing Event resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventDataArgs', 'EventDataArgsDict']]]] datas: Provides additional information for a management station event.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] event_details: Details of an event.
        :param pulumi.Input[_builtins.str] event_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        :param pulumi.Input[_builtins.str] event_summary: Summary of the event.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_managed_by_autonomous_linux: Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        :param pulumi.Input[_builtins.str] lifecycle_details: Describes the current state of the event in more detail. For example, the  message can provide actionable information for a resource in the 'FAILED' state.
        :param pulumi.Input[_builtins.str] resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        :param pulumi.Input[_builtins.str] state: The current state of the event.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventSystemDetailArgs', 'EventSystemDetailArgsDict']]]] system_details: Provides information about the system architecture and operating system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the Event was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_occurred: The date and time that the event occurred.
        :param pulumi.Input[_builtins.str] time_updated: The date and time that the event was updated (in [RFC 3339](https://tools.ietf.org/html/rfc3339) format). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] type: Event type:
               * `KERNEL_OOPS` - Used to identify a kernel panic condition event
               * `KERNEL_CRASH` - Used to identify an internal fatal kernel error that cannot be safely recovered from
               * `EXPLOIT_ATTEMPT` - Used to identify a known exploit detection as identified by Ksplice
               * `SOFTWARE_UPDATE` - Software updates - Packages
               * `KSPLICE_UPDATE` - Ksplice updates
               * `SOFTWARE_SOURCE` - Software source
               * `AGENT` - Agent
               * `MANAGEMENT_STATION` - Management Station
               * `SYSADMIN` - Used to identify attempts on fixing agent errors on the instance
               * `REBOOT` - Reboot
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventState.__new__(_EventState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["datas"] = datas
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["event_details"] = event_details
        __props__.__dict__["event_id"] = event_id
        __props__.__dict__["event_summary"] = event_summary
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_managed_by_autonomous_linux"] = is_managed_by_autonomous_linux
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_details"] = system_details
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_occurred"] = time_occurred
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return Event(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def datas(self) -> pulumi.Output[Sequence['outputs.EventData']]:
        """
        Provides additional information for a management station event.
        """
        return pulumi.get(self, "datas")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="eventDetails")
    def event_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details of an event.
        """
        return pulumi.get(self, "event_details")

    @_builtins.property
    @pulumi.getter(name="eventId")
    def event_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        """
        return pulumi.get(self, "event_id")

    @_builtins.property
    @pulumi.getter(name="eventSummary")
    def event_summary(self) -> pulumi.Output[_builtins.str]:
        """
        Summary of the event.
        """
        return pulumi.get(self, "event_summary")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the current state of the event in more detail. For example, the  message can provide actionable information for a resource in the 'FAILED' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the event.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemDetails")
    def system_details(self) -> pulumi.Output[Sequence['outputs.EventSystemDetail']]:
        """
        Provides information about the system architecture and operating system.
        """
        return pulumi.get(self, "system_details")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the Event was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOccurred")
    def time_occurred(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the event occurred.
        """
        return pulumi.get(self, "time_occurred")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the event was updated (in [RFC 3339](https://tools.ietf.org/html/rfc3339) format). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Event type:
        * `KERNEL_OOPS` - Used to identify a kernel panic condition event
        * `KERNEL_CRASH` - Used to identify an internal fatal kernel error that cannot be safely recovered from
        * `EXPLOIT_ATTEMPT` - Used to identify a known exploit detection as identified by Ksplice
        * `SOFTWARE_UPDATE` - Software updates - Packages
        * `KSPLICE_UPDATE` - Ksplice updates
        * `SOFTWARE_SOURCE` - Software source
        * `AGENT` - Agent
        * `MANAGEMENT_STATION` - Management Station
        * `SYSADMIN` - Used to identify attempts on fixing agent errors on the instance
        * `REBOOT` - Reboot
        """
        return pulumi.get(self, "type")

