# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLifecycleEnvironmentsResult',
    'AwaitableGetLifecycleEnvironmentsResult',
    'get_lifecycle_environments',
    'get_lifecycle_environments_output',
]

@pulumi.output_type
class GetLifecycleEnvironmentsResult:
    """
    A collection of values returned by getLifecycleEnvironments.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, lifecycle_environment_collections=None, lifecycle_environment_id=None, location_not_equal_tos=None, locations=None, os_family=None, state=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_environment_collections and not isinstance(lifecycle_environment_collections, list):
            raise TypeError("Expected argument 'lifecycle_environment_collections' to be a list")
        pulumi.set(__self__, "lifecycle_environment_collections", lifecycle_environment_collections)
        if lifecycle_environment_id and not isinstance(lifecycle_environment_id, str):
            raise TypeError("Expected argument 'lifecycle_environment_id' to be a str")
        pulumi.set(__self__, "lifecycle_environment_id", lifecycle_environment_id)
        if location_not_equal_tos and not isinstance(location_not_equal_tos, list):
            raise TypeError("Expected argument 'location_not_equal_tos' to be a list")
        pulumi.set(__self__, "location_not_equal_tos", location_not_equal_tos)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[_builtins.str]:
        """
        The CPU architecture of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "arch_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the lifecycle stage.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name_contains")

    @_builtins.property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLifecycleEnvironmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleEnvironmentCollections")
    def lifecycle_environment_collections(self) -> Sequence['outputs.GetLifecycleEnvironmentsLifecycleEnvironmentCollectionResult']:
        """
        The list of lifecycle_environment_collection.
        """
        return pulumi.get(self, "lifecycle_environment_collections")

    @_builtins.property
    @pulumi.getter(name="lifecycleEnvironmentId")
    def lifecycle_environment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle environment that contains the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_environment_id")

    @_builtins.property
    @pulumi.getter(name="locationNotEqualTos")
    def location_not_equal_tos(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "location_not_equal_tos")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[_builtins.str]]:
        """
        The location of managed instances associated with the lifecycle stage.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[_builtins.str]:
        """
        The operating system of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "os_family")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the lifecycle environment.
        """
        return pulumi.get(self, "state")


class AwaitableGetLifecycleEnvironmentsResult(GetLifecycleEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLifecycleEnvironmentsResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            lifecycle_environment_collections=self.lifecycle_environment_collections,
            lifecycle_environment_id=self.lifecycle_environment_id,
            location_not_equal_tos=self.location_not_equal_tos,
            locations=self.locations,
            os_family=self.os_family,
            state=self.state)


def get_lifecycle_environments(arch_type: Optional[_builtins.str] = None,
                               compartment_id: Optional[_builtins.str] = None,
                               display_name_contains: Optional[_builtins.str] = None,
                               display_names: Optional[Sequence[_builtins.str]] = None,
                               filters: Optional[Sequence[Union['GetLifecycleEnvironmentsFilterArgs', 'GetLifecycleEnvironmentsFilterArgsDict']]] = None,
                               lifecycle_environment_id: Optional[_builtins.str] = None,
                               location_not_equal_tos: Optional[Sequence[_builtins.str]] = None,
                               locations: Optional[Sequence[_builtins.str]] = None,
                               os_family: Optional[_builtins.str] = None,
                               state: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLifecycleEnvironmentsResult:
    """
    This data source provides the list of Lifecycle Environments in Oracle Cloud Infrastructure Os Management Hub service.

    Lists lifecycle environments that match the specified compartment or lifecycle environment OCID. Filter the list
    against a variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_environments = oci.OsManagementHub.get_lifecycle_environments(arch_type=lifecycle_environment_arch_type,
        compartment_id=compartment_id,
        display_names=lifecycle_environment_display_name,
        display_name_contains=lifecycle_environment_display_name_contains,
        lifecycle_environment_id=test_lifecycle_environment["id"],
        locations=lifecycle_environment_location,
        location_not_equal_tos=lifecycle_environment_location_not_equal_to,
        os_family=lifecycle_environment_os_family,
        state=lifecycle_environment_state)
    ```


    :param _builtins.str arch_type: A filter to return only profiles that match the given archType.
    :param _builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param _builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[_builtins.str] display_names: A filter to return resources that match the given display names.
    :param _builtins.str lifecycle_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle environment.
    :param Sequence[_builtins.str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[_builtins.str] locations: A filter to return only resources whose location matches the given value.
    :param _builtins.str os_family: A filter to return only resources that match the given operating system family.
    :param _builtins.str state: A filter to return only the lifecycle environments that match the display name given.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['lifecycleEnvironmentId'] = lifecycle_environment_id
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['osFamily'] = os_family
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getLifecycleEnvironments:getLifecycleEnvironments', __args__, opts=opts, typ=GetLifecycleEnvironmentsResult).value

    return AwaitableGetLifecycleEnvironmentsResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_environment_collections=pulumi.get(__ret__, 'lifecycle_environment_collections'),
        lifecycle_environment_id=pulumi.get(__ret__, 'lifecycle_environment_id'),
        location_not_equal_tos=pulumi.get(__ret__, 'location_not_equal_tos'),
        locations=pulumi.get(__ret__, 'locations'),
        os_family=pulumi.get(__ret__, 'os_family'),
        state=pulumi.get(__ret__, 'state'))
def get_lifecycle_environments_output(arch_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      display_name_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      display_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLifecycleEnvironmentsFilterArgs', 'GetLifecycleEnvironmentsFilterArgsDict']]]]] = None,
                                      lifecycle_environment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      location_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      locations: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                      os_family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLifecycleEnvironmentsResult]:
    """
    This data source provides the list of Lifecycle Environments in Oracle Cloud Infrastructure Os Management Hub service.

    Lists lifecycle environments that match the specified compartment or lifecycle environment OCID. Filter the list
    against a variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_environments = oci.OsManagementHub.get_lifecycle_environments(arch_type=lifecycle_environment_arch_type,
        compartment_id=compartment_id,
        display_names=lifecycle_environment_display_name,
        display_name_contains=lifecycle_environment_display_name_contains,
        lifecycle_environment_id=test_lifecycle_environment["id"],
        locations=lifecycle_environment_location,
        location_not_equal_tos=lifecycle_environment_location_not_equal_to,
        os_family=lifecycle_environment_os_family,
        state=lifecycle_environment_state)
    ```


    :param _builtins.str arch_type: A filter to return only profiles that match the given archType.
    :param _builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param _builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[_builtins.str] display_names: A filter to return resources that match the given display names.
    :param _builtins.str lifecycle_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle environment.
    :param Sequence[_builtins.str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[_builtins.str] locations: A filter to return only resources whose location matches the given value.
    :param _builtins.str os_family: A filter to return only resources that match the given operating system family.
    :param _builtins.str state: A filter to return only the lifecycle environments that match the display name given.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['lifecycleEnvironmentId'] = lifecycle_environment_id
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['osFamily'] = os_family
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getLifecycleEnvironments:getLifecycleEnvironments', __args__, opts=opts, typ=GetLifecycleEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetLifecycleEnvironmentsResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        display_names=pulumi.get(__response__, 'display_names'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_environment_collections=pulumi.get(__response__, 'lifecycle_environment_collections'),
        lifecycle_environment_id=pulumi.get(__response__, 'lifecycle_environment_id'),
        location_not_equal_tos=pulumi.get(__response__, 'location_not_equal_tos'),
        locations=pulumi.get(__response__, 'locations'),
        os_family=pulumi.get(__response__, 'os_family'),
        state=pulumi.get(__response__, 'state')))
