# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProtectedDatabaseMetric',
    'ProtectedDatabaseRecoveryServiceSubnet',
    'GetProtectedDatabaseMetricResult',
    'GetProtectedDatabaseRecoveryServiceSubnetResult',
    'GetProtectedDatabasesFilterResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult',
    'GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult',
    'GetProtectionPoliciesFilterResult',
    'GetProtectionPoliciesProtectionPolicyCollectionResult',
    'GetProtectionPoliciesProtectionPolicyCollectionItemResult',
    'GetRecoveryServiceSubnetsFilterResult',
    'GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult',
    'GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult',
]

@pulumi.output_type
class ProtectedDatabaseMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupSpaceEstimateInGbs":
            suggest = "backup_space_estimate_in_gbs"
        elif key == "backupSpaceUsedInGbs":
            suggest = "backup_space_used_in_gbs"
        elif key == "currentRetentionPeriodInSeconds":
            suggest = "current_retention_period_in_seconds"
        elif key == "dbSizeInGbs":
            suggest = "db_size_in_gbs"
        elif key == "isRedoLogsEnabled":
            suggest = "is_redo_logs_enabled"
        elif key == "minimumRecoveryNeededInDays":
            suggest = "minimum_recovery_needed_in_days"
        elif key == "retentionPeriodInDays":
            suggest = "retention_period_in_days"
        elif key == "unprotectedWindowInSeconds":
            suggest = "unprotected_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectedDatabaseMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectedDatabaseMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectedDatabaseMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: Optional[_builtins.float] = None,
                 backup_space_used_in_gbs: Optional[_builtins.float] = None,
                 current_retention_period_in_seconds: Optional[_builtins.float] = None,
                 db_size_in_gbs: Optional[_builtins.float] = None,
                 is_redo_logs_enabled: Optional[_builtins.bool] = None,
                 minimum_recovery_needed_in_days: Optional[_builtins.float] = None,
                 retention_period_in_days: Optional[_builtins.float] = None,
                 unprotected_window_in_seconds: Optional[_builtins.float] = None):
        """
        :param _builtins.float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param _builtins.float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param _builtins.float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param _builtins.float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param _builtins.bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param _builtins.float minimum_recovery_needed_in_days: Number of days of redo/archive to be applied to recover database.
        :param _builtins.float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param _builtins.float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        if backup_space_estimate_in_gbs is not None:
            pulumi.set(__self__, "backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        if backup_space_used_in_gbs is not None:
            pulumi.set(__self__, "backup_space_used_in_gbs", backup_space_used_in_gbs)
        if current_retention_period_in_seconds is not None:
            pulumi.set(__self__, "current_retention_period_in_seconds", current_retention_period_in_seconds)
        if db_size_in_gbs is not None:
            pulumi.set(__self__, "db_size_in_gbs", db_size_in_gbs)
        if is_redo_logs_enabled is not None:
            pulumi.set(__self__, "is_redo_logs_enabled", is_redo_logs_enabled)
        if minimum_recovery_needed_in_days is not None:
            pulumi.set(__self__, "minimum_recovery_needed_in_days", minimum_recovery_needed_in_days)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if unprotected_window_in_seconds is not None:
            pulumi.set(__self__, "unprotected_window_in_seconds", unprotected_window_in_seconds)

    @_builtins.property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> Optional[_builtins.float]:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> Optional[_builtins.float]:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @_builtins.property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> Optional[_builtins.float]:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @_builtins.property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> Optional[_builtins.float]:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> Optional[_builtins.bool]:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="minimumRecoveryNeededInDays")
    def minimum_recovery_needed_in_days(self) -> Optional[_builtins.float]:
        """
        Number of days of redo/archive to be applied to recover database.
        """
        return pulumi.get(self, "minimum_recovery_needed_in_days")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[_builtins.float]:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> Optional[_builtins.float]:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class ProtectedDatabaseRecoveryServiceSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryServiceSubnetId":
            suggest = "recovery_service_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectedDatabaseRecoveryServiceSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectedDatabaseRecoveryServiceSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectedDatabaseRecoveryServiceSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recovery_service_subnet_id: _builtins.str,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str recovery_service_subnet_id: (Updatable) The recovery service subnet OCID.
        :param _builtins.str state: The current state of the Protected Database.
        """
        pulumi.set(__self__, "recovery_service_subnet_id", recovery_service_subnet_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> _builtins.str:
        """
        (Updatable) The recovery service subnet OCID.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectedDatabaseMetricResult(dict):
    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: _builtins.float,
                 backup_space_used_in_gbs: _builtins.float,
                 current_retention_period_in_seconds: _builtins.float,
                 db_size_in_gbs: _builtins.float,
                 is_redo_logs_enabled: _builtins.bool,
                 minimum_recovery_needed_in_days: _builtins.float,
                 retention_period_in_days: _builtins.float,
                 unprotected_window_in_seconds: _builtins.float):
        """
        :param _builtins.float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param _builtins.float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param _builtins.float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param _builtins.float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param _builtins.bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param _builtins.float minimum_recovery_needed_in_days: Number of days of redo/archive to be applied to recover database.
        :param _builtins.float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param _builtins.float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        pulumi.set(__self__, "backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        pulumi.set(__self__, "backup_space_used_in_gbs", backup_space_used_in_gbs)
        pulumi.set(__self__, "current_retention_period_in_seconds", current_retention_period_in_seconds)
        pulumi.set(__self__, "db_size_in_gbs", db_size_in_gbs)
        pulumi.set(__self__, "is_redo_logs_enabled", is_redo_logs_enabled)
        pulumi.set(__self__, "minimum_recovery_needed_in_days", minimum_recovery_needed_in_days)
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        pulumi.set(__self__, "unprotected_window_in_seconds", unprotected_window_in_seconds)

    @_builtins.property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> _builtins.float:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> _builtins.float:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @_builtins.property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> _builtins.float:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @_builtins.property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> _builtins.float:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> _builtins.bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="minimumRecoveryNeededInDays")
    def minimum_recovery_needed_in_days(self) -> _builtins.float:
        """
        Number of days of redo/archive to be applied to recover database.
        """
        return pulumi.get(self, "minimum_recovery_needed_in_days")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> _builtins.float:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> _builtins.float:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class GetProtectedDatabaseRecoveryServiceSubnetResult(dict):
    def __init__(__self__, *,
                 recovery_service_subnet_id: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str recovery_service_subnet_id: Recovery Service Subnet Identifier.
        :param _builtins.str state: The current state of the Protected Database.
        """
        pulumi.set(__self__, "recovery_service_subnet_id", recovery_service_subnet_id)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> _builtins.str:
        """
        Recovery Service Subnet Identifier.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Protected Database.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectedDatabasesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 database_id: _builtins.str,
                 database_size: _builtins.str,
                 db_unique_name: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 deletion_schedule: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 health: _builtins.str,
                 health_details: _builtins.str,
                 id: _builtins.str,
                 is_read_only_resource: _builtins.bool,
                 is_redo_logs_shipped: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 metrics: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult'],
                 password: _builtins.str,
                 policy_locked_date_time: _builtins.str,
                 protection_policy_id: _builtins.str,
                 recovery_service_subnets: Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult'],
                 state: _builtins.str,
                 subscription_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 vpc_user_name: _builtins.str):
        """
        :param _builtins.str compartment_id: The compartment OCID.
        :param _builtins.str database_id: The OCID of the protected database.
        :param _builtins.str database_size: The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        :param _builtins.str db_unique_name: The dbUniqueName for the protected database in Recovery Service. You cannot change the unique name.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str health: Indicates the protection status of the database.
        :param _builtins.str health_details: A message describing the current health of the protected database.
        :param _builtins.str id: The protected database OCID.
        :param _builtins.bool is_read_only_resource: Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        :param _builtins.bool is_redo_logs_shipped: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups. For this to be effective, additional configuration is needed on client side.
        :param _builtins.str lifecycle_details: Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param Sequence['GetProtectedDatabasesProtectedDatabaseCollectionItemMetricArgs'] metrics: Backup performance and storage utilization metrics for the protected database.
        :param _builtins.str policy_locked_date_time: An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        :param _builtins.str protection_policy_id: The protection policy OCID.
        :param Sequence['GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetArgs'] recovery_service_subnets: List of recovery service subnet resources associated with the protected database.
        :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
        :param _builtins.str subscription_id: The OCID of the cloud service subscription to which the protected database is linked.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str time_created: An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param _builtins.str time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        :param _builtins.str vpc_user_name: The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "database_size", database_size)
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "deletion_schedule", deletion_schedule)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_details", health_details)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_read_only_resource", is_read_only_resource)
        pulumi.set(__self__, "is_redo_logs_shipped", is_redo_logs_shipped)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "policy_locked_date_time", policy_locked_date_time)
        pulumi.set(__self__, "protection_policy_id", protection_policy_id)
        pulumi.set(__self__, "recovery_service_subnets", recovery_service_subnets)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vpc_user_name", vpc_user_name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> _builtins.str:
        """
        The OCID of the protected database.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="databaseSize")
    def database_size(self) -> _builtins.str:
        """
        The size of the protected database. XS - Less than 5GB, S - 5GB to 50GB, M - 50GB to 500GB, L - 500GB to 1TB, XL - 1TB to 5TB, XXL - Greater than 5TB.
        """
        return pulumi.get(self, "database_size")

    @_builtins.property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> _builtins.str:
        """
        The dbUniqueName for the protected database in Recovery Service. You cannot change the unique name.
        """
        return pulumi.get(self, "db_unique_name")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="deletionSchedule")
    def deletion_schedule(self) -> _builtins.str:
        return pulumi.get(self, "deletion_schedule")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Indicates the protection status of the database.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="healthDetails")
    def health_details(self) -> _builtins.str:
        """
        A message describing the current health of the protected database.
        """
        return pulumi.get(self, "health_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The protected database OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isReadOnlyResource")
    def is_read_only_resource(self) -> _builtins.bool:
        """
        Indicates whether the protected database is created by Recovery Service or created manually. Set to <b>TRUE</b> for a service-defined protected database. When you enable the OCI-managed automatic backups option for a database and set Recovery Service as the backup destination, then Recovery Service creates the associated protected database resource. Set to <b>FALSE</b> for a user-defined protected database.
        """
        return pulumi.get(self, "is_read_only_resource")

    @_builtins.property
    @pulumi.getter(name="isRedoLogsShipped")
    def is_redo_logs_shipped(self) -> _builtins.bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups. For this to be effective, additional configuration is needed on client side.
        """
        return pulumi.get(self, "is_redo_logs_shipped")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Detailed description about the current lifecycle state of the protected database. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult']:
        """
        Backup performance and storage utilization metrics for the protected database.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="policyLockedDateTime")
    def policy_locked_date_time(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        """
        return pulumi.get(self, "policy_locked_date_time")

    @_builtins.property
    @pulumi.getter(name="protectionPolicyId")
    def protection_policy_id(self) -> _builtins.str:
        """
        The protection policy OCID.
        """
        return pulumi.get(self, "protection_policy_id")

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnets")
    def recovery_service_subnets(self) -> Sequence['outputs.GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult']:
        """
        List of recovery service subnet resources associated with the protected database.
        """
        return pulumi.get(self, "recovery_service_subnets")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The OCID of the cloud service subscription to which the protected database is linked.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the created time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a protected database. For example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vpcUserName")
    def vpc_user_name(self) -> _builtins.str:
        """
        The virtual private catalog (VPC) user credentials that authenticates the protected database to access Recovery Service.
        """
        return pulumi.get(self, "vpc_user_name")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 backup_space_estimate_in_gbs: _builtins.float,
                 backup_space_used_in_gbs: _builtins.float,
                 current_retention_period_in_seconds: _builtins.float,
                 db_size_in_gbs: _builtins.float,
                 is_redo_logs_enabled: _builtins.bool,
                 minimum_recovery_needed_in_days: _builtins.float,
                 retention_period_in_days: _builtins.float,
                 unprotected_window_in_seconds: _builtins.float):
        """
        :param _builtins.float backup_space_estimate_in_gbs: The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        :param _builtins.float backup_space_used_in_gbs: Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        :param _builtins.float current_retention_period_in_seconds: Number of seconds backups are currently retained for this database.
        :param _builtins.float db_size_in_gbs: The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        :param _builtins.bool is_redo_logs_enabled: The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        :param _builtins.float minimum_recovery_needed_in_days: Number of days of redo/archive to be applied to recover database.
        :param _builtins.float retention_period_in_days: The maximum number of days to retain backups for a protected database.
        :param _builtins.float unprotected_window_in_seconds: This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        pulumi.set(__self__, "backup_space_estimate_in_gbs", backup_space_estimate_in_gbs)
        pulumi.set(__self__, "backup_space_used_in_gbs", backup_space_used_in_gbs)
        pulumi.set(__self__, "current_retention_period_in_seconds", current_retention_period_in_seconds)
        pulumi.set(__self__, "db_size_in_gbs", db_size_in_gbs)
        pulumi.set(__self__, "is_redo_logs_enabled", is_redo_logs_enabled)
        pulumi.set(__self__, "minimum_recovery_needed_in_days", minimum_recovery_needed_in_days)
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        pulumi.set(__self__, "unprotected_window_in_seconds", unprotected_window_in_seconds)

    @_builtins.property
    @pulumi.getter(name="backupSpaceEstimateInGbs")
    def backup_space_estimate_in_gbs(self) -> _builtins.float:
        """
        The estimated backup storage space, in gigabytes, required to meet the recovery window goal, including foot print and backups for the protected database.
        """
        return pulumi.get(self, "backup_space_estimate_in_gbs")

    @_builtins.property
    @pulumi.getter(name="backupSpaceUsedInGbs")
    def backup_space_used_in_gbs(self) -> _builtins.float:
        """
        Backup storage space, in gigabytes, utilized by the protected database. Oracle charges for the total storage used.
        """
        return pulumi.get(self, "backup_space_used_in_gbs")

    @_builtins.property
    @pulumi.getter(name="currentRetentionPeriodInSeconds")
    def current_retention_period_in_seconds(self) -> _builtins.float:
        """
        Number of seconds backups are currently retained for this database.
        """
        return pulumi.get(self, "current_retention_period_in_seconds")

    @_builtins.property
    @pulumi.getter(name="dbSizeInGbs")
    def db_size_in_gbs(self) -> _builtins.float:
        """
        The estimated space, in gigabytes, consumed by the protected database. The database size is based on the size of the data files in the catalog, and does not include archive logs.
        """
        return pulumi.get(self, "db_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="isRedoLogsEnabled")
    def is_redo_logs_enabled(self) -> _builtins.bool:
        """
        The value TRUE indicates that the protected database is configured to use Real-time data protection, and redo-data is sent from the protected database to Recovery Service. Real-time data protection substantially reduces the window of potential data loss that exists between successive archived redo log backups.
        """
        return pulumi.get(self, "is_redo_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="minimumRecoveryNeededInDays")
    def minimum_recovery_needed_in_days(self) -> _builtins.float:
        """
        Number of days of redo/archive to be applied to recover database.
        """
        return pulumi.get(self, "minimum_recovery_needed_in_days")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> _builtins.float:
        """
        The maximum number of days to retain backups for a protected database.
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="unprotectedWindowInSeconds")
    def unprotected_window_in_seconds(self) -> _builtins.float:
        """
        This is the time window when there is data loss exposure. The point after which recovery is impossible unless additional redo is available.  This is the time we received the last backup or last redo-log shipped.
        """
        return pulumi.get(self, "unprotected_window_in_seconds")


@pulumi.output_type
class GetProtectedDatabasesProtectedDatabaseCollectionItemRecoveryServiceSubnetResult(dict):
    def __init__(__self__, *,
                 recovery_service_subnet_id: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str recovery_service_subnet_id: The recovery service subnet OCID.
        :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
        """
        pulumi.set(__self__, "recovery_service_subnet_id", recovery_service_subnet_id)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="recoveryServiceSubnetId")
    def recovery_service_subnet_id(self) -> _builtins.str:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "recovery_service_subnet_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetProtectionPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProtectionPoliciesProtectionPolicyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProtectionPoliciesProtectionPolicyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProtectionPoliciesProtectionPolicyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProtectionPoliciesProtectionPolicyCollectionItemResult(dict):
    def __init__(__self__, *,
                 backup_retention_period_in_days: _builtins.int,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_predefined_policy: _builtins.bool,
                 lifecycle_details: _builtins.str,
                 must_enforce_cloud_locality: _builtins.bool,
                 policy_locked_date_time: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.int backup_retention_period_in_days: The maximum number of days to retain backups for a protected database. Specify a period ranging from a minimum 14 days to a maximum 95 days. For example, specify the value 55 if you want to retain backups for 55 days.
        :param _builtins.str compartment_id: The compartment OCID.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The protection policy OCID.
        :param _builtins.bool is_predefined_policy: Set to TRUE if the policy is Oracle-defined, and FALSE for a user-defined custom policy. You can modify only the custom policies.
        :param _builtins.str lifecycle_details: Detailed description about the current lifecycle state of the protection policy. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param _builtins.bool must_enforce_cloud_locality: Indicates whether the protection policy enforces Recovery Service to retain backups in the same cloud service environment where your Oracle Database is provisioned.
        :param _builtins.str policy_locked_date_time: An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str time_created: An RFC3339 formatted datetime string that indicates the created time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        :param _builtins.str time_updated: An RFC3339 formatted datetime string that indicates the updated time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "backup_retention_period_in_days", backup_retention_period_in_days)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_predefined_policy", is_predefined_policy)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "must_enforce_cloud_locality", must_enforce_cloud_locality)
        pulumi.set(__self__, "policy_locked_date_time", policy_locked_date_time)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="backupRetentionPeriodInDays")
    def backup_retention_period_in_days(self) -> _builtins.int:
        """
        The maximum number of days to retain backups for a protected database. Specify a period ranging from a minimum 14 days to a maximum 95 days. For example, specify the value 55 if you want to retain backups for 55 days.
        """
        return pulumi.get(self, "backup_retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The protection policy OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPredefinedPolicy")
    def is_predefined_policy(self) -> _builtins.bool:
        """
        Set to TRUE if the policy is Oracle-defined, and FALSE for a user-defined custom policy. You can modify only the custom policies.
        """
        return pulumi.get(self, "is_predefined_policy")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Detailed description about the current lifecycle state of the protection policy. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="mustEnforceCloudLocality")
    def must_enforce_cloud_locality(self) -> _builtins.bool:
        """
        Indicates whether the protection policy enforces Recovery Service to retain backups in the same cloud service environment where your Oracle Database is provisioned.
        """
        return pulumi.get(self, "must_enforce_cloud_locality")

    @_builtins.property
    @pulumi.getter(name="policyLockedDateTime")
    def policy_locked_date_time(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that specifies the exact date and time for the retention lock to take effect and permanently lock the retention period defined in the policy.
        """
        return pulumi.get(self, "policy_locked_date_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the created time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the updated time for the protection policy. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRecoveryServiceSubnetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecoveryServiceSubnetsRecoveryServiceSubnetCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 subnets: Sequence[_builtins.str],
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The compartment OCID.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str display_name: A filter to return only resources that match the entire 'displayname' given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The recovery service subnet OCID.
        :param _builtins.str lifecycle_details: Detailed description about the current lifecycle state of the recovery service subnet. For example, it can be used to provide actionable information for a resource in a Failed state
        :param Sequence[_builtins.str] nsg_ids: A list of network security group (NSG) OCIDs that are associated with the Recovery Service subnet. You can specify a maximum of 5 unique OCIDs, which implies that you can associate a maximum of 5 NSGs to each Recovery Service subnet. Specify an empty array if you want to remove all the associated NSGs from a Recovery Service subnet. See [Network Security Groups](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/) for more information.
        :param _builtins.str state: A filter to return only the resources that match the specified lifecycle state.
        :param _builtins.str subnet_id: Deprecated. One of the subnets associated with the Recovery Service subnet.
        :param Sequence[_builtins.str] subnets: A list of OCIDs of all the subnets associated with the Recovery Service subnet.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        :param _builtins.str time_created: An RFC3339 formatted datetime string that indicates the last created time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        :param _builtins.str time_updated: An RFC3339 formatted datetime string that indicates the last updated time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        :param _builtins.str vcn_id: The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire 'displayname' given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The recovery service subnet OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Detailed description about the current lifecycle state of the recovery service subnet. For example, it can be used to provide actionable information for a resource in a Failed state
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        A list of network security group (NSG) OCIDs that are associated with the Recovery Service subnet. You can specify a maximum of 5 unique OCIDs, which implies that you can associate a maximum of 5 NSGs to each Recovery Service subnet. Specify an empty array if you want to remove all the associated NSGs from a Recovery Service subnet. See [Network Security Groups](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/) for more information.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""The 'subnet_id' field has been deprecated. Please use 'subnets' instead.""")
    def subnet_id(self) -> _builtins.str:
        """
        Deprecated. One of the subnets associated with the Recovery Service subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        A list of OCIDs of all the subnets associated with the Recovery Service subnet.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`. For more information, see [Resource Tags](https://docs.oracle.com/en-us/iaas/Content/General/Concepts/resourcetags.htm)
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the last created time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        An RFC3339 formatted datetime string that indicates the last updated time for a recovery service subnet. For example: '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The OCID of the virtual cloud network (VCN) associated with the recovery service subnet.
        """
        return pulumi.get(self, "vcn_id")


