# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOciCacheDefaultConfigSetResult',
    'AwaitableGetOciCacheDefaultConfigSetResult',
    'get_oci_cache_default_config_set',
    'get_oci_cache_default_config_set_output',
]

@pulumi.output_type
class GetOciCacheDefaultConfigSetResult:
    """
    A collection of values returned by getOciCacheDefaultConfigSet.
    """
    def __init__(__self__, compartment_id=None, default_configuration_details=None, description=None, display_name=None, id=None, oci_cache_default_config_set_id=None, software_version=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_configuration_details and not isinstance(default_configuration_details, list):
            raise TypeError("Expected argument 'default_configuration_details' to be a list")
        pulumi.set(__self__, "default_configuration_details", default_configuration_details)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oci_cache_default_config_set_id and not isinstance(oci_cache_default_config_set_id, str):
            raise TypeError("Expected argument 'oci_cache_default_config_set_id' to be a str")
        pulumi.set(__self__, "oci_cache_default_config_set_id", oci_cache_default_config_set_id)
        if software_version and not isinstance(software_version, str):
            raise TypeError("Expected argument 'software_version' to be a str")
        pulumi.set(__self__, "software_version", software_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="defaultConfigurationDetails")
    def default_configuration_details(self) -> Sequence['outputs.GetOciCacheDefaultConfigSetDefaultConfigurationDetailResult']:
        """
        List of Oracle Cloud Infrastructure Cache Default Config Set Values.
        """
        return pulumi.get(self, "default_configuration_details")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Oracle Cloud Infrastructure Cache Default Config Set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name of the Oracle Cloud Infrastructure Cache Default Config Set.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociCacheDefaultConfigSetId")
    def oci_cache_default_config_set_id(self) -> _builtins.str:
        return pulumi.get(self, "oci_cache_default_config_set_id")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> _builtins.str:
        """
        The engine version of the Oracle Cloud Infrastructure Cache Default Config Set.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Oracle Cloud Infrastructure Cache Default Config Set.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the Oracle Cloud Infrastructure Cache Default Config Set was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetOciCacheDefaultConfigSetResult(GetOciCacheDefaultConfigSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOciCacheDefaultConfigSetResult(
            compartment_id=self.compartment_id,
            default_configuration_details=self.default_configuration_details,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            oci_cache_default_config_set_id=self.oci_cache_default_config_set_id,
            software_version=self.software_version,
            state=self.state,
            time_created=self.time_created)


def get_oci_cache_default_config_set(compartment_id: Optional[_builtins.str] = None,
                                     oci_cache_default_config_set_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOciCacheDefaultConfigSetResult:
    """
    This data source provides details about a specific Oci Cache Default Config Set resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache Default Config Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_default_config_set = oci.Redis.get_oci_cache_default_config_set(compartment_id=compartment_id,
        oci_cache_default_config_set_id=test_oci_cache_default_config_set_oci_redis_oci_cache_default_config_set["id"])
    ```


    :param _builtins.str compartment_id: The unique identifier for the compartment.
    :param _builtins.str oci_cache_default_config_set_id: Unique Oracle Cloud Infrastructure Cache Default Config Set identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['ociCacheDefaultConfigSetId'] = oci_cache_default_config_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getOciCacheDefaultConfigSet:getOciCacheDefaultConfigSet', __args__, opts=opts, typ=GetOciCacheDefaultConfigSetResult).value

    return AwaitableGetOciCacheDefaultConfigSetResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_configuration_details=pulumi.get(__ret__, 'default_configuration_details'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        oci_cache_default_config_set_id=pulumi.get(__ret__, 'oci_cache_default_config_set_id'),
        software_version=pulumi.get(__ret__, 'software_version'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_oci_cache_default_config_set_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            oci_cache_default_config_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOciCacheDefaultConfigSetResult]:
    """
    This data source provides details about a specific Oci Cache Default Config Set resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache Default Config Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oci_cache_default_config_set = oci.Redis.get_oci_cache_default_config_set(compartment_id=compartment_id,
        oci_cache_default_config_set_id=test_oci_cache_default_config_set_oci_redis_oci_cache_default_config_set["id"])
    ```


    :param _builtins.str compartment_id: The unique identifier for the compartment.
    :param _builtins.str oci_cache_default_config_set_id: Unique Oracle Cloud Infrastructure Cache Default Config Set identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['ociCacheDefaultConfigSetId'] = oci_cache_default_config_set_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getOciCacheDefaultConfigSet:getOciCacheDefaultConfigSet', __args__, opts=opts, typ=GetOciCacheDefaultConfigSetResult)
    return __ret__.apply(lambda __response__: GetOciCacheDefaultConfigSetResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        default_configuration_details=pulumi.get(__response__, 'default_configuration_details'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        oci_cache_default_config_set_id=pulumi.get(__response__, 'oci_cache_default_config_set_id'),
        software_version=pulumi.get(__response__, 'software_version'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
