# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAttributesResult',
    'AwaitableGetSecurityAttributesResult',
    'get_security_attributes',
    'get_security_attributes_output',
]

@pulumi.output_type
class GetSecurityAttributesResult:
    """
    A collection of values returned by getSecurityAttributes.
    """
    def __init__(__self__, filters=None, id=None, security_attribute_namespace_id=None, security_attributes=None, state=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_attribute_namespace_id and not isinstance(security_attribute_namespace_id, str):
            raise TypeError("Expected argument 'security_attribute_namespace_id' to be a str")
        pulumi.set(__self__, "security_attribute_namespace_id", security_attribute_namespace_id)
        if security_attributes and not isinstance(security_attributes, list):
            raise TypeError("Expected argument 'security_attributes' to be a list")
        pulumi.set(__self__, "security_attributes", security_attributes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAttributesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="securityAttributeNamespaceId")
    def security_attribute_namespace_id(self) -> _builtins.str:
        """
        The OCID of the security attribute namespace that contains the security attribute definition.
        """
        return pulumi.get(self, "security_attribute_namespace_id")

    @_builtins.property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Sequence['outputs.GetSecurityAttributesSecurityAttributeResult']:
        """
        The list of security_attributes.
        """
        return pulumi.get(self, "security_attributes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")


class AwaitableGetSecurityAttributesResult(GetSecurityAttributesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAttributesResult(
            filters=self.filters,
            id=self.id,
            security_attribute_namespace_id=self.security_attribute_namespace_id,
            security_attributes=self.security_attributes,
            state=self.state)


def get_security_attributes(filters: Optional[Sequence[Union['GetSecurityAttributesFilterArgs', 'GetSecurityAttributesFilterArgsDict']]] = None,
                            security_attribute_namespace_id: Optional[_builtins.str] = None,
                            state: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAttributesResult:
    """
    This data source provides the list of Security Attributes in Oracle Cloud Infrastructure Security Attribute service.

    Lists the security attributes in the specified namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attributes = oci.SecurityAttribute.get_security_attributes(security_attribute_namespace_id=test_security_attribute_namespace["id"],
        state=security_attribute_state)
    ```


    :param _builtins.str security_attribute_namespace_id: The OCID of the security attribute namespace.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['securityAttributeNamespaceId'] = security_attribute_namespace_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:SecurityAttribute/getSecurityAttributes:getSecurityAttributes', __args__, opts=opts, typ=GetSecurityAttributesResult).value

    return AwaitableGetSecurityAttributesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_attribute_namespace_id=pulumi.get(__ret__, 'security_attribute_namespace_id'),
        security_attributes=pulumi.get(__ret__, 'security_attributes'),
        state=pulumi.get(__ret__, 'state'))
def get_security_attributes_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityAttributesFilterArgs', 'GetSecurityAttributesFilterArgsDict']]]]] = None,
                                   security_attribute_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAttributesResult]:
    """
    This data source provides the list of Security Attributes in Oracle Cloud Infrastructure Security Attribute service.

    Lists the security attributes in the specified namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attributes = oci.SecurityAttribute.get_security_attributes(security_attribute_namespace_id=test_security_attribute_namespace["id"],
        state=security_attribute_state)
    ```


    :param _builtins.str security_attribute_namespace_id: The OCID of the security attribute namespace.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['securityAttributeNamespaceId'] = security_attribute_namespace_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:SecurityAttribute/getSecurityAttributes:getSecurityAttributes', __args__, opts=opts, typ=GetSecurityAttributesResult)
    return __ret__.apply(lambda __response__: GetSecurityAttributesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        security_attribute_namespace_id=pulumi.get(__response__, 'security_attribute_namespace_id'),
        security_attributes=pulumi.get(__response__, 'security_attributes'),
        state=pulumi.get(__response__, 'state')))
