# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceEnvironmentServiceDefinitionResult',
    'GetServiceEnvironmentServiceEnvironmentEndpointResult',
    'GetServiceEnvironmentsFilterResult',
    'GetServiceEnvironmentsServiceEnvironmentCollectionResult',
    'GetServiceEnvironmentsServiceEnvironmentCollectionItemResult',
    'GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceDefinitionResult',
    'GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceEnvironmentEndpointResult',
]

@pulumi.output_type
class GetServiceEnvironmentServiceDefinitionResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 short_display_name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str display_name: Display name of the service. For example, "Oracle Retail Order Management Cloud Service".
        :param _builtins.str short_display_name: Short display name of the service. For example, "Retail Order Management".
        :param _builtins.str type: The service definition type. For example, a service definition type "RGBUOROMS"  would be for the service "Oracle Retail Order Management Cloud Service".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "short_display_name", short_display_name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the service. For example, "Oracle Retail Order Management Cloud Service".
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="shortDisplayName")
    def short_display_name(self) -> _builtins.str:
        """
        Short display name of the service. For example, "Retail Order Management".
        """
        return pulumi.get(self, "short_display_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The service definition type. For example, a service definition type "RGBUOROMS"  would be for the service "Oracle Retail Order Management Cloud Service".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceEnvironmentServiceEnvironmentEndpointResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 environment_type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str description: Description of the environment link
        :param _builtins.str environment_type: Service environment endpoint type.
        :param _builtins.str url: Service environment instance URL.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment_type", environment_type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the environment link
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> _builtins.str:
        """
        Service environment endpoint type.
        """
        return pulumi.get(self, "environment_type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Service environment instance URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceEnvironmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceEnvironmentsServiceEnvironmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceEnvironmentsServiceEnvironmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 console_url: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 service_definitions: Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceDefinitionResult'],
                 service_environment_endpoints: Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceEnvironmentEndpointResult'],
                 status: _builtins.str,
                 subscription_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment.
        :param _builtins.str console_url: The URL for the console.
        :param _builtins.str id: Unqiue identifier for the entitlement related to the environment.
        :param Sequence['GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceDefinitionArgs'] service_definitions: Details for a service definition.
        :param Sequence['GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceEnvironmentEndpointArgs'] service_environment_endpoints: Array of service environment end points.
        :param _builtins.str status: Status of the entitlement registration for the service.
        :param _builtins.str subscription_id: The unique subscription ID associated with the service environment ID.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "console_url", console_url)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_definitions", service_definitions)
        pulumi.set(__self__, "service_environment_endpoints", service_environment_endpoints)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="consoleUrl")
    def console_url(self) -> _builtins.str:
        """
        The URL for the console.
        """
        return pulumi.get(self, "console_url")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unqiue identifier for the entitlement related to the environment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceDefinitions")
    def service_definitions(self) -> Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceDefinitionResult']:
        """
        Details for a service definition.
        """
        return pulumi.get(self, "service_definitions")

    @_builtins.property
    @pulumi.getter(name="serviceEnvironmentEndpoints")
    def service_environment_endpoints(self) -> Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceEnvironmentEndpointResult']:
        """
        Array of service environment end points.
        """
        return pulumi.get(self, "service_environment_endpoints")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the entitlement registration for the service.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The unique subscription ID associated with the service environment ID.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceDefinitionResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 short_display_name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str display_name: The display name of the resource.
        :param _builtins.str short_display_name: Short display name of the service. For example, "Retail Order Management".
        :param _builtins.str type: The service definition type. For example, a service definition type "RGBUOROMS"  would be for the service "Oracle Retail Order Management Cloud Service".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "short_display_name", short_display_name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="shortDisplayName")
    def short_display_name(self) -> _builtins.str:
        """
        Short display name of the service. For example, "Retail Order Management".
        """
        return pulumi.get(self, "short_display_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The service definition type. For example, a service definition type "RGBUOROMS"  would be for the service "Oracle Retail Order Management Cloud Service".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceEnvironmentsServiceEnvironmentCollectionItemServiceEnvironmentEndpointResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 environment_type: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str description: Description of the environment link
        :param _builtins.str environment_type: Service environment endpoint type.
        :param _builtins.str url: Service environment instance URL.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment_type", environment_type)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the environment link
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> _builtins.str:
        """
        Service environment endpoint type.
        """
        return pulumi.get(self, "environment_type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Service environment instance URL.
        """
        return pulumi.get(self, "url")


