# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDiscoveryJobsResult',
    'AwaitableGetDiscoveryJobsResult',
    'get_discovery_jobs',
    'get_discovery_jobs_output',
]

@pulumi.output_type
class GetDiscoveryJobsResult:
    """
    A collection of values returned by getDiscoveryJobs.
    """
    def __init__(__self__, compartment_id=None, discovery_job_collections=None, filters=None, id=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if discovery_job_collections and not isinstance(discovery_job_collections, list):
            raise TypeError("Expected argument 'discovery_job_collections' to be a list")
        pulumi.set(__self__, "discovery_job_collections", discovery_job_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="discoveryJobCollections")
    def discovery_job_collections(self) -> Sequence['outputs.GetDiscoveryJobsDiscoveryJobCollectionResult']:
        """
        The list of discovery_job_collection.
        """
        return pulumi.get(self, "discovery_job_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDiscoveryJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


class AwaitableGetDiscoveryJobsResult(GetDiscoveryJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryJobsResult(
            compartment_id=self.compartment_id,
            discovery_job_collections=self.discovery_job_collections,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_discovery_jobs(compartment_id: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetDiscoveryJobsFilterArgs', 'GetDiscoveryJobsFilterArgsDict']]] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryJobsResult:
    """
    This data source provides the list of Discovery Jobs in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of all Discovery Jobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_jobs = oci.StackMonitoring.get_discovery_jobs(compartment_id=compartment_id,
        name=discovery_job_name)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param _builtins.str name: A filter to return only discovery jobs that match the entire resource name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getDiscoveryJobs:getDiscoveryJobs', __args__, opts=opts, typ=GetDiscoveryJobsResult).value

    return AwaitableGetDiscoveryJobsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        discovery_job_collections=pulumi.get(__ret__, 'discovery_job_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_discovery_jobs_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDiscoveryJobsFilterArgs', 'GetDiscoveryJobsFilterArgsDict']]]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiscoveryJobsResult]:
    """
    This data source provides the list of Discovery Jobs in Oracle Cloud Infrastructure Stack Monitoring service.

    API to get the details of all Discovery Jobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_jobs = oci.StackMonitoring.get_discovery_jobs(compartment_id=compartment_id,
        name=discovery_job_name)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which data is listed.
    :param _builtins.str name: A filter to return only discovery jobs that match the entire resource name given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getDiscoveryJobs:getDiscoveryJobs', __args__, opts=opts, typ=GetDiscoveryJobsResult)
    return __ret__.apply(lambda __response__: GetDiscoveryJobsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        discovery_job_collections=pulumi.get(__response__, 'discovery_job_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
