# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PathAnalyzerTestArgs', 'PathAnalyzerTest']

@pulumi.input_type
class PathAnalyzerTestArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 destination_endpoint: pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'],
                 protocol: pulumi.Input[_builtins.int],
                 source_endpoint: pulumi.Input['PathAnalyzerTestSourceEndpointArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
                 query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None):
        """
        The set of arguments for constructing a PathAnalyzerTest resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestSourceEndpointArgs'] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['PathAnalyzerTestProtocolParametersArgs'] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestQueryOptionsArgs'] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "destination_endpoint", destination_endpoint)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_endpoint", source_endpoint)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if protocol_parameters is not None:
            pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        if query_options is not None:
            pulumi.set(__self__, "query_options", query_options)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @destination_endpoint.setter
    def destination_endpoint(self, value: pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']):
        pulumi.set(self, "destination_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> pulumi.Input['PathAnalyzerTestSourceEndpointArgs']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @source_endpoint.setter
    def source_endpoint(self, value: pulumi.Input['PathAnalyzerTestSourceEndpointArgs']):
        pulumi.set(self, "source_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @_builtins.property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @query_options.setter
    def query_options(self, value: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]):
        pulumi.set(self, "query_options", value)


@pulumi.input_type
class _PathAnalyzerTestState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 destination_endpoint: Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
                 query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None,
                 source_endpoint: Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PathAnalyzerTest resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestProtocolParametersArgs'] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestQueryOptionsArgs'] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestSourceEndpointArgs'] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if destination_endpoint is not None:
            pulumi.set(__self__, "destination_endpoint", destination_endpoint)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_parameters is not None:
            pulumi.set(__self__, "protocol_parameters", protocol_parameters)
        if query_options is not None:
            pulumi.set(__self__, "query_options", query_options)
        if source_endpoint is not None:
            pulumi.set(__self__, "source_endpoint", source_endpoint)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']]:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @destination_endpoint.setter
    def destination_endpoint(self, value: Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']]):
        pulumi.set(self, "destination_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @_builtins.property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @query_options.setter
    def query_options(self, value: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]):
        pulumi.set(self, "query_options", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']]:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @source_endpoint.setter
    def source_endpoint(self, value: Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']]):
        pulumi.set(self, "source_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest")
class PathAnalyzerTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 destination_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestDestinationEndpointArgs', 'PathAnalyzerTestDestinationEndpointArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input[Union['PathAnalyzerTestProtocolParametersArgs', 'PathAnalyzerTestProtocolParametersArgsDict']]] = None,
                 query_options: Optional[pulumi.Input[Union['PathAnalyzerTestQueryOptionsArgs', 'PathAnalyzerTestQueryOptionsArgsDict']]] = None,
                 source_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestSourceEndpointArgs', 'PathAnalyzerTestSourceEndpointArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

        Creates a new `PathAnalyzerTest` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_path_analyzer_test = oci.vnmonitoring.PathAnalyzerTest("test_path_analyzer_test",
            compartment_id=compartment_id,
            destination_endpoint={
                "type": path_analyzer_test_destination_endpoint_type,
                "address": path_analyzer_test_destination_endpoint_address,
                "instance_id": test_instance["id"],
                "listener_id": test_listener["id"],
                "load_balancer_id": test_load_balancer["id"],
                "network_load_balancer_id": test_network_load_balancer["id"],
                "subnet_id": test_subnet["id"],
                "vlan_id": test_vlan["id"],
                "vnic_id": test_vnic_attachment["id"],
            },
            protocol=path_analyzer_test_protocol,
            source_endpoint={
                "type": path_analyzer_test_source_endpoint_type,
                "address": path_analyzer_test_source_endpoint_address,
                "instance_id": test_instance["id"],
                "listener_id": test_listener["id"],
                "load_balancer_id": test_load_balancer["id"],
                "network_load_balancer_id": test_network_load_balancer["id"],
                "subnet_id": test_subnet["id"],
                "vlan_id": test_vlan["id"],
                "vnic_id": test_vnic_attachment["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=path_analyzer_test_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            protocol_parameters={
                "type": path_analyzer_test_protocol_parameters_type,
                "destination_port": path_analyzer_test_protocol_parameters_destination_port,
                "icmp_code": path_analyzer_test_protocol_parameters_icmp_code,
                "icmp_type": path_analyzer_test_protocol_parameters_icmp_type,
                "source_port": path_analyzer_test_protocol_parameters_source_port,
            },
            query_options={
                "is_bi_directional_analysis": path_analyzer_test_query_options_is_bi_directional_analysis,
            })
        ```

        ## Import

        PathAnalyzerTests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest test_path_analyzer_test "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['PathAnalyzerTestDestinationEndpointArgs', 'PathAnalyzerTestDestinationEndpointArgsDict']] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestProtocolParametersArgs', 'PathAnalyzerTestProtocolParametersArgsDict']] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestQueryOptionsArgs', 'PathAnalyzerTestQueryOptionsArgsDict']] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestSourceEndpointArgs', 'PathAnalyzerTestSourceEndpointArgsDict']] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PathAnalyzerTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

        Creates a new `PathAnalyzerTest` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_path_analyzer_test = oci.vnmonitoring.PathAnalyzerTest("test_path_analyzer_test",
            compartment_id=compartment_id,
            destination_endpoint={
                "type": path_analyzer_test_destination_endpoint_type,
                "address": path_analyzer_test_destination_endpoint_address,
                "instance_id": test_instance["id"],
                "listener_id": test_listener["id"],
                "load_balancer_id": test_load_balancer["id"],
                "network_load_balancer_id": test_network_load_balancer["id"],
                "subnet_id": test_subnet["id"],
                "vlan_id": test_vlan["id"],
                "vnic_id": test_vnic_attachment["id"],
            },
            protocol=path_analyzer_test_protocol,
            source_endpoint={
                "type": path_analyzer_test_source_endpoint_type,
                "address": path_analyzer_test_source_endpoint_address,
                "instance_id": test_instance["id"],
                "listener_id": test_listener["id"],
                "load_balancer_id": test_load_balancer["id"],
                "network_load_balancer_id": test_network_load_balancer["id"],
                "subnet_id": test_subnet["id"],
                "vlan_id": test_vlan["id"],
                "vnic_id": test_vnic_attachment["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=path_analyzer_test_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            protocol_parameters={
                "type": path_analyzer_test_protocol_parameters_type,
                "destination_port": path_analyzer_test_protocol_parameters_destination_port,
                "icmp_code": path_analyzer_test_protocol_parameters_icmp_code,
                "icmp_type": path_analyzer_test_protocol_parameters_icmp_type,
                "source_port": path_analyzer_test_protocol_parameters_source_port,
            },
            query_options={
                "is_bi_directional_analysis": path_analyzer_test_query_options_is_bi_directional_analysis,
            })
        ```

        ## Import

        PathAnalyzerTests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest test_path_analyzer_test "id"
        ```

        :param str resource_name: The name of the resource.
        :param PathAnalyzerTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PathAnalyzerTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 destination_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestDestinationEndpointArgs', 'PathAnalyzerTestDestinationEndpointArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_parameters: Optional[pulumi.Input[Union['PathAnalyzerTestProtocolParametersArgs', 'PathAnalyzerTestProtocolParametersArgsDict']]] = None,
                 query_options: Optional[pulumi.Input[Union['PathAnalyzerTestQueryOptionsArgs', 'PathAnalyzerTestQueryOptionsArgsDict']]] = None,
                 source_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestSourceEndpointArgs', 'PathAnalyzerTestSourceEndpointArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PathAnalyzerTestArgs.__new__(PathAnalyzerTestArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if destination_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint'")
            __props__.__dict__["destination_endpoint"] = destination_endpoint
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_parameters"] = protocol_parameters
            __props__.__dict__["query_options"] = query_options
            if source_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint'")
            __props__.__dict__["source_endpoint"] = source_endpoint
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(PathAnalyzerTest, __self__).__init__(
            'oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            destination_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestDestinationEndpointArgs', 'PathAnalyzerTestDestinationEndpointArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            protocol: Optional[pulumi.Input[_builtins.int]] = None,
            protocol_parameters: Optional[pulumi.Input[Union['PathAnalyzerTestProtocolParametersArgs', 'PathAnalyzerTestProtocolParametersArgsDict']]] = None,
            query_options: Optional[pulumi.Input[Union['PathAnalyzerTestQueryOptionsArgs', 'PathAnalyzerTestQueryOptionsArgsDict']]] = None,
            source_endpoint: Optional[pulumi.Input[Union['PathAnalyzerTestSourceEndpointArgs', 'PathAnalyzerTestSourceEndpointArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'PathAnalyzerTest':
        """
        Get an existing PathAnalyzerTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['PathAnalyzerTestDestinationEndpointArgs', 'PathAnalyzerTestDestinationEndpointArgsDict']] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestProtocolParametersArgs', 'PathAnalyzerTestProtocolParametersArgsDict']] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestQueryOptionsArgs', 'PathAnalyzerTestQueryOptionsArgsDict']] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input[Union['PathAnalyzerTestSourceEndpointArgs', 'PathAnalyzerTestSourceEndpointArgsDict']] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[_builtins.str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PathAnalyzerTestState.__new__(_PathAnalyzerTestState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["destination_endpoint"] = destination_endpoint
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_parameters"] = protocol_parameters
        __props__.__dict__["query_options"] = query_options
        __props__.__dict__["source_endpoint"] = source_endpoint
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return PathAnalyzerTest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> pulumi.Output['outputs.PathAnalyzerTestDestinationEndpoint']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> pulumi.Output['outputs.PathAnalyzerTestProtocolParameters']:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @_builtins.property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> pulumi.Output['outputs.PathAnalyzerTestQueryOptions']:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @_builtins.property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> pulumi.Output['outputs.PathAnalyzerTestSourceEndpoint']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

