"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupMode = exports.Compression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Possible compression options Kinesis Data Firehose can use to compress data on delivery.
 */
class Compression {
    /**
     * Creates a new Compression instance with a custom value.
     */
    static of(value) {
        return new Compression(value);
    }
    /**
     * @param value the string value of the Compression.
     */
    constructor(value) {
        this.value = value;
    }
}
exports.Compression = Compression;
_a = JSII_RTTI_SYMBOL_1;
Compression[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations-alpha.Compression", version: "2.118.0-alpha.0" };
/**
 * gzip
 */
Compression.GZIP = new Compression('GZIP');
/**
 * Hadoop-compatible Snappy
 */
Compression.HADOOP_SNAPPY = new Compression('HADOOP_SNAPPY');
/**
 * Snappy
 */
Compression.SNAPPY = new Compression('Snappy');
/**
 * ZIP
 */
Compression.ZIP = new Compression('ZIP');
/**
 * Options for S3 record backup of a delivery stream.
 */
var BackupMode;
(function (BackupMode) {
    /**
     * All records are backed up.
     */
    BackupMode[BackupMode["ALL"] = 0] = "ALL";
    /**
     * Only records that failed to deliver or transform are backed up.
     */
    BackupMode[BackupMode["FAILED"] = 1] = "FAILED";
})(BackupMode || (exports.BackupMode = BackupMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBT0E7O0dBRUc7QUFDSCxNQUFhLFdBQVc7SUFxQnRCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxLQUFhO1FBQzVCLE9BQU8sSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0I7SUFFRDs7T0FFRztJQUNILFlBQW9DLEtBQWE7UUFBYixVQUFLLEdBQUwsS0FBSyxDQUFRO0tBQUs7O0FBL0J4RCxrQ0FnQ0M7OztBQS9CQzs7R0FFRztBQUNvQixnQkFBSSxHQUFHLElBQUksV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRXREOztHQUVHO0FBQ29CLHlCQUFhLEdBQUcsSUFBSSxXQUFXLENBQUMsZUFBZSxDQUFDLENBQUM7QUFFeEU7O0dBRUc7QUFDb0Isa0JBQU0sR0FBRyxJQUFJLFdBQVcsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUUxRDs7R0FFRztBQUNvQixlQUFHLEdBQUcsSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7QUFldEQ7O0dBRUc7QUFDSCxJQUFZLFVBVVg7QUFWRCxXQUFZLFVBQVU7SUFDcEI7O09BRUc7SUFDSCx5Q0FBRyxDQUFBO0lBRUg7O09BRUc7SUFDSCwrQ0FBTSxDQUFBO0FBQ1IsQ0FBQyxFQVZXLFVBQVUsMEJBQVYsVUFBVSxRQVVyQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGZpcmVob3NlIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzZmlyZWhvc2UtYWxwaGEnO1xuaW1wb3J0ICogYXMga21zIGZyb20gJ2F3cy1jZGstbGliL2F3cy1rbXMnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbG9ncyc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliL2NvcmUnO1xuXG4vKipcbiAqIFBvc3NpYmxlIGNvbXByZXNzaW9uIG9wdGlvbnMgS2luZXNpcyBEYXRhIEZpcmVob3NlIGNhbiB1c2UgdG8gY29tcHJlc3MgZGF0YSBvbiBkZWxpdmVyeS5cbiAqL1xuZXhwb3J0IGNsYXNzIENvbXByZXNzaW9uIHtcbiAgLyoqXG4gICAqIGd6aXBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1pJUCA9IG5ldyBDb21wcmVzc2lvbignR1pJUCcpO1xuXG4gIC8qKlxuICAgKiBIYWRvb3AtY29tcGF0aWJsZSBTbmFwcHlcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSEFET09QX1NOQVBQWSA9IG5ldyBDb21wcmVzc2lvbignSEFET09QX1NOQVBQWScpO1xuXG4gIC8qKlxuICAgKiBTbmFwcHlcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU05BUFBZID0gbmV3IENvbXByZXNzaW9uKCdTbmFwcHknKTtcblxuICAvKipcbiAgICogWklQXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFpJUCA9IG5ldyBDb21wcmVzc2lvbignWklQJyk7XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBuZXcgQ29tcHJlc3Npb24gaW5zdGFuY2Ugd2l0aCBhIGN1c3RvbSB2YWx1ZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YodmFsdWU6IHN0cmluZyk6IENvbXByZXNzaW9uIHtcbiAgICByZXR1cm4gbmV3IENvbXByZXNzaW9uKHZhbHVlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAcGFyYW0gdmFsdWUgdGhlIHN0cmluZyB2YWx1ZSBvZiB0aGUgQ29tcHJlc3Npb24uXG4gICAqL1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHB1YmxpYyByZWFkb25seSB2YWx1ZTogc3RyaW5nKSB7IH1cbn1cblxuLyoqXG4gKiBPcHRpb25zIGZvciBTMyByZWNvcmQgYmFja3VwIG9mIGEgZGVsaXZlcnkgc3RyZWFtLlxuICovXG5leHBvcnQgZW51bSBCYWNrdXBNb2RlIHtcbiAgLyoqXG4gICAqIEFsbCByZWNvcmRzIGFyZSBiYWNrZWQgdXAuXG4gICAqL1xuICBBTEwsXG5cbiAgLyoqXG4gICAqIE9ubHkgcmVjb3JkcyB0aGF0IGZhaWxlZCB0byBkZWxpdmVyIG9yIHRyYW5zZm9ybSBhcmUgYmFja2VkIHVwLlxuICAgKi9cbiAgRkFJTEVELFxufVxuXG4vKipcbiAqIExvZ2dpbmcgcmVsYXRlZCBwcm9wZXJ0aWVzIGZvciBhIGRlbGl2ZXJ5IHN0cmVhbSBkZXN0aW5hdGlvbi5cbiAqL1xuaW50ZXJmYWNlIERlc3RpbmF0aW9uTG9nZ2luZ1Byb3BzIHtcbiAgLyoqXG4gICAqIElmIHRydWUsIGxvZyBlcnJvcnMgd2hlbiBkYXRhIHRyYW5zZm9ybWF0aW9uIG9yIGRhdGEgZGVsaXZlcnkgZmFpbHMuXG4gICAqXG4gICAqIElmIGBsb2dHcm91cGAgaXMgcHJvdmlkZWQsIHRoaXMgd2lsbCBiZSBpbXBsaWNpdGx5IHNldCB0byBgdHJ1ZWAuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWUgLSBlcnJvcnMgYXJlIGxvZ2dlZC5cbiAgICovXG4gIHJlYWRvbmx5IGxvZ2dpbmc/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgQ2xvdWRXYXRjaCBsb2cgZ3JvdXAgd2hlcmUgbG9nIHN0cmVhbXMgd2lsbCBiZSBjcmVhdGVkIHRvIGhvbGQgZXJyb3IgbG9ncy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBpZiBgbG9nZ2luZ2AgaXMgc2V0IHRvIGB0cnVlYCwgYSBsb2cgZ3JvdXAgd2lsbCBiZSBjcmVhdGVkIGZvciB5b3UuXG4gICAqL1xuICByZWFkb25seSBsb2dHcm91cD86IGxvZ3MuSUxvZ0dyb3VwO1xufVxuXG4vKipcbiAqIENvbW1vbiBwcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGJhY2t1cCwgaW50ZXJtZWRpYXJ5LCBvciBmaW5hbCBTMyBkZXN0aW5hdGlvbiBmb3IgYSBLaW5lc2lzIERhdGEgRmlyZWhvc2UgZGVsaXZlcnkgc3RyZWFtLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENvbW1vbkRlc3RpbmF0aW9uUzNQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbGVuZ3RoIG9mIHRpbWUgdGhhdCBGaXJlaG9zZSBidWZmZXJzIGluY29taW5nIGRhdGEgYmVmb3JlIGRlbGl2ZXJpbmdcbiAgICogaXQgdG8gdGhlIFMzIGJ1Y2tldC5cbiAgICpcbiAgICogTWluaW11bTogRHVyYXRpb24uc2Vjb25kcyg2MClcbiAgICogTWF4aW11bTogRHVyYXRpb24uc2Vjb25kcyg5MDApXG4gICAqXG4gICAqIEBkZWZhdWx0IER1cmF0aW9uLnNlY29uZHMoMzAwKVxuICAgKi9cbiAgcmVhZG9ubHkgYnVmZmVyaW5nSW50ZXJ2YWw/OiBjZGsuRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBzaXplIG9mIHRoZSBidWZmZXIgdGhhdCBLaW5lc2lzIERhdGEgRmlyZWhvc2UgdXNlcyBmb3IgaW5jb21pbmcgZGF0YSBiZWZvcmVcbiAgICogZGVsaXZlcmluZyBpdCB0byB0aGUgUzMgYnVja2V0LlxuICAgKlxuICAgKiBNaW5pbXVtOiBTaXplLm1lYmlieXRlcygxKVxuICAgKiBNYXhpbXVtOiBTaXplLm1lYmlieXRlcygxMjgpXG4gICAqXG4gICAqIEBkZWZhdWx0IFNpemUubWViaWJ5dGVzKDUpXG4gICAqL1xuICByZWFkb25seSBidWZmZXJpbmdTaXplPzogY2RrLlNpemU7XG5cbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIGNvbXByZXNzaW9uIHRoYXQgS2luZXNpcyBEYXRhIEZpcmVob3NlIHVzZXMgdG8gY29tcHJlc3MgdGhlIGRhdGFcbiAgICogdGhhdCBpdCBkZWxpdmVycyB0byB0aGUgQW1hem9uIFMzIGJ1Y2tldC5cbiAgICpcbiAgICogVGhlIGNvbXByZXNzaW9uIGZvcm1hdHMgU05BUFBZIG9yIFpJUCBjYW5ub3QgYmUgc3BlY2lmaWVkIGZvciBBbWF6b24gUmVkc2hpZnRcbiAgICogZGVzdGluYXRpb25zIGJlY2F1c2UgdGhleSBhcmUgbm90IHN1cHBvcnRlZCBieSB0aGUgQW1hem9uIFJlZHNoaWZ0IENPUFkgb3BlcmF0aW9uXG4gICAqIHRoYXQgcmVhZHMgZnJvbSB0aGUgUzMgYnVja2V0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVOQ09NUFJFU1NFRFxuICAgKi9cbiAgcmVhZG9ubHkgY29tcHJlc3Npb24/OiBDb21wcmVzc2lvbjtcblxuICAvKipcbiAgICogVGhlIEFXUyBLTVMga2V5IHVzZWQgdG8gZW5jcnlwdCB0aGUgZGF0YSB0aGF0IGl0IGRlbGl2ZXJzIHRvIHlvdXIgQW1hem9uIFMzIGJ1Y2tldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBEYXRhIGlzIG5vdCBlbmNyeXB0ZWQuXG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzoga21zLklLZXk7XG5cbiAgLyoqXG4gICAqIEEgcHJlZml4IHRoYXQgS2luZXNpcyBEYXRhIEZpcmVob3NlIGV2YWx1YXRlcyBhbmQgYWRkcyB0byBmYWlsZWQgcmVjb3JkcyBiZWZvcmUgd3JpdGluZyB0aGVtIHRvIFMzLlxuICAgKlxuICAgKiBUaGlzIHByZWZpeCBhcHBlYXJzIGltbWVkaWF0ZWx5IGZvbGxvd2luZyB0aGUgYnVja2V0IG5hbWUuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZpcmVob3NlL2xhdGVzdC9kZXYvczMtcHJlZml4ZXMuaHRtbFxuICAgKlxuICAgKiBAZGVmYXVsdCBcIllZWVkvTU0vREQvSEhcIlxuICAgKi9cbiAgcmVhZG9ubHkgZXJyb3JPdXRwdXRQcmVmaXg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgcHJlZml4IHRoYXQgS2luZXNpcyBEYXRhIEZpcmVob3NlIGV2YWx1YXRlcyBhbmQgYWRkcyB0byByZWNvcmRzIGJlZm9yZSB3cml0aW5nIHRoZW0gdG8gUzMuXG4gICAqXG4gICAqIFRoaXMgcHJlZml4IGFwcGVhcnMgaW1tZWRpYXRlbHkgZm9sbG93aW5nIHRoZSBidWNrZXQgbmFtZS5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZmlyZWhvc2UvbGF0ZXN0L2Rldi9zMy1wcmVmaXhlcy5odG1sXG4gICAqXG4gICAqIEBkZWZhdWx0IFwiWVlZWS9NTS9ERC9ISFwiXG4gICAqL1xuICByZWFkb25seSBkYXRhT3V0cHV0UHJlZml4Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGFuIFMzIGJhY2t1cCBkZXN0aW5hdGlvbi5cbiAqXG4gKiBTMyBiYWNrdXAgaXMgYXZhaWxhYmxlIGZvciBhbGwgZGVzdGluYXRpb25zLCByZWdhcmRsZXNzIG9mIHdoZXRoZXIgdGhlIGZpbmFsIGRlc3RpbmF0aW9uIGlzIFMzIG9yIG5vdC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEZXN0aW5hdGlvblMzQmFja3VwUHJvcHMgZXh0ZW5kcyBEZXN0aW5hdGlvbkxvZ2dpbmdQcm9wcywgQ29tbW9uRGVzdGluYXRpb25TM1Byb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBTMyBidWNrZXQgdGhhdCB3aWxsIHN0b3JlIGRhdGEgYW5kIGZhaWxlZCByZWNvcmRzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIElmIGBtb2RlYCBpcyBzZXQgdG8gYEJhY2t1cE1vZGUuQUxMYCBvciBgQmFja3VwTW9kZS5GQUlMRURgLCBhIGJ1Y2tldCB3aWxsIGJlIGNyZWF0ZWQgZm9yIHlvdS5cbiAgICovXG4gIHJlYWRvbmx5IGJ1Y2tldD86IHMzLklCdWNrZXQ7XG5cbiAgLyoqXG4gICAqIEluZGljYXRlcyB0aGUgbW9kZSBieSB3aGljaCBpbmNvbWluZyByZWNvcmRzIHNob3VsZCBiZSBiYWNrZWQgdXAgdG8gUzMsIGlmIGFueS5cbiAgICpcbiAgICogSWYgYGJ1Y2tldGAgaXMgcHJvdmlkZWQsIHRoaXMgd2lsbCBiZSBpbXBsaWNpdGx5IHNldCB0byBgQmFja3VwTW9kZS5BTExgLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIElmIGBidWNrZXRgIGlzIHByb3ZpZGVkLCB0aGUgZGVmYXVsdCB3aWxsIGJlIGBCYWNrdXBNb2RlLkFMTGAuIE90aGVyd2lzZSxcbiAgICogc291cmNlIHJlY29yZHMgYXJlIG5vdCBiYWNrZWQgdXAgdG8gUzMuXG4gICovXG4gIHJlYWRvbmx5IG1vZGU/OiBCYWNrdXBNb2RlO1xufVxuXG4vKipcbiAqIEdlbmVyaWMgcHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBkZWxpdmVyeSBzdHJlYW0gZGVzdGluYXRpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29tbW9uRGVzdGluYXRpb25Qcm9wcyBleHRlbmRzIERlc3RpbmF0aW9uTG9nZ2luZ1Byb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBJQU0gcm9sZSBhc3NvY2lhdGVkIHdpdGggdGhpcyBkZXN0aW5hdGlvbi5cbiAgICpcbiAgICogQXNzdW1lZCBieSBLaW5lc2lzIERhdGEgRmlyZWhvc2UgdG8gaW52b2tlIHByb2Nlc3NvcnMgYW5kIHdyaXRlIHRvIGRlc3RpbmF0aW9uc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgcm9sZSB3aWxsIGJlIGNyZWF0ZWQgd2l0aCBkZWZhdWx0IHBlcm1pc3Npb25zLlxuICAgKi9cbiAgcmVhZG9ubHkgcm9sZT86IGlhbS5JUm9sZTtcblxuICAvKipcbiAgICogVGhlIGRhdGEgdHJhbnNmb3JtYXRpb24gdGhhdCBzaG91bGQgYmUgcGVyZm9ybWVkIG9uIHRoZSBkYXRhIGJlZm9yZSB3cml0aW5nIHRvIHRoZSBkZXN0aW5hdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBkYXRhIHRyYW5zZm9ybWF0aW9uIHdpbGwgb2NjdXIuXG4gICAqL1xuICByZWFkb25seSBwcm9jZXNzb3I/OiBmaXJlaG9zZS5JRGF0YVByb2Nlc3NvcjtcblxuICAvKipcbiAgICogVGhlIGNvbmZpZ3VyYXRpb24gZm9yIGJhY2tpbmcgdXAgc291cmNlIHJlY29yZHMgdG8gUzMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gc291cmNlIHJlY29yZHMgd2lsbCBub3QgYmUgYmFja2VkIHVwIHRvIFMzLlxuICAgKi9cbiAgcmVhZG9ubHkgczNCYWNrdXA/OiBEZXN0aW5hdGlvblMzQmFja3VwUHJvcHM7XG59XG4iXX0=