import * as firehose from '@aws-cdk/aws-kinesisfirehose-alpha';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { CommonDestinationProps, CommonDestinationS3Props } from './common';
/**
 * Props for defining an S3 destination of a Kinesis Data Firehose delivery stream.
 */
export interface S3BucketProps extends CommonDestinationS3Props, CommonDestinationProps {
}
/**
 * An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 */
export declare class S3Bucket implements firehose.IDestination {
    private readonly bucket;
    private readonly props;
    constructor(bucket: s3.IBucket, props?: S3BucketProps);
    bind(scope: Construct, _options: firehose.DestinationBindOptions): firehose.DestinationConfig;
    private getS3BackupMode;
}
