"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3Bucket = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const common_1 = require("./common");
const helpers_1 = require("./private/helpers");
/**
 * An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 */
class S3Bucket {
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kinesisfirehose_destinations_alpha_S3BucketProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, S3Bucket);
            }
            throw error;
        }
        if (this.props.s3Backup?.mode === common_1.BackupMode.FAILED) {
            throw new Error('S3 destinations do not support BackupMode.FAILED');
        }
    }
    bind(scope, _options) {
        const role = this.props.role ?? new iam.Role(scope, 'S3 Destination Role', {
            assumedBy: new iam.ServicePrincipal('firehose.amazonaws.com'),
        });
        const bucketGrant = this.bucket.grantReadWrite(role);
        const { loggingOptions, dependables: loggingDependables } = (0, helpers_1.createLoggingOptions)(scope, {
            logging: this.props.logging,
            logGroup: this.props.logGroup,
            role,
            streamId: 'S3Destination',
        }) ?? {};
        const { backupConfig, dependables: backupDependables } = (0, helpers_1.createBackupConfig)(scope, role, this.props.s3Backup) ?? {};
        return {
            extendedS3DestinationConfiguration: {
                cloudWatchLoggingOptions: loggingOptions,
                processingConfiguration: (0, helpers_1.createProcessingConfig)(scope, role, this.props.processor),
                roleArn: role.roleArn,
                s3BackupConfiguration: backupConfig,
                s3BackupMode: this.getS3BackupMode(),
                bufferingHints: (0, helpers_1.createBufferingHints)(this.props.bufferingInterval, this.props.bufferingSize),
                bucketArn: this.bucket.bucketArn,
                compressionFormat: this.props.compression?.value,
                encryptionConfiguration: (0, helpers_1.createEncryptionConfig)(role, this.props.encryptionKey),
                errorOutputPrefix: this.props.errorOutputPrefix,
                prefix: this.props.dataOutputPrefix,
            },
            dependables: [bucketGrant, ...(loggingDependables ?? []), ...(backupDependables ?? [])],
        };
    }
    getS3BackupMode() {
        return this.props.s3Backup?.bucket || this.props.s3Backup?.mode === common_1.BackupMode.ALL
            ? 'Enabled'
            : undefined;
    }
}
exports.S3Bucket = S3Bucket;
_a = JSII_RTTI_SYMBOL_1;
S3Bucket[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-destinations-alpha.S3Bucket", version: "2.118.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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