# PatronX
PatronX is a small toolkit for managing PostgreSQL backups and point‑in‑time
restores. It is written in typed Python and exposes a concise command‑line
interface. Backups can be scheduled, diffed and off‑loaded to S3 with a minimal
setup.


<img src="./patronx.jpg" width="200" />

[![codecov](https://codecov.io/gh/xdanielsb/patronx/graph/badge.svg?token=AHTJFKDSKU)](https://codecov.io/gh/xdanielsb/patron)
![Test](https://github.com/xdanielsb/patronx/actions/workflows/ci-test.yml/badge.svg)
![Docker publish](https://github.com/xdanielsb/patronx/actions/workflows/cd-docker-publish.yml/badge.svg)
![PyPI publish](https://github.com/xdanielsb/patronx/actions/workflows/cd-publish-to-pypi.yml/badge.svg)
[![PyPI](https://img.shields.io/pypi/v/patronx)](https://pypi.org/project/patronx/)

Docker Tags are available on [Docker Hub](https://hub.docker.com/r/xdanielsb/patronx/tags):

## Utilities 

| Command                     | Purpose                                                       |
|-----------------------------|---------------------------------------------------------------|
| ``patronx backup``          | create a new dump                                             |
| ``patronx restore``         | restore a dump into the database                              |
| ``patronx list``            | list all dumps in ``BACKUP_DIR``                              |
| ``patronx diff``            | diff latest dump against the database                         |
| ``patronx check-db``        | verify database connectivity                                  |
| ``patronx start``           | run scheduled backup/cleanup loops and listen for healthcheck |
| ``patronx enqueue-backup``  | queue a backup job immediately                                |
| ``patronx enqueue-cleanup`` | queue cleanup of old dumps                                    |

`backup` and `enqueue-backup` upload the dumps to s3 if s3 is configured.



## Configuration
The following environment variables control how PatronX connects to the database
and schedules jobs:

- ``PGHOST``           – database host (default ``localhost``)
- ``PGPORT``           – database port (default ``5432``)
- ``PGUSER``           – authentication user (default ``test_user``)
- ``PGPASSWORD``       – password for ``PGUSER``
- ``PGDATABASE``       – database name (default ``test_db``)
- ``BACKUP_DIR``       – where dumps are stored (default ``./backups``)
- ``BACKUP_CRON``      – cron expression for automated backups
- ``CLEANUP_CRON``     – cron expression for removing old dumps
- ``RETENTION_DAYS``   – how long to keep dumps (default ``30``)
- ``S3_BUCKET``        – optional bucket for S3 uploads
- ``AMQP_URL``         – RabbitMQ connection string
- ``LOGSTASH_HOST``    – Logstash host (default ``logstash``)
- ``LOGSTASH_PORT``    – Logstash port (default ``5000``)
- ``HEALTH_PORT``      – port for the built‑in health server (default ``7775``)


## Docs

For guidance on setting up an IAM user with minimum access for S3 uploads, see
[``docs/aws-user-creation.md``](docs/aws-user-creation.md).


### Development  

```bash
pytest                   # run tests
```

```bash
ruff check . --fix       # lint
```

```bash
isort .                  # format imports
```

# generate requirements.txt
```bash
pip install pip-tools
```
```bash
pip-compile --output-file=requirements.txt pyproject.toml 
```
