# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessLevelConditionArgs', 'AccessLevelCondition']

@pulumi.input_type
class AccessLevelConditionArgs:
    def __init__(__self__, *,
                 access_level: pulumi.Input[_builtins.str],
                 device_policy: Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']] = None,
                 ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_network_sources: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]] = None):
        """
        The set of arguments for constructing a AccessLevelCondition resource.
        :param pulumi.Input[_builtins.str] access_level: The name of the Access Level to add this condition to.
        :param pulumi.Input['AccessLevelConditionDevicePolicyArgs'] device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param pulumi.Input[_builtins.bool] negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]] vpc_network_sources: The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
               Structure is documented below.
        """
        pulumi.set(__self__, "access_level", access_level)
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)
        if vpc_network_sources is not None:
            pulumi.set(__self__, "vpc_network_sources", vpc_network_sources)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Access Level to add this condition to.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']]:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']]):
        pulumi.set(self, "device_policy", value)

    @_builtins.property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @ip_subnetworks.setter
    def ip_subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_subnetworks", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")

    @required_access_levels.setter
    def required_access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "required_access_levels", value)

    @_builtins.property
    @pulumi.getter(name="vpcNetworkSources")
    def vpc_network_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]]:
        """
        The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_network_sources")

    @vpc_network_sources.setter
    def vpc_network_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]]):
        pulumi.set(self, "vpc_network_sources", value)


@pulumi.input_type
class _AccessLevelConditionState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 device_policy: Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']] = None,
                 ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_network_sources: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering AccessLevelCondition resources.
        :param pulumi.Input[_builtins.str] access_level: The name of the Access Level to add this condition to.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input['AccessLevelConditionDevicePolicyArgs'] device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param pulumi.Input[_builtins.bool] negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]] vpc_network_sources: The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
               Structure is documented below.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_policy_id is not None:
            pulumi.set(__self__, "access_policy_id", access_policy_id)
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)
        if vpc_network_sources is not None:
            pulumi.set(__self__, "vpc_network_sources", vpc_network_sources)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Access Level to add this condition to.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @access_policy_id.setter
    def access_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']]:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input['AccessLevelConditionDevicePolicyArgs']]):
        pulumi.set(self, "device_policy", value)

    @_builtins.property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @ip_subnetworks.setter
    def ip_subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_subnetworks", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")

    @required_access_levels.setter
    def required_access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "required_access_levels", value)

    @_builtins.property
    @pulumi.getter(name="vpcNetworkSources")
    def vpc_network_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]]:
        """
        The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_network_sources")

    @vpc_network_sources.setter
    def vpc_network_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelConditionVpcNetworkSourceArgs']]]]):
        pulumi.set(self, "vpc_network_sources", value)


@pulumi.type_token("gcp:accesscontextmanager/accessLevelCondition:AccessLevelCondition")
class AccessLevelCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 device_policy: Optional[pulumi.Input[Union['AccessLevelConditionDevicePolicyArgs', 'AccessLevelConditionDevicePolicyArgsDict']]] = None,
                 ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_network_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelConditionVpcNetworkSourceArgs', 'AccessLevelConditionVpcNetworkSourceArgsDict']]]]] = None,
                 __props__=None):
        """
        Allows configuring a single access level condition to be appended to an access level's conditions.
        This resource is intended to be used in cases where it is not possible to compile a full list
        of conditions to include in a `accesscontextmanager.AccessLevel` resource,
        to enable them to be added separately.

        > **Note:** If this resource is used alongside a `accesscontextmanager.AccessLevel` resource,
        the access level resource must have a `lifecycle` block with `ignore_changes = [basic[0].conditions]` so
        they don't fight over which service accounts should be included.

        To get more information about AccessLevelCondition, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.accessLevels)
        * How-to Guides
            * [Access Policy Quickstart](https://cloud.google.com/access-context-manager/docs/quickstart)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage

        ### Access Context Manager Access Level Condition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        access_level_service_account = gcp.accesscontextmanager.AccessLevel("access-level-service-account",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            name=access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
            title="chromeos_no_lock",
            basic={
                "conditions": [{
                    "device_policy": {
                        "require_screen_lock": True,
                        "os_constraints": [{
                            "os_type": "DESKTOP_CHROME_OS",
                        }],
                    },
                    "regions": [
                        "CH",
                        "IT",
                        "US",
                    ],
                }],
            })
        created_later = gcp.serviceaccount.Account("created-later", account_id="my-account-id")
        access_level_conditions = gcp.accesscontextmanager.AccessLevelCondition("access-level-conditions",
            access_level=access_level_service_account.name,
            ip_subnetworks=["192.0.4.0/24"],
            members=[
                "user:test@google.com",
                "user:test2@google.com",
                created_later.email.apply(lambda email: f"serviceAccount:{email}"),
            ],
            negate=False,
            device_policy={
                "require_screen_lock": False,
                "require_admin_approval": False,
                "require_corp_owned": True,
                "os_constraints": [{
                    "os_type": "DESKTOP_CHROME_OS",
                }],
            },
            regions=[
                "IT",
                "US",
            ])
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: The name of the Access Level to add this condition to.
        :param pulumi.Input[Union['AccessLevelConditionDevicePolicyArgs', 'AccessLevelConditionDevicePolicyArgsDict']] device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param pulumi.Input[_builtins.bool] negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelConditionVpcNetworkSourceArgs', 'AccessLevelConditionVpcNetworkSourceArgsDict']]]] vpc_network_sources: The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessLevelConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows configuring a single access level condition to be appended to an access level's conditions.
        This resource is intended to be used in cases where it is not possible to compile a full list
        of conditions to include in a `accesscontextmanager.AccessLevel` resource,
        to enable them to be added separately.

        > **Note:** If this resource is used alongside a `accesscontextmanager.AccessLevel` resource,
        the access level resource must have a `lifecycle` block with `ignore_changes = [basic[0].conditions]` so
        they don't fight over which service accounts should be included.

        To get more information about AccessLevelCondition, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.accessLevels)
        * How-to Guides
            * [Access Policy Quickstart](https://cloud.google.com/access-context-manager/docs/quickstart)

        > **Warning:** If you are using User ADCs (Application Default Credentials) with this resource,
        you must specify a `billing_project` and set `user_project_override` to true
        in the provider configuration. Otherwise the ACM API will return a 403 error.
        Your account must have the `serviceusage.services.use` permission on the
        `billing_project` you defined.

        ## Example Usage

        ### Access Context Manager Access Level Condition Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        access_level_service_account = gcp.accesscontextmanager.AccessLevel("access-level-service-account",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            name=access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
            title="chromeos_no_lock",
            basic={
                "conditions": [{
                    "device_policy": {
                        "require_screen_lock": True,
                        "os_constraints": [{
                            "os_type": "DESKTOP_CHROME_OS",
                        }],
                    },
                    "regions": [
                        "CH",
                        "IT",
                        "US",
                    ],
                }],
            })
        created_later = gcp.serviceaccount.Account("created-later", account_id="my-account-id")
        access_level_conditions = gcp.accesscontextmanager.AccessLevelCondition("access-level-conditions",
            access_level=access_level_service_account.name,
            ip_subnetworks=["192.0.4.0/24"],
            members=[
                "user:test@google.com",
                "user:test2@google.com",
                created_later.email.apply(lambda email: f"serviceAccount:{email}"),
            ],
            negate=False,
            device_policy={
                "require_screen_lock": False,
                "require_admin_approval": False,
                "require_corp_owned": True,
                "os_constraints": [{
                    "os_type": "DESKTOP_CHROME_OS",
                }],
            },
            regions=[
                "IT",
                "US",
            ])
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param AccessLevelConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessLevelConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 device_policy: Optional[pulumi.Input[Union['AccessLevelConditionDevicePolicyArgs', 'AccessLevelConditionDevicePolicyArgsDict']]] = None,
                 ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_network_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelConditionVpcNetworkSourceArgs', 'AccessLevelConditionVpcNetworkSourceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessLevelConditionArgs.__new__(AccessLevelConditionArgs)

            if access_level is None and not opts.urn:
                raise TypeError("Missing required property 'access_level'")
            __props__.__dict__["access_level"] = access_level
            __props__.__dict__["device_policy"] = device_policy
            __props__.__dict__["ip_subnetworks"] = ip_subnetworks
            __props__.__dict__["members"] = members
            __props__.__dict__["negate"] = negate
            __props__.__dict__["regions"] = regions
            __props__.__dict__["required_access_levels"] = required_access_levels
            __props__.__dict__["vpc_network_sources"] = vpc_network_sources
            __props__.__dict__["access_policy_id"] = None
        super(AccessLevelCondition, __self__).__init__(
            'gcp:accesscontextmanager/accessLevelCondition:AccessLevelCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[_builtins.str]] = None,
            access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            device_policy: Optional[pulumi.Input[Union['AccessLevelConditionDevicePolicyArgs', 'AccessLevelConditionDevicePolicyArgsDict']]] = None,
            ip_subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            negate: Optional[pulumi.Input[_builtins.bool]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            required_access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_network_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelConditionVpcNetworkSourceArgs', 'AccessLevelConditionVpcNetworkSourceArgsDict']]]]] = None) -> 'AccessLevelCondition':
        """
        Get an existing AccessLevelCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: The name of the Access Level to add this condition to.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[Union['AccessLevelConditionDevicePolicyArgs', 'AccessLevelConditionDevicePolicyArgsDict']] device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param pulumi.Input[_builtins.bool] negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelConditionVpcNetworkSourceArgs', 'AccessLevelConditionVpcNetworkSourceArgsDict']]]] vpc_network_sources: The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessLevelConditionState.__new__(_AccessLevelConditionState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["access_policy_id"] = access_policy_id
        __props__.__dict__["device_policy"] = device_policy
        __props__.__dict__["ip_subnetworks"] = ip_subnetworks
        __props__.__dict__["members"] = members
        __props__.__dict__["negate"] = negate
        __props__.__dict__["regions"] = regions
        __props__.__dict__["required_access_levels"] = required_access_levels
        __props__.__dict__["vpc_network_sources"] = vpc_network_sources
        return AccessLevelCondition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Access Level to add this condition to.
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @_builtins.property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> pulumi.Output[Optional['outputs.AccessLevelConditionDevicePolicy']]:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @_builtins.property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def negate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")

    @_builtins.property
    @pulumi.getter(name="vpcNetworkSources")
    def vpc_network_sources(self) -> pulumi.Output[Optional[Sequence['outputs.AccessLevelConditionVpcNetworkSource']]]:
        """
        The request must originate from one of the provided VPC networks in Google Cloud. Cannot specify this field together with `ip_subnetworks`.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_network_sources")

