# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EgressPolicyArgs', 'EgressPolicy']

@pulumi.input_type
class EgressPolicyArgs:
    def __init__(__self__, *,
                 egress_policy_name: pulumi.Input[_builtins.str],
                 resource: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EgressPolicy resource.
        :param pulumi.Input[_builtins.str] egress_policy_name: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] resource: A GCP resource that is inside of the service perimeter.
        """
        pulumi.set(__self__, "egress_policy_name", egress_policy_name)
        pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="egressPolicyName")
    def egress_policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "egress_policy_name")

    @egress_policy_name.setter
    def egress_policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "egress_policy_name", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Input[_builtins.str]:
        """
        A GCP resource that is inside of the service perimeter.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class _EgressPolicyState:
    def __init__(__self__, *,
                 access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EgressPolicy resources.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[_builtins.str] egress_policy_name: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] resource: A GCP resource that is inside of the service perimeter.
        """
        if access_policy_id is not None:
            pulumi.set(__self__, "access_policy_id", access_policy_id)
        if egress_policy_name is not None:
            pulumi.set(__self__, "egress_policy_name", egress_policy_name)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @access_policy_id.setter
    def access_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="egressPolicyName")
    def egress_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "egress_policy_name")

    @egress_policy_name.setter
    def egress_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "egress_policy_name", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A GCP resource that is inside of the service perimeter.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)


@pulumi.type_token("gcp:accesscontextmanager/egressPolicy:EgressPolicy")
class EgressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource has been deprecated, please refer to ServicePerimeterEgressPolicy.

        To get more information about EgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)

        ## Import

        EgressPolicy can be imported using any of these accepted formats:

        * `{{egress_policy_name}}/{{resource}}`

        When using the `pulumi import` command, EgressPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/egressPolicy:EgressPolicy default {{egress_policy_name}}/{{resource}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] egress_policy_name: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] resource: A GCP resource that is inside of the service perimeter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EgressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource has been deprecated, please refer to ServicePerimeterEgressPolicy.

        To get more information about EgressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#egresspolicy)

        ## Import

        EgressPolicy can be imported using any of these accepted formats:

        * `{{egress_policy_name}}/{{resource}}`

        When using the `pulumi import` command, EgressPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/egressPolicy:EgressPolicy default {{egress_policy_name}}/{{resource}}
        ```

        :param str resource_name: The name of the resource.
        :param EgressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EgressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EgressPolicyArgs.__new__(EgressPolicyArgs)

            if egress_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'egress_policy_name'")
            __props__.__dict__["egress_policy_name"] = egress_policy_name
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            __props__.__dict__["access_policy_id"] = None
        super(EgressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/egressPolicy:EgressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            egress_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource: Optional[pulumi.Input[_builtins.str]] = None) -> 'EgressPolicy':
        """
        Get an existing EgressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[_builtins.str] egress_policy_name: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] resource: A GCP resource that is inside of the service perimeter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EgressPolicyState.__new__(_EgressPolicyState)

        __props__.__dict__["access_policy_id"] = access_policy_id
        __props__.__dict__["egress_policy_name"] = egress_policy_name
        __props__.__dict__["resource"] = resource
        return EgressPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @_builtins.property
    @pulumi.getter(name="egressPolicyName")
    def egress_policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "egress_policy_name")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Output[_builtins.str]:
        """
        A GCP resource that is inside of the service perimeter.
        """
        return pulumi.get(self, "resource")

