# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ControlPlaneAccessArgs', 'ControlPlaneAccess']

@pulumi.input_type
class ControlPlaneAccessArgs:
    def __init__(__self__, *,
                 analytics_publisher_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronizer_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ControlPlaneAccess resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] analytics_publisher_identities: Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        :param pulumi.Input[_builtins.str] name: Name of the Apigee organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] synchronizer_identities: Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        if analytics_publisher_identities is not None:
            pulumi.set(__self__, "analytics_publisher_identities", analytics_publisher_identities)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if synchronizer_identities is not None:
            pulumi.set(__self__, "synchronizer_identities", synchronizer_identities)

    @_builtins.property
    @pulumi.getter(name="analyticsPublisherIdentities")
    def analytics_publisher_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        """
        return pulumi.get(self, "analytics_publisher_identities")

    @analytics_publisher_identities.setter
    def analytics_publisher_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "analytics_publisher_identities", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="synchronizerIdentities")
    def synchronizer_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "synchronizer_identities")

    @synchronizer_identities.setter
    def synchronizer_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "synchronizer_identities", value)


@pulumi.input_type
class _ControlPlaneAccessState:
    def __init__(__self__, *,
                 analytics_publisher_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronizer_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ControlPlaneAccess resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] analytics_publisher_identities: Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        :param pulumi.Input[_builtins.str] name: Name of the Apigee organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] synchronizer_identities: Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        if analytics_publisher_identities is not None:
            pulumi.set(__self__, "analytics_publisher_identities", analytics_publisher_identities)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if synchronizer_identities is not None:
            pulumi.set(__self__, "synchronizer_identities", synchronizer_identities)

    @_builtins.property
    @pulumi.getter(name="analyticsPublisherIdentities")
    def analytics_publisher_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        """
        return pulumi.get(self, "analytics_publisher_identities")

    @analytics_publisher_identities.setter
    def analytics_publisher_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "analytics_publisher_identities", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="synchronizerIdentities")
    def synchronizer_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "synchronizer_identities")

    @synchronizer_identities.setter
    def synchronizer_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "synchronizer_identities", value)


@pulumi.type_token("gcp:apigee/controlPlaneAccess:ControlPlaneAccess")
class ControlPlaneAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_publisher_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronizer_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Authorize the Runtime components to access directly with Apigee Control Plane.

        To get more information about ControlPlaneAccess, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations/updateControlPlaneAccess)
        * How-to Guides
            * [Enable ControlPlane access](https://cloud.google.com/apigee/docs/hybrid/v1.14/install-enable-control-plane-access)

        ## Example Usage

        ### Apigee Control Plane Access Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project.project_id,
            runtime_type="HYBRID",
            opts = pulumi.ResourceOptions(depends_on=[apigee]))
        service_account = gcp.serviceaccount.Account("service_account",
            account_id="my-account",
            display_name="Service Account")
        synchronizer_iam = gcp.projects.IAMMember("synchronizer-iam",
            project=project.project_id,
            role="roles/apigee.synchronizerManager",
            member=service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        apigee_control_plane_access = gcp.apigee.ControlPlaneAccess("apigee_control_plane_access",
            name=apigee_org.name,
            synchronizer_identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")],
            analytics_publisher_identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")])
        ```

        ## Import

        ControlPlaneAccess can be imported using any of these accepted formats:

        * `organizations/{{name}}/controlPlaneAccess`

        * `{{name}}`

        When using the `pulumi import` command, ControlPlaneAccess can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/controlPlaneAccess:ControlPlaneAccess default organizations/{{name}}/controlPlaneAccess
        ```

        ```sh
        $ pulumi import gcp:apigee/controlPlaneAccess:ControlPlaneAccess default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] analytics_publisher_identities: Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        :param pulumi.Input[_builtins.str] name: Name of the Apigee organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] synchronizer_identities: Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ControlPlaneAccessArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Authorize the Runtime components to access directly with Apigee Control Plane.

        To get more information about ControlPlaneAccess, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations/updateControlPlaneAccess)
        * How-to Guides
            * [Enable ControlPlane access](https://cloud.google.com/apigee/docs/hybrid/v1.14/install-enable-control-plane-access)

        ## Example Usage

        ### Apigee Control Plane Access Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project.project_id,
            runtime_type="HYBRID",
            opts = pulumi.ResourceOptions(depends_on=[apigee]))
        service_account = gcp.serviceaccount.Account("service_account",
            account_id="my-account",
            display_name="Service Account")
        synchronizer_iam = gcp.projects.IAMMember("synchronizer-iam",
            project=project.project_id,
            role="roles/apigee.synchronizerManager",
            member=service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        apigee_control_plane_access = gcp.apigee.ControlPlaneAccess("apigee_control_plane_access",
            name=apigee_org.name,
            synchronizer_identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")],
            analytics_publisher_identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")])
        ```

        ## Import

        ControlPlaneAccess can be imported using any of these accepted formats:

        * `organizations/{{name}}/controlPlaneAccess`

        * `{{name}}`

        When using the `pulumi import` command, ControlPlaneAccess can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/controlPlaneAccess:ControlPlaneAccess default organizations/{{name}}/controlPlaneAccess
        ```

        ```sh
        $ pulumi import gcp:apigee/controlPlaneAccess:ControlPlaneAccess default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ControlPlaneAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlPlaneAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_publisher_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronizer_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlPlaneAccessArgs.__new__(ControlPlaneAccessArgs)

            __props__.__dict__["analytics_publisher_identities"] = analytics_publisher_identities
            __props__.__dict__["name"] = name
            __props__.__dict__["synchronizer_identities"] = synchronizer_identities
        super(ControlPlaneAccess, __self__).__init__(
            'gcp:apigee/controlPlaneAccess:ControlPlaneAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analytics_publisher_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            synchronizer_identities: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ControlPlaneAccess':
        """
        Get an existing ControlPlaneAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] analytics_publisher_identities: Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        :param pulumi.Input[_builtins.str] name: Name of the Apigee organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] synchronizer_identities: Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlPlaneAccessState.__new__(_ControlPlaneAccessState)

        __props__.__dict__["analytics_publisher_identities"] = analytics_publisher_identities
        __props__.__dict__["name"] = name
        __props__.__dict__["synchronizer_identities"] = synchronizer_identities
        return ControlPlaneAccess(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="analyticsPublisherIdentities")
    def analytics_publisher_identities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of service accounts authorized to publish analytics data to the control plane, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        """
        return pulumi.get(self, "analytics_publisher_identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="synchronizerIdentities")
    def synchronizer_identities(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of service accounts to grant access to control plane resources (for the Synchronizer component), each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "synchronizer_identities")

