# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApiHubInstanceConfig',
    'CurationEndpoint',
    'CurationEndpointApplicationIntegrationEndpointDetails',
    'CurationPluginInstanceAction',
    'PluginActionsConfig',
    'PluginConfigTemplate',
    'PluginConfigTemplateAdditionalConfigTemplate',
    'PluginConfigTemplateAdditionalConfigTemplateEnumOption',
    'PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption',
    'PluginConfigTemplateAuthConfigTemplate',
    'PluginConfigTemplateAuthConfigTemplateServiceAccount',
    'PluginDocumentation',
    'PluginHostingService',
    'PluginInstanceAction',
    'PluginInstanceActionCurationConfig',
    'PluginInstanceActionCurationConfigCustomCuration',
    'PluginInstanceActionHubInstanceAction',
    'PluginInstanceActionHubInstanceActionLastExecution',
    'PluginInstanceAuthConfig',
    'PluginInstanceAuthConfigApiKeyConfig',
    'PluginInstanceAuthConfigApiKeyConfigApiKey',
    'PluginInstanceAuthConfigGoogleServiceAccountConfig',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfig',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret',
    'PluginInstanceAuthConfigUserPasswordConfig',
    'PluginInstanceAuthConfigUserPasswordConfigPassword',
]

@pulumi.output_type
class ApiHubInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmekKeyName":
            suggest = "cmek_key_name"
        elif key == "disableSearch":
            suggest = "disable_search"
        elif key == "encryptionType":
            suggest = "encryption_type"
        elif key == "vertexLocation":
            suggest = "vertex_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHubInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHubInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHubInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmek_key_name: Optional[_builtins.str] = None,
                 disable_search: Optional[_builtins.bool] = None,
                 encryption_type: Optional[_builtins.str] = None,
                 vertex_location: Optional[_builtins.str] = None):
        """
        :param _builtins.str cmek_key_name: Optional. The Customer Managed Encryption Key (CMEK) used for data encryption.
               The CMEK name should follow the format of
               `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
               where the location must match the instance location.
               If the CMEK is not provided, a GMEK will be created for the instance.
        :param _builtins.bool disable_search: Optional. If true, the search will be disabled for the instance. The default value
               is false.
        :param _builtins.str encryption_type: Optional. Encryption type for the region. If the encryption type is CMEK, the
               cmek_key_name must be provided. If no encryption type is provided,
               GMEK will be used.
               Possible values:
               ENCRYPTION_TYPE_UNSPECIFIED
               GMEK
               CMEK
        :param _builtins.str vertex_location: Optional. The name of the Vertex AI location where the data store is stored.
        """
        if cmek_key_name is not None:
            pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        if disable_search is not None:
            pulumi.set(__self__, "disable_search", disable_search)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if vertex_location is not None:
            pulumi.set(__self__, "vertex_location", vertex_location)

    @_builtins.property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> Optional[_builtins.str]:
        """
        Optional. The Customer Managed Encryption Key (CMEK) used for data encryption.
        The CMEK name should follow the format of
        `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
        where the location must match the instance location.
        If the CMEK is not provided, a GMEK will be created for the instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @_builtins.property
    @pulumi.getter(name="disableSearch")
    def disable_search(self) -> Optional[_builtins.bool]:
        """
        Optional. If true, the search will be disabled for the instance. The default value
        is false.
        """
        return pulumi.get(self, "disable_search")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[_builtins.str]:
        """
        Optional. Encryption type for the region. If the encryption type is CMEK, the
        cmek_key_name must be provided. If no encryption type is provided,
        GMEK will be used.
        Possible values:
        ENCRYPTION_TYPE_UNSPECIFIED
        GMEK
        CMEK
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="vertexLocation")
    def vertex_location(self) -> Optional[_builtins.str]:
        """
        Optional. The name of the Vertex AI location where the data store is stored.
        """
        return pulumi.get(self, "vertex_location")


@pulumi.output_type
class CurationEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationIntegrationEndpointDetails":
            suggest = "application_integration_endpoint_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CurationEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CurationEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CurationEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_integration_endpoint_details: 'outputs.CurationEndpointApplicationIntegrationEndpointDetails'):
        """
        :param 'CurationEndpointApplicationIntegrationEndpointDetailsArgs' application_integration_endpoint_details: The details of the Application Integration endpoint to be triggered for
               curation.
               Structure is documented below.
        """
        pulumi.set(__self__, "application_integration_endpoint_details", application_integration_endpoint_details)

    @_builtins.property
    @pulumi.getter(name="applicationIntegrationEndpointDetails")
    def application_integration_endpoint_details(self) -> 'outputs.CurationEndpointApplicationIntegrationEndpointDetails':
        """
        The details of the Application Integration endpoint to be triggered for
        curation.
        Structure is documented below.
        """
        return pulumi.get(self, "application_integration_endpoint_details")


@pulumi.output_type
class CurationEndpointApplicationIntegrationEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerId":
            suggest = "trigger_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CurationEndpointApplicationIntegrationEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CurationEndpointApplicationIntegrationEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CurationEndpointApplicationIntegrationEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trigger_id: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str trigger_id: The API trigger ID of the Application Integration workflow.
        :param _builtins.str uri: The endpoint URI should be a valid REST URI for triggering an Application
               Integration.
               Format:
               `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
               or
               `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        """
        pulumi.set(__self__, "trigger_id", trigger_id)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> _builtins.str:
        """
        The API trigger ID of the Application Integration workflow.
        """
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The endpoint URI should be a valid REST URI for triggering an Application
        Integration.
        Format:
        `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        or
        `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class CurationPluginInstanceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionId":
            suggest = "action_id"
        elif key == "pluginInstance":
            suggest = "plugin_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CurationPluginInstanceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CurationPluginInstanceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CurationPluginInstanceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_id: Optional[_builtins.str] = None,
                 plugin_instance: Optional[_builtins.str] = None):
        """
        :param _builtins.str action_id: (Output)
               The action ID that is using the curation.
               This should map to one of the action IDs specified
               in action configs in the plugin.
        :param _builtins.str plugin_instance: (Output)
               Plugin instance that is using the curation.
               Format is
               `projects/{project}/locations/{locati on}/plugins/{plugin}/instances/{instance}`
        """
        if action_id is not None:
            pulumi.set(__self__, "action_id", action_id)
        if plugin_instance is not None:
            pulumi.set(__self__, "plugin_instance", plugin_instance)

    @_builtins.property
    @pulumi.getter(name="actionId")
    def action_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        The action ID that is using the curation.
        This should map to one of the action IDs specified
        in action configs in the plugin.
        """
        return pulumi.get(self, "action_id")

    @_builtins.property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> Optional[_builtins.str]:
        """
        (Output)
        Plugin instance that is using the curation.
        Format is
        `projects/{project}/locations/{locati on}/plugins/{plugin}/instances/{instance}`
        """
        return pulumi.get(self, "plugin_instance")


@pulumi.output_type
class PluginActionsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "triggerMode":
            suggest = "trigger_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginActionsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginActionsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginActionsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 trigger_mode: _builtins.str):
        """
        :param _builtins.str description: The description of the operation performed by the action.
        :param _builtins.str display_name: The display name of the action.
        :param _builtins.str id: The id of the action.
        :param _builtins.str trigger_mode: The trigger mode supported by the action.
               Possible values:
               TRIGGER_MODE_UNSPECIFIED
               API_HUB_ON_DEMAND_TRIGGER
               API_HUB_SCHEDULE_TRIGGER
               NON_API_HUB_MANAGED
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "trigger_mode", trigger_mode)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the operation performed by the action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the action.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the action.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="triggerMode")
    def trigger_mode(self) -> _builtins.str:
        """
        The trigger mode supported by the action.
        Possible values:
        TRIGGER_MODE_UNSPECIFIED
        API_HUB_ON_DEMAND_TRIGGER
        API_HUB_SCHEDULE_TRIGGER
        NON_API_HUB_MANAGED
        """
        return pulumi.get(self, "trigger_mode")


@pulumi.output_type
class PluginConfigTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalConfigTemplates":
            suggest = "additional_config_templates"
        elif key == "authConfigTemplate":
            suggest = "auth_config_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_config_templates: Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplate']] = None,
                 auth_config_template: Optional['outputs.PluginConfigTemplateAuthConfigTemplate'] = None):
        """
        :param Sequence['PluginConfigTemplateAdditionalConfigTemplateArgs'] additional_config_templates: The list of additional configuration variables for the plugin's
               configuration.
               Structure is documented below.
        :param 'PluginConfigTemplateAuthConfigTemplateArgs' auth_config_template: AuthConfigTemplate represents the authentication template for a plugin.
               Structure is documented below.
        """
        if additional_config_templates is not None:
            pulumi.set(__self__, "additional_config_templates", additional_config_templates)
        if auth_config_template is not None:
            pulumi.set(__self__, "auth_config_template", auth_config_template)

    @_builtins.property
    @pulumi.getter(name="additionalConfigTemplates")
    def additional_config_templates(self) -> Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplate']]:
        """
        The list of additional configuration variables for the plugin's
        configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_config_templates")

    @_builtins.property
    @pulumi.getter(name="authConfigTemplate")
    def auth_config_template(self) -> Optional['outputs.PluginConfigTemplateAuthConfigTemplate']:
        """
        AuthConfigTemplate represents the authentication template for a plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config_template")


@pulumi.output_type
class PluginConfigTemplateAdditionalConfigTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"
        elif key == "enumOptions":
            suggest = "enum_options"
        elif key == "multiSelectOptions":
            suggest = "multi_select_options"
        elif key == "validationRegex":
            suggest = "validation_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplateAdditionalConfigTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplateAdditionalConfigTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplateAdditionalConfigTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 value_type: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 enum_options: Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplateEnumOption']] = None,
                 multi_select_options: Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption']] = None,
                 required: Optional[_builtins.bool] = None,
                 validation_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the config variable. Must be unique within the configuration.
        :param _builtins.str value_type: Type of the parameter: string, int, bool etc.
               Possible values:
               VALUE_TYPE_UNSPECIFIED
               STRING
               INT
               BOOL
               SECRET
               ENUM
               MULTI_SELECT
               MULTI_STRING
               MULTI_INT
        :param _builtins.str description: Description.
        :param Sequence['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs'] enum_options: Enum options. To be populated if `ValueType` is `ENUM`.
               Structure is documented below.
        :param Sequence['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs'] multi_select_options: Multi select options. To be populated if `ValueType` is `MULTI_SELECT`.
               Structure is documented below.
        :param _builtins.bool required: Flag represents that this `ConfigVariable` must be provided for a
               PluginInstance.
        :param _builtins.str validation_regex: Regular expression in RE2 syntax used for validating the `value` of a
               `ConfigVariable`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "value_type", value_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_options is not None:
            pulumi.set(__self__, "enum_options", enum_options)
        if multi_select_options is not None:
            pulumi.set(__self__, "multi_select_options", multi_select_options)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if validation_regex is not None:
            pulumi.set(__self__, "validation_regex", validation_regex)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the config variable. Must be unique within the configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        Type of the parameter: string, int, bool etc.
        Possible values:
        VALUE_TYPE_UNSPECIFIED
        STRING
        INT
        BOOL
        SECRET
        ENUM
        MULTI_SELECT
        MULTI_STRING
        MULTI_INT
        """
        return pulumi.get(self, "value_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enumOptions")
    def enum_options(self) -> Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplateEnumOption']]:
        """
        Enum options. To be populated if `ValueType` is `ENUM`.
        Structure is documented below.
        """
        return pulumi.get(self, "enum_options")

    @_builtins.property
    @pulumi.getter(name="multiSelectOptions")
    def multi_select_options(self) -> Optional[Sequence['outputs.PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption']]:
        """
        Multi select options. To be populated if `ValueType` is `MULTI_SELECT`.
        Structure is documented below.
        """
        return pulumi.get(self, "multi_select_options")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[_builtins.bool]:
        """
        Flag represents that this `ConfigVariable` must be provided for a
        PluginInstance.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter(name="validationRegex")
    def validation_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression in RE2 syntax used for validating the `value` of a
        `ConfigVariable`.
        """
        return pulumi.get(self, "validation_regex")


@pulumi.output_type
class PluginConfigTemplateAdditionalConfigTemplateEnumOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplateAdditionalConfigTemplateEnumOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplateAdditionalConfigTemplateEnumOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplateAdditionalConfigTemplateEnumOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Display name of the option.
        :param _builtins.str id: Id of the option.
        :param _builtins.str description: Description of the option.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the option.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Id of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the option.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplateAdditionalConfigTemplateMultiSelectOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Display name of the option.
        :param _builtins.str id: Id of the option.
        :param _builtins.str description: Description of the option.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the option.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Id of the option.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the option.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PluginConfigTemplateAuthConfigTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportedAuthTypes":
            suggest = "supported_auth_types"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplateAuthConfigTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplateAuthConfigTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplateAuthConfigTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 supported_auth_types: Sequence[_builtins.str],
                 service_account: Optional['outputs.PluginConfigTemplateAuthConfigTemplateServiceAccount'] = None):
        """
        :param Sequence[_builtins.str] supported_auth_types: The list of authentication types supported by the plugin.
        :param 'PluginConfigTemplateAuthConfigTemplateServiceAccountArgs' service_account: Config for Google service account authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "supported_auth_types", supported_auth_types)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="supportedAuthTypes")
    def supported_auth_types(self) -> Sequence[_builtins.str]:
        """
        The list of authentication types supported by the plugin.
        """
        return pulumi.get(self, "supported_auth_types")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional['outputs.PluginConfigTemplateAuthConfigTemplateServiceAccount']:
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class PluginConfigTemplateAuthConfigTemplateServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginConfigTemplateAuthConfigTemplateServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginConfigTemplateAuthConfigTemplateServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginConfigTemplateAuthConfigTemplateServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: _builtins.str):
        """
        :param _builtins.str service_account: The service account to be used for authenticating request.
               The `iam.serviceAccounts.getAccessToken` permission should be granted on
               this service account to the impersonator service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class PluginDocumentation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalUri":
            suggest = "external_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginDocumentation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginDocumentation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginDocumentation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str external_uri: The uri of the externally hosted documentation.
        """
        if external_uri is not None:
            pulumi.set(__self__, "external_uri", external_uri)

    @_builtins.property
    @pulumi.getter(name="externalUri")
    def external_uri(self) -> Optional[_builtins.str]:
        """
        The uri of the externally hosted documentation.
        """
        return pulumi.get(self, "external_uri")


@pulumi.output_type
class PluginHostingService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginHostingService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginHostingService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginHostingService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str service_uri: The URI of the service implemented by the plugin developer, used to
               invoke the plugin's functionality. This information is only required for
               user defined plugins.
        """
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @_builtins.property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[_builtins.str]:
        """
        The URI of the service implemented by the plugin developer, used to
        invoke the plugin's functionality. This information is only required for
        user defined plugins.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class PluginInstanceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionId":
            suggest = "action_id"
        elif key == "curationConfig":
            suggest = "curation_config"
        elif key == "hubInstanceActions":
            suggest = "hub_instance_actions"
        elif key == "scheduleCronExpression":
            suggest = "schedule_cron_expression"
        elif key == "scheduleTimeZone":
            suggest = "schedule_time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_id: _builtins.str,
                 curation_config: Optional['outputs.PluginInstanceActionCurationConfig'] = None,
                 hub_instance_actions: Optional[Sequence['outputs.PluginInstanceActionHubInstanceAction']] = None,
                 schedule_cron_expression: Optional[_builtins.str] = None,
                 schedule_time_zone: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str action_id: This should map to one of the action id specified
               in actions_config in the plugin.
        :param 'PluginInstanceActionCurationConfigArgs' curation_config: The curation information for this plugin instance.
               Structure is documented below.
        :param Sequence['PluginInstanceActionHubInstanceActionArgs'] hub_instance_actions: (Output)
               The execution status for the plugin instance.
               Structure is documented below.
        :param _builtins.str schedule_cron_expression: The schedule for this plugin instance action. This can only be set if the
               plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        :param _builtins.str schedule_time_zone: The time zone for the schedule cron expression. If not provided, UTC will
               be used.
               
               
               <a name="nested_actions_actions_hub_instance_action"></a>The `hub_instance_action` block contains:
        :param _builtins.str state: (Output)
               The current state of the plugin action in the plugin instance.
               Possible values:
               STATE_UNSPECIFIED
               ENABLED
               DISABLED
               ENABLING
               DISABLING
               ERROR
        """
        pulumi.set(__self__, "action_id", action_id)
        if curation_config is not None:
            pulumi.set(__self__, "curation_config", curation_config)
        if hub_instance_actions is not None:
            pulumi.set(__self__, "hub_instance_actions", hub_instance_actions)
        if schedule_cron_expression is not None:
            pulumi.set(__self__, "schedule_cron_expression", schedule_cron_expression)
        if schedule_time_zone is not None:
            pulumi.set(__self__, "schedule_time_zone", schedule_time_zone)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="actionId")
    def action_id(self) -> _builtins.str:
        """
        This should map to one of the action id specified
        in actions_config in the plugin.
        """
        return pulumi.get(self, "action_id")

    @_builtins.property
    @pulumi.getter(name="curationConfig")
    def curation_config(self) -> Optional['outputs.PluginInstanceActionCurationConfig']:
        """
        The curation information for this plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "curation_config")

    @_builtins.property
    @pulumi.getter(name="hubInstanceActions")
    def hub_instance_actions(self) -> Optional[Sequence['outputs.PluginInstanceActionHubInstanceAction']]:
        """
        (Output)
        The execution status for the plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "hub_instance_actions")

    @_builtins.property
    @pulumi.getter(name="scheduleCronExpression")
    def schedule_cron_expression(self) -> Optional[_builtins.str]:
        """
        The schedule for this plugin instance action. This can only be set if the
        plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        """
        return pulumi.get(self, "schedule_cron_expression")

    @_builtins.property
    @pulumi.getter(name="scheduleTimeZone")
    def schedule_time_zone(self) -> Optional[_builtins.str]:
        """
        The time zone for the schedule cron expression. If not provided, UTC will
        be used.


        <a name="nested_actions_actions_hub_instance_action"></a>The `hub_instance_action` block contains:
        """
        return pulumi.get(self, "schedule_time_zone")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        The current state of the plugin action in the plugin instance.
        Possible values:
        STATE_UNSPECIFIED
        ENABLED
        DISABLED
        ENABLING
        DISABLING
        ERROR
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PluginInstanceActionCurationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "curationType":
            suggest = "curation_type"
        elif key == "customCuration":
            suggest = "custom_curation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceActionCurationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceActionCurationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceActionCurationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 curation_type: Optional[_builtins.str] = None,
                 custom_curation: Optional['outputs.PluginInstanceActionCurationConfigCustomCuration'] = None):
        """
        :param _builtins.str curation_type: Possible values:
               CURATION_TYPE_UNSPECIFIED
               DEFAULT_CURATION_FOR_API_METADATA
               CUSTOM_CURATION_FOR_API_METADATA
        :param 'PluginInstanceActionCurationConfigCustomCurationArgs' custom_curation: Custom curation information for this plugin instance.
               Structure is documented below.
        """
        if curation_type is not None:
            pulumi.set(__self__, "curation_type", curation_type)
        if custom_curation is not None:
            pulumi.set(__self__, "custom_curation", custom_curation)

    @_builtins.property
    @pulumi.getter(name="curationType")
    def curation_type(self) -> Optional[_builtins.str]:
        """
        Possible values:
        CURATION_TYPE_UNSPECIFIED
        DEFAULT_CURATION_FOR_API_METADATA
        CUSTOM_CURATION_FOR_API_METADATA
        """
        return pulumi.get(self, "curation_type")

    @_builtins.property
    @pulumi.getter(name="customCuration")
    def custom_curation(self) -> Optional['outputs.PluginInstanceActionCurationConfigCustomCuration']:
        """
        Custom curation information for this plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_curation")


@pulumi.output_type
class PluginInstanceActionCurationConfigCustomCuration(dict):
    def __init__(__self__, *,
                 curation: _builtins.str):
        """
        :param _builtins.str curation: The unique name of the curation resource. This will be the name of the
               curation resource in the format:
               `projects/{project}/locations/{location}/curations/{curation}`
        """
        pulumi.set(__self__, "curation", curation)

    @_builtins.property
    @pulumi.getter
    def curation(self) -> _builtins.str:
        """
        The unique name of the curation resource. This will be the name of the
        curation resource in the format:
        `projects/{project}/locations/{location}/curations/{curation}`
        """
        return pulumi.get(self, "curation")


@pulumi.output_type
class PluginInstanceActionHubInstanceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentExecutionState":
            suggest = "current_execution_state"
        elif key == "lastExecutions":
            suggest = "last_executions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceActionHubInstanceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceActionHubInstanceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceActionHubInstanceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_execution_state: Optional[_builtins.str] = None,
                 last_executions: Optional[Sequence['outputs.PluginInstanceActionHubInstanceActionLastExecution']] = None):
        """
        :param _builtins.str current_execution_state: The current state of the execution.
               Possible values:
               CURRENT_EXECUTION_STATE_UNSPECIFIED
               RUNNING
               NOT_RUNNING
        :param Sequence['PluginInstanceActionHubInstanceActionLastExecutionArgs'] last_executions: The result of the last execution of the plugin instance.
        """
        if current_execution_state is not None:
            pulumi.set(__self__, "current_execution_state", current_execution_state)
        if last_executions is not None:
            pulumi.set(__self__, "last_executions", last_executions)

    @_builtins.property
    @pulumi.getter(name="currentExecutionState")
    def current_execution_state(self) -> Optional[_builtins.str]:
        """
        The current state of the execution.
        Possible values:
        CURRENT_EXECUTION_STATE_UNSPECIFIED
        RUNNING
        NOT_RUNNING
        """
        return pulumi.get(self, "current_execution_state")

    @_builtins.property
    @pulumi.getter(name="lastExecutions")
    def last_executions(self) -> Optional[Sequence['outputs.PluginInstanceActionHubInstanceActionLastExecution']]:
        """
        The result of the last execution of the plugin instance.
        """
        return pulumi.get(self, "last_executions")


@pulumi.output_type
class PluginInstanceActionHubInstanceActionLastExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceActionHubInstanceActionLastExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceActionHubInstanceActionLastExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceActionHubInstanceActionLastExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 error_message: Optional[_builtins.str] = None,
                 result: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: The last execution end time of the plugin instance.
        :param _builtins.str error_message: Error message describing the failure, if any, during Create, Delete or
               ApplyConfig operation corresponding to the plugin instance.This field will
               only be populated if the plugin instance is in the ERROR or FAILED state.
        :param _builtins.str result: The result of the last execution of the plugin instance.
               Possible values:
               RESULT_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param _builtins.str start_time: The last execution start time of the plugin instance.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        The last execution end time of the plugin instance.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[_builtins.str]:
        """
        Error message describing the failure, if any, during Create, Delete or
        ApplyConfig operation corresponding to the plugin instance.This field will
        only be populated if the plugin instance is in the ERROR or FAILED state.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def result(self) -> Optional[_builtins.str]:
        """
        The result of the last execution of the plugin instance.
        Possible values:
        RESULT_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        The last execution start time of the plugin instance.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class PluginInstanceAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "apiKeyConfig":
            suggest = "api_key_config"
        elif key == "googleServiceAccountConfig":
            suggest = "google_service_account_config"
        elif key == "oauth2ClientCredentialsConfig":
            suggest = "oauth2_client_credentials_config"
        elif key == "userPasswordConfig":
            suggest = "user_password_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 api_key_config: Optional['outputs.PluginInstanceAuthConfigApiKeyConfig'] = None,
                 google_service_account_config: Optional['outputs.PluginInstanceAuthConfigGoogleServiceAccountConfig'] = None,
                 oauth2_client_credentials_config: Optional['outputs.PluginInstanceAuthConfigOauth2ClientCredentialsConfig'] = None,
                 user_password_config: Optional['outputs.PluginInstanceAuthConfigUserPasswordConfig'] = None):
        """
        :param _builtins.str auth_type: Possible values:
               AUTH_TYPE_UNSPECIFIED
               NO_AUTH
               GOOGLE_SERVICE_ACCOUNT
               USER_PASSWORD
               API_KEY
               OAUTH2_CLIENT_CREDENTIALS
        :param 'PluginInstanceAuthConfigApiKeyConfigArgs' api_key_config: Config for authentication with API key.
               Structure is documented below.
        :param 'PluginInstanceAuthConfigGoogleServiceAccountConfigArgs' google_service_account_config: Config for Google service account authentication.
               Structure is documented below.
        :param 'PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs' oauth2_client_credentials_config: Parameters to support Oauth 2.0 client credentials grant authentication.
               See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
               Structure is documented below.
        :param 'PluginInstanceAuthConfigUserPasswordConfigArgs' user_password_config: Parameters to support Username and Password Authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if api_key_config is not None:
            pulumi.set(__self__, "api_key_config", api_key_config)
        if google_service_account_config is not None:
            pulumi.set(__self__, "google_service_account_config", google_service_account_config)
        if oauth2_client_credentials_config is not None:
            pulumi.set(__self__, "oauth2_client_credentials_config", oauth2_client_credentials_config)
        if user_password_config is not None:
            pulumi.set(__self__, "user_password_config", user_password_config)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Possible values:
        AUTH_TYPE_UNSPECIFIED
        NO_AUTH
        GOOGLE_SERVICE_ACCOUNT
        USER_PASSWORD
        API_KEY
        OAUTH2_CLIENT_CREDENTIALS
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="apiKeyConfig")
    def api_key_config(self) -> Optional['outputs.PluginInstanceAuthConfigApiKeyConfig']:
        """
        Config for authentication with API key.
        Structure is documented below.
        """
        return pulumi.get(self, "api_key_config")

    @_builtins.property
    @pulumi.getter(name="googleServiceAccountConfig")
    def google_service_account_config(self) -> Optional['outputs.PluginInstanceAuthConfigGoogleServiceAccountConfig']:
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "google_service_account_config")

    @_builtins.property
    @pulumi.getter(name="oauth2ClientCredentialsConfig")
    def oauth2_client_credentials_config(self) -> Optional['outputs.PluginInstanceAuthConfigOauth2ClientCredentialsConfig']:
        """
        Parameters to support Oauth 2.0 client credentials grant authentication.
        See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_client_credentials_config")

    @_builtins.property
    @pulumi.getter(name="userPasswordConfig")
    def user_password_config(self) -> Optional['outputs.PluginInstanceAuthConfigUserPasswordConfig']:
        """
        Parameters to support Username and Password Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "user_password_config")


@pulumi.output_type
class PluginInstanceAuthConfigApiKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "httpElementLocation":
            suggest = "http_element_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigApiKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigApiKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigApiKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: 'outputs.PluginInstanceAuthConfigApiKeyConfigApiKey',
                 http_element_location: _builtins.str,
                 name: _builtins.str):
        """
        :param 'PluginInstanceAuthConfigApiKeyConfigApiKeyArgs' api_key: Secret provides a reference to entries in Secret Manager.
               Structure is documented below.
        :param _builtins.str http_element_location: The location of the API key.
               The default value is QUERY.
               Possible values:
               HTTP_ELEMENT_LOCATION_UNSPECIFIED
               QUERY
               HEADER
               PATH
               BODY
               COOKIE
        :param _builtins.str name: The parameter name of the API key.
               E.g. If the API request is "https://example.com/act?api_key=",
               "api_key" would be the parameter name.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "http_element_location", http_element_location)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> 'outputs.PluginInstanceAuthConfigApiKeyConfigApiKey':
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="httpElementLocation")
    def http_element_location(self) -> _builtins.str:
        """
        The location of the API key.
        The default value is QUERY.
        Possible values:
        HTTP_ELEMENT_LOCATION_UNSPECIFIED
        QUERY
        HEADER
        PATH
        BODY
        COOKIE
        """
        return pulumi.get(self, "http_element_location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The parameter name of the API key.
        E.g. If the API request is "https://example.com/act?api_key=",
        "api_key" would be the parameter name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PluginInstanceAuthConfigApiKeyConfigApiKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigApiKeyConfigApiKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigApiKeyConfigApiKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigApiKeyConfigApiKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
               
               <a name="nested_auth_config_oauth2_client_credentials_config"></a>The `oauth2_client_credentials_config` block supports:
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.

        <a name="nested_auth_config_oauth2_client_credentials_config"></a>The `oauth2_client_credentials_config` block supports:
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class PluginInstanceAuthConfigGoogleServiceAccountConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigGoogleServiceAccountConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigGoogleServiceAccountConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigGoogleServiceAccountConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: _builtins.str):
        """
        :param _builtins.str service_account: The service account to be used for authenticating request.
               The `iam.serviceAccounts.getAccessToken` permission should be granted on
               this service account to the impersonator service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class PluginInstanceAuthConfigOauth2ClientCredentialsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigOauth2ClientCredentialsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigOauth2ClientCredentialsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigOauth2ClientCredentialsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret: 'outputs.PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret'):
        """
        :param _builtins.str client_id: The client identifier.
        :param 'PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs' client_secret: Secret provides a reference to entries in Secret Manager.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client identifier.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> 'outputs.PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret':
        """
        Secret provides a reference to entries in Secret Manager.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class PluginInstanceAuthConfigUserPasswordConfig(dict):
    def __init__(__self__, *,
                 password: 'outputs.PluginInstanceAuthConfigUserPasswordConfigPassword',
                 username: _builtins.str):
        """
        :param 'PluginInstanceAuthConfigUserPasswordConfigPasswordArgs' password: Secret provides a reference to entries in Secret Manager.
               Structure is documented below.
        :param _builtins.str username: Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> 'outputs.PluginInstanceAuthConfigUserPasswordConfigPassword':
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PluginInstanceAuthConfigUserPasswordConfigPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PluginInstanceAuthConfigUserPasswordConfigPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PluginInstanceAuthConfigUserPasswordConfigPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PluginInstanceAuthConfigUserPasswordConfigPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "secret_version")


