# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPackageResult',
    'AwaitableGetPackageResult',
    'get_package',
    'get_package_output',
]

@pulumi.output_type
class GetPackageResult:
    """
    A collection of values returned by getPackage.
    """
    def __init__(__self__, annotations=None, create_time=None, display_name=None, id=None, location=None, name=None, project=None, repository_id=None, update_time=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Client specified annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the package.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was last updated. This includes publishing a new version of the package.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetPackageResult(GetPackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPackageResult(
            annotations=self.annotations,
            create_time=self.create_time,
            display_name=self.display_name,
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project,
            repository_id=self.repository_id,
            update_time=self.update_time)


def get_package(location: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                project: Optional[_builtins.str] = None,
                repository_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPackageResult:
    """
    This data source fetches information of a package from a provided Artifact Registry repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_google as google

    my_package = google.index.ArtifactRegistryPackage("my_package",
        location=us-west1,
        repository_id=my-repository)
    ```


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getPackage:getPackage', __args__, opts=opts, typ=GetPackageResult).value

    return AwaitableGetPackageResult(
        annotations=pulumi.get(__ret__, 'annotations'),
        create_time=pulumi.get(__ret__, 'create_time'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_package_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPackageResult]:
    """
    This data source fetches information of a package from a provided Artifact Registry repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_google as google

    my_package = google.index.ArtifactRegistryPackage("my_package",
        location=us-west1,
        repository_id=my-repository)
    ```


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getPackage:getPackage', __args__, opts=opts, typ=GetPackageResult)
    return __ret__.apply(lambda __response__: GetPackageResult(
        annotations=pulumi.get(__response__, 'annotations'),
        create_time=pulumi.get(__response__, 'create_time'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        update_time=pulumi.get(__response__, 'update_time')))
