# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTagResult',
    'AwaitableGetTagResult',
    'get_tag',
    'get_tag_output',
]

@pulumi.output_type
class GetTagResult:
    """
    A collection of values returned by getTag.
    """
    def __init__(__self__, id=None, location=None, name=None, package_name=None, project=None, repository_id=None, tag_name=None, version=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if tag_name and not isinstance(tag_name, str):
            raise TypeError("Expected argument 'tag_name' to be a str")
        pulumi.set(__self__, "tag_name", tag_name)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1`. If the package part contains slashes, the slashes are escaped.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> _builtins.str:
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the tag.
        """
        return pulumi.get(self, "version")


class AwaitableGetTagResult(GetTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagResult(
            id=self.id,
            location=self.location,
            name=self.name,
            package_name=self.package_name,
            project=self.project,
            repository_id=self.repository_id,
            tag_name=self.tag_name,
            version=self.version)


def get_tag(location: Optional[_builtins.str] = None,
            package_name: Optional[_builtins.str] = None,
            project: Optional[_builtins.str] = None,
            repository_id: Optional[_builtins.str] = None,
            tag_name: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagResult:
    """
    This data source fetches information of a tag from a provided Artifact Registry repository.


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    :param _builtins.str tag_name: The name of the tag.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['tagName'] = tag_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getTag:getTag', __args__, opts=opts, typ=GetTagResult).value

    return AwaitableGetTagResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        package_name=pulumi.get(__ret__, 'package_name'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        tag_name=pulumi.get(__ret__, 'tag_name'),
        version=pulumi.get(__ret__, 'version'))
def get_tag_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                   package_name: Optional[pulumi.Input[_builtins.str]] = None,
                   project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                   tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagResult]:
    """
    This data source fetches information of a tag from a provided Artifact Registry repository.


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    :param _builtins.str tag_name: The name of the tag.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['tagName'] = tag_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getTag:getTag', __args__, opts=opts, typ=GetTagResult)
    return __ret__.apply(lambda __response__: GetTagResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        package_name=pulumi.get(__response__, 'package_name'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        tag_name=pulumi.get(__response__, 'tag_name'),
        version=pulumi.get(__response__, 'version')))
