# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTagsResult',
    'AwaitableGetTagsResult',
    'get_tags',
    'get_tags_output',
]

@pulumi.output_type
class GetTagsResult:
    """
    A collection of values returned by getTags.
    """
    def __init__(__self__, filter=None, id=None, location=None, package_name=None, project=None, repository_id=None, tags=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetTagsTagResult']:
        """
        A list of all retrieved Artifact Registry tags. Structure is defined below.
        """
        return pulumi.get(self, "tags")


class AwaitableGetTagsResult(GetTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagsResult(
            filter=self.filter,
            id=self.id,
            location=self.location,
            package_name=self.package_name,
            project=self.project,
            repository_id=self.repository_id,
            tags=self.tags)


def get_tags(filter: Optional[_builtins.str] = None,
             location: Optional[_builtins.str] = None,
             package_name: Optional[_builtins.str] = None,
             project: Optional[_builtins.str] = None,
             repository_id: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagsResult:
    """
    Get information about Artifact Registry tags.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/overview)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages.tags/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_tags = gcp.artifactregistry.get_tags(location="us-central1",
        repository_id="example-repo",
        package_name="example-package")
    ```


    :param _builtins.str filter: An expression for filtering the results of the request. Filter rules are case insensitive. The fields eligible for filtering are `name` and `version`. Further information can be found in the [REST API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages.tags/list#query-parameters).
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getTags:getTags', __args__, opts=opts, typ=GetTagsResult).value

    return AwaitableGetTagsResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        package_name=pulumi.get(__ret__, 'package_name'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_tags_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    location: Optional[pulumi.Input[_builtins.str]] = None,
                    package_name: Optional[pulumi.Input[_builtins.str]] = None,
                    project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagsResult]:
    """
    Get information about Artifact Registry tags.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/overview)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages.tags/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_tags = gcp.artifactregistry.get_tags(location="us-central1",
        repository_id="example-repo",
        package_name="example-package")
    ```


    :param _builtins.str filter: An expression for filtering the results of the request. Filter rules are case insensitive. The fields eligible for filtering are `name` and `version`. Further information can be found in the [REST API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages.tags/list#query-parameters).
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getTags:getTags', __args__, opts=opts, typ=GetTagsResult)
    return __ret__.apply(lambda __response__: GetTagsResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        package_name=pulumi.get(__response__, 'package_name'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        tags=pulumi.get(__response__, 'tags')))
