# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupPlanAssociationArgs', 'BackupPlanAssociation']

@pulumi.input_type
class BackupPlanAssociationArgs:
    def __init__(__self__, *,
                 backup_plan: pulumi.Input[_builtins.str],
                 backup_plan_association_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 resource: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupPlanAssociation resource.
        :param pulumi.Input[_builtins.str] backup_plan: The BP with which resource needs to be created
               Note:
               - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
               - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        :param pulumi.Input[_builtins.str] backup_plan_association_id: The id of backupplan association
        :param pulumi.Input[_builtins.str] location: The location for the backupplan association
        :param pulumi.Input[_builtins.str] resource: The resource for which BPA needs to be created
        :param pulumi.Input[_builtins.str] resource_type: The resource type of workload on which backupplan is applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_plan", backup_plan)
        pulumi.set(__self__, "backup_plan_association_id", backup_plan_association_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "resource_type", resource_type)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> pulumi.Input[_builtins.str]:
        """
        The BP with which resource needs to be created
        Note:
        - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
        - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        """
        return pulumi.get(self, "backup_plan")

    @backup_plan.setter
    def backup_plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_plan", value)

    @_builtins.property
    @pulumi.getter(name="backupPlanAssociationId")
    def backup_plan_association_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of backupplan association
        """
        return pulumi.get(self, "backup_plan_association_id")

    @backup_plan_association_id.setter
    def backup_plan_association_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_plan_association_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the backupplan association
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Input[_builtins.str]:
        """
        The resource for which BPA needs to be created
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The resource type of workload on which backupplan is applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BackupPlanAssociationState:
    def __init__(__self__, *,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source: Optional[pulumi.Input[_builtins.str]] = None,
                 last_successful_backup_consistency_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_config_infos: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAssociationRulesConfigInfoArgs']]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupPlanAssociation resources.
        :param pulumi.Input[_builtins.str] backup_plan: The BP with which resource needs to be created
               Note:
               - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
               - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        :param pulumi.Input[_builtins.str] backup_plan_association_id: The id of backupplan association
        :param pulumi.Input[_builtins.str] create_time: The time when the instance was created
        :param pulumi.Input[_builtins.str] data_source: Resource name of data source which will be used as storage location for backups taken
        :param pulumi.Input[_builtins.str] last_successful_backup_consistency_time: The point in time when the last successful backup was captured from the source
        :param pulumi.Input[_builtins.str] location: The location for the backupplan association
        :param pulumi.Input[_builtins.str] name: The name of backup plan association resource created
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource: The resource for which BPA needs to be created
        :param pulumi.Input[_builtins.str] resource_type: The resource type of workload on which backupplan is applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanAssociationRulesConfigInfoArgs']]] rules_config_infos: Message for rules config info
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time when the instance was updated.
        """
        if backup_plan is not None:
            pulumi.set(__self__, "backup_plan", backup_plan)
        if backup_plan_association_id is not None:
            pulumi.set(__self__, "backup_plan_association_id", backup_plan_association_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if last_successful_backup_consistency_time is not None:
            pulumi.set(__self__, "last_successful_backup_consistency_time", last_successful_backup_consistency_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if rules_config_infos is not None:
            pulumi.set(__self__, "rules_config_infos", rules_config_infos)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BP with which resource needs to be created
        Note:
        - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
        - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        """
        return pulumi.get(self, "backup_plan")

    @backup_plan.setter
    def backup_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_plan", value)

    @_builtins.property
    @pulumi.getter(name="backupPlanAssociationId")
    def backup_plan_association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of backupplan association
        """
        return pulumi.get(self, "backup_plan_association_id")

    @backup_plan_association_id.setter
    def backup_plan_association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_plan_association_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the instance was created
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of data source which will be used as storage location for backups taken
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source", value)

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulBackupConsistencyTime")
    def last_successful_backup_consistency_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time when the last successful backup was captured from the source
        """
        return pulumi.get(self, "last_successful_backup_consistency_time")

    @last_successful_backup_consistency_time.setter
    def last_successful_backup_consistency_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_successful_backup_consistency_time", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the backupplan association
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of backup plan association resource created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource for which BPA needs to be created
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of workload on which backupplan is applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="rulesConfigInfos")
    def rules_config_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAssociationRulesConfigInfoArgs']]]]:
        """
        Message for rules config info
        Structure is documented below.
        """
        return pulumi.get(self, "rules_config_infos")

    @rules_config_infos.setter
    def rules_config_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupPlanAssociationRulesConfigInfoArgs']]]]):
        pulumi.set(self, "rules_config_infos", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation")
class BackupPlanAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Backup and DR BackupPlanAssociation.

        To get more information about BackupPlanAssociation, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Bpa

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_sa = gcp.serviceaccount.Account("mySA",
            account_id="my-custom",
            display_name="Custom SA for VM Instance")
        myinstance = gcp.compute.Instance("myinstance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="test-instance",
            machine_type="n2-standard-2",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            service_account={
                "email": my_sa.email,
                "scopes": ["cloud-platform"],
            })
        bv1 = gcp.backupdisasterrecovery.BackupVault("bv1",
            location="us-central1",
            backup_vault_id="bv-bpa",
            backup_minimum_enforced_retention_duration="100000s",
            force_delete=True)
        bp1 = gcp.backupdisasterrecovery.BackupPlan("bp1",
            location="us-central1",
            backup_plan_id="bp-bpa-test",
            resource_type="compute.googleapis.com/Instance",
            backup_vault=bv1.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 2,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 6,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 12,
                        "end_hour_of_day": 18,
                    },
                },
            }])
        my_backup_plan_association = gcp.backupdisasterrecovery.BackupPlanAssociation("my-backup-plan-association",
            location="us-central1",
            resource_type="compute.googleapis.com/Instance",
            backup_plan_association_id="my-bpa",
            resource=myinstance.id,
            backup_plan=bp1.name)
        ```

        ## Import

        BackupPlanAssociation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlanAssociations/{{backup_plan_association_id}}`

        * `{{project}}/{{location}}/{{backup_plan_association_id}}`

        * `{{location}}/{{backup_plan_association_id}}`

        When using the `pulumi import` command, BackupPlanAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default projects/{{project}}/locations/{{location}}/backupPlanAssociations/{{backup_plan_association_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default {{project}}/{{location}}/{{backup_plan_association_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default {{location}}/{{backup_plan_association_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_plan: The BP with which resource needs to be created
               Note:
               - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
               - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        :param pulumi.Input[_builtins.str] backup_plan_association_id: The id of backupplan association
        :param pulumi.Input[_builtins.str] location: The location for the backupplan association
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource: The resource for which BPA needs to be created
        :param pulumi.Input[_builtins.str] resource_type: The resource type of workload on which backupplan is applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupPlanAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Backup and DR BackupPlanAssociation.

        To get more information about BackupPlanAssociation, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Bpa

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_sa = gcp.serviceaccount.Account("mySA",
            account_id="my-custom",
            display_name="Custom SA for VM Instance")
        myinstance = gcp.compute.Instance("myinstance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="test-instance",
            machine_type="n2-standard-2",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            service_account={
                "email": my_sa.email,
                "scopes": ["cloud-platform"],
            })
        bv1 = gcp.backupdisasterrecovery.BackupVault("bv1",
            location="us-central1",
            backup_vault_id="bv-bpa",
            backup_minimum_enforced_retention_duration="100000s",
            force_delete=True)
        bp1 = gcp.backupdisasterrecovery.BackupPlan("bp1",
            location="us-central1",
            backup_plan_id="bp-bpa-test",
            resource_type="compute.googleapis.com/Instance",
            backup_vault=bv1.id,
            backup_rules=[{
                "rule_id": "rule-1",
                "backup_retention_days": 2,
                "standard_schedule": {
                    "recurrence_type": "HOURLY",
                    "hourly_frequency": 6,
                    "time_zone": "UTC",
                    "backup_window": {
                        "start_hour_of_day": 12,
                        "end_hour_of_day": 18,
                    },
                },
            }])
        my_backup_plan_association = gcp.backupdisasterrecovery.BackupPlanAssociation("my-backup-plan-association",
            location="us-central1",
            resource_type="compute.googleapis.com/Instance",
            backup_plan_association_id="my-bpa",
            resource=myinstance.id,
            backup_plan=bp1.name)
        ```

        ## Import

        BackupPlanAssociation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupPlanAssociations/{{backup_plan_association_id}}`

        * `{{project}}/{{location}}/{{backup_plan_association_id}}`

        * `{{location}}/{{backup_plan_association_id}}`

        When using the `pulumi import` command, BackupPlanAssociation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default projects/{{project}}/locations/{{location}}/backupPlanAssociations/{{backup_plan_association_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default {{project}}/{{location}}/{{backup_plan_association_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation default {{location}}/{{backup_plan_association_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupPlanAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupPlanAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_plan_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupPlanAssociationArgs.__new__(BackupPlanAssociationArgs)

            if backup_plan is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan'")
            __props__.__dict__["backup_plan"] = backup_plan
            if backup_plan_association_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan_association_id'")
            __props__.__dict__["backup_plan_association_id"] = backup_plan_association_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_source"] = None
            __props__.__dict__["last_successful_backup_consistency_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["rules_config_infos"] = None
            __props__.__dict__["update_time"] = None
        super(BackupPlanAssociation, __self__).__init__(
            'gcp:backupdisasterrecovery/backupPlanAssociation:BackupPlanAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_plan: Optional[pulumi.Input[_builtins.str]] = None,
            backup_plan_association_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source: Optional[pulumi.Input[_builtins.str]] = None,
            last_successful_backup_consistency_time: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resource: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            rules_config_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanAssociationRulesConfigInfoArgs', 'BackupPlanAssociationRulesConfigInfoArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupPlanAssociation':
        """
        Get an existing BackupPlanAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_plan: The BP with which resource needs to be created
               Note:
               - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
               - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        :param pulumi.Input[_builtins.str] backup_plan_association_id: The id of backupplan association
        :param pulumi.Input[_builtins.str] create_time: The time when the instance was created
        :param pulumi.Input[_builtins.str] data_source: Resource name of data source which will be used as storage location for backups taken
        :param pulumi.Input[_builtins.str] last_successful_backup_consistency_time: The point in time when the last successful backup was captured from the source
        :param pulumi.Input[_builtins.str] location: The location for the backupplan association
        :param pulumi.Input[_builtins.str] name: The name of backup plan association resource created
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource: The resource for which BPA needs to be created
        :param pulumi.Input[_builtins.str] resource_type: The resource type of workload on which backupplan is applied.
               Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupPlanAssociationRulesConfigInfoArgs', 'BackupPlanAssociationRulesConfigInfoArgsDict']]]] rules_config_infos: Message for rules config info
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time when the instance was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupPlanAssociationState.__new__(_BackupPlanAssociationState)

        __props__.__dict__["backup_plan"] = backup_plan
        __props__.__dict__["backup_plan_association_id"] = backup_plan_association_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["last_successful_backup_consistency_time"] = last_successful_backup_consistency_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource"] = resource
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["rules_config_infos"] = rules_config_infos
        __props__.__dict__["update_time"] = update_time
        return BackupPlanAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> pulumi.Output[_builtins.str]:
        """
        The BP with which resource needs to be created
        Note:
        - A Backup Plan configured for 'compute.googleapis.com/Instance', can only protect instance type resources.
        - A Backup Plan configured for 'compute.googleapis.com/Disk' can be used to protect both standard Disks and Regional Disks resources.
        """
        return pulumi.get(self, "backup_plan")

    @_builtins.property
    @pulumi.getter(name="backupPlanAssociationId")
    def backup_plan_association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of backupplan association
        """
        return pulumi.get(self, "backup_plan_association_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the instance was created
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[_builtins.str]:
        """
        Resource name of data source which will be used as storage location for backups taken
        """
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulBackupConsistencyTime")
    def last_successful_backup_consistency_time(self) -> pulumi.Output[_builtins.str]:
        """
        The point in time when the last successful backup was captured from the source
        """
        return pulumi.get(self, "last_successful_backup_consistency_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the backupplan association
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of backup plan association resource created
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Output[_builtins.str]:
        """
        The resource for which BPA needs to be created
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The resource type of workload on which backupplan is applied.
        Examples include, "compute.googleapis.com/Instance", "compute.googleapis.com/Disk", and "compute.googleapis.com/RegionDisk"
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="rulesConfigInfos")
    def rules_config_infos(self) -> pulumi.Output[Sequence['outputs.BackupPlanAssociationRulesConfigInfo']]:
        """
        Message for rules config info
        Structure is documented below.
        """
        return pulumi.get(self, "rules_config_infos")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

