# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataSourceResult',
    'AwaitableGetDataSourceResult',
    'get_data_source',
    'get_data_source_output',
]

@pulumi.output_type
class GetDataSourceResult:
    """
    A collection of values returned by getDataSource.
    """
    def __init__(__self__, backup_config_infos=None, backup_count=None, backup_vault_id=None, config_state=None, create_time=None, data_source_backup_appliance_applications=None, data_source_gcp_resources=None, data_source_id=None, etag=None, id=None, labels=None, location=None, name=None, project=None, state=None, total_stored_bytes=None, update_time=None):
        if backup_config_infos and not isinstance(backup_config_infos, list):
            raise TypeError("Expected argument 'backup_config_infos' to be a list")
        pulumi.set(__self__, "backup_config_infos", backup_config_infos)
        if backup_count and not isinstance(backup_count, str):
            raise TypeError("Expected argument 'backup_count' to be a str")
        pulumi.set(__self__, "backup_count", backup_count)
        if backup_vault_id and not isinstance(backup_vault_id, str):
            raise TypeError("Expected argument 'backup_vault_id' to be a str")
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if config_state and not isinstance(config_state, str):
            raise TypeError("Expected argument 'config_state' to be a str")
        pulumi.set(__self__, "config_state", config_state)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_source_backup_appliance_applications and not isinstance(data_source_backup_appliance_applications, list):
            raise TypeError("Expected argument 'data_source_backup_appliance_applications' to be a list")
        pulumi.set(__self__, "data_source_backup_appliance_applications", data_source_backup_appliance_applications)
        if data_source_gcp_resources and not isinstance(data_source_gcp_resources, list):
            raise TypeError("Expected argument 'data_source_gcp_resources' to be a list")
        pulumi.set(__self__, "data_source_gcp_resources", data_source_gcp_resources)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if total_stored_bytes and not isinstance(total_stored_bytes, str):
            raise TypeError("Expected argument 'total_stored_bytes' to be a str")
        pulumi.set(__self__, "total_stored_bytes", total_stored_bytes)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="backupConfigInfos")
    def backup_config_infos(self) -> Sequence['outputs.GetDataSourceBackupConfigInfoResult']:
        return pulumi.get(self, "backup_config_infos")

    @_builtins.property
    @pulumi.getter(name="backupCount")
    def backup_count(self) -> _builtins.str:
        return pulumi.get(self, "backup_count")

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_vault_id")

    @_builtins.property
    @pulumi.getter(name="configState")
    def config_state(self) -> _builtins.str:
        return pulumi.get(self, "config_state")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceBackupApplianceApplications")
    def data_source_backup_appliance_applications(self) -> Sequence['outputs.GetDataSourceDataSourceBackupApplianceApplicationResult']:
        return pulumi.get(self, "data_source_backup_appliance_applications")

    @_builtins.property
    @pulumi.getter(name="dataSourceGcpResources")
    def data_source_gcp_resources(self) -> Sequence['outputs.GetDataSourceDataSourceGcpResourceResult']:
        return pulumi.get(self, "data_source_gcp_resources")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="totalStoredBytes")
    def total_stored_bytes(self) -> _builtins.str:
        return pulumi.get(self, "total_stored_bytes")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetDataSourceResult(GetDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceResult(
            backup_config_infos=self.backup_config_infos,
            backup_count=self.backup_count,
            backup_vault_id=self.backup_vault_id,
            config_state=self.config_state,
            create_time=self.create_time,
            data_source_backup_appliance_applications=self.data_source_backup_appliance_applications,
            data_source_gcp_resources=self.data_source_gcp_resources,
            data_source_id=self.data_source_id,
            etag=self.etag,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            state=self.state,
            total_stored_bytes=self.total_stored_bytes,
            update_time=self.update_time)


def get_data_source(backup_vault_id: Optional[_builtins.str] = None,
                    data_source_id: Optional[_builtins.str] = None,
                    location: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceResult:
    """
    A Backup and DR Data Source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.backupdisasterrecovery.get_data_source(location="us-central1",
        project="project-test",
        data_source_id="ds-test",
        backup_vault_id="bv-test")
    ```


    :param _builtins.str backup_vault_id: The ID of the Backup Vault in which the Data Source belongs.
    :param _builtins.str data_source_id: The ID of the Data Source.
    :param _builtins.str location: The location in which the Data Source belongs.
    :param _builtins.str project: The Google Cloud Project in which the Data Source belongs.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['dataSourceId'] = data_source_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:backupdisasterrecovery/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult).value

    return AwaitableGetDataSourceResult(
        backup_config_infos=pulumi.get(__ret__, 'backup_config_infos'),
        backup_count=pulumi.get(__ret__, 'backup_count'),
        backup_vault_id=pulumi.get(__ret__, 'backup_vault_id'),
        config_state=pulumi.get(__ret__, 'config_state'),
        create_time=pulumi.get(__ret__, 'create_time'),
        data_source_backup_appliance_applications=pulumi.get(__ret__, 'data_source_backup_appliance_applications'),
        data_source_gcp_resources=pulumi.get(__ret__, 'data_source_gcp_resources'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'),
        total_stored_bytes=pulumi.get(__ret__, 'total_stored_bytes'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_data_source_output(backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                           data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                           location: Optional[pulumi.Input[_builtins.str]] = None,
                           project: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSourceResult]:
    """
    A Backup and DR Data Source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.backupdisasterrecovery.get_data_source(location="us-central1",
        project="project-test",
        data_source_id="ds-test",
        backup_vault_id="bv-test")
    ```


    :param _builtins.str backup_vault_id: The ID of the Backup Vault in which the Data Source belongs.
    :param _builtins.str data_source_id: The ID of the Data Source.
    :param _builtins.str location: The location in which the Data Source belongs.
    :param _builtins.str project: The Google Cloud Project in which the Data Source belongs.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['dataSourceId'] = data_source_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:backupdisasterrecovery/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult)
    return __ret__.apply(lambda __response__: GetDataSourceResult(
        backup_config_infos=pulumi.get(__response__, 'backup_config_infos'),
        backup_count=pulumi.get(__response__, 'backup_count'),
        backup_vault_id=pulumi.get(__response__, 'backup_vault_id'),
        config_state=pulumi.get(__response__, 'config_state'),
        create_time=pulumi.get(__response__, 'create_time'),
        data_source_backup_appliance_applications=pulumi.get(__response__, 'data_source_backup_appliance_applications'),
        data_source_gcp_resources=pulumi.get(__response__, 'data_source_gcp_resources'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        state=pulumi.get(__response__, 'state'),
        total_stored_bytes=pulumi.get(__response__, 'total_stored_bytes'),
        update_time=pulumi.get(__response__, 'update_time')))
