# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppGatewayResult',
    'AwaitableGetAppGatewayResult',
    'get_app_gateway',
    'get_app_gateway_output',
]

@pulumi.output_type
class GetAppGatewayResult:
    """
    A collection of values returned by getAppGateway.
    """
    def __init__(__self__, allocated_connections=None, display_name=None, effective_labels=None, host_type=None, id=None, labels=None, name=None, project=None, pulumi_labels=None, region=None, state=None, type=None, uri=None):
        if allocated_connections and not isinstance(allocated_connections, list):
            raise TypeError("Expected argument 'allocated_connections' to be a list")
        pulumi.set(__self__, "allocated_connections", allocated_connections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if host_type and not isinstance(host_type, str):
            raise TypeError("Expected argument 'host_type' to be a str")
        pulumi.set(__self__, "host_type", host_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="allocatedConnections")
    def allocated_connections(self) -> Sequence['outputs.GetAppGatewayAllocatedConnectionResult']:
        return pulumi.get(self, "allocated_connections")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="hostType")
    def host_type(self) -> _builtins.str:
        return pulumi.get(self, "host_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        return pulumi.get(self, "uri")


class AwaitableGetAppGatewayResult(GetAppGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppGatewayResult(
            allocated_connections=self.allocated_connections,
            display_name=self.display_name,
            effective_labels=self.effective_labels,
            host_type=self.host_type,
            id=self.id,
            labels=self.labels,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            region=self.region,
            state=self.state,
            type=self.type,
            uri=self.uri)


def get_app_gateway(name: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppGatewayResult:
    """
    Get information about a Google BeyondCorp App Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_gateway = gcp.beyondcorp.get_app_gateway(name="my-beyondcorp-app-gateway")
    ```


    :param _builtins.str name: The name of the App Gateway.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:beyondcorp/getAppGateway:getAppGateway', __args__, opts=opts, typ=GetAppGatewayResult).value

    return AwaitableGetAppGatewayResult(
        allocated_connections=pulumi.get(__ret__, 'allocated_connections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        host_type=pulumi.get(__ret__, 'host_type'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        uri=pulumi.get(__ret__, 'uri'))
def get_app_gateway_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppGatewayResult]:
    """
    Get information about a Google BeyondCorp App Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_gateway = gcp.beyondcorp.get_app_gateway(name="my-beyondcorp-app-gateway")
    ```


    :param _builtins.str name: The name of the App Gateway.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:beyondcorp/getAppGateway:getAppGateway', __args__, opts=opts, typ=GetAppGatewayResult)
    return __ret__.apply(lambda __response__: GetAppGatewayResult(
        allocated_connections=pulumi.get(__response__, 'allocated_connections'),
        display_name=pulumi.get(__response__, 'display_name'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        host_type=pulumi.get(__response__, 'host_type'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type'),
        uri=pulumi.get(__response__, 'uri')))
