# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatasetsResult',
    'AwaitableGetDatasetsResult',
    'get_datasets',
    'get_datasets_output',
]

@pulumi.output_type
class GetDatasetsResult:
    """
    A collection of values returned by getDatasets.
    """
    def __init__(__self__, datasets=None, id=None, project=None):
        if datasets and not isinstance(datasets, list):
            raise TypeError("Expected argument 'datasets' to be a list")
        pulumi.set(__self__, "datasets", datasets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def datasets(self) -> Sequence['outputs.GetDatasetsDatasetResult']:
        """
        A list of all retrieved BigQuery datasets. Structure is defined below.
        """
        return pulumi.get(self, "datasets")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetDatasetsResult(GetDatasetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetsResult(
            datasets=self.datasets,
            id=self.id,
            project=self.project)


def get_datasets(project: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetsResult:
    """
    Get a list of datasets in a GCP project. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/datasets/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    datasets = gcp.bigquery.get_datasets(project="my-project")
    ```


    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigquery/getDatasets:getDatasets', __args__, opts=opts, typ=GetDatasetsResult).value

    return AwaitableGetDatasetsResult(
        datasets=pulumi.get(__ret__, 'datasets'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'))
def get_datasets_output(project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetsResult]:
    """
    Get a list of datasets in a GCP project. For more information see
    the [official documentation](https://cloud.google.com/bigquery/docs)
    and [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/datasets/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    datasets = gcp.bigquery.get_datasets(project="my-project")
    ```


    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigquery/getDatasets:getDatasets', __args__, opts=opts, typ=GetDatasetsResult)
    return __ret__.apply(lambda __response__: GetDatasetsResult(
        datasets=pulumi.get(__response__, 'datasets'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project')))
