# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[_builtins.str],
                 table_id: pulumi.Input[_builtins.str],
                 biglake_configuration: Optional[pulumi.Input['TableBiglakeConfigurationArgs']] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['TableEncryptionConfigurationArgs']] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
                 external_catalog_table_options: Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']] = None,
                 external_data_configuration: Optional[pulumi.Input['TableExternalDataConfigurationArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_auto_generated_schema: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_schema_changes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 materialized_view: Optional[pulumi.Input['TableMaterializedViewArgs']] = None,
                 max_staleness: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 range_partitioning: Optional[pulumi.Input['TableRangePartitioningArgs']] = None,
                 require_partition_filter: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_foreign_type_info: Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']] = None,
                 table_constraints: Optional[pulumi.Input['TableTableConstraintsArgs']] = None,
                 table_metadata_view: Optional[pulumi.Input[_builtins.str]] = None,
                 table_replication_info: Optional[pulumi.Input['TableTableReplicationInfoArgs']] = None,
                 time_partitioning: Optional[pulumi.Input['TableTimePartitioningArgs']] = None,
                 view: Optional[pulumi.Input['TableViewArgs']] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[_builtins.str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input['TableBiglakeConfigurationArgs'] biglake_configuration: Specifies the configuration of a BigLake managed table. Structure is documented below
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[_builtins.str] description: The field description.
        :param pulumi.Input['TableEncryptionConfigurationArgs'] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[_builtins.int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input['TableExternalCatalogTableOptionsArgs'] external_catalog_table_options: Options defining open source
               compatible table. Structure is documented below.
        :param pulumi.Input['TableExternalDataConfigurationArgs'] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[_builtins.str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_schema_changes: A list of fields which should be ignored for each column in schema.
               **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A mapping of labels to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input['TableMaterializedViewArgs'] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] max_staleness: The maximum staleness of data that could be
               returned when the table (or stale MV) is queried. Staleness encoded as a
               string encoding of [SQL IntervalValue
               type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['TableRangePartitioningArgs'] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.bool] require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: The tags attached to this table. Tag keys are
               globally unique. Tag key is expected to be in the namespaced format, for
               example "123456789012/environment" where 123456789012 is the ID of the
               parent organization or project resource for this tag key. Tag value is
               expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[_builtins.str] schema: A JSON schema for the table.
        :param pulumi.Input['TableSchemaForeignTypeInfoArgs'] schema_foreign_type_info: Specifies metadata of the foreign data
               type definition in field schema. Structure is documented below.
        :param pulumi.Input['TableTableConstraintsArgs'] table_constraints: Defines the primary key and foreign keys. 
               Structure is documented below.
        :param pulumi.Input[_builtins.str] table_metadata_view: View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        :param pulumi.Input['TableTableReplicationInfoArgs'] table_replication_info: Replication info of a table created
               using "AS REPLICA" DDL like:
               `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
               Structure is documented below.
        :param pulumi.Input['TableTimePartitioningArgs'] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input['TableViewArgs'] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "table_id", table_id)
        if biglake_configuration is not None:
            pulumi.set(__self__, "biglake_configuration", biglake_configuration)
        if clusterings is not None:
            pulumi.set(__self__, "clusterings", clusterings)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if external_catalog_table_options is not None:
            pulumi.set(__self__, "external_catalog_table_options", external_catalog_table_options)
        if external_data_configuration is not None:
            pulumi.set(__self__, "external_data_configuration", external_data_configuration)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if ignore_auto_generated_schema is not None:
            pulumi.set(__self__, "ignore_auto_generated_schema", ignore_auto_generated_schema)
        if ignore_schema_changes is not None:
            pulumi.set(__self__, "ignore_schema_changes", ignore_schema_changes)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if materialized_view is not None:
            pulumi.set(__self__, "materialized_view", materialized_view)
        if max_staleness is not None:
            pulumi.set(__self__, "max_staleness", max_staleness)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_foreign_type_info is not None:
            pulumi.set(__self__, "schema_foreign_type_info", schema_foreign_type_info)
        if table_constraints is not None:
            pulumi.set(__self__, "table_constraints", table_constraints)
        if table_metadata_view is not None:
            pulumi.set(__self__, "table_metadata_view", table_metadata_view)
        if table_replication_info is not None:
            pulumi.set(__self__, "table_replication_info", table_replication_info)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[_builtins.str]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_id", value)

    @_builtins.property
    @pulumi.getter(name="biglakeConfiguration")
    def biglake_configuration(self) -> Optional[pulumi.Input['TableBiglakeConfigurationArgs']]:
        """
        Specifies the configuration of a BigLake managed table. Structure is documented below
        """
        return pulumi.get(self, "biglake_configuration")

    @biglake_configuration.setter
    def biglake_configuration(self, value: Optional[pulumi.Input['TableBiglakeConfigurationArgs']]):
        pulumi.set(self, "biglake_configuration", value)

    @_builtins.property
    @pulumi.getter
    def clusterings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @clusterings.setter
    def clusterings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "clusterings", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['TableEncryptionConfigurationArgs']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['TableEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter(name="externalCatalogTableOptions")
    def external_catalog_table_options(self) -> Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']]:
        """
        Options defining open source
        compatible table. Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_table_options")

    @external_catalog_table_options.setter
    def external_catalog_table_options(self, value: Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']]):
        pulumi.set(self, "external_catalog_table_options", value)

    @_builtins.property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> Optional[pulumi.Input['TableExternalDataConfigurationArgs']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @external_data_configuration.setter
    def external_data_configuration(self, value: Optional[pulumi.Input['TableExternalDataConfigurationArgs']]):
        pulumi.set(self, "external_data_configuration", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="ignoreAutoGeneratedSchema")
    def ignore_auto_generated_schema(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ignore_auto_generated_schema")

    @ignore_auto_generated_schema.setter
    def ignore_auto_generated_schema(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_auto_generated_schema", value)

    @_builtins.property
    @pulumi.getter(name="ignoreSchemaChanges")
    def ignore_schema_changes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of fields which should be ignored for each column in schema.
        **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        """
        return pulumi.get(self, "ignore_schema_changes")

    @ignore_schema_changes.setter
    def ignore_schema_changes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_schema_changes", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of labels to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> Optional[pulumi.Input['TableMaterializedViewArgs']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @materialized_view.setter
    def materialized_view(self, value: Optional[pulumi.Input['TableMaterializedViewArgs']]):
        pulumi.set(self, "materialized_view", value)

    @_builtins.property
    @pulumi.getter(name="maxStaleness")
    def max_staleness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum staleness of data that could be
        returned when the table (or stale MV) is queried. Staleness encoded as a
        string encoding of [SQL IntervalValue
        type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        """
        return pulumi.get(self, "max_staleness")

    @max_staleness.setter
    def max_staleness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_staleness", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['TableRangePartitioningArgs']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['TableRangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @_builtins.property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified.
        """
        return pulumi.get(self, "require_partition_filter")

    @require_partition_filter.setter
    def require_partition_filter(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_partition_filter", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags attached to this table. Tag keys are
        globally unique. Tag key is expected to be in the namespaced format, for
        example "123456789012/environment" where 123456789012 is the ID of the
        parent organization or project resource for this tag key. Tag value is
        expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON schema for the table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaForeignTypeInfo")
    def schema_foreign_type_info(self) -> Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']]:
        """
        Specifies metadata of the foreign data
        type definition in field schema. Structure is documented below.
        """
        return pulumi.get(self, "schema_foreign_type_info")

    @schema_foreign_type_info.setter
    def schema_foreign_type_info(self, value: Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']]):
        pulumi.set(self, "schema_foreign_type_info", value)

    @_builtins.property
    @pulumi.getter(name="tableConstraints")
    def table_constraints(self) -> Optional[pulumi.Input['TableTableConstraintsArgs']]:
        """
        Defines the primary key and foreign keys. 
        Structure is documented below.
        """
        return pulumi.get(self, "table_constraints")

    @table_constraints.setter
    def table_constraints(self, value: Optional[pulumi.Input['TableTableConstraintsArgs']]):
        pulumi.set(self, "table_constraints", value)

    @_builtins.property
    @pulumi.getter(name="tableMetadataView")
    def table_metadata_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        """
        return pulumi.get(self, "table_metadata_view")

    @table_metadata_view.setter
    def table_metadata_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_metadata_view", value)

    @_builtins.property
    @pulumi.getter(name="tableReplicationInfo")
    def table_replication_info(self) -> Optional[pulumi.Input['TableTableReplicationInfoArgs']]:
        """
        Replication info of a table created
        using "AS REPLICA" DDL like:
        `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
        Structure is documented below.
        """
        return pulumi.get(self, "table_replication_info")

    @table_replication_info.setter
    def table_replication_info(self, value: Optional[pulumi.Input['TableTableReplicationInfoArgs']]):
        pulumi.set(self, "table_replication_info", value)

    @_builtins.property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TableTimePartitioningArgs']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TableTimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['TableViewArgs']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['TableViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 biglake_configuration: Optional[pulumi.Input['TableBiglakeConfigurationArgs']] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 encryption_configuration: Optional[pulumi.Input['TableEncryptionConfigurationArgs']] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
                 external_catalog_table_options: Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']] = None,
                 external_data_configuration: Optional[pulumi.Input['TableExternalDataConfigurationArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 generated_schema_columns: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_auto_generated_schema: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_schema_changes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 materialized_view: Optional[pulumi.Input['TableMaterializedViewArgs']] = None,
                 max_staleness: Optional[pulumi.Input[_builtins.str]] = None,
                 num_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_long_term_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 num_rows: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 range_partitioning: Optional[pulumi.Input['TableRangePartitioningArgs']] = None,
                 require_partition_filter: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_foreign_type_info: Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 table_constraints: Optional[pulumi.Input['TableTableConstraintsArgs']] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_metadata_view: Optional[pulumi.Input[_builtins.str]] = None,
                 table_replication_info: Optional[pulumi.Input['TableTableReplicationInfoArgs']] = None,
                 time_partitioning: Optional[pulumi.Input['TableTimePartitioningArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 view: Optional[pulumi.Input['TableViewArgs']] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input['TableBiglakeConfigurationArgs'] biglake_configuration: Specifies the configuration of a BigLake managed table. Structure is documented below
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[_builtins.int] creation_time: The time when this table was created, in milliseconds since the epoch.
        :param pulumi.Input[_builtins.str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[_builtins.str] description: The field description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
               
               * <a name="schema"></a>`schema` - (Optional) A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced a field data type (`STRUCT` with
               `RECORD`, `DECIMAL` with `NUMERIC`, etc.), we currently cannot suppress
               the recurring diff this causes. As a workaround, we recommend using the
               schema as returned by the API.
               
               ~>**NOTE:**  If you use `external_data_configuration`
               documented below and do **not** set
               `external_data_configuration.connection_id`, schemas must be specified
               with `external_data_configuration.schema`. Otherwise, schemas must be
               specified with this top-level field.
        :param pulumi.Input['TableEncryptionConfigurationArgs'] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: A hash of the resource.
        :param pulumi.Input[_builtins.int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input['TableExternalCatalogTableOptionsArgs'] external_catalog_table_options: Options defining open source
               compatible table. Structure is documented below.
        :param pulumi.Input['TableExternalDataConfigurationArgs'] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[_builtins.str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[_builtins.str] generated_schema_columns: (Output-only) A list of autogenerated schema fields.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_schema_changes: A list of fields which should be ignored for each column in schema.
               **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A mapping of labels to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] last_modified_time: The time when this table was last modified, in milliseconds since the epoch.
        :param pulumi.Input[_builtins.str] location: The geographic location where the table resides. This value is inherited from the dataset.
        :param pulumi.Input['TableMaterializedViewArgs'] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] max_staleness: The maximum staleness of data that could be
               returned when the table (or stale MV) is queried. Staleness encoded as a
               string encoding of [SQL IntervalValue
               type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        :param pulumi.Input[_builtins.int] num_bytes: The size of this table in bytes, excluding any data in the streaming buffer.
        :param pulumi.Input[_builtins.int] num_long_term_bytes: The number of bytes in the table that are considered "long-term storage".
        :param pulumi.Input[_builtins.int] num_rows: The number of rows of data in this table, excluding any data in the streaming buffer.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input['TableRangePartitioningArgs'] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.bool] require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: The tags attached to this table. Tag keys are
               globally unique. Tag key is expected to be in the namespaced format, for
               example "123456789012/environment" where 123456789012 is the ID of the
               parent organization or project resource for this tag key. Tag value is
               expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[_builtins.str] schema: A JSON schema for the table.
        :param pulumi.Input['TableSchemaForeignTypeInfoArgs'] schema_foreign_type_info: Specifies metadata of the foreign data
               type definition in field schema. Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['TableTableConstraintsArgs'] table_constraints: Defines the primary key and foreign keys. 
               Structure is documented below.
        :param pulumi.Input[_builtins.str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_metadata_view: View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        :param pulumi.Input['TableTableReplicationInfoArgs'] table_replication_info: Replication info of a table created
               using "AS REPLICA" DDL like:
               `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
               Structure is documented below.
        :param pulumi.Input['TableTimePartitioningArgs'] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.str] type: Describes the table type.
        :param pulumi.Input['TableViewArgs'] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        if biglake_configuration is not None:
            pulumi.set(__self__, "biglake_configuration", biglake_configuration)
        if clusterings is not None:
            pulumi.set(__self__, "clusterings", clusterings)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if external_catalog_table_options is not None:
            pulumi.set(__self__, "external_catalog_table_options", external_catalog_table_options)
        if external_data_configuration is not None:
            pulumi.set(__self__, "external_data_configuration", external_data_configuration)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if generated_schema_columns is not None:
            pulumi.set(__self__, "generated_schema_columns", generated_schema_columns)
        if ignore_auto_generated_schema is not None:
            pulumi.set(__self__, "ignore_auto_generated_schema", ignore_auto_generated_schema)
        if ignore_schema_changes is not None:
            pulumi.set(__self__, "ignore_schema_changes", ignore_schema_changes)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if materialized_view is not None:
            pulumi.set(__self__, "materialized_view", materialized_view)
        if max_staleness is not None:
            pulumi.set(__self__, "max_staleness", max_staleness)
        if num_bytes is not None:
            pulumi.set(__self__, "num_bytes", num_bytes)
        if num_long_term_bytes is not None:
            pulumi.set(__self__, "num_long_term_bytes", num_long_term_bytes)
        if num_rows is not None:
            pulumi.set(__self__, "num_rows", num_rows)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if range_partitioning is not None:
            pulumi.set(__self__, "range_partitioning", range_partitioning)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_foreign_type_info is not None:
            pulumi.set(__self__, "schema_foreign_type_info", schema_foreign_type_info)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if table_constraints is not None:
            pulumi.set(__self__, "table_constraints", table_constraints)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if table_metadata_view is not None:
            pulumi.set(__self__, "table_metadata_view", table_metadata_view)
        if table_replication_info is not None:
            pulumi.set(__self__, "table_replication_info", table_replication_info)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @_builtins.property
    @pulumi.getter(name="biglakeConfiguration")
    def biglake_configuration(self) -> Optional[pulumi.Input['TableBiglakeConfigurationArgs']]:
        """
        Specifies the configuration of a BigLake managed table. Structure is documented below
        """
        return pulumi.get(self, "biglake_configuration")

    @biglake_configuration.setter
    def biglake_configuration(self, value: Optional[pulumi.Input['TableBiglakeConfigurationArgs']]):
        pulumi.set(self, "biglake_configuration", value)

    @_builtins.property
    @pulumi.getter
    def clusterings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @clusterings.setter
    def clusterings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "clusterings", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this table was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.

        * <a name="schema"></a>`schema` - (Optional) A JSON schema for the table.

        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        If the API returns a different value for the same schema, e.g. it
        switched the order of values or replaced a field data type (`STRUCT` with
        `RECORD`, `DECIMAL` with `NUMERIC`, etc.), we currently cannot suppress
        the recurring diff this causes. As a workaround, we recommend using the
        schema as returned by the API.

        ~>**NOTE:**  If you use `external_data_configuration`
        documented below and do **not** set
        `external_data_configuration.connection_id`, schemas must be specified
        with `external_data_configuration.schema`. Otherwise, schemas must be
        specified with this top-level field.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['TableEncryptionConfigurationArgs']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['TableEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter(name="externalCatalogTableOptions")
    def external_catalog_table_options(self) -> Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']]:
        """
        Options defining open source
        compatible table. Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_table_options")

    @external_catalog_table_options.setter
    def external_catalog_table_options(self, value: Optional[pulumi.Input['TableExternalCatalogTableOptionsArgs']]):
        pulumi.set(self, "external_catalog_table_options", value)

    @_builtins.property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> Optional[pulumi.Input['TableExternalDataConfigurationArgs']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @external_data_configuration.setter
    def external_data_configuration(self, value: Optional[pulumi.Input['TableExternalDataConfigurationArgs']]):
        pulumi.set(self, "external_data_configuration", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="generatedSchemaColumns")
    def generated_schema_columns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output-only) A list of autogenerated schema fields.
        """
        return pulumi.get(self, "generated_schema_columns")

    @generated_schema_columns.setter
    def generated_schema_columns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generated_schema_columns", value)

    @_builtins.property
    @pulumi.getter(name="ignoreAutoGeneratedSchema")
    def ignore_auto_generated_schema(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ignore_auto_generated_schema")

    @ignore_auto_generated_schema.setter
    def ignore_auto_generated_schema(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_auto_generated_schema", value)

    @_builtins.property
    @pulumi.getter(name="ignoreSchemaChanges")
    def ignore_schema_changes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of fields which should be ignored for each column in schema.
        **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        """
        return pulumi.get(self, "ignore_schema_changes")

    @ignore_schema_changes.setter
    def ignore_schema_changes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_schema_changes", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of labels to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this table was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the table resides. This value is inherited from the dataset.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> Optional[pulumi.Input['TableMaterializedViewArgs']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @materialized_view.setter
    def materialized_view(self, value: Optional[pulumi.Input['TableMaterializedViewArgs']]):
        pulumi.set(self, "materialized_view", value)

    @_builtins.property
    @pulumi.getter(name="maxStaleness")
    def max_staleness(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum staleness of data that could be
        returned when the table (or stale MV) is queried. Staleness encoded as a
        string encoding of [SQL IntervalValue
        type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        """
        return pulumi.get(self, "max_staleness")

    @max_staleness.setter
    def max_staleness(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_staleness", value)

    @_builtins.property
    @pulumi.getter(name="numBytes")
    def num_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of this table in bytes, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_bytes")

    @num_bytes.setter
    def num_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_bytes", value)

    @_builtins.property
    @pulumi.getter(name="numLongTermBytes")
    def num_long_term_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bytes in the table that are considered "long-term storage".
        """
        return pulumi.get(self, "num_long_term_bytes")

    @num_long_term_bytes.setter
    def num_long_term_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_long_term_bytes", value)

    @_builtins.property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of rows of data in this table, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_rows")

    @num_rows.setter
    def num_rows(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_rows", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> Optional[pulumi.Input['TableRangePartitioningArgs']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: Optional[pulumi.Input['TableRangePartitioningArgs']]):
        pulumi.set(self, "range_partitioning", value)

    @_builtins.property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified.
        """
        return pulumi.get(self, "require_partition_filter")

    @require_partition_filter.setter
    def require_partition_filter(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_partition_filter", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags attached to this table. Tag keys are
        globally unique. Tag key is expected to be in the namespaced format, for
        example "123456789012/environment" where 123456789012 is the ID of the
        parent organization or project resource for this tag key. Tag value is
        expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON schema for the table.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaForeignTypeInfo")
    def schema_foreign_type_info(self) -> Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']]:
        """
        Specifies metadata of the foreign data
        type definition in field schema. Structure is documented below.
        """
        return pulumi.get(self, "schema_foreign_type_info")

    @schema_foreign_type_info.setter
    def schema_foreign_type_info(self, value: Optional[pulumi.Input['TableSchemaForeignTypeInfoArgs']]):
        pulumi.set(self, "schema_foreign_type_info", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="tableConstraints")
    def table_constraints(self) -> Optional[pulumi.Input['TableTableConstraintsArgs']]:
        """
        Defines the primary key and foreign keys. 
        Structure is documented below.
        """
        return pulumi.get(self, "table_constraints")

    @table_constraints.setter
    def table_constraints(self, value: Optional[pulumi.Input['TableTableConstraintsArgs']]):
        pulumi.set(self, "table_constraints", value)

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_id", value)

    @_builtins.property
    @pulumi.getter(name="tableMetadataView")
    def table_metadata_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        """
        return pulumi.get(self, "table_metadata_view")

    @table_metadata_view.setter
    def table_metadata_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_metadata_view", value)

    @_builtins.property
    @pulumi.getter(name="tableReplicationInfo")
    def table_replication_info(self) -> Optional[pulumi.Input['TableTableReplicationInfoArgs']]:
        """
        Replication info of a table created
        using "AS REPLICA" DDL like:
        `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
        Structure is documented below.
        """
        return pulumi.get(self, "table_replication_info")

    @table_replication_info.setter
    def table_replication_info(self, value: Optional[pulumi.Input['TableTableReplicationInfoArgs']]):
        pulumi.set(self, "table_replication_info", value)

    @_builtins.property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['TableTimePartitioningArgs']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['TableTimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the table type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['TableViewArgs']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['TableViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.type_token("gcp:bigquery/table:Table")
class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biglake_configuration: Optional[pulumi.Input[Union['TableBiglakeConfigurationArgs', 'TableBiglakeConfigurationArgsDict']]] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['TableEncryptionConfigurationArgs', 'TableEncryptionConfigurationArgsDict']]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
                 external_catalog_table_options: Optional[pulumi.Input[Union['TableExternalCatalogTableOptionsArgs', 'TableExternalCatalogTableOptionsArgsDict']]] = None,
                 external_data_configuration: Optional[pulumi.Input[Union['TableExternalDataConfigurationArgs', 'TableExternalDataConfigurationArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_auto_generated_schema: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_schema_changes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 materialized_view: Optional[pulumi.Input[Union['TableMaterializedViewArgs', 'TableMaterializedViewArgsDict']]] = None,
                 max_staleness: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 range_partitioning: Optional[pulumi.Input[Union['TableRangePartitioningArgs', 'TableRangePartitioningArgsDict']]] = None,
                 require_partition_filter: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_foreign_type_info: Optional[pulumi.Input[Union['TableSchemaForeignTypeInfoArgs', 'TableSchemaForeignTypeInfoArgsDict']]] = None,
                 table_constraints: Optional[pulumi.Input[Union['TableTableConstraintsArgs', 'TableTableConstraintsArgsDict']]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_metadata_view: Optional[pulumi.Input[_builtins.str]] = None,
                 table_replication_info: Optional[pulumi.Input[Union['TableTableReplicationInfoArgs', 'TableTableReplicationInfoArgsDict']]] = None,
                 time_partitioning: Optional[pulumi.Input[Union['TableTimePartitioningArgs', 'TableTimePartitioningArgsDict']]] = None,
                 view: Optional[pulumi.Input[Union['TableViewArgs', 'TableViewArgsDict']]] = None,
                 __props__=None):
        """
        Creates a table resource in a dataset for Google BigQuery. For more information see
        [the official documentation](https://cloud.google.com/bigquery/docs/) and
        [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="foo",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("default",
            dataset_id=default.dataset_id,
            table_id="bar",
            time_partitioning={
                "type": "DAY",
            },
            labels={
                "env": "default",
            },
            schema=\"\"\"[
          {
            "name": "permalink",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "The Permalink"
          },
          {
            "name": "state",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "State where the head office is located"
          }
        ]
        \"\"\")
        sheet = gcp.bigquery.Table("sheet",
            dataset_id=default.dataset_id,
            table_id="sheet",
            external_data_configuration={
                "autodetect": True,
                "source_format": "GOOGLE_SHEETS",
                "google_sheets_options": {
                    "skip_leading_rows": 1,
                },
                "source_uris": ["https://docs.google.com/spreadsheets/d/123456789012345"],
            })
        ```

        ## Import

        BigQuery tables can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}`

        * `{{project}}/{{dataset_id}}/{{table_id}}`

        * `{{dataset_id}}/{{table_id}}`

        When using the `pulumi import` command, BigQuery tables can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/table:Table default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/table:Table default {{project}}/{{dataset_id}}/{{table_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/table:Table default {{dataset_id}}/{{table_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableBiglakeConfigurationArgs', 'TableBiglakeConfigurationArgsDict']] biglake_configuration: Specifies the configuration of a BigLake managed table. Structure is documented below
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[_builtins.str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[_builtins.str] description: The field description.
        :param pulumi.Input[Union['TableEncryptionConfigurationArgs', 'TableEncryptionConfigurationArgsDict']] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[_builtins.int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input[Union['TableExternalCatalogTableOptionsArgs', 'TableExternalCatalogTableOptionsArgsDict']] external_catalog_table_options: Options defining open source
               compatible table. Structure is documented below.
        :param pulumi.Input[Union['TableExternalDataConfigurationArgs', 'TableExternalDataConfigurationArgsDict']] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[_builtins.str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_schema_changes: A list of fields which should be ignored for each column in schema.
               **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A mapping of labels to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[Union['TableMaterializedViewArgs', 'TableMaterializedViewArgsDict']] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] max_staleness: The maximum staleness of data that could be
               returned when the table (or stale MV) is queried. Staleness encoded as a
               string encoding of [SQL IntervalValue
               type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['TableRangePartitioningArgs', 'TableRangePartitioningArgsDict']] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.bool] require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: The tags attached to this table. Tag keys are
               globally unique. Tag key is expected to be in the namespaced format, for
               example "123456789012/environment" where 123456789012 is the ID of the
               parent organization or project resource for this tag key. Tag value is
               expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[_builtins.str] schema: A JSON schema for the table.
        :param pulumi.Input[Union['TableSchemaForeignTypeInfoArgs', 'TableSchemaForeignTypeInfoArgsDict']] schema_foreign_type_info: Specifies metadata of the foreign data
               type definition in field schema. Structure is documented below.
        :param pulumi.Input[Union['TableTableConstraintsArgs', 'TableTableConstraintsArgsDict']] table_constraints: Defines the primary key and foreign keys. 
               Structure is documented below.
        :param pulumi.Input[_builtins.str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_metadata_view: View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        :param pulumi.Input[Union['TableTableReplicationInfoArgs', 'TableTableReplicationInfoArgsDict']] table_replication_info: Replication info of a table created
               using "AS REPLICA" DDL like:
               `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
               Structure is documented below.
        :param pulumi.Input[Union['TableTimePartitioningArgs', 'TableTimePartitioningArgsDict']] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[Union['TableViewArgs', 'TableViewArgsDict']] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a table resource in a dataset for Google BigQuery. For more information see
        [the official documentation](https://cloud.google.com/bigquery/docs/) and
        [API](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables).

        > **Note**: On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi update` to write the field to state) in order to destroy an instance.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.bigquery.Dataset("default",
            dataset_id="foo",
            friendly_name="test",
            description="This is a test description",
            location="EU",
            default_table_expiration_ms=3600000,
            labels={
                "env": "default",
            })
        default_table = gcp.bigquery.Table("default",
            dataset_id=default.dataset_id,
            table_id="bar",
            time_partitioning={
                "type": "DAY",
            },
            labels={
                "env": "default",
            },
            schema=\"\"\"[
          {
            "name": "permalink",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "The Permalink"
          },
          {
            "name": "state",
            "type": "STRING",
            "mode": "NULLABLE",
            "description": "State where the head office is located"
          }
        ]
        \"\"\")
        sheet = gcp.bigquery.Table("sheet",
            dataset_id=default.dataset_id,
            table_id="sheet",
            external_data_configuration={
                "autodetect": True,
                "source_format": "GOOGLE_SHEETS",
                "google_sheets_options": {
                    "skip_leading_rows": 1,
                },
                "source_uris": ["https://docs.google.com/spreadsheets/d/123456789012345"],
            })
        ```

        ## Import

        BigQuery tables can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}`

        * `{{project}}/{{dataset_id}}/{{table_id}}`

        * `{{dataset_id}}/{{table_id}}`

        When using the `pulumi import` command, BigQuery tables can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/table:Table default projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/table:Table default {{project}}/{{dataset_id}}/{{table_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/table:Table default {{dataset_id}}/{{table_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biglake_configuration: Optional[pulumi.Input[Union['TableBiglakeConfigurationArgs', 'TableBiglakeConfigurationArgsDict']]] = None,
                 clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['TableEncryptionConfigurationArgs', 'TableEncryptionConfigurationArgsDict']]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
                 external_catalog_table_options: Optional[pulumi.Input[Union['TableExternalCatalogTableOptionsArgs', 'TableExternalCatalogTableOptionsArgsDict']]] = None,
                 external_data_configuration: Optional[pulumi.Input[Union['TableExternalDataConfigurationArgs', 'TableExternalDataConfigurationArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_auto_generated_schema: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_schema_changes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 materialized_view: Optional[pulumi.Input[Union['TableMaterializedViewArgs', 'TableMaterializedViewArgsDict']]] = None,
                 max_staleness: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 range_partitioning: Optional[pulumi.Input[Union['TableRangePartitioningArgs', 'TableRangePartitioningArgsDict']]] = None,
                 require_partition_filter: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_foreign_type_info: Optional[pulumi.Input[Union['TableSchemaForeignTypeInfoArgs', 'TableSchemaForeignTypeInfoArgsDict']]] = None,
                 table_constraints: Optional[pulumi.Input[Union['TableTableConstraintsArgs', 'TableTableConstraintsArgsDict']]] = None,
                 table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table_metadata_view: Optional[pulumi.Input[_builtins.str]] = None,
                 table_replication_info: Optional[pulumi.Input[Union['TableTableReplicationInfoArgs', 'TableTableReplicationInfoArgsDict']]] = None,
                 time_partitioning: Optional[pulumi.Input[Union['TableTimePartitioningArgs', 'TableTimePartitioningArgsDict']]] = None,
                 view: Optional[pulumi.Input[Union['TableViewArgs', 'TableViewArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["biglake_configuration"] = biglake_configuration
            __props__.__dict__["clusterings"] = clusterings
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["expiration_time"] = expiration_time
            __props__.__dict__["external_catalog_table_options"] = external_catalog_table_options
            __props__.__dict__["external_data_configuration"] = external_data_configuration
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["ignore_auto_generated_schema"] = ignore_auto_generated_schema
            __props__.__dict__["ignore_schema_changes"] = ignore_schema_changes
            __props__.__dict__["labels"] = labels
            __props__.__dict__["materialized_view"] = materialized_view
            __props__.__dict__["max_staleness"] = max_staleness
            __props__.__dict__["project"] = project
            __props__.__dict__["range_partitioning"] = range_partitioning
            __props__.__dict__["require_partition_filter"] = require_partition_filter
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["schema"] = schema
            __props__.__dict__["schema_foreign_type_info"] = schema_foreign_type_info
            __props__.__dict__["table_constraints"] = table_constraints
            if table_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_id'")
            __props__.__dict__["table_id"] = table_id
            __props__.__dict__["table_metadata_view"] = table_metadata_view
            __props__.__dict__["table_replication_info"] = table_replication_info
            __props__.__dict__["time_partitioning"] = time_partitioning
            __props__.__dict__["view"] = view
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["generated_schema_columns"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["num_bytes"] = None
            __props__.__dict__["num_long_term_bytes"] = None
            __props__.__dict__["num_rows"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Table, __self__).__init__(
            'gcp:bigquery/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            biglake_configuration: Optional[pulumi.Input[Union['TableBiglakeConfigurationArgs', 'TableBiglakeConfigurationArgsDict']]] = None,
            clusterings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            encryption_configuration: Optional[pulumi.Input[Union['TableEncryptionConfigurationArgs', 'TableEncryptionConfigurationArgsDict']]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_time: Optional[pulumi.Input[_builtins.int]] = None,
            external_catalog_table_options: Optional[pulumi.Input[Union['TableExternalCatalogTableOptionsArgs', 'TableExternalCatalogTableOptionsArgsDict']]] = None,
            external_data_configuration: Optional[pulumi.Input[Union['TableExternalDataConfigurationArgs', 'TableExternalDataConfigurationArgsDict']]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            generated_schema_columns: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_auto_generated_schema: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_schema_changes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            materialized_view: Optional[pulumi.Input[Union['TableMaterializedViewArgs', 'TableMaterializedViewArgsDict']]] = None,
            max_staleness: Optional[pulumi.Input[_builtins.str]] = None,
            num_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            num_long_term_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            num_rows: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            range_partitioning: Optional[pulumi.Input[Union['TableRangePartitioningArgs', 'TableRangePartitioningArgsDict']]] = None,
            require_partition_filter: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            schema_foreign_type_info: Optional[pulumi.Input[Union['TableSchemaForeignTypeInfoArgs', 'TableSchemaForeignTypeInfoArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            table_constraints: Optional[pulumi.Input[Union['TableTableConstraintsArgs', 'TableTableConstraintsArgsDict']]] = None,
            table_id: Optional[pulumi.Input[_builtins.str]] = None,
            table_metadata_view: Optional[pulumi.Input[_builtins.str]] = None,
            table_replication_info: Optional[pulumi.Input[Union['TableTableReplicationInfoArgs', 'TableTableReplicationInfoArgsDict']]] = None,
            time_partitioning: Optional[pulumi.Input[Union['TableTimePartitioningArgs', 'TableTimePartitioningArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            view: Optional[pulumi.Input[Union['TableViewArgs', 'TableViewArgsDict']]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableBiglakeConfigurationArgs', 'TableBiglakeConfigurationArgsDict']] biglake_configuration: Specifies the configuration of a BigLake managed table. Structure is documented below
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] clusterings: Specifies column names to use for data clustering.
               Up to four top-level columns are allowed, and should be specified in
               descending priority order.
        :param pulumi.Input[_builtins.int] creation_time: The time when this table was created, in milliseconds since the epoch.
        :param pulumi.Input[_builtins.str] dataset_id: The dataset ID to create the table in.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether or not to allow the provider to destroy the instance. Unless this field is set to false
               in state, a `=destroy` or `=update` that would delete the instance will fail.
        :param pulumi.Input[_builtins.str] description: The field description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
               
               * <a name="schema"></a>`schema` - (Optional) A JSON schema for the table.
               
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               If the API returns a different value for the same schema, e.g. it
               switched the order of values or replaced a field data type (`STRUCT` with
               `RECORD`, `DECIMAL` with `NUMERIC`, etc.), we currently cannot suppress
               the recurring diff this causes. As a workaround, we recommend using the
               schema as returned by the API.
               
               ~>**NOTE:**  If you use `external_data_configuration`
               documented below and do **not** set
               `external_data_configuration.connection_id`, schemas must be specified
               with `external_data_configuration.schema`. Otherwise, schemas must be
               specified with this top-level field.
        :param pulumi.Input[Union['TableEncryptionConfigurationArgs', 'TableEncryptionConfigurationArgsDict']] encryption_configuration: Specifies how the table should be encrypted.
               If left blank, the table will be encrypted with a Google-managed key; that process
               is transparent to the user.  Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: A hash of the resource.
        :param pulumi.Input[_builtins.int] expiration_time: The time when this table expires, in
               milliseconds since the epoch. If not present, the table will persist
               indefinitely. Expired tables will be deleted and their storage
               reclaimed.
        :param pulumi.Input[Union['TableExternalCatalogTableOptionsArgs', 'TableExternalCatalogTableOptionsArgsDict']] external_catalog_table_options: Options defining open source
               compatible table. Structure is documented below.
        :param pulumi.Input[Union['TableExternalDataConfigurationArgs', 'TableExternalDataConfigurationArgsDict']] external_data_configuration: Describes the data format,
               location, and other properties of a table stored outside of BigQuery.
               By defining these properties, the data source can then be queried as
               if it were a standard BigQuery table. Structure is documented below.
        :param pulumi.Input[_builtins.str] friendly_name: A descriptive name for the table.
        :param pulumi.Input[_builtins.str] generated_schema_columns: (Output-only) A list of autogenerated schema fields.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_schema_changes: A list of fields which should be ignored for each column in schema.
               **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A mapping of labels to assign to the resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] last_modified_time: The time when this table was last modified, in milliseconds since the epoch.
        :param pulumi.Input[_builtins.str] location: The geographic location where the table resides. This value is inherited from the dataset.
        :param pulumi.Input[Union['TableMaterializedViewArgs', 'TableMaterializedViewArgsDict']] materialized_view: If specified, configures this table as a materialized view.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] max_staleness: The maximum staleness of data that could be
               returned when the table (or stale MV) is queried. Staleness encoded as a
               string encoding of [SQL IntervalValue
               type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        :param pulumi.Input[_builtins.int] num_bytes: The size of this table in bytes, excluding any data in the streaming buffer.
        :param pulumi.Input[_builtins.int] num_long_term_bytes: The number of bytes in the table that are considered "long-term storage".
        :param pulumi.Input[_builtins.int] num_rows: The number of rows of data in this table, excluding any data in the streaming buffer.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Union['TableRangePartitioningArgs', 'TableRangePartitioningArgsDict']] range_partitioning: If specified, configures range-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.bool] require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: The tags attached to this table. Tag keys are
               globally unique. Tag key is expected to be in the namespaced format, for
               example "123456789012/environment" where 123456789012 is the ID of the
               parent organization or project resource for this tag key. Tag value is
               expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
               for more details.
        :param pulumi.Input[_builtins.str] schema: A JSON schema for the table.
        :param pulumi.Input[Union['TableSchemaForeignTypeInfoArgs', 'TableSchemaForeignTypeInfoArgsDict']] schema_foreign_type_info: Specifies metadata of the foreign data
               type definition in field schema. Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['TableTableConstraintsArgs', 'TableTableConstraintsArgsDict']] table_constraints: Defines the primary key and foreign keys. 
               Structure is documented below.
        :param pulumi.Input[_builtins.str] table_id: A unique ID for the resource.
               Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table_metadata_view: View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        :param pulumi.Input[Union['TableTableReplicationInfoArgs', 'TableTableReplicationInfoArgsDict']] table_replication_info: Replication info of a table created
               using "AS REPLICA" DDL like:
               `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
               Structure is documented below.
        :param pulumi.Input[Union['TableTimePartitioningArgs', 'TableTimePartitioningArgsDict']] time_partitioning: If specified, configures time-based
               partitioning for this table. Structure is documented below.
        :param pulumi.Input[_builtins.str] type: Describes the table type.
        :param pulumi.Input[Union['TableViewArgs', 'TableViewArgsDict']] view: If specified, configures this table as a view.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["biglake_configuration"] = biglake_configuration
        __props__.__dict__["clusterings"] = clusterings
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["external_catalog_table_options"] = external_catalog_table_options
        __props__.__dict__["external_data_configuration"] = external_data_configuration
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["generated_schema_columns"] = generated_schema_columns
        __props__.__dict__["ignore_auto_generated_schema"] = ignore_auto_generated_schema
        __props__.__dict__["ignore_schema_changes"] = ignore_schema_changes
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["location"] = location
        __props__.__dict__["materialized_view"] = materialized_view
        __props__.__dict__["max_staleness"] = max_staleness
        __props__.__dict__["num_bytes"] = num_bytes
        __props__.__dict__["num_long_term_bytes"] = num_long_term_bytes
        __props__.__dict__["num_rows"] = num_rows
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["range_partitioning"] = range_partitioning
        __props__.__dict__["require_partition_filter"] = require_partition_filter
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["schema"] = schema
        __props__.__dict__["schema_foreign_type_info"] = schema_foreign_type_info
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["table_constraints"] = table_constraints
        __props__.__dict__["table_id"] = table_id
        __props__.__dict__["table_metadata_view"] = table_metadata_view
        __props__.__dict__["table_replication_info"] = table_replication_info
        __props__.__dict__["time_partitioning"] = time_partitioning
        __props__.__dict__["type"] = type
        __props__.__dict__["view"] = view
        return Table(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="biglakeConfiguration")
    def biglake_configuration(self) -> pulumi.Output[Optional['outputs.TableBiglakeConfiguration']]:
        """
        Specifies the configuration of a BigLake managed table. Structure is documented below
        """
        return pulumi.get(self, "biglake_configuration")

    @_builtins.property
    @pulumi.getter
    def clusterings(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies column names to use for data clustering.
        Up to four top-level columns are allowed, and should be specified in
        descending priority order.
        """
        return pulumi.get(self, "clusterings")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when this table was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The dataset ID to create the table in.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to allow the provider to destroy the instance. Unless this field is set to false
        in state, a `=destroy` or `=update` that would delete the instance will fail.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The field description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.

        * <a name="schema"></a>`schema` - (Optional) A JSON schema for the table.

        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        If the API returns a different value for the same schema, e.g. it
        switched the order of values or replaced a field data type (`STRUCT` with
        `RECORD`, `DECIMAL` with `NUMERIC`, etc.), we currently cannot suppress
        the recurring diff this causes. As a workaround, we recommend using the
        schema as returned by the API.

        ~>**NOTE:**  If you use `external_data_configuration`
        documented below and do **not** set
        `external_data_configuration.connection_id`, schemas must be specified
        with `external_data_configuration.schema`. Otherwise, schemas must be
        specified with this top-level field.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.TableEncryptionConfiguration']]:
        """
        Specifies how the table should be encrypted.
        If left blank, the table will be encrypted with a Google-managed key; that process
        is transparent to the user.  Structure is documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        A hash of the resource.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when this table expires, in
        milliseconds since the epoch. If not present, the table will persist
        indefinitely. Expired tables will be deleted and their storage
        reclaimed.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="externalCatalogTableOptions")
    def external_catalog_table_options(self) -> pulumi.Output[Optional['outputs.TableExternalCatalogTableOptions']]:
        """
        Options defining open source
        compatible table. Structure is documented below.
        """
        return pulumi.get(self, "external_catalog_table_options")

    @_builtins.property
    @pulumi.getter(name="externalDataConfiguration")
    def external_data_configuration(self) -> pulumi.Output[Optional['outputs.TableExternalDataConfiguration']]:
        """
        Describes the data format,
        location, and other properties of a table stored outside of BigQuery.
        By defining these properties, the data source can then be queried as
        if it were a standard BigQuery table. Structure is documented below.
        """
        return pulumi.get(self, "external_data_configuration")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A descriptive name for the table.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="generatedSchemaColumns")
    def generated_schema_columns(self) -> pulumi.Output[_builtins.str]:
        """
        (Output-only) A list of autogenerated schema fields.
        """
        return pulumi.get(self, "generated_schema_columns")

    @_builtins.property
    @pulumi.getter(name="ignoreAutoGeneratedSchema")
    def ignore_auto_generated_schema(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "ignore_auto_generated_schema")

    @_builtins.property
    @pulumi.getter(name="ignoreSchemaChanges")
    def ignore_schema_changes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of fields which should be ignored for each column in schema.
        **NOTE:** Right now only `dataPolicies` field is supported. We might support others in the future.
        """
        return pulumi.get(self, "ignore_schema_changes")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of labels to assign to the resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when this table was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the table resides. This value is inherited from the dataset.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="materializedView")
    def materialized_view(self) -> pulumi.Output[Optional['outputs.TableMaterializedView']]:
        """
        If specified, configures this table as a materialized view.
        Structure is documented below.
        """
        return pulumi.get(self, "materialized_view")

    @_builtins.property
    @pulumi.getter(name="maxStaleness")
    def max_staleness(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum staleness of data that could be
        returned when the table (or stale MV) is queried. Staleness encoded as a
        string encoding of [SQL IntervalValue
        type](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#interval_type).
        """
        return pulumi.get(self, "max_staleness")

    @_builtins.property
    @pulumi.getter(name="numBytes")
    def num_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        The size of this table in bytes, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_bytes")

    @_builtins.property
    @pulumi.getter(name="numLongTermBytes")
    def num_long_term_bytes(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bytes in the table that are considered "long-term storage".
        """
        return pulumi.get(self, "num_long_term_bytes")

    @_builtins.property
    @pulumi.getter(name="numRows")
    def num_rows(self) -> pulumi.Output[_builtins.int]:
        """
        The number of rows of data in this table, excluding any data in the streaming buffer.
        """
        return pulumi.get(self, "num_rows")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="rangePartitioning")
    def range_partitioning(self) -> pulumi.Output[Optional['outputs.TableRangePartitioning']]:
        """
        If specified, configures range-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "range_partitioning")

    @_builtins.property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified.
        """
        return pulumi.get(self, "require_partition_filter")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags attached to this table. Tag keys are
        globally unique. Tag key is expected to be in the namespaced format, for
        example "123456789012/environment" where 123456789012 is the ID of the
        parent organization or project resource for this tag key. Tag value is
        expected to be the short name, for example "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-control#definitions)
        for more details.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        A JSON schema for the table.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaForeignTypeInfo")
    def schema_foreign_type_info(self) -> pulumi.Output[Optional['outputs.TableSchemaForeignTypeInfo']]:
        """
        Specifies metadata of the foreign data
        type definition in field schema. Structure is documented below.
        """
        return pulumi.get(self, "schema_foreign_type_info")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="tableConstraints")
    def table_constraints(self) -> pulumi.Output[Optional['outputs.TableTableConstraints']]:
        """
        Defines the primary key and foreign keys. 
        Structure is documented below.
        """
        return pulumi.get(self, "table_constraints")

    @_builtins.property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique ID for the resource.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "table_id")

    @_builtins.property
    @pulumi.getter(name="tableMetadataView")
    def table_metadata_view(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        View sets the optional parameter "view": Specifies the view that determines which table information is returned. By default, basic table information and storage statistics (STORAGE_STATS) are returned. Possible values: TABLE_METADATA_VIEW_UNSPECIFIED, BASIC, STORAGE_STATS, FULL
        """
        return pulumi.get(self, "table_metadata_view")

    @_builtins.property
    @pulumi.getter(name="tableReplicationInfo")
    def table_replication_info(self) -> pulumi.Output[Optional['outputs.TableTableReplicationInfo']]:
        """
        Replication info of a table created
        using "AS REPLICA" DDL like:
        `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`.
        Structure is documented below.
        """
        return pulumi.get(self, "table_replication_info")

    @_builtins.property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> pulumi.Output[Optional['outputs.TableTimePartitioning']]:
        """
        If specified, configures time-based
        partitioning for this table. Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the table type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def view(self) -> pulumi.Output[Optional['outputs.TableView']]:
        """
        If specified, configures this table as a view.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

