# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BlockchainNodesConnectionInfo',
    'BlockchainNodesConnectionInfoEndpointInfo',
    'BlockchainNodesEthereumDetails',
    'BlockchainNodesEthereumDetailsAdditionalEndpoint',
    'BlockchainNodesEthereumDetailsGethDetails',
    'BlockchainNodesEthereumDetailsValidatorConfig',
]

@pulumi.output_type
class BlockchainNodesConnectionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointInfos":
            suggest = "endpoint_infos"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesConnectionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesConnectionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesConnectionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_infos: Optional[Sequence['outputs.BlockchainNodesConnectionInfoEndpointInfo']] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param Sequence['BlockchainNodesConnectionInfoEndpointInfoArgs'] endpoint_infos: (Output)
               The endpoint information through which to interact with a blockchain node.
               Structure is documented below.
        :param _builtins.str service_attachment: (Output)
               A service attachment that exposes a node, and has the following format: projects/{project}/regions/{region}/serviceAttachments/{service_attachment_name}
        """
        if endpoint_infos is not None:
            pulumi.set(__self__, "endpoint_infos", endpoint_infos)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter(name="endpointInfos")
    def endpoint_infos(self) -> Optional[Sequence['outputs.BlockchainNodesConnectionInfoEndpointInfo']]:
        """
        (Output)
        The endpoint information through which to interact with a blockchain node.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint_infos")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        (Output)
        A service attachment that exposes a node, and has the following format: projects/{project}/regions/{region}/serviceAttachments/{service_attachment_name}
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class BlockchainNodesConnectionInfoEndpointInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonRpcApiEndpoint":
            suggest = "json_rpc_api_endpoint"
        elif key == "websocketsApiEndpoint":
            suggest = "websockets_api_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesConnectionInfoEndpointInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesConnectionInfoEndpointInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesConnectionInfoEndpointInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_rpc_api_endpoint: Optional[_builtins.str] = None,
                 websockets_api_endpoint: Optional[_builtins.str] = None):
        """
        :param _builtins.str json_rpc_api_endpoint: (Output)
               The assigned URL for the node JSON-RPC API endpoint.
        :param _builtins.str websockets_api_endpoint: (Output)
               The assigned URL for the node WebSockets API endpoint.
        """
        if json_rpc_api_endpoint is not None:
            pulumi.set(__self__, "json_rpc_api_endpoint", json_rpc_api_endpoint)
        if websockets_api_endpoint is not None:
            pulumi.set(__self__, "websockets_api_endpoint", websockets_api_endpoint)

    @_builtins.property
    @pulumi.getter(name="jsonRpcApiEndpoint")
    def json_rpc_api_endpoint(self) -> Optional[_builtins.str]:
        """
        (Output)
        The assigned URL for the node JSON-RPC API endpoint.
        """
        return pulumi.get(self, "json_rpc_api_endpoint")

    @_builtins.property
    @pulumi.getter(name="websocketsApiEndpoint")
    def websockets_api_endpoint(self) -> Optional[_builtins.str]:
        """
        (Output)
        The assigned URL for the node WebSockets API endpoint.
        """
        return pulumi.get(self, "websockets_api_endpoint")


@pulumi.output_type
class BlockchainNodesEthereumDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalEndpoints":
            suggest = "additional_endpoints"
        elif key == "apiEnableAdmin":
            suggest = "api_enable_admin"
        elif key == "apiEnableDebug":
            suggest = "api_enable_debug"
        elif key == "consensusClient":
            suggest = "consensus_client"
        elif key == "executionClient":
            suggest = "execution_client"
        elif key == "gethDetails":
            suggest = "geth_details"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "validatorConfig":
            suggest = "validator_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesEthereumDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesEthereumDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesEthereumDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_endpoints: Optional[Sequence['outputs.BlockchainNodesEthereumDetailsAdditionalEndpoint']] = None,
                 api_enable_admin: Optional[_builtins.bool] = None,
                 api_enable_debug: Optional[_builtins.bool] = None,
                 consensus_client: Optional[_builtins.str] = None,
                 execution_client: Optional[_builtins.str] = None,
                 geth_details: Optional['outputs.BlockchainNodesEthereumDetailsGethDetails'] = None,
                 network: Optional[_builtins.str] = None,
                 node_type: Optional[_builtins.str] = None,
                 validator_config: Optional['outputs.BlockchainNodesEthereumDetailsValidatorConfig'] = None):
        """
        :param Sequence['BlockchainNodesEthereumDetailsAdditionalEndpointArgs'] additional_endpoints: (Output)
               User-provided key-value pairs
               Structure is documented below.
        :param _builtins.bool api_enable_admin: Enables JSON-RPC access to functions in the admin namespace. Defaults to false.
        :param _builtins.bool api_enable_debug: Enables JSON-RPC access to functions in the debug namespace. Defaults to false.
        :param _builtins.str consensus_client: The consensus client
               Possible values are: `CONSENSUS_CLIENT_UNSPECIFIED`, `LIGHTHOUSE`.
        :param _builtins.str execution_client: The execution client
               Possible values are: `EXECUTION_CLIENT_UNSPECIFIED`, `GETH`, `ERIGON`.
        :param 'BlockchainNodesEthereumDetailsGethDetailsArgs' geth_details: User-provided key-value pairs
               Structure is documented below.
        :param _builtins.str network: The Ethereum environment being accessed.
               Possible values are: `MAINNET`, `TESTNET_GOERLI_PRATER`, `TESTNET_SEPOLIA`.
        :param _builtins.str node_type: The type of Ethereum node.
               Possible values are: `LIGHT`, `FULL`, `ARCHIVE`.
        :param 'BlockchainNodesEthereumDetailsValidatorConfigArgs' validator_config: Configuration for validator-related parameters on the beacon client, and for any managed validator client.
               Structure is documented below.
        """
        if additional_endpoints is not None:
            pulumi.set(__self__, "additional_endpoints", additional_endpoints)
        if api_enable_admin is not None:
            pulumi.set(__self__, "api_enable_admin", api_enable_admin)
        if api_enable_debug is not None:
            pulumi.set(__self__, "api_enable_debug", api_enable_debug)
        if consensus_client is not None:
            pulumi.set(__self__, "consensus_client", consensus_client)
        if execution_client is not None:
            pulumi.set(__self__, "execution_client", execution_client)
        if geth_details is not None:
            pulumi.set(__self__, "geth_details", geth_details)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if validator_config is not None:
            pulumi.set(__self__, "validator_config", validator_config)

    @_builtins.property
    @pulumi.getter(name="additionalEndpoints")
    def additional_endpoints(self) -> Optional[Sequence['outputs.BlockchainNodesEthereumDetailsAdditionalEndpoint']]:
        """
        (Output)
        User-provided key-value pairs
        Structure is documented below.
        """
        return pulumi.get(self, "additional_endpoints")

    @_builtins.property
    @pulumi.getter(name="apiEnableAdmin")
    def api_enable_admin(self) -> Optional[_builtins.bool]:
        """
        Enables JSON-RPC access to functions in the admin namespace. Defaults to false.
        """
        return pulumi.get(self, "api_enable_admin")

    @_builtins.property
    @pulumi.getter(name="apiEnableDebug")
    def api_enable_debug(self) -> Optional[_builtins.bool]:
        """
        Enables JSON-RPC access to functions in the debug namespace. Defaults to false.
        """
        return pulumi.get(self, "api_enable_debug")

    @_builtins.property
    @pulumi.getter(name="consensusClient")
    def consensus_client(self) -> Optional[_builtins.str]:
        """
        The consensus client
        Possible values are: `CONSENSUS_CLIENT_UNSPECIFIED`, `LIGHTHOUSE`.
        """
        return pulumi.get(self, "consensus_client")

    @_builtins.property
    @pulumi.getter(name="executionClient")
    def execution_client(self) -> Optional[_builtins.str]:
        """
        The execution client
        Possible values are: `EXECUTION_CLIENT_UNSPECIFIED`, `GETH`, `ERIGON`.
        """
        return pulumi.get(self, "execution_client")

    @_builtins.property
    @pulumi.getter(name="gethDetails")
    def geth_details(self) -> Optional['outputs.BlockchainNodesEthereumDetailsGethDetails']:
        """
        User-provided key-value pairs
        Structure is documented below.
        """
        return pulumi.get(self, "geth_details")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The Ethereum environment being accessed.
        Possible values are: `MAINNET`, `TESTNET_GOERLI_PRATER`, `TESTNET_SEPOLIA`.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        """
        The type of Ethereum node.
        Possible values are: `LIGHT`, `FULL`, `ARCHIVE`.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="validatorConfig")
    def validator_config(self) -> Optional['outputs.BlockchainNodesEthereumDetailsValidatorConfig']:
        """
        Configuration for validator-related parameters on the beacon client, and for any managed validator client.
        Structure is documented below.
        """
        return pulumi.get(self, "validator_config")


@pulumi.output_type
class BlockchainNodesEthereumDetailsAdditionalEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beaconApiEndpoint":
            suggest = "beacon_api_endpoint"
        elif key == "beaconPrometheusMetricsApiEndpoint":
            suggest = "beacon_prometheus_metrics_api_endpoint"
        elif key == "executionClientPrometheusMetricsApiEndpoint":
            suggest = "execution_client_prometheus_metrics_api_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesEthereumDetailsAdditionalEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesEthereumDetailsAdditionalEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesEthereumDetailsAdditionalEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 beacon_api_endpoint: Optional[_builtins.str] = None,
                 beacon_prometheus_metrics_api_endpoint: Optional[_builtins.str] = None,
                 execution_client_prometheus_metrics_api_endpoint: Optional[_builtins.str] = None):
        """
        :param _builtins.str beacon_api_endpoint: The assigned URL for the node's Beacon API endpoint.
        :param _builtins.str beacon_prometheus_metrics_api_endpoint: The assigned URL for the node's Beacon Prometheus metrics endpoint.
        :param _builtins.str execution_client_prometheus_metrics_api_endpoint: The assigned URL for the node's execution client's Prometheus metrics endpoint.
        """
        if beacon_api_endpoint is not None:
            pulumi.set(__self__, "beacon_api_endpoint", beacon_api_endpoint)
        if beacon_prometheus_metrics_api_endpoint is not None:
            pulumi.set(__self__, "beacon_prometheus_metrics_api_endpoint", beacon_prometheus_metrics_api_endpoint)
        if execution_client_prometheus_metrics_api_endpoint is not None:
            pulumi.set(__self__, "execution_client_prometheus_metrics_api_endpoint", execution_client_prometheus_metrics_api_endpoint)

    @_builtins.property
    @pulumi.getter(name="beaconApiEndpoint")
    def beacon_api_endpoint(self) -> Optional[_builtins.str]:
        """
        The assigned URL for the node's Beacon API endpoint.
        """
        return pulumi.get(self, "beacon_api_endpoint")

    @_builtins.property
    @pulumi.getter(name="beaconPrometheusMetricsApiEndpoint")
    def beacon_prometheus_metrics_api_endpoint(self) -> Optional[_builtins.str]:
        """
        The assigned URL for the node's Beacon Prometheus metrics endpoint.
        """
        return pulumi.get(self, "beacon_prometheus_metrics_api_endpoint")

    @_builtins.property
    @pulumi.getter(name="executionClientPrometheusMetricsApiEndpoint")
    def execution_client_prometheus_metrics_api_endpoint(self) -> Optional[_builtins.str]:
        """
        The assigned URL for the node's execution client's Prometheus metrics endpoint.
        """
        return pulumi.get(self, "execution_client_prometheus_metrics_api_endpoint")


@pulumi.output_type
class BlockchainNodesEthereumDetailsGethDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "garbageCollectionMode":
            suggest = "garbage_collection_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesEthereumDetailsGethDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesEthereumDetailsGethDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesEthereumDetailsGethDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 garbage_collection_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str garbage_collection_mode: Blockchain garbage collection modes. Only applicable when NodeType is FULL or ARCHIVE.
               Possible values are: `FULL`, `ARCHIVE`.
               
               <a name="nested_ethereum_details_additional_endpoints"></a>The `additional_endpoints` block contains:
        """
        if garbage_collection_mode is not None:
            pulumi.set(__self__, "garbage_collection_mode", garbage_collection_mode)

    @_builtins.property
    @pulumi.getter(name="garbageCollectionMode")
    def garbage_collection_mode(self) -> Optional[_builtins.str]:
        """
        Blockchain garbage collection modes. Only applicable when NodeType is FULL or ARCHIVE.
        Possible values are: `FULL`, `ARCHIVE`.

        <a name="nested_ethereum_details_additional_endpoints"></a>The `additional_endpoints` block contains:
        """
        return pulumi.get(self, "garbage_collection_mode")


@pulumi.output_type
class BlockchainNodesEthereumDetailsValidatorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mevRelayUrls":
            suggest = "mev_relay_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlockchainNodesEthereumDetailsValidatorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlockchainNodesEthereumDetailsValidatorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlockchainNodesEthereumDetailsValidatorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mev_relay_urls: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] mev_relay_urls: URLs for MEV-relay services to use for block building. When set, a managed MEV-boost service is configured on the beacon client.
        """
        if mev_relay_urls is not None:
            pulumi.set(__self__, "mev_relay_urls", mev_relay_urls)

    @_builtins.property
    @pulumi.getter(name="mevRelayUrls")
    def mev_relay_urls(self) -> Optional[Sequence[_builtins.str]]:
        """
        URLs for MEV-relay services to use for block building. When set, a managed MEV-boost service is configured on the beacon client.
        """
        return pulumi.get(self, "mev_relay_urls")


