# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorityArgs', 'Authority']

@pulumi.input_type
class AuthorityArgs:
    def __init__(__self__, *,
                 certificate_authority_id: pulumi.Input[_builtins.str],
                 config: pulumi.Input['AuthorityConfigArgs'],
                 key_spec: pulumi.Input['AuthorityKeySpecArgs'],
                 location: pulumi.Input[_builtins.str],
                 pool: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_active_certificates_on_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 pem_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_grace_period: Optional[pulumi.Input[_builtins.bool]] = None,
                 subordinate_config: Optional[pulumi.Input['AuthoritySubordinateConfigArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_defined_access_urls: Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']] = None):
        """
        The set of arguments for constructing a Authority resource.
        :param pulumi.Input[_builtins.str] certificate_authority_id: The user provided Resource ID for this Certificate Authority.
        :param pulumi.Input['AuthorityConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input['AuthorityKeySpecArgs'] key_spec: Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
               is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
               certificate. Otherwise, it is used to sign a CSR.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[_builtins.str] pool: The name of the CaPool this Certificate Authority belongs to.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
               Possible values: ENABLED, DISABLED, STAGED.
        :param pulumi.Input[_builtins.str] gcs_bucket: The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
               such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
               (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
               my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
               created.
        :param pulumi.Input[_builtins.bool] ignore_active_certificates_on_deletion: This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
               Use with care. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] pem_ca_certificate: The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_grace_period: If this flag is set, the Certificate Authority will be deleted as soon as
               possible without a 30-day grace period where undeletion would have been
               allowed. If you proceed, there will be no way to recover this CA.
               Use with care. Defaults to `false`.
        :param pulumi.Input['AuthoritySubordinateConfigArgs'] subordinate_config: If this is a subordinate CertificateAuthority, this field will be set
               with the subordinate configuration, which describes its issuers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The Type of this CertificateAuthority.
               > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
               be activated before they can issue certificates.
               Default value is `SELF_SIGNED`.
               Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        :param pulumi.Input['AuthorityUserDefinedAccessUrlsArgs'] user_defined_access_urls: Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
               that can be specified by users.
               Structure is documented below.
        """
        pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "key_spec", key_spec)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "pool", pool)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if ignore_active_certificates_on_deletion is not None:
            pulumi.set(__self__, "ignore_active_certificates_on_deletion", ignore_active_certificates_on_deletion)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if pem_ca_certificate is not None:
            pulumi.set(__self__, "pem_ca_certificate", pem_ca_certificate)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if skip_grace_period is not None:
            pulumi.set(__self__, "skip_grace_period", skip_grace_period)
        if subordinate_config is not None:
            pulumi.set(__self__, "subordinate_config", subordinate_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_defined_access_urls is not None:
            pulumi.set(__self__, "user_defined_access_urls", user_defined_access_urls)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user provided Resource ID for this Certificate Authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @certificate_authority_id.setter
    def certificate_authority_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_authority_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['AuthorityConfigArgs']:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['AuthorityConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> pulumi.Input['AuthorityKeySpecArgs']:
        """
        Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
        is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
        certificate. Otherwise, it is used to sign a CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "key_spec")

    @key_spec.setter
    def key_spec(self, value: pulumi.Input['AuthorityKeySpecArgs']):
        pulumi.set(self, "key_spec", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location of the CertificateAuthority. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def pool(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the CaPool this Certificate Authority belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
        Possible values: ENABLED, DISABLED, STAGED.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
        such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
        (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
        my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
        created.
        """
        return pulumi.get(self, "gcs_bucket")

    @gcs_bucket.setter
    def gcs_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcs_bucket", value)

    @_builtins.property
    @pulumi.getter(name="ignoreActiveCertificatesOnDeletion")
    def ignore_active_certificates_on_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_active_certificates_on_deletion")

    @ignore_active_certificates_on_deletion.setter
    def ignore_active_certificates_on_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_active_certificates_on_deletion", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter(name="pemCaCertificate")
    def pem_ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        """
        return pulumi.get(self, "pem_ca_certificate")

    @pem_ca_certificate.setter
    def pem_ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pem_ca_certificate", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="skipGracePeriod")
    def skip_grace_period(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this flag is set, the Certificate Authority will be deleted as soon as
        possible without a 30-day grace period where undeletion would have been
        allowed. If you proceed, there will be no way to recover this CA.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "skip_grace_period")

    @skip_grace_period.setter
    def skip_grace_period(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="subordinateConfig")
    def subordinate_config(self) -> Optional[pulumi.Input['AuthoritySubordinateConfigArgs']]:
        """
        If this is a subordinate CertificateAuthority, this field will be set
        with the subordinate configuration, which describes its issuers.
        Structure is documented below.
        """
        return pulumi.get(self, "subordinate_config")

    @subordinate_config.setter
    def subordinate_config(self, value: Optional[pulumi.Input['AuthoritySubordinateConfigArgs']]):
        pulumi.set(self, "subordinate_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Type of this CertificateAuthority.
        > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
        be activated before they can issue certificates.
        Default value is `SELF_SIGNED`.
        Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userDefinedAccessUrls")
    def user_defined_access_urls(self) -> Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']]:
        """
        Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
        that can be specified by users.
        Structure is documented below.
        """
        return pulumi.get(self, "user_defined_access_urls")

    @user_defined_access_urls.setter
    def user_defined_access_urls(self, value: Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']]):
        pulumi.set(self, "user_defined_access_urls", value)


@pulumi.input_type
class _AuthorityState:
    def __init__(__self__, *,
                 access_urls: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorityAccessUrlArgs']]]] = None,
                 certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input['AuthorityConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gcs_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_active_certificates_on_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input['AuthorityKeySpecArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pem_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 pem_ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pool: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 skip_grace_period: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subordinate_config: Optional[pulumi.Input['AuthoritySubordinateConfigArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 user_defined_access_urls: Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']] = None):
        """
        Input properties used for looking up and filtering Authority resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorityAccessUrlArgs']]] access_urls: URLs for accessing content published by this CA, such as the CA certificate and CRLs.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] certificate_authority_id: The user provided Resource ID for this Certificate Authority.
        :param pulumi.Input['AuthorityConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The time at which this CertificateAuthority was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
               Possible values: ENABLED, DISABLED, STAGED.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] gcs_bucket: The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
               such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
               (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
               my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
               created.
        :param pulumi.Input[_builtins.bool] ignore_active_certificates_on_deletion: This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
               Use with care. Defaults to `false`.
        :param pulumi.Input['AuthorityKeySpecArgs'] key_spec: Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
               is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
               certificate. Otherwise, it is used to sign a CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[_builtins.str] name: The resource name for this CertificateAuthority in the format
               projects/*/locations/*/certificateAuthorities/*.
        :param pulumi.Input[_builtins.str] pem_ca_certificate: The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pem_ca_certificates: This CertificateAuthority's certificate chain, including the current
               CertificateAuthority's certificate. Ordered such that the root issuer is the final
               element (consistent with RFC 5246). For a self-signed CA, this will only list the current
               CertificateAuthority's certificate.
        :param pulumi.Input[_builtins.str] pool: The name of the CaPool this Certificate Authority belongs to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] skip_grace_period: If this flag is set, the Certificate Authority will be deleted as soon as
               possible without a 30-day grace period where undeletion would have been
               allowed. If you proceed, there will be no way to recover this CA.
               Use with care. Defaults to `false`.
        :param pulumi.Input[_builtins.str] state: The State for this CertificateAuthority.
        :param pulumi.Input['AuthoritySubordinateConfigArgs'] subordinate_config: If this is a subordinate CertificateAuthority, this field will be set
               with the subordinate configuration, which describes its issuers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The Type of this CertificateAuthority.
               > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
               be activated before they can issue certificates.
               Default value is `SELF_SIGNED`.
               Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        :param pulumi.Input[_builtins.str] update_time: The time at which this CertificateAuthority was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input['AuthorityUserDefinedAccessUrlsArgs'] user_defined_access_urls: Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
               that can be specified by users.
               Structure is documented below.
        """
        if access_urls is not None:
            pulumi.set(__self__, "access_urls", access_urls)
        if certificate_authority_id is not None:
            pulumi.set(__self__, "certificate_authority_id", certificate_authority_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if ignore_active_certificates_on_deletion is not None:
            pulumi.set(__self__, "ignore_active_certificates_on_deletion", ignore_active_certificates_on_deletion)
        if key_spec is not None:
            pulumi.set(__self__, "key_spec", key_spec)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pem_ca_certificate is not None:
            pulumi.set(__self__, "pem_ca_certificate", pem_ca_certificate)
        if pem_ca_certificates is not None:
            pulumi.set(__self__, "pem_ca_certificates", pem_ca_certificates)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if skip_grace_period is not None:
            pulumi.set(__self__, "skip_grace_period", skip_grace_period)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subordinate_config is not None:
            pulumi.set(__self__, "subordinate_config", subordinate_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if user_defined_access_urls is not None:
            pulumi.set(__self__, "user_defined_access_urls", user_defined_access_urls)

    @_builtins.property
    @pulumi.getter(name="accessUrls")
    def access_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorityAccessUrlArgs']]]]:
        """
        URLs for accessing content published by this CA, such as the CA certificate and CRLs.
        Structure is documented below.
        """
        return pulumi.get(self, "access_urls")

    @access_urls.setter
    def access_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorityAccessUrlArgs']]]]):
        pulumi.set(self, "access_urls", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user provided Resource ID for this Certificate Authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @certificate_authority_id.setter
    def certificate_authority_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AuthorityConfigArgs']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AuthorityConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which this CertificateAuthority was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
        Possible values: ENABLED, DISABLED, STAGED.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
        such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
        (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
        my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
        created.
        """
        return pulumi.get(self, "gcs_bucket")

    @gcs_bucket.setter
    def gcs_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcs_bucket", value)

    @_builtins.property
    @pulumi.getter(name="ignoreActiveCertificatesOnDeletion")
    def ignore_active_certificates_on_deletion(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_active_certificates_on_deletion")

    @ignore_active_certificates_on_deletion.setter
    def ignore_active_certificates_on_deletion(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_active_certificates_on_deletion", value)

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> Optional[pulumi.Input['AuthorityKeySpecArgs']]:
        """
        Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
        is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
        certificate. Otherwise, it is used to sign a CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "key_spec")

    @key_spec.setter
    def key_spec(self, value: Optional[pulumi.Input['AuthorityKeySpecArgs']]):
        pulumi.set(self, "key_spec", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifetime", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of the CertificateAuthority. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for this CertificateAuthority in the format
        projects/*/locations/*/certificateAuthorities/*.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pemCaCertificate")
    def pem_ca_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        """
        return pulumi.get(self, "pem_ca_certificate")

    @pem_ca_certificate.setter
    def pem_ca_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pem_ca_certificate", value)

    @_builtins.property
    @pulumi.getter(name="pemCaCertificates")
    def pem_ca_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This CertificateAuthority's certificate chain, including the current
        CertificateAuthority's certificate. Ordered such that the root issuer is the final
        element (consistent with RFC 5246). For a self-signed CA, this will only list the current
        CertificateAuthority's certificate.
        """
        return pulumi.get(self, "pem_ca_certificates")

    @pem_ca_certificates.setter
    def pem_ca_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pem_ca_certificates", value)

    @_builtins.property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the CaPool this Certificate Authority belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="skipGracePeriod")
    def skip_grace_period(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this flag is set, the Certificate Authority will be deleted as soon as
        possible without a 30-day grace period where undeletion would have been
        allowed. If you proceed, there will be no way to recover this CA.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "skip_grace_period")

    @skip_grace_period.setter
    def skip_grace_period(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_grace_period", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The State for this CertificateAuthority.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subordinateConfig")
    def subordinate_config(self) -> Optional[pulumi.Input['AuthoritySubordinateConfigArgs']]:
        """
        If this is a subordinate CertificateAuthority, this field will be set
        with the subordinate configuration, which describes its issuers.
        Structure is documented below.
        """
        return pulumi.get(self, "subordinate_config")

    @subordinate_config.setter
    def subordinate_config(self, value: Optional[pulumi.Input['AuthoritySubordinateConfigArgs']]):
        pulumi.set(self, "subordinate_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Type of this CertificateAuthority.
        > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
        be activated before they can issue certificates.
        Default value is `SELF_SIGNED`.
        Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which this CertificateAuthority was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="userDefinedAccessUrls")
    def user_defined_access_urls(self) -> Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']]:
        """
        Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
        that can be specified by users.
        Structure is documented below.
        """
        return pulumi.get(self, "user_defined_access_urls")

    @user_defined_access_urls.setter
    def user_defined_access_urls(self, value: Optional[pulumi.Input['AuthorityUserDefinedAccessUrlsArgs']]):
        pulumi.set(self, "user_defined_access_urls", value)


@pulumi.type_token("gcp:certificateauthority/authority:Authority")
class Authority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['AuthorityConfigArgs', 'AuthorityConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_active_certificates_on_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[Union['AuthorityKeySpecArgs', 'AuthorityKeySpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 pem_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 pool: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_grace_period: Optional[pulumi.Input[_builtins.bool]] = None,
                 subordinate_config: Optional[pulumi.Input[Union['AuthoritySubordinateConfigArgs', 'AuthoritySubordinateConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_defined_access_urls: Optional[pulumi.Input[Union['AuthorityUserDefinedAccessUrlsArgs', 'AuthorityUserDefinedAccessUrlsArgsDict']]] = None,
                 __props__=None):
        """
        A CertificateAuthority represents an individual Certificate Authority. A
        CertificateAuthority can be used to create Certificates.

        To get more information about CertificateAuthority, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-authority-service)

        > **Warning:** On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi up` to write the field to state) in order to destroy a CertificateAuthority.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ### Privateca Certificate Authority Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ```
        ### Privateca Certificate Authority Basic No Org

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ```
        ### Privateca Certificate Authority Subordinate

        ```python
        import pulumi
        import pulumi_gcp as gcp

        root_ca = gcp.certificateauthority.Authority("root-ca",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority-root",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority-sub",
            location="us-central1",
            deletion_protection=True,
            subordinate_config={
                "certificate_authority": root_ca.name,
            },
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-subordinate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                        "zero_max_issuer_path_length": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{5 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_2048_SHA256",
            },
            type="SUBORDINATE")
        ```
        ### Privateca Certificate Authority Byo Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        privateca_sa = gcp.projects.ServiceIdentity("privateca_sa", service="privateca.googleapis.com")
        privateca_sa_keyuser_signerverifier = gcp.kms.CryptoKeyIAMMember("privateca_sa_keyuser_signerverifier",
            crypto_key_id="projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key",
            role="roles/cloudkms.signerVerifier",
            member=privateca_sa.member)
        privateca_sa_keyuser_viewer = gcp.kms.CryptoKeyIAMMember("privateca_sa_keyuser_viewer",
            crypto_key_id="projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key",
            role="roles/viewer",
            member=privateca_sa.member)
        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            key_spec={
                "cloud_kms_key_version": "projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key/cryptoKeyVersions/1",
            },
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Example, Org.",
                        "common_name": "Example Authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": ["*.example.com"],
                        "excluded_dns_names": ["*.deny.example.com"],
                        "permitted_ip_ranges": ["10.0.0.0/8"],
                        "excluded_ip_ranges": ["10.1.1.0/24"],
                        "permitted_email_addresses": [".example.com"],
                        "excluded_email_addresses": [".deny.example.com"],
                        "permitted_uris": [".example.com"],
                        "excluded_uris": [".deny.example.com"],
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    privateca_sa_keyuser_signerverifier,
                    privateca_sa_keyuser_viewer,
                ]))
        ```
        ### Privateca Certificate Authority Custom Ski

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "subject_key_id": {
                    "key_id": "4cf3372289b1d411b999dbb9ebcd44744b6b2fca",
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "cloud_kms_key_version": "projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key/cryptoKeyVersions/1",
            })
        ```
        ### Privateca Certificate Authority Basic With Custom Cdp Aia Urls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            user_defined_access_urls={
                "aia_issuing_certificate_urls": [
                    "http://example.com/ca.crt",
                    "http://example.com/anotherca.crt",
                ],
                "crl_access_urls": [
                    "http://example.com/crl1.crt",
                    "http://example.com/crl2.crt",
                ],
            })
        ```

        ## Import

        CertificateAuthority can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}`

        * `{{project}}/{{location}}/{{pool}}/{{certificate_authority_id}}`

        * `{{location}}/{{pool}}/{{certificate_authority_id}}`

        When using the `pulumi import` command, CertificateAuthority can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default {{project}}/{{location}}/{{pool}}/{{certificate_authority_id}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default {{location}}/{{pool}}/{{certificate_authority_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_authority_id: The user provided Resource ID for this Certificate Authority.
        :param pulumi.Input[Union['AuthorityConfigArgs', 'AuthorityConfigArgsDict']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
               Possible values: ENABLED, DISABLED, STAGED.
        :param pulumi.Input[_builtins.str] gcs_bucket: The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
               such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
               (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
               my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
               created.
        :param pulumi.Input[_builtins.bool] ignore_active_certificates_on_deletion: This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
               Use with care. Defaults to `false`.
        :param pulumi.Input[Union['AuthorityKeySpecArgs', 'AuthorityKeySpecArgsDict']] key_spec: Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
               is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
               certificate. Otherwise, it is used to sign a CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[_builtins.str] pem_ca_certificate: The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        :param pulumi.Input[_builtins.str] pool: The name of the CaPool this Certificate Authority belongs to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] skip_grace_period: If this flag is set, the Certificate Authority will be deleted as soon as
               possible without a 30-day grace period where undeletion would have been
               allowed. If you proceed, there will be no way to recover this CA.
               Use with care. Defaults to `false`.
        :param pulumi.Input[Union['AuthoritySubordinateConfigArgs', 'AuthoritySubordinateConfigArgsDict']] subordinate_config: If this is a subordinate CertificateAuthority, this field will be set
               with the subordinate configuration, which describes its issuers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The Type of this CertificateAuthority.
               > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
               be activated before they can issue certificates.
               Default value is `SELF_SIGNED`.
               Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        :param pulumi.Input[Union['AuthorityUserDefinedAccessUrlsArgs', 'AuthorityUserDefinedAccessUrlsArgsDict']] user_defined_access_urls: Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
               that can be specified by users.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A CertificateAuthority represents an individual Certificate Authority. A
        CertificateAuthority can be used to create Certificates.

        To get more information about CertificateAuthority, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-authority-service)

        > **Warning:** On newer versions of the provider, you must explicitly set `deletion_protection=false`
        (and run `pulumi up` to write the field to state) in order to destroy a CertificateAuthority.
        It is recommended to not set this field (or set it to true) until you're ready to destroy.

        ## Example Usage

        ### Privateca Certificate Authority Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ```
        ### Privateca Certificate Authority Basic No Org

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            })
        ```
        ### Privateca Certificate Authority Subordinate

        ```python
        import pulumi
        import pulumi_gcp as gcp

        root_ca = gcp.certificateauthority.Authority("root-ca",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority-root",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            skip_grace_period=True,
            ignore_active_certificates_on_deletion=True)
        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority-sub",
            location="us-central1",
            deletion_protection=True,
            subordinate_config={
                "certificate_authority": root_ca.name,
            },
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-subordinate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                        "zero_max_issuer_path_length": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{5 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_2048_SHA256",
            },
            type="SUBORDINATE")
        ```
        ### Privateca Certificate Authority Byo Key

        ```python
        import pulumi
        import pulumi_gcp as gcp

        privateca_sa = gcp.projects.ServiceIdentity("privateca_sa", service="privateca.googleapis.com")
        privateca_sa_keyuser_signerverifier = gcp.kms.CryptoKeyIAMMember("privateca_sa_keyuser_signerverifier",
            crypto_key_id="projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key",
            role="roles/cloudkms.signerVerifier",
            member=privateca_sa.member)
        privateca_sa_keyuser_viewer = gcp.kms.CryptoKeyIAMMember("privateca_sa_keyuser_viewer",
            crypto_key_id="projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key",
            role="roles/viewer",
            member=privateca_sa.member)
        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            key_spec={
                "cloud_kms_key_version": "projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key/cryptoKeyVersions/1",
            },
            config={
                "subject_config": {
                    "subject": {
                        "organization": "Example, Org.",
                        "common_name": "Example Authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": ["*.example.com"],
                        "excluded_dns_names": ["*.deny.example.com"],
                        "permitted_ip_ranges": ["10.0.0.0/8"],
                        "excluded_ip_ranges": ["10.1.1.0/24"],
                        "permitted_email_addresses": [".example.com"],
                        "excluded_email_addresses": [".deny.example.com"],
                        "permitted_uris": [".example.com"],
                        "excluded_uris": [".deny.example.com"],
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    privateca_sa_keyuser_signerverifier,
                    privateca_sa_keyuser_viewer,
                ]))
        ```
        ### Privateca Certificate Authority Custom Ski

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "subject_key_id": {
                    "key_id": "4cf3372289b1d411b999dbb9ebcd44744b6b2fca",
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "cloud_kms_key_version": "projects/keys-project/locations/us-central1/keyRings/key-ring/cryptoKeys/crypto-key/cryptoKeyVersions/1",
            })
        ```
        ### Privateca Certificate Authority Basic With Custom Cdp Aia Urls

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.Authority("default",
            pool="ca-pool",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            deletion_protection=True,
            config={
                "subject_config": {
                    "subject": {
                        "organization": "ACME",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {},
                    },
                },
            },
            lifetime=f"{10 * 365 * 24 * 3600}s",
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            user_defined_access_urls={
                "aia_issuing_certificate_urls": [
                    "http://example.com/ca.crt",
                    "http://example.com/anotherca.crt",
                ],
                "crl_access_urls": [
                    "http://example.com/crl1.crt",
                    "http://example.com/crl2.crt",
                ],
            })
        ```

        ## Import

        CertificateAuthority can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}`

        * `{{project}}/{{location}}/{{pool}}/{{certificate_authority_id}}`

        * `{{location}}/{{pool}}/{{certificate_authority_id}}`

        When using the `pulumi import` command, CertificateAuthority can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default {{project}}/{{location}}/{{pool}}/{{certificate_authority_id}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/authority:Authority default {{location}}/{{pool}}/{{certificate_authority_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['AuthorityConfigArgs', 'AuthorityConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 gcs_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_active_certificates_on_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_spec: Optional[pulumi.Input[Union['AuthorityKeySpecArgs', 'AuthorityKeySpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifetime: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 pem_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 pool: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_grace_period: Optional[pulumi.Input[_builtins.bool]] = None,
                 subordinate_config: Optional[pulumi.Input[Union['AuthoritySubordinateConfigArgs', 'AuthoritySubordinateConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_defined_access_urls: Optional[pulumi.Input[Union['AuthorityUserDefinedAccessUrlsArgs', 'AuthorityUserDefinedAccessUrlsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorityArgs.__new__(AuthorityArgs)

            if certificate_authority_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_id'")
            __props__.__dict__["certificate_authority_id"] = certificate_authority_id
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["desired_state"] = desired_state
            __props__.__dict__["gcs_bucket"] = gcs_bucket
            __props__.__dict__["ignore_active_certificates_on_deletion"] = ignore_active_certificates_on_deletion
            if key_spec is None and not opts.urn:
                raise TypeError("Missing required property 'key_spec'")
            __props__.__dict__["key_spec"] = key_spec
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lifetime"] = lifetime
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["pem_ca_certificate"] = pem_ca_certificate
            if pool is None and not opts.urn:
                raise TypeError("Missing required property 'pool'")
            __props__.__dict__["pool"] = pool
            __props__.__dict__["project"] = project
            __props__.__dict__["skip_grace_period"] = skip_grace_period
            __props__.__dict__["subordinate_config"] = subordinate_config
            __props__.__dict__["type"] = type
            __props__.__dict__["user_defined_access_urls"] = user_defined_access_urls
            __props__.__dict__["access_urls"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pem_ca_certificates"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Authority, __self__).__init__(
            'gcp:certificateauthority/authority:Authority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorityAccessUrlArgs', 'AuthorityAccessUrlArgsDict']]]]] = None,
            certificate_authority_id: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[Union['AuthorityConfigArgs', 'AuthorityConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gcs_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_active_certificates_on_deletion: Optional[pulumi.Input[_builtins.bool]] = None,
            key_spec: Optional[pulumi.Input[Union['AuthorityKeySpecArgs', 'AuthorityKeySpecArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifetime: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pem_ca_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            pem_ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pool: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            skip_grace_period: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subordinate_config: Optional[pulumi.Input[Union['AuthoritySubordinateConfigArgs', 'AuthoritySubordinateConfigArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            user_defined_access_urls: Optional[pulumi.Input[Union['AuthorityUserDefinedAccessUrlsArgs', 'AuthorityUserDefinedAccessUrlsArgsDict']]] = None) -> 'Authority':
        """
        Get an existing Authority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorityAccessUrlArgs', 'AuthorityAccessUrlArgsDict']]]] access_urls: URLs for accessing content published by this CA, such as the CA certificate and CRLs.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] certificate_authority_id: The user provided Resource ID for this Certificate Authority.
        :param pulumi.Input[Union['AuthorityConfigArgs', 'AuthorityConfigArgsDict']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The time at which this CertificateAuthority was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
               Possible values: ENABLED, DISABLED, STAGED.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] gcs_bucket: The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
               such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
               (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
               my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
               created.
        :param pulumi.Input[_builtins.bool] ignore_active_certificates_on_deletion: This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
               Use with care. Defaults to `false`.
        :param pulumi.Input[Union['AuthorityKeySpecArgs', 'AuthorityKeySpecArgsDict']] key_spec: Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
               is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
               certificate. Otherwise, it is used to sign a CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[_builtins.str] location: Location of the CertificateAuthority. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[_builtins.str] name: The resource name for this CertificateAuthority in the format
               projects/*/locations/*/certificateAuthorities/*.
        :param pulumi.Input[_builtins.str] pem_ca_certificate: The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pem_ca_certificates: This CertificateAuthority's certificate chain, including the current
               CertificateAuthority's certificate. Ordered such that the root issuer is the final
               element (consistent with RFC 5246). For a self-signed CA, this will only list the current
               CertificateAuthority's certificate.
        :param pulumi.Input[_builtins.str] pool: The name of the CaPool this Certificate Authority belongs to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] skip_grace_period: If this flag is set, the Certificate Authority will be deleted as soon as
               possible without a 30-day grace period where undeletion would have been
               allowed. If you proceed, there will be no way to recover this CA.
               Use with care. Defaults to `false`.
        :param pulumi.Input[_builtins.str] state: The State for this CertificateAuthority.
        :param pulumi.Input[Union['AuthoritySubordinateConfigArgs', 'AuthoritySubordinateConfigArgsDict']] subordinate_config: If this is a subordinate CertificateAuthority, this field will be set
               with the subordinate configuration, which describes its issuers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] type: The Type of this CertificateAuthority.
               > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
               be activated before they can issue certificates.
               Default value is `SELF_SIGNED`.
               Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        :param pulumi.Input[_builtins.str] update_time: The time at which this CertificateAuthority was updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[Union['AuthorityUserDefinedAccessUrlsArgs', 'AuthorityUserDefinedAccessUrlsArgsDict']] user_defined_access_urls: Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
               that can be specified by users.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorityState.__new__(_AuthorityState)

        __props__.__dict__["access_urls"] = access_urls
        __props__.__dict__["certificate_authority_id"] = certificate_authority_id
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gcs_bucket"] = gcs_bucket
        __props__.__dict__["ignore_active_certificates_on_deletion"] = ignore_active_certificates_on_deletion
        __props__.__dict__["key_spec"] = key_spec
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["pem_ca_certificate"] = pem_ca_certificate
        __props__.__dict__["pem_ca_certificates"] = pem_ca_certificates
        __props__.__dict__["pool"] = pool
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["skip_grace_period"] = skip_grace_period
        __props__.__dict__["state"] = state
        __props__.__dict__["subordinate_config"] = subordinate_config
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["user_defined_access_urls"] = user_defined_access_urls
        return Authority(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessUrls")
    def access_urls(self) -> pulumi.Output[Sequence['outputs.AuthorityAccessUrl']]:
        """
        URLs for accessing content published by this CA, such as the CA certificate and CRLs.
        Structure is documented below.
        """
        return pulumi.get(self, "access_urls")

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityId")
    def certificate_authority_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user provided Resource ID for this Certificate Authority.
        """
        return pulumi.get(self, "certificate_authority_id")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.AuthorityConfig']:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which this CertificateAuthority was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Desired state of the CertificateAuthority. Set this field to `STAGED` to create a `STAGED` root CA.
        Possible values: ENABLED, DISABLED, STAGED.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
        such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
        (such as `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a bucket named
        my-bucket, you would simply specify `my-bucket`. If not specified, a managed bucket will be
        created.
        """
        return pulumi.get(self, "gcs_bucket")

    @_builtins.property
    @pulumi.getter(name="ignoreActiveCertificatesOnDeletion")
    def ignore_active_certificates_on_deletion(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_active_certificates_on_deletion")

    @_builtins.property
    @pulumi.getter(name="keySpec")
    def key_spec(self) -> pulumi.Output['outputs.AuthorityKeySpec']:
        """
        Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
        is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
        certificate. Otherwise, it is used to sign a CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "key_spec")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location of the CertificateAuthority. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for this CertificateAuthority in the format
        projects/*/locations/*/certificateAuthorities/*.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pemCaCertificate")
    def pem_ca_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
        """
        return pulumi.get(self, "pem_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="pemCaCertificates")
    def pem_ca_certificates(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        This CertificateAuthority's certificate chain, including the current
        CertificateAuthority's certificate. Ordered such that the root issuer is the final
        element (consistent with RFC 5246). For a self-signed CA, this will only list the current
        CertificateAuthority's certificate.
        """
        return pulumi.get(self, "pem_ca_certificates")

    @_builtins.property
    @pulumi.getter
    def pool(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the CaPool this Certificate Authority belongs to.
        """
        return pulumi.get(self, "pool")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="skipGracePeriod")
    def skip_grace_period(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If this flag is set, the Certificate Authority will be deleted as soon as
        possible without a 30-day grace period where undeletion would have been
        allowed. If you proceed, there will be no way to recover this CA.
        Use with care. Defaults to `false`.
        """
        return pulumi.get(self, "skip_grace_period")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The State for this CertificateAuthority.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subordinateConfig")
    def subordinate_config(self) -> pulumi.Output[Optional['outputs.AuthoritySubordinateConfig']]:
        """
        If this is a subordinate CertificateAuthority, this field will be set
        with the subordinate configuration, which describes its issuers.
        Structure is documented below.
        """
        return pulumi.get(self, "subordinate_config")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Type of this CertificateAuthority.
        > **Note:** For `SUBORDINATE` Certificate Authorities, they need to
        be activated before they can issue certificates.
        Default value is `SELF_SIGNED`.
        Possible values are: `SELF_SIGNED`, `SUBORDINATE`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which this CertificateAuthority was updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="userDefinedAccessUrls")
    def user_defined_access_urls(self) -> pulumi.Output[Optional['outputs.AuthorityUserDefinedAccessUrls']]:
        """
        Custom URLs for accessing content published by this CA, such as the CA certificate and CRLs,
        that can be specified by users.
        Structure is documented below.
        """
        return pulumi.get(self, "user_defined_access_urls")

