# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 approval_config: Optional[pulumi.Input['TriggerApprovalConfigArgs']] = None,
                 bitbucket_server_trigger_config: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']] = None,
                 build: Optional[pulumi.Input['TriggerBuildArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 git_file_source: Optional[pulumi.Input['TriggerGitFileSourceArgs']] = None,
                 github: Optional[pulumi.Input['TriggerGithubArgs']] = None,
                 ignored_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 include_build_logs: Optional[pulumi.Input[_builtins.str]] = None,
                 included_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_config: Optional[pulumi.Input['TriggerPubsubConfigArgs']] = None,
                 repository_event_config: Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 source_to_build: Optional[pulumi.Input['TriggerSourceToBuildArgs']] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_template: Optional[pulumi.Input['TriggerTriggerTemplateArgs']] = None,
                 webhook_config: Optional[pulumi.Input['TriggerWebhookConfigArgs']] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input['TriggerApprovalConfigArgs'] approval_config: Configuration for manual approval to start a build invocation of this BuildTrigger.
               Builds created by this trigger will require approval before they execute.
               Any user with a Cloud Build Approver role for the project can approve a build.
               Structure is documented below.
        :param pulumi.Input['TriggerBitbucketServerTriggerConfigArgs'] bitbucket_server_trigger_config: BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildArgs'] build: Contents of the build template. Either a filename or build template must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the trigger.
        :param pulumi.Input[_builtins.bool] disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param pulumi.Input[_builtins.str] filename: Path, from the source root, to a file whose contents is used for the template.
               Either a filename or build template must be provided. Set this only when using trigger_template or github.
               When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        :param pulumi.Input[_builtins.str] filter: A Common Expression Language string. Used only with Pub/Sub and Webhook.
        :param pulumi.Input['TriggerGitFileSourceArgs'] git_file_source: The file source describing the local or remote Build template.
               Structure is documented below.
        :param pulumi.Input['TriggerGithubArgs'] github: Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
               One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If ignoredFiles and changed files are both empty, then they are not
               used to determine whether or not to trigger a build.
               If ignoredFiles is not empty, then we ignore any files that match any
               of the ignored_file globs. If the change has no files that are outside
               of the ignoredFiles globs, then we do not trigger a build.
        :param pulumi.Input[_builtins.str] include_build_logs: Build logs will be sent back to GitHub as part of the checkrun
               result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
               INCLUDE_BUILD_LOGS_WITH_STATUS
               Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is empty, then as far as this filter is concerned, we
               should trigger the build.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is not empty, then we make sure that at least one of
               those files matches a includedFiles glob. If not, then we do not trigger
               a build.
        :param pulumi.Input[_builtins.str] location: The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
               If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the trigger. Must be unique within the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['TriggerPubsubConfigArgs'] pubsub_config: PubsubConfig describes the configuration of a trigger that creates
               a build whenever a Pub/Sub message is published.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input['TriggerRepositoryEventConfigArgs'] repository_event_config: The configuration of a trigger that creates a build whenever an event from Repo API is received.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account: The service account used for all user-controlled operations including
               triggers.patch, triggers.run, builds.create, and builds.cancel.
               If no service account is set, then the standard Cloud Build service account
               ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
               Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        :param pulumi.Input['TriggerSourceToBuildArgs'] source_to_build: The repo and ref of the repository from which to build.
               This field is used only for those triggers that do not respond to SCM events.
               Triggers that respond to such events build source at whatever commit caused the event.
               This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] substitutions: Substitutions data for Build resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for annotation of a BuildTrigger
        :param pulumi.Input['TriggerTriggerTemplateArgs'] trigger_template: Template describing the types of source changes to trigger a build.
               Branch and tag names in trigger templates are interpreted as regular
               expressions. Any branch or tag change that matches that regular
               expression will trigger a build.
               One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input['TriggerWebhookConfigArgs'] webhook_config: WebhookConfig describes the configuration of a trigger that creates
               a build whenever a webhook is sent to a trigger's webhook URL.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        """
        if approval_config is not None:
            pulumi.set(__self__, "approval_config", approval_config)
        if bitbucket_server_trigger_config is not None:
            pulumi.set(__self__, "bitbucket_server_trigger_config", bitbucket_server_trigger_config)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if git_file_source is not None:
            pulumi.set(__self__, "git_file_source", git_file_source)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if ignored_files is not None:
            pulumi.set(__self__, "ignored_files", ignored_files)
        if include_build_logs is not None:
            pulumi.set(__self__, "include_build_logs", include_build_logs)
        if included_files is not None:
            pulumi.set(__self__, "included_files", included_files)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_config is not None:
            pulumi.set(__self__, "pubsub_config", pubsub_config)
        if repository_event_config is not None:
            pulumi.set(__self__, "repository_event_config", repository_event_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source_to_build is not None:
            pulumi.set(__self__, "source_to_build", source_to_build)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trigger_template is not None:
            pulumi.set(__self__, "trigger_template", trigger_template)
        if webhook_config is not None:
            pulumi.set(__self__, "webhook_config", webhook_config)

    @_builtins.property
    @pulumi.getter(name="approvalConfig")
    def approval_config(self) -> Optional[pulumi.Input['TriggerApprovalConfigArgs']]:
        """
        Configuration for manual approval to start a build invocation of this BuildTrigger.
        Builds created by this trigger will require approval before they execute.
        Any user with a Cloud Build Approver role for the project can approve a build.
        Structure is documented below.
        """
        return pulumi.get(self, "approval_config")

    @approval_config.setter
    def approval_config(self, value: Optional[pulumi.Input['TriggerApprovalConfigArgs']]):
        pulumi.set(self, "approval_config", value)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerTriggerConfig")
    def bitbucket_server_trigger_config(self) -> Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']]:
        """
        BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_server_trigger_config")

    @bitbucket_server_trigger_config.setter
    def bitbucket_server_trigger_config(self, value: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']]):
        pulumi.set(self, "bitbucket_server_trigger_config", value)

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['TriggerBuildArgs']]:
        """
        Contents of the build template. Either a filename or build template must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['TriggerBuildArgs']]):
        pulumi.set(self, "build", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path, from the source root, to a file whose contents is used for the template.
        Either a filename or build template must be provided. Set this only when using trigger_template or github.
        When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Common Expression Language string. Used only with Pub/Sub and Webhook.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="gitFileSource")
    def git_file_source(self) -> Optional[pulumi.Input['TriggerGitFileSourceArgs']]:
        """
        The file source describing the local or remote Build template.
        Structure is documented below.
        """
        return pulumi.get(self, "git_file_source")

    @git_file_source.setter
    def git_file_source(self, value: Optional[pulumi.Input['TriggerGitFileSourceArgs']]):
        pulumi.set(self, "git_file_source", value)

    @_builtins.property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['TriggerGithubArgs']]:
        """
        Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
        One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['TriggerGithubArgs']]):
        pulumi.set(self, "github", value)

    @_builtins.property
    @pulumi.getter(name="ignoredFiles")
    def ignored_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If ignoredFiles and changed files are both empty, then they are not
        used to determine whether or not to trigger a build.
        If ignoredFiles is not empty, then we ignore any files that match any
        of the ignored_file globs. If the change has no files that are outside
        of the ignoredFiles globs, then we do not trigger a build.
        """
        return pulumi.get(self, "ignored_files")

    @ignored_files.setter
    def ignored_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignored_files", value)

    @_builtins.property
    @pulumi.getter(name="includeBuildLogs")
    def include_build_logs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Build logs will be sent back to GitHub as part of the checkrun
        result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
        INCLUDE_BUILD_LOGS_WITH_STATUS
        Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        """
        return pulumi.get(self, "include_build_logs")

    @include_build_logs.setter
    def include_build_logs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_build_logs", value)

    @_builtins.property
    @pulumi.getter(name="includedFiles")
    def included_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is empty, then as far as this filter is concerned, we
        should trigger the build.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is not empty, then we make sure that at least one of
        those files matches a includedFiles glob. If not, then we do not trigger
        a build.
        """
        return pulumi.get(self, "included_files")

    @included_files.setter
    def included_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_files", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
        If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the trigger. Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pubsubConfig")
    def pubsub_config(self) -> Optional[pulumi.Input['TriggerPubsubConfigArgs']]:
        """
        PubsubConfig describes the configuration of a trigger that creates
        a build whenever a Pub/Sub message is published.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_config")

    @pubsub_config.setter
    def pubsub_config(self, value: Optional[pulumi.Input['TriggerPubsubConfigArgs']]):
        pulumi.set(self, "pubsub_config", value)

    @_builtins.property
    @pulumi.getter(name="repositoryEventConfig")
    def repository_event_config(self) -> Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']]:
        """
        The configuration of a trigger that creates a build whenever an event from Repo API is received.
        Structure is documented below.
        """
        return pulumi.get(self, "repository_event_config")

    @repository_event_config.setter
    def repository_event_config(self, value: Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']]):
        pulumi.set(self, "repository_event_config", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account used for all user-controlled operations including
        triggers.patch, triggers.run, builds.create, and builds.cancel.
        If no service account is set, then the standard Cloud Build service account
        ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
        Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="sourceToBuild")
    def source_to_build(self) -> Optional[pulumi.Input['TriggerSourceToBuildArgs']]:
        """
        The repo and ref of the repository from which to build.
        This field is used only for those triggers that do not respond to SCM events.
        Triggers that respond to such events build source at whatever commit caused the event.
        This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source_to_build")

    @source_to_build.setter
    def source_to_build(self, value: Optional[pulumi.Input['TriggerSourceToBuildArgs']]):
        pulumi.set(self, "source_to_build", value)

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "substitutions", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for annotation of a BuildTrigger
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="triggerTemplate")
    def trigger_template(self) -> Optional[pulumi.Input['TriggerTriggerTemplateArgs']]:
        """
        Template describing the types of source changes to trigger a build.
        Branch and tag names in trigger templates are interpreted as regular
        expressions. Any branch or tag change that matches that regular
        expression will trigger a build.
        One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_template")

    @trigger_template.setter
    def trigger_template(self, value: Optional[pulumi.Input['TriggerTriggerTemplateArgs']]):
        pulumi.set(self, "trigger_template", value)

    @_builtins.property
    @pulumi.getter(name="webhookConfig")
    def webhook_config(self) -> Optional[pulumi.Input['TriggerWebhookConfigArgs']]:
        """
        WebhookConfig describes the configuration of a trigger that creates
        a build whenever a webhook is sent to a trigger's webhook URL.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "webhook_config")

    @webhook_config.setter
    def webhook_config(self, value: Optional[pulumi.Input['TriggerWebhookConfigArgs']]):
        pulumi.set(self, "webhook_config", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 approval_config: Optional[pulumi.Input['TriggerApprovalConfigArgs']] = None,
                 bitbucket_server_trigger_config: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']] = None,
                 build: Optional[pulumi.Input['TriggerBuildArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 git_file_source: Optional[pulumi.Input['TriggerGitFileSourceArgs']] = None,
                 github: Optional[pulumi.Input['TriggerGithubArgs']] = None,
                 ignored_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 include_build_logs: Optional[pulumi.Input[_builtins.str]] = None,
                 included_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_config: Optional[pulumi.Input['TriggerPubsubConfigArgs']] = None,
                 repository_event_config: Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 source_to_build: Optional[pulumi.Input['TriggerSourceToBuildArgs']] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_template: Optional[pulumi.Input['TriggerTriggerTemplateArgs']] = None,
                 webhook_config: Optional[pulumi.Input['TriggerWebhookConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input['TriggerApprovalConfigArgs'] approval_config: Configuration for manual approval to start a build invocation of this BuildTrigger.
               Builds created by this trigger will require approval before they execute.
               Any user with a Cloud Build Approver role for the project can approve a build.
               Structure is documented below.
        :param pulumi.Input['TriggerBitbucketServerTriggerConfigArgs'] bitbucket_server_trigger_config: BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildArgs'] build: Contents of the build template. Either a filename or build template must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time when the trigger was created.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the trigger.
        :param pulumi.Input[_builtins.bool] disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param pulumi.Input[_builtins.str] filename: Path, from the source root, to a file whose contents is used for the template.
               Either a filename or build template must be provided. Set this only when using trigger_template or github.
               When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        :param pulumi.Input[_builtins.str] filter: A Common Expression Language string. Used only with Pub/Sub and Webhook.
        :param pulumi.Input['TriggerGitFileSourceArgs'] git_file_source: The file source describing the local or remote Build template.
               Structure is documented below.
        :param pulumi.Input['TriggerGithubArgs'] github: Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
               One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If ignoredFiles and changed files are both empty, then they are not
               used to determine whether or not to trigger a build.
               If ignoredFiles is not empty, then we ignore any files that match any
               of the ignored_file globs. If the change has no files that are outside
               of the ignoredFiles globs, then we do not trigger a build.
        :param pulumi.Input[_builtins.str] include_build_logs: Build logs will be sent back to GitHub as part of the checkrun
               result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
               INCLUDE_BUILD_LOGS_WITH_STATUS
               Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is empty, then as far as this filter is concerned, we
               should trigger the build.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is not empty, then we make sure that at least one of
               those files matches a includedFiles glob. If not, then we do not trigger
               a build.
        :param pulumi.Input[_builtins.str] location: The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
               If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the trigger. Must be unique within the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['TriggerPubsubConfigArgs'] pubsub_config: PubsubConfig describes the configuration of a trigger that creates
               a build whenever a Pub/Sub message is published.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input['TriggerRepositoryEventConfigArgs'] repository_event_config: The configuration of a trigger that creates a build whenever an event from Repo API is received.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account: The service account used for all user-controlled operations including
               triggers.patch, triggers.run, builds.create, and builds.cancel.
               If no service account is set, then the standard Cloud Build service account
               ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
               Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        :param pulumi.Input['TriggerSourceToBuildArgs'] source_to_build: The repo and ref of the repository from which to build.
               This field is used only for those triggers that do not respond to SCM events.
               Triggers that respond to such events build source at whatever commit caused the event.
               This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] substitutions: Substitutions data for Build resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for annotation of a BuildTrigger
        :param pulumi.Input[_builtins.str] trigger_id: The unique identifier for the trigger.
        :param pulumi.Input['TriggerTriggerTemplateArgs'] trigger_template: Template describing the types of source changes to trigger a build.
               Branch and tag names in trigger templates are interpreted as regular
               expressions. Any branch or tag change that matches that regular
               expression will trigger a build.
               One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input['TriggerWebhookConfigArgs'] webhook_config: WebhookConfig describes the configuration of a trigger that creates
               a build whenever a webhook is sent to a trigger's webhook URL.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        """
        if approval_config is not None:
            pulumi.set(__self__, "approval_config", approval_config)
        if bitbucket_server_trigger_config is not None:
            pulumi.set(__self__, "bitbucket_server_trigger_config", bitbucket_server_trigger_config)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if git_file_source is not None:
            pulumi.set(__self__, "git_file_source", git_file_source)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if ignored_files is not None:
            pulumi.set(__self__, "ignored_files", ignored_files)
        if include_build_logs is not None:
            pulumi.set(__self__, "include_build_logs", include_build_logs)
        if included_files is not None:
            pulumi.set(__self__, "included_files", included_files)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_config is not None:
            pulumi.set(__self__, "pubsub_config", pubsub_config)
        if repository_event_config is not None:
            pulumi.set(__self__, "repository_event_config", repository_event_config)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source_to_build is not None:
            pulumi.set(__self__, "source_to_build", source_to_build)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if trigger_template is not None:
            pulumi.set(__self__, "trigger_template", trigger_template)
        if webhook_config is not None:
            pulumi.set(__self__, "webhook_config", webhook_config)

    @_builtins.property
    @pulumi.getter(name="approvalConfig")
    def approval_config(self) -> Optional[pulumi.Input['TriggerApprovalConfigArgs']]:
        """
        Configuration for manual approval to start a build invocation of this BuildTrigger.
        Builds created by this trigger will require approval before they execute.
        Any user with a Cloud Build Approver role for the project can approve a build.
        Structure is documented below.
        """
        return pulumi.get(self, "approval_config")

    @approval_config.setter
    def approval_config(self, value: Optional[pulumi.Input['TriggerApprovalConfigArgs']]):
        pulumi.set(self, "approval_config", value)

    @_builtins.property
    @pulumi.getter(name="bitbucketServerTriggerConfig")
    def bitbucket_server_trigger_config(self) -> Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']]:
        """
        BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_server_trigger_config")

    @bitbucket_server_trigger_config.setter
    def bitbucket_server_trigger_config(self, value: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigArgs']]):
        pulumi.set(self, "bitbucket_server_trigger_config", value)

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['TriggerBuildArgs']]:
        """
        Contents of the build template. Either a filename or build template must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['TriggerBuildArgs']]):
        pulumi.set(self, "build", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the trigger was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path, from the source root, to a file whose contents is used for the template.
        Either a filename or build template must be provided. Set this only when using trigger_template or github.
        When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filename", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Common Expression Language string. Used only with Pub/Sub and Webhook.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="gitFileSource")
    def git_file_source(self) -> Optional[pulumi.Input['TriggerGitFileSourceArgs']]:
        """
        The file source describing the local or remote Build template.
        Structure is documented below.
        """
        return pulumi.get(self, "git_file_source")

    @git_file_source.setter
    def git_file_source(self, value: Optional[pulumi.Input['TriggerGitFileSourceArgs']]):
        pulumi.set(self, "git_file_source", value)

    @_builtins.property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['TriggerGithubArgs']]:
        """
        Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
        One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['TriggerGithubArgs']]):
        pulumi.set(self, "github", value)

    @_builtins.property
    @pulumi.getter(name="ignoredFiles")
    def ignored_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If ignoredFiles and changed files are both empty, then they are not
        used to determine whether or not to trigger a build.
        If ignoredFiles is not empty, then we ignore any files that match any
        of the ignored_file globs. If the change has no files that are outside
        of the ignoredFiles globs, then we do not trigger a build.
        """
        return pulumi.get(self, "ignored_files")

    @ignored_files.setter
    def ignored_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignored_files", value)

    @_builtins.property
    @pulumi.getter(name="includeBuildLogs")
    def include_build_logs(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Build logs will be sent back to GitHub as part of the checkrun
        result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
        INCLUDE_BUILD_LOGS_WITH_STATUS
        Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        """
        return pulumi.get(self, "include_build_logs")

    @include_build_logs.setter
    def include_build_logs(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_build_logs", value)

    @_builtins.property
    @pulumi.getter(name="includedFiles")
    def included_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is empty, then as far as this filter is concerned, we
        should trigger the build.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is not empty, then we make sure that at least one of
        those files matches a includedFiles glob. If not, then we do not trigger
        a build.
        """
        return pulumi.get(self, "included_files")

    @included_files.setter
    def included_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_files", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
        If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the trigger. Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pubsubConfig")
    def pubsub_config(self) -> Optional[pulumi.Input['TriggerPubsubConfigArgs']]:
        """
        PubsubConfig describes the configuration of a trigger that creates
        a build whenever a Pub/Sub message is published.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_config")

    @pubsub_config.setter
    def pubsub_config(self, value: Optional[pulumi.Input['TriggerPubsubConfigArgs']]):
        pulumi.set(self, "pubsub_config", value)

    @_builtins.property
    @pulumi.getter(name="repositoryEventConfig")
    def repository_event_config(self) -> Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']]:
        """
        The configuration of a trigger that creates a build whenever an event from Repo API is received.
        Structure is documented below.
        """
        return pulumi.get(self, "repository_event_config")

    @repository_event_config.setter
    def repository_event_config(self, value: Optional[pulumi.Input['TriggerRepositoryEventConfigArgs']]):
        pulumi.set(self, "repository_event_config", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account used for all user-controlled operations including
        triggers.patch, triggers.run, builds.create, and builds.cancel.
        If no service account is set, then the standard Cloud Build service account
        ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
        Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="sourceToBuild")
    def source_to_build(self) -> Optional[pulumi.Input['TriggerSourceToBuildArgs']]:
        """
        The repo and ref of the repository from which to build.
        This field is used only for those triggers that do not respond to SCM events.
        Triggers that respond to such events build source at whatever commit caused the event.
        This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source_to_build")

    @source_to_build.setter
    def source_to_build(self, value: Optional[pulumi.Input['TriggerSourceToBuildArgs']]):
        pulumi.set(self, "source_to_build", value)

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "substitutions", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags for annotation of a BuildTrigger
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the trigger.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter(name="triggerTemplate")
    def trigger_template(self) -> Optional[pulumi.Input['TriggerTriggerTemplateArgs']]:
        """
        Template describing the types of source changes to trigger a build.
        Branch and tag names in trigger templates are interpreted as regular
        expressions. Any branch or tag change that matches that regular
        expression will trigger a build.
        One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_template")

    @trigger_template.setter
    def trigger_template(self, value: Optional[pulumi.Input['TriggerTriggerTemplateArgs']]):
        pulumi.set(self, "trigger_template", value)

    @_builtins.property
    @pulumi.getter(name="webhookConfig")
    def webhook_config(self) -> Optional[pulumi.Input['TriggerWebhookConfigArgs']]:
        """
        WebhookConfig describes the configuration of a trigger that creates
        a build whenever a webhook is sent to a trigger's webhook URL.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "webhook_config")

    @webhook_config.setter
    def webhook_config(self, value: Optional[pulumi.Input['TriggerWebhookConfigArgs']]):
        pulumi.set(self, "webhook_config", value)


@pulumi.type_token("gcp:cloudbuild/trigger:Trigger")
class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_config: Optional[pulumi.Input[Union['TriggerApprovalConfigArgs', 'TriggerApprovalConfigArgsDict']]] = None,
                 bitbucket_server_trigger_config: Optional[pulumi.Input[Union['TriggerBitbucketServerTriggerConfigArgs', 'TriggerBitbucketServerTriggerConfigArgsDict']]] = None,
                 build: Optional[pulumi.Input[Union['TriggerBuildArgs', 'TriggerBuildArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 git_file_source: Optional[pulumi.Input[Union['TriggerGitFileSourceArgs', 'TriggerGitFileSourceArgsDict']]] = None,
                 github: Optional[pulumi.Input[Union['TriggerGithubArgs', 'TriggerGithubArgsDict']]] = None,
                 ignored_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 include_build_logs: Optional[pulumi.Input[_builtins.str]] = None,
                 included_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_config: Optional[pulumi.Input[Union['TriggerPubsubConfigArgs', 'TriggerPubsubConfigArgsDict']]] = None,
                 repository_event_config: Optional[pulumi.Input[Union['TriggerRepositoryEventConfigArgs', 'TriggerRepositoryEventConfigArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 source_to_build: Optional[pulumi.Input[Union['TriggerSourceToBuildArgs', 'TriggerSourceToBuildArgsDict']]] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_template: Optional[pulumi.Input[Union['TriggerTriggerTemplateArgs', 'TriggerTriggerTemplateArgsDict']]] = None,
                 webhook_config: Optional[pulumi.Input[Union['TriggerWebhookConfigArgs', 'TriggerWebhookConfigArgsDict']]] = None,
                 __props__=None):
        """
        Configuration for an automated build in response to source repository changes.

        To get more information about Trigger, see:

        * [API documentation](https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.triggers)
        * How-to Guides
            * [Automating builds using build triggers](https://cloud.google.com/cloud-build/docs/running-builds/automate-builds)

        > **Note:** You can retrieve the email of the Cloud Build Service Account used in jobs by using the `projects.ServiceIdentity` resource.

        ## Example Usage

        ### Cloudbuild Trigger Filename

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filename_trigger = gcp.cloudbuild.Trigger("filename-trigger",
            location="us-central1",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            substitutions={
                "_FOO": "bar",
                "_BAZ": "qux",
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Build

        ```python
        import pulumi
        import pulumi_gcp as gcp

        build_trigger = gcp.cloudbuild.Trigger("build-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [
                    {
                        "name": "gcr.io/cloud-builders/gsutil",
                        "args": [
                            "cp",
                            "gs://mybucket/remotefile.zip",
                            "localfile.zip",
                        ],
                        "timeout": "120s",
                        "secret_envs": ["MY_SECRET"],
                    },
                    {
                        "name": "ubuntu",
                        "script": "echo hello",
                    },
                ],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                    "npm_packages": [{
                        "package_path": "package.json",
                        "repository": "https://us-west1-npm.pkg.dev/myProject/quickstart-nodejs-repo",
                    }],
                    "python_packages": [{
                        "paths": ["dist/*"],
                        "repository": "https://us-west1-python.pkg.dev/myProject/quickstart-python-repo",
                    }],
                    "maven_artifacts": [{
                        "repository": "https://us-west1-maven.pkg.dev/myProject/quickstart-java-repo",
                        "path": "/workspace/my-app/target/my-app-1.0.SNAPSHOT.jar",
                        "artifact_id": "my-app",
                        "group_id": "com.mycompany.app",
                        "version": "1.0",
                    }],
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudbuild_service_account = gcp.serviceaccount.Account("cloudbuild_service_account", account_id="cloud-sa")
        act_as = gcp.projects.IAMMember("act_as",
            project=project.project_id,
            role="roles/iam.serviceAccountUser",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logs_writer",
            project=project.project_id,
            role="roles/logging.logWriter",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        service_account_trigger = gcp.cloudbuild.Trigger("service-account-trigger",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            service_account=cloudbuild_service_account.id,
            filename="cloudbuild.yaml",
            opts = pulumi.ResourceOptions(depends_on=[
                    act_as,
                    logs_writer,
                ]))
        ```
        ### Cloudbuild Trigger Include Build Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        include_build_logs_trigger = gcp.cloudbuild.Trigger("include-build-logs-trigger",
            location="us-central1",
            name="include-build-logs-trigger",
            filename="cloudbuild.yaml",
            github={
                "owner": "hashicorp",
                "name": "terraform-provider-google-beta",
                "push": {
                    "branch": "^main$",
                },
            },
            include_build_logs="INCLUDE_BUILD_LOGS_WITH_STATUS")
        ```
        ### Cloudbuild Trigger Pubsub Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        mytopic = gcp.pubsub.Topic("mytopic", name="my-topic")
        pubsub_config_trigger = gcp.cloudbuild.Trigger("pubsub-config-trigger",
            location="us-central1",
            name="pubsub-trigger",
            description="acceptance test example pubsub build trigger",
            pubsub_config={
                "topic": mytopic.id,
            },
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            substitutions={
                "_ACTION": "$(body.message.data.action)",
            },
            filter="_ACTION.matches('INSERT')")
        ```
        ### Cloudbuild Trigger Webhook Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        webhook_trigger_secret_key = gcp.secretmanager.Secret("webhook_trigger_secret_key",
            secret_id="webhook-trigger-secret-key",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        webhook_trigger_secret_key_data = gcp.secretmanager.SecretVersion("webhook_trigger_secret_key_data",
            secret=webhook_trigger_secret_key.id,
            secret_data="secretkeygoeshere")
        project = gcp.organizations.get_project()
        secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": [f"serviceAccount:service-{project.number}@gcp-sa-cloudbuild.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            project=webhook_trigger_secret_key.project,
            secret_id=webhook_trigger_secret_key.secret_id,
            policy_data=secret_accessor.policy_data)
        webhook_config_trigger = gcp.cloudbuild.Trigger("webhook-config-trigger",
            name="webhook-trigger",
            description="acceptance test example webhook build trigger",
            webhook_config={
                "secret": webhook_trigger_secret_key_data.id,
            },
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            })
        ```
        ### Cloudbuild Trigger Manual

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_trigger = gcp.cloudbuild.Trigger("manual-trigger",
            name="manual-trigger",
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            approval_config={
                "approval_required": True,
            })
        ```
        ### Cloudbuild Trigger Manual Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_ghe_trigger = gcp.cloudbuild.Trigger("manual-ghe-trigger",
            name="my-trigger",
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
                "github_enterprise_config": "projects/myProject/locations/global/githubEnterpriseConfigs/configID",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
                "github_enterprise_config": "projects/myProject/locations/global/githubEnterpriseConfigs/configID",
            })
        ```
        ### Cloudbuild Trigger Manual Bitbucket Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_bitbucket_trigger = gcp.cloudbuild.Trigger("manual-bitbucket-trigger",
            name="terraform-manual-bbs-trigger",
            source_to_build={
                "uri": "https://bbs.com/scm/stag/test-repo.git",
                "ref": "refs/heads/main",
                "repo_type": "BITBUCKET_SERVER",
                "bitbucket_server_config": "projects/myProject/locations/global/bitbucketServerConfigs/configID",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://bbs.com/scm/stag/test-repo.git",
                "revision": "refs/heads/main",
                "repo_type": "BITBUCKET_SERVER",
                "bitbucket_server_config": "projects/myProject/locations/global/bitbucketServerConfigs/configID",
            })
        ```
        ### Cloudbuild Trigger Repo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.cloudbuildv2.Connection("my-connection",
            location="us-central1",
            name="my-connection",
            github_config={
                "app_installation_id": 123123,
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/my-project/secrets/github-pat-secret/versions/latest",
                },
            })
        my_repository = gcp.cloudbuildv2.Repository("my-repository",
            name="my-repo",
            parent_connection=my_connection.id,
            remote_uri="https://github.com/myuser/my-repo.git")
        repo_trigger = gcp.cloudbuild.Trigger("repo-trigger",
            location="us-central1",
            repository_event_config={
                "repository": my_repository.id,
                "push": {
                    "branch": "feature-.*",
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Bitbucket Server Push

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_push_trigger = gcp.cloudbuild.Trigger("bbs-push-trigger",
            name="bbs-push-trigger",
            location="us-central1",
            bitbucket_server_trigger_config={
                "repo_slug": "bbs-push-trigger",
                "project_key": "STAG",
                "bitbucket_server_config_resource": "projects/123456789/locations/us-central1/bitbucketServerConfigs/myBitbucketConfig",
                "push": {
                    "tag": "^0.1.*",
                    "invert_regex": True,
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Bitbucket Server Pull Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_pull_request_trigger = gcp.cloudbuild.Trigger("bbs-pull-request-trigger",
            name="ghe-trigger",
            location="us-central1",
            bitbucket_server_trigger_config={
                "repo_slug": "terraform-provider-google",
                "project_key": "STAG",
                "bitbucket_server_config_resource": "projects/123456789/locations/us-central1/bitbucketServerConfigs/myBitbucketConfig",
                "pull_request": {
                    "branch": "^master$",
                    "invert_regex": False,
                    "comment_control": "COMMENTS_ENABLED",
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ghe_trigger = gcp.cloudbuild.Trigger("ghe-trigger",
            name="ghe-trigger",
            location="us-central1",
            github={
                "owner": "hashicorp",
                "name": "terraform-provider-google",
                "push": {
                    "branch": "^main$",
                },
                "enterprise_config_resource_name": "projects/123456789/locations/us-central1/githubEnterpriseConfigs/configID",
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Allow Failure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        allow_failure_trigger = gcp.cloudbuild.Trigger("allow-failure-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [{
                    "name": "ubuntu",
                    "args": [
                        "-c",
                        "exit 1",
                    ],
                    "allow_failure": True,
                }],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Allow Exit Codes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        allow_exit_codes_trigger = gcp.cloudbuild.Trigger("allow-exit-codes-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [{
                    "name": "ubuntu",
                    "args": [
                        "-c",
                        "exit 1",
                    ],
                    "allow_exit_codes": [
                        1,
                        3,
                    ],
                }],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Pubsub With Repo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.cloudbuildv2.Connection("my-connection",
            location="us-central1",
            name="my-connection",
            github_config={
                "app_installation_id": 123123,
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/my-project/secrets/github-pat-secret/versions/latest",
                },
            })
        my_repository = gcp.cloudbuildv2.Repository("my-repository",
            name="my-repo",
            parent_connection=my_connection.id,
            remote_uri="https://github.com/myuser/my-repo.git")
        mytopic = gcp.pubsub.Topic("mytopic", name="my-topic")
        pubsub_with_repo_trigger = gcp.cloudbuild.Trigger("pubsub-with-repo-trigger",
            name="pubsub-with-repo-trigger",
            location="us-central1",
            pubsub_config={
                "topic": mytopic.id,
            },
            source_to_build={
                "repository": my_repository.id,
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "repository": my_repository.id,
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            })
        ```

        ## Import

        Trigger can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}`

        * `projects/{{project}}/triggers/{{trigger_id}}`

        * `{{project}}/{{trigger_id}}`

        * `{{trigger_id}}`

        When using the `pulumi import` command, Trigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default projects/{{project}}/triggers/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default {{project}}/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default {{trigger_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TriggerApprovalConfigArgs', 'TriggerApprovalConfigArgsDict']] approval_config: Configuration for manual approval to start a build invocation of this BuildTrigger.
               Builds created by this trigger will require approval before they execute.
               Any user with a Cloud Build Approver role for the project can approve a build.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerBitbucketServerTriggerConfigArgs', 'TriggerBitbucketServerTriggerConfigArgsDict']] bitbucket_server_trigger_config: BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerBuildArgs', 'TriggerBuildArgsDict']] build: Contents of the build template. Either a filename or build template must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the trigger.
        :param pulumi.Input[_builtins.bool] disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param pulumi.Input[_builtins.str] filename: Path, from the source root, to a file whose contents is used for the template.
               Either a filename or build template must be provided. Set this only when using trigger_template or github.
               When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        :param pulumi.Input[_builtins.str] filter: A Common Expression Language string. Used only with Pub/Sub and Webhook.
        :param pulumi.Input[Union['TriggerGitFileSourceArgs', 'TriggerGitFileSourceArgsDict']] git_file_source: The file source describing the local or remote Build template.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerGithubArgs', 'TriggerGithubArgsDict']] github: Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
               One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If ignoredFiles and changed files are both empty, then they are not
               used to determine whether or not to trigger a build.
               If ignoredFiles is not empty, then we ignore any files that match any
               of the ignored_file globs. If the change has no files that are outside
               of the ignoredFiles globs, then we do not trigger a build.
        :param pulumi.Input[_builtins.str] include_build_logs: Build logs will be sent back to GitHub as part of the checkrun
               result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
               INCLUDE_BUILD_LOGS_WITH_STATUS
               Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is empty, then as far as this filter is concerned, we
               should trigger the build.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is not empty, then we make sure that at least one of
               those files matches a includedFiles glob. If not, then we do not trigger
               a build.
        :param pulumi.Input[_builtins.str] location: The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
               If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the trigger. Must be unique within the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['TriggerPubsubConfigArgs', 'TriggerPubsubConfigArgsDict']] pubsub_config: PubsubConfig describes the configuration of a trigger that creates
               a build whenever a Pub/Sub message is published.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerRepositoryEventConfigArgs', 'TriggerRepositoryEventConfigArgsDict']] repository_event_config: The configuration of a trigger that creates a build whenever an event from Repo API is received.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account: The service account used for all user-controlled operations including
               triggers.patch, triggers.run, builds.create, and builds.cancel.
               If no service account is set, then the standard Cloud Build service account
               ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
               Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        :param pulumi.Input[Union['TriggerSourceToBuildArgs', 'TriggerSourceToBuildArgsDict']] source_to_build: The repo and ref of the repository from which to build.
               This field is used only for those triggers that do not respond to SCM events.
               Triggers that respond to such events build source at whatever commit caused the event.
               This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] substitutions: Substitutions data for Build resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for annotation of a BuildTrigger
        :param pulumi.Input[Union['TriggerTriggerTemplateArgs', 'TriggerTriggerTemplateArgsDict']] trigger_template: Template describing the types of source changes to trigger a build.
               Branch and tag names in trigger templates are interpreted as regular
               expressions. Any branch or tag change that matches that regular
               expression will trigger a build.
               One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerWebhookConfigArgs', 'TriggerWebhookConfigArgsDict']] webhook_config: WebhookConfig describes the configuration of a trigger that creates
               a build whenever a webhook is sent to a trigger's webhook URL.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TriggerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configuration for an automated build in response to source repository changes.

        To get more information about Trigger, see:

        * [API documentation](https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.triggers)
        * How-to Guides
            * [Automating builds using build triggers](https://cloud.google.com/cloud-build/docs/running-builds/automate-builds)

        > **Note:** You can retrieve the email of the Cloud Build Service Account used in jobs by using the `projects.ServiceIdentity` resource.

        ## Example Usage

        ### Cloudbuild Trigger Filename

        ```python
        import pulumi
        import pulumi_gcp as gcp

        filename_trigger = gcp.cloudbuild.Trigger("filename-trigger",
            location="us-central1",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            substitutions={
                "_FOO": "bar",
                "_BAZ": "qux",
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Build

        ```python
        import pulumi
        import pulumi_gcp as gcp

        build_trigger = gcp.cloudbuild.Trigger("build-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [
                    {
                        "name": "gcr.io/cloud-builders/gsutil",
                        "args": [
                            "cp",
                            "gs://mybucket/remotefile.zip",
                            "localfile.zip",
                        ],
                        "timeout": "120s",
                        "secret_envs": ["MY_SECRET"],
                    },
                    {
                        "name": "ubuntu",
                        "script": "echo hello",
                    },
                ],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                    "npm_packages": [{
                        "package_path": "package.json",
                        "repository": "https://us-west1-npm.pkg.dev/myProject/quickstart-nodejs-repo",
                    }],
                    "python_packages": [{
                        "paths": ["dist/*"],
                        "repository": "https://us-west1-python.pkg.dev/myProject/quickstart-python-repo",
                    }],
                    "maven_artifacts": [{
                        "repository": "https://us-west1-maven.pkg.dev/myProject/quickstart-java-repo",
                        "path": "/workspace/my-app/target/my-app-1.0.SNAPSHOT.jar",
                        "artifact_id": "my-app",
                        "group_id": "com.mycompany.app",
                        "version": "1.0",
                    }],
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Service Account

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudbuild_service_account = gcp.serviceaccount.Account("cloudbuild_service_account", account_id="cloud-sa")
        act_as = gcp.projects.IAMMember("act_as",
            project=project.project_id,
            role="roles/iam.serviceAccountUser",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        logs_writer = gcp.projects.IAMMember("logs_writer",
            project=project.project_id,
            role="roles/logging.logWriter",
            member=cloudbuild_service_account.email.apply(lambda email: f"serviceAccount:{email}"))
        service_account_trigger = gcp.cloudbuild.Trigger("service-account-trigger",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            service_account=cloudbuild_service_account.id,
            filename="cloudbuild.yaml",
            opts = pulumi.ResourceOptions(depends_on=[
                    act_as,
                    logs_writer,
                ]))
        ```
        ### Cloudbuild Trigger Include Build Logs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        include_build_logs_trigger = gcp.cloudbuild.Trigger("include-build-logs-trigger",
            location="us-central1",
            name="include-build-logs-trigger",
            filename="cloudbuild.yaml",
            github={
                "owner": "hashicorp",
                "name": "terraform-provider-google-beta",
                "push": {
                    "branch": "^main$",
                },
            },
            include_build_logs="INCLUDE_BUILD_LOGS_WITH_STATUS")
        ```
        ### Cloudbuild Trigger Pubsub Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        mytopic = gcp.pubsub.Topic("mytopic", name="my-topic")
        pubsub_config_trigger = gcp.cloudbuild.Trigger("pubsub-config-trigger",
            location="us-central1",
            name="pubsub-trigger",
            description="acceptance test example pubsub build trigger",
            pubsub_config={
                "topic": mytopic.id,
            },
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            substitutions={
                "_ACTION": "$(body.message.data.action)",
            },
            filter="_ACTION.matches('INSERT')")
        ```
        ### Cloudbuild Trigger Webhook Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        webhook_trigger_secret_key = gcp.secretmanager.Secret("webhook_trigger_secret_key",
            secret_id="webhook-trigger-secret-key",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        webhook_trigger_secret_key_data = gcp.secretmanager.SecretVersion("webhook_trigger_secret_key_data",
            secret=webhook_trigger_secret_key.id,
            secret_data="secretkeygoeshere")
        project = gcp.organizations.get_project()
        secret_accessor = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/secretmanager.secretAccessor",
            "members": [f"serviceAccount:service-{project.number}@gcp-sa-cloudbuild.iam.gserviceaccount.com"],
        }])
        policy = gcp.secretmanager.SecretIamPolicy("policy",
            project=webhook_trigger_secret_key.project,
            secret_id=webhook_trigger_secret_key.secret_id,
            policy_data=secret_accessor.policy_data)
        webhook_config_trigger = gcp.cloudbuild.Trigger("webhook-config-trigger",
            name="webhook-trigger",
            description="acceptance test example webhook build trigger",
            webhook_config={
                "secret": webhook_trigger_secret_key_data.id,
            },
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            })
        ```
        ### Cloudbuild Trigger Manual

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_trigger = gcp.cloudbuild.Trigger("manual-trigger",
            name="manual-trigger",
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            approval_config={
                "approval_required": True,
            })
        ```
        ### Cloudbuild Trigger Manual Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_ghe_trigger = gcp.cloudbuild.Trigger("manual-ghe-trigger",
            name="my-trigger",
            source_to_build={
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
                "github_enterprise_config": "projects/myProject/locations/global/githubEnterpriseConfigs/configID",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://hashicorp/terraform-provider-google-beta",
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
                "github_enterprise_config": "projects/myProject/locations/global/githubEnterpriseConfigs/configID",
            })
        ```
        ### Cloudbuild Trigger Manual Bitbucket Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        manual_bitbucket_trigger = gcp.cloudbuild.Trigger("manual-bitbucket-trigger",
            name="terraform-manual-bbs-trigger",
            source_to_build={
                "uri": "https://bbs.com/scm/stag/test-repo.git",
                "ref": "refs/heads/main",
                "repo_type": "BITBUCKET_SERVER",
                "bitbucket_server_config": "projects/myProject/locations/global/bitbucketServerConfigs/configID",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "uri": "https://bbs.com/scm/stag/test-repo.git",
                "revision": "refs/heads/main",
                "repo_type": "BITBUCKET_SERVER",
                "bitbucket_server_config": "projects/myProject/locations/global/bitbucketServerConfigs/configID",
            })
        ```
        ### Cloudbuild Trigger Repo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.cloudbuildv2.Connection("my-connection",
            location="us-central1",
            name="my-connection",
            github_config={
                "app_installation_id": 123123,
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/my-project/secrets/github-pat-secret/versions/latest",
                },
            })
        my_repository = gcp.cloudbuildv2.Repository("my-repository",
            name="my-repo",
            parent_connection=my_connection.id,
            remote_uri="https://github.com/myuser/my-repo.git")
        repo_trigger = gcp.cloudbuild.Trigger("repo-trigger",
            location="us-central1",
            repository_event_config={
                "repository": my_repository.id,
                "push": {
                    "branch": "feature-.*",
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Bitbucket Server Push

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_push_trigger = gcp.cloudbuild.Trigger("bbs-push-trigger",
            name="bbs-push-trigger",
            location="us-central1",
            bitbucket_server_trigger_config={
                "repo_slug": "bbs-push-trigger",
                "project_key": "STAG",
                "bitbucket_server_config_resource": "projects/123456789/locations/us-central1/bitbucketServerConfigs/myBitbucketConfig",
                "push": {
                    "tag": "^0.1.*",
                    "invert_regex": True,
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Bitbucket Server Pull Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bbs_pull_request_trigger = gcp.cloudbuild.Trigger("bbs-pull-request-trigger",
            name="ghe-trigger",
            location="us-central1",
            bitbucket_server_trigger_config={
                "repo_slug": "terraform-provider-google",
                "project_key": "STAG",
                "bitbucket_server_config_resource": "projects/123456789/locations/us-central1/bitbucketServerConfigs/myBitbucketConfig",
                "pull_request": {
                    "branch": "^master$",
                    "invert_regex": False,
                    "comment_control": "COMMENTS_ENABLED",
                },
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Github Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ghe_trigger = gcp.cloudbuild.Trigger("ghe-trigger",
            name="ghe-trigger",
            location="us-central1",
            github={
                "owner": "hashicorp",
                "name": "terraform-provider-google",
                "push": {
                    "branch": "^main$",
                },
                "enterprise_config_resource_name": "projects/123456789/locations/us-central1/githubEnterpriseConfigs/configID",
            },
            filename="cloudbuild.yaml")
        ```
        ### Cloudbuild Trigger Allow Failure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        allow_failure_trigger = gcp.cloudbuild.Trigger("allow-failure-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [{
                    "name": "ubuntu",
                    "args": [
                        "-c",
                        "exit 1",
                    ],
                    "allow_failure": True,
                }],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Allow Exit Codes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        allow_exit_codes_trigger = gcp.cloudbuild.Trigger("allow-exit-codes-trigger",
            name="my-trigger",
            location="global",
            trigger_template={
                "branch_name": "main",
                "repo_name": "my-repo",
            },
            build={
                "steps": [{
                    "name": "ubuntu",
                    "args": [
                        "-c",
                        "exit 1",
                    ],
                    "allow_exit_codes": [
                        1,
                        3,
                    ],
                }],
                "source": {
                    "storage_source": {
                        "bucket": "mybucket",
                        "object": "source_code.tar.gz",
                    },
                },
                "tags": [
                    "build",
                    "newFeature",
                ],
                "substitutions": {
                    "_FOO": "bar",
                    "_BAZ": "qux",
                },
                "queue_ttl": "20s",
                "logs_bucket": "gs://mybucket/logs",
                "secrets": [{
                    "kms_key_name": "projects/myProject/locations/global/keyRings/keyring-name/cryptoKeys/key-name",
                    "secret_env": {
                        "PASSWORD": "ZW5jcnlwdGVkLXBhc3N3b3JkCg==",
                    },
                }],
                "available_secrets": {
                    "secret_managers": [{
                        "env": "MY_SECRET",
                        "version_name": "projects/myProject/secrets/mySecret/versions/latest",
                    }],
                },
                "artifacts": {
                    "images": ["gcr.io/$PROJECT_ID/$REPO_NAME:$COMMIT_SHA"],
                    "objects": {
                        "location": "gs://bucket/path/to/somewhere/",
                        "paths": ["path"],
                    },
                },
                "options": {
                    "source_provenance_hashes": ["MD5"],
                    "requested_verify_option": "VERIFIED",
                    "machine_type": "N1_HIGHCPU_8",
                    "disk_size_gb": 100,
                    "substitution_option": "ALLOW_LOOSE",
                    "dynamic_substitutions": True,
                    "log_streaming_option": "STREAM_OFF",
                    "worker_pool": "pool",
                    "logging": "LEGACY",
                    "envs": ["ekey = evalue"],
                    "secret_envs": ["secretenv = svalue"],
                    "volumes": [{
                        "name": "v1",
                        "path": "v1",
                    }],
                },
            })
        ```
        ### Cloudbuild Trigger Pubsub With Repo

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_connection = gcp.cloudbuildv2.Connection("my-connection",
            location="us-central1",
            name="my-connection",
            github_config={
                "app_installation_id": 123123,
                "authorizer_credential": {
                    "oauth_token_secret_version": "projects/my-project/secrets/github-pat-secret/versions/latest",
                },
            })
        my_repository = gcp.cloudbuildv2.Repository("my-repository",
            name="my-repo",
            parent_connection=my_connection.id,
            remote_uri="https://github.com/myuser/my-repo.git")
        mytopic = gcp.pubsub.Topic("mytopic", name="my-topic")
        pubsub_with_repo_trigger = gcp.cloudbuild.Trigger("pubsub-with-repo-trigger",
            name="pubsub-with-repo-trigger",
            location="us-central1",
            pubsub_config={
                "topic": mytopic.id,
            },
            source_to_build={
                "repository": my_repository.id,
                "ref": "refs/heads/main",
                "repo_type": "GITHUB",
            },
            git_file_source={
                "path": "cloudbuild.yaml",
                "repository": my_repository.id,
                "revision": "refs/heads/main",
                "repo_type": "GITHUB",
            })
        ```

        ## Import

        Trigger can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}`

        * `projects/{{project}}/triggers/{{trigger_id}}`

        * `{{project}}/{{trigger_id}}`

        * `{{trigger_id}}`

        When using the `pulumi import` command, Trigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default projects/{{project}}/triggers/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default {{project}}/{{trigger_id}}
        ```

        ```sh
        $ pulumi import gcp:cloudbuild/trigger:Trigger default {{trigger_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_config: Optional[pulumi.Input[Union['TriggerApprovalConfigArgs', 'TriggerApprovalConfigArgsDict']]] = None,
                 bitbucket_server_trigger_config: Optional[pulumi.Input[Union['TriggerBitbucketServerTriggerConfigArgs', 'TriggerBitbucketServerTriggerConfigArgsDict']]] = None,
                 build: Optional[pulumi.Input[Union['TriggerBuildArgs', 'TriggerBuildArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filename: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 git_file_source: Optional[pulumi.Input[Union['TriggerGitFileSourceArgs', 'TriggerGitFileSourceArgsDict']]] = None,
                 github: Optional[pulumi.Input[Union['TriggerGithubArgs', 'TriggerGithubArgsDict']]] = None,
                 ignored_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 include_build_logs: Optional[pulumi.Input[_builtins.str]] = None,
                 included_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_config: Optional[pulumi.Input[Union['TriggerPubsubConfigArgs', 'TriggerPubsubConfigArgsDict']]] = None,
                 repository_event_config: Optional[pulumi.Input[Union['TriggerRepositoryEventConfigArgs', 'TriggerRepositoryEventConfigArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 source_to_build: Optional[pulumi.Input[Union['TriggerSourceToBuildArgs', 'TriggerSourceToBuildArgsDict']]] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_template: Optional[pulumi.Input[Union['TriggerTriggerTemplateArgs', 'TriggerTriggerTemplateArgsDict']]] = None,
                 webhook_config: Optional[pulumi.Input[Union['TriggerWebhookConfigArgs', 'TriggerWebhookConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            __props__.__dict__["approval_config"] = approval_config
            __props__.__dict__["bitbucket_server_trigger_config"] = bitbucket_server_trigger_config
            __props__.__dict__["build"] = build
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["filename"] = filename
            __props__.__dict__["filter"] = filter
            __props__.__dict__["git_file_source"] = git_file_source
            __props__.__dict__["github"] = github
            __props__.__dict__["ignored_files"] = ignored_files
            __props__.__dict__["include_build_logs"] = include_build_logs
            __props__.__dict__["included_files"] = included_files
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["pubsub_config"] = pubsub_config
            __props__.__dict__["repository_event_config"] = repository_event_config
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["source_to_build"] = source_to_build
            __props__.__dict__["substitutions"] = substitutions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trigger_template"] = trigger_template
            __props__.__dict__["webhook_config"] = webhook_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["trigger_id"] = None
        super(Trigger, __self__).__init__(
            'gcp:cloudbuild/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_config: Optional[pulumi.Input[Union['TriggerApprovalConfigArgs', 'TriggerApprovalConfigArgsDict']]] = None,
            bitbucket_server_trigger_config: Optional[pulumi.Input[Union['TriggerBitbucketServerTriggerConfigArgs', 'TriggerBitbucketServerTriggerConfigArgsDict']]] = None,
            build: Optional[pulumi.Input[Union['TriggerBuildArgs', 'TriggerBuildArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filename: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            git_file_source: Optional[pulumi.Input[Union['TriggerGitFileSourceArgs', 'TriggerGitFileSourceArgsDict']]] = None,
            github: Optional[pulumi.Input[Union['TriggerGithubArgs', 'TriggerGithubArgsDict']]] = None,
            ignored_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            include_build_logs: Optional[pulumi.Input[_builtins.str]] = None,
            included_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pubsub_config: Optional[pulumi.Input[Union['TriggerPubsubConfigArgs', 'TriggerPubsubConfigArgsDict']]] = None,
            repository_event_config: Optional[pulumi.Input[Union['TriggerRepositoryEventConfigArgs', 'TriggerRepositoryEventConfigArgsDict']]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            source_to_build: Optional[pulumi.Input[Union['TriggerSourceToBuildArgs', 'TriggerSourceToBuildArgsDict']]] = None,
            substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_template: Optional[pulumi.Input[Union['TriggerTriggerTemplateArgs', 'TriggerTriggerTemplateArgsDict']]] = None,
            webhook_config: Optional[pulumi.Input[Union['TriggerWebhookConfigArgs', 'TriggerWebhookConfigArgsDict']]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TriggerApprovalConfigArgs', 'TriggerApprovalConfigArgsDict']] approval_config: Configuration for manual approval to start a build invocation of this BuildTrigger.
               Builds created by this trigger will require approval before they execute.
               Any user with a Cloud Build Approver role for the project can approve a build.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerBitbucketServerTriggerConfigArgs', 'TriggerBitbucketServerTriggerConfigArgsDict']] bitbucket_server_trigger_config: BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerBuildArgs', 'TriggerBuildArgsDict']] build: Contents of the build template. Either a filename or build template must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time when the trigger was created.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the trigger.
        :param pulumi.Input[_builtins.bool] disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param pulumi.Input[_builtins.str] filename: Path, from the source root, to a file whose contents is used for the template.
               Either a filename or build template must be provided. Set this only when using trigger_template or github.
               When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        :param pulumi.Input[_builtins.str] filter: A Common Expression Language string. Used only with Pub/Sub and Webhook.
        :param pulumi.Input[Union['TriggerGitFileSourceArgs', 'TriggerGitFileSourceArgsDict']] git_file_source: The file source describing the local or remote Build template.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerGithubArgs', 'TriggerGithubArgsDict']] github: Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
               One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If ignoredFiles and changed files are both empty, then they are not
               used to determine whether or not to trigger a build.
               If ignoredFiles is not empty, then we ignore any files that match any
               of the ignored_file globs. If the change has no files that are outside
               of the ignoredFiles globs, then we do not trigger a build.
        :param pulumi.Input[_builtins.str] include_build_logs: Build logs will be sent back to GitHub as part of the checkrun
               result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
               INCLUDE_BUILD_LOGS_WITH_STATUS
               Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
               extended with support for `**`.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is empty, then as far as this filter is concerned, we
               should trigger the build.
               If any of the files altered in the commit pass the ignoredFiles filter
               and includedFiles is not empty, then we make sure that at least one of
               those files matches a includedFiles glob. If not, then we do not trigger
               a build.
        :param pulumi.Input[_builtins.str] location: The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
               If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the trigger. Must be unique within the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['TriggerPubsubConfigArgs', 'TriggerPubsubConfigArgsDict']] pubsub_config: PubsubConfig describes the configuration of a trigger that creates
               a build whenever a Pub/Sub message is published.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerRepositoryEventConfigArgs', 'TriggerRepositoryEventConfigArgsDict']] repository_event_config: The configuration of a trigger that creates a build whenever an event from Repo API is received.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account: The service account used for all user-controlled operations including
               triggers.patch, triggers.run, builds.create, and builds.cancel.
               If no service account is set, then the standard Cloud Build service account
               ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
               Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        :param pulumi.Input[Union['TriggerSourceToBuildArgs', 'TriggerSourceToBuildArgsDict']] source_to_build: The repo and ref of the repository from which to build.
               This field is used only for those triggers that do not respond to SCM events.
               Triggers that respond to such events build source at whatever commit caused the event.
               This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] substitutions: Substitutions data for Build resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags for annotation of a BuildTrigger
        :param pulumi.Input[_builtins.str] trigger_id: The unique identifier for the trigger.
        :param pulumi.Input[Union['TriggerTriggerTemplateArgs', 'TriggerTriggerTemplateArgsDict']] trigger_template: Template describing the types of source changes to trigger a build.
               Branch and tag names in trigger templates are interpreted as regular
               expressions. Any branch or tag change that matches that regular
               expression will trigger a build.
               One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        :param pulumi.Input[Union['TriggerWebhookConfigArgs', 'TriggerWebhookConfigArgsDict']] webhook_config: WebhookConfig describes the configuration of a trigger that creates
               a build whenever a webhook is sent to a trigger's webhook URL.
               One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["approval_config"] = approval_config
        __props__.__dict__["bitbucket_server_trigger_config"] = bitbucket_server_trigger_config
        __props__.__dict__["build"] = build
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["filename"] = filename
        __props__.__dict__["filter"] = filter
        __props__.__dict__["git_file_source"] = git_file_source
        __props__.__dict__["github"] = github
        __props__.__dict__["ignored_files"] = ignored_files
        __props__.__dict__["include_build_logs"] = include_build_logs
        __props__.__dict__["included_files"] = included_files
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pubsub_config"] = pubsub_config
        __props__.__dict__["repository_event_config"] = repository_event_config
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["source_to_build"] = source_to_build
        __props__.__dict__["substitutions"] = substitutions
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["trigger_template"] = trigger_template
        __props__.__dict__["webhook_config"] = webhook_config
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approvalConfig")
    def approval_config(self) -> pulumi.Output['outputs.TriggerApprovalConfig']:
        """
        Configuration for manual approval to start a build invocation of this BuildTrigger.
        Builds created by this trigger will require approval before they execute.
        Any user with a Cloud Build Approver role for the project can approve a build.
        Structure is documented below.
        """
        return pulumi.get(self, "approval_config")

    @_builtins.property
    @pulumi.getter(name="bitbucketServerTriggerConfig")
    def bitbucket_server_trigger_config(self) -> pulumi.Output[Optional['outputs.TriggerBitbucketServerTriggerConfig']]:
        """
        BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
        Structure is documented below.
        """
        return pulumi.get(self, "bitbucket_server_trigger_config")

    @_builtins.property
    @pulumi.getter
    def build(self) -> pulumi.Output[Optional['outputs.TriggerBuild']]:
        """
        Contents of the build template. Either a filename or build template must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the trigger was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description of the trigger.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path, from the source root, to a file whose contents is used for the template.
        Either a filename or build template must be provided. Set this only when using trigger_template or github.
        When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A Common Expression Language string. Used only with Pub/Sub and Webhook.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="gitFileSource")
    def git_file_source(self) -> pulumi.Output[Optional['outputs.TriggerGitFileSource']]:
        """
        The file source describing the local or remote Build template.
        Structure is documented below.
        """
        return pulumi.get(self, "git_file_source")

    @_builtins.property
    @pulumi.getter
    def github(self) -> pulumi.Output[Optional['outputs.TriggerGithub']]:
        """
        Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
        One of `trigger_template`, `github`, `pubsub_config` or `webhook_config` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "github")

    @_builtins.property
    @pulumi.getter(name="ignoredFiles")
    def ignored_files(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If ignoredFiles and changed files are both empty, then they are not
        used to determine whether or not to trigger a build.
        If ignoredFiles is not empty, then we ignore any files that match any
        of the ignored_file globs. If the change has no files that are outside
        of the ignoredFiles globs, then we do not trigger a build.
        """
        return pulumi.get(self, "ignored_files")

    @_builtins.property
    @pulumi.getter(name="includeBuildLogs")
    def include_build_logs(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Build logs will be sent back to GitHub as part of the checkrun
        result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
        INCLUDE_BUILD_LOGS_WITH_STATUS
        Possible values are: `INCLUDE_BUILD_LOGS_UNSPECIFIED`, `INCLUDE_BUILD_LOGS_WITH_STATUS`.
        """
        return pulumi.get(self, "include_build_logs")

    @_builtins.property
    @pulumi.getter(name="includedFiles")
    def included_files(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
        extended with support for `**`.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is empty, then as far as this filter is concerned, we
        should trigger the build.
        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is not empty, then we make sure that at least one of
        those files matches a includedFiles glob. If not, then we do not trigger
        a build.
        """
        return pulumi.get(self, "included_files")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
        If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the trigger. Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pubsubConfig")
    def pubsub_config(self) -> pulumi.Output[Optional['outputs.TriggerPubsubConfig']]:
        """
        PubsubConfig describes the configuration of a trigger that creates
        a build whenever a Pub/Sub message is published.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_config")

    @_builtins.property
    @pulumi.getter(name="repositoryEventConfig")
    def repository_event_config(self) -> pulumi.Output[Optional['outputs.TriggerRepositoryEventConfig']]:
        """
        The configuration of a trigger that creates a build whenever an event from Repo API is received.
        Structure is documented below.
        """
        return pulumi.get(self, "repository_event_config")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service account used for all user-controlled operations including
        triggers.patch, triggers.run, builds.create, and builds.cancel.
        If no service account is set, then the standard Cloud Build service account
        ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
        Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="sourceToBuild")
    def source_to_build(self) -> pulumi.Output[Optional['outputs.TriggerSourceToBuild']]:
        """
        The repo and ref of the repository from which to build.
        This field is used only for those triggers that do not respond to SCM events.
        Triggers that respond to such events build source at whatever commit caused the event.
        This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source_to_build")

    @_builtins.property
    @pulumi.getter
    def substitutions(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags for annotation of a BuildTrigger
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the trigger.
        """
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter(name="triggerTemplate")
    def trigger_template(self) -> pulumi.Output[Optional['outputs.TriggerTriggerTemplate']]:
        """
        Template describing the types of source changes to trigger a build.
        Branch and tag names in trigger templates are interpreted as regular
        expressions. Any branch or tag change that matches that regular
        expression will trigger a build.
        One of `trigger_template`, `github`, `pubsub_config`, `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_template")

    @_builtins.property
    @pulumi.getter(name="webhookConfig")
    def webhook_config(self) -> pulumi.Output[Optional['outputs.TriggerWebhookConfig']]:
        """
        WebhookConfig describes the configuration of a trigger that creates
        a build whenever a webhook is sent to a trigger's webhook URL.
        One of `trigger_template`, `github`, `pubsub_config` `webhook_config` or `source_to_build` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "webhook_config")

