# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SQuotaAdjusterSettingsArgs', 'SQuotaAdjusterSettings']

@pulumi.input_type
class SQuotaAdjusterSettingsArgs:
    def __init__(__self__, *,
                 enablement: pulumi.Input[_builtins.str],
                 parent: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SQuotaAdjusterSettings resource.
        :param pulumi.Input[_builtins.str] enablement: Required. The configured value of the enablement at the given resource.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] parent: The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        pulumi.set(__self__, "enablement", enablement)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @_builtins.property
    @pulumi.getter
    def enablement(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The configured value of the enablement at the given resource.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement")

    @enablement.setter
    def enablement(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "enablement", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _SQuotaAdjusterSettingsState:
    def __init__(__self__, *,
                 effective_container: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_enablement: Optional[pulumi.Input[_builtins.str]] = None,
                 enablement: Optional[pulumi.Input[_builtins.str]] = None,
                 inherited: Optional[pulumi.Input[_builtins.bool]] = None,
                 inherited_from: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SQuotaAdjusterSettings resources.
        :param pulumi.Input[_builtins.str] effective_container: The resource container that determines if the quota adjuster is set for this project.
        :param pulumi.Input[_builtins.str] effective_enablement: Based on the effective container`s setting above, determines Whether this resource container has the quota adjuster enabled.
        :param pulumi.Input[_builtins.str] enablement: Required. The configured value of the enablement at the given resource.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.bool] inherited: Indicates whether the setting is inherited or explicitly specified.
        :param pulumi.Input[_builtins.str] inherited_from: The resource container from which the setting is inherited. This refers to the  nearest ancestor with enablement set (either ENABLED or DISABLED).
               The value can be `organizations/{organization_id}`, `folders/{folder_id}`, or can be `default` if no ancestor exists with enablement set.
               The value will be empty when `enablement` is specified on this resource container.
        :param pulumi.Input[_builtins.str] parent: The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        if effective_container is not None:
            pulumi.set(__self__, "effective_container", effective_container)
        if effective_enablement is not None:
            pulumi.set(__self__, "effective_enablement", effective_enablement)
        if enablement is not None:
            pulumi.set(__self__, "enablement", enablement)
        if inherited is not None:
            pulumi.set(__self__, "inherited", inherited)
        if inherited_from is not None:
            pulumi.set(__self__, "inherited_from", inherited_from)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @_builtins.property
    @pulumi.getter(name="effectiveContainer")
    def effective_container(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource container that determines if the quota adjuster is set for this project.
        """
        return pulumi.get(self, "effective_container")

    @effective_container.setter
    def effective_container(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_container", value)

    @_builtins.property
    @pulumi.getter(name="effectiveEnablement")
    def effective_enablement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Based on the effective container`s setting above, determines Whether this resource container has the quota adjuster enabled.
        """
        return pulumi.get(self, "effective_enablement")

    @effective_enablement.setter
    def effective_enablement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_enablement", value)

    @_builtins.property
    @pulumi.getter
    def enablement(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The configured value of the enablement at the given resource.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement")

    @enablement.setter
    def enablement(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enablement", value)

    @_builtins.property
    @pulumi.getter
    def inherited(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the setting is inherited or explicitly specified.
        """
        return pulumi.get(self, "inherited")

    @inherited.setter
    def inherited(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inherited", value)

    @_builtins.property
    @pulumi.getter(name="inheritedFrom")
    def inherited_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource container from which the setting is inherited. This refers to the  nearest ancestor with enablement set (either ENABLED or DISABLED).
        The value can be `organizations/{organization_id}`, `folders/{folder_id}`, or can be `default` if no ancestor exists with enablement set.
        The value will be empty when `enablement` is specified on this resource container.
        """
        return pulumi.get(self, "inherited_from")

    @inherited_from.setter
    def inherited_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inherited_from", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.type_token("gcp:cloudquota/sQuotaAdjusterSettings:SQuotaAdjusterSettings")
class SQuotaAdjusterSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enablement: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Cloudquotas Quota Adjuster Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        adjuster_settings = gcp.cloudquota.SQuotaAdjusterSettings("adjuster_settings",
            parent="projects/104740170505",
            enablement="ENABLED")
        ```

        ## Import

        QuotaAdjusterSettings can be imported using any of these accepted formats:

        * `{{parent}}/locations/global/quotaAdjusterSettings`

        When using the `pulumi import` command, QuotaAdjusterSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudquota/sQuotaAdjusterSettings:SQuotaAdjusterSettings default {{parent}}/locations/global/quotaAdjusterSettings
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enablement: Required. The configured value of the enablement at the given resource.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.str] parent: The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SQuotaAdjusterSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Cloudquotas Quota Adjuster Settings Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        adjuster_settings = gcp.cloudquota.SQuotaAdjusterSettings("adjuster_settings",
            parent="projects/104740170505",
            enablement="ENABLED")
        ```

        ## Import

        QuotaAdjusterSettings can be imported using any of these accepted formats:

        * `{{parent}}/locations/global/quotaAdjusterSettings`

        When using the `pulumi import` command, QuotaAdjusterSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudquota/sQuotaAdjusterSettings:SQuotaAdjusterSettings default {{parent}}/locations/global/quotaAdjusterSettings
        ```

        :param str resource_name: The name of the resource.
        :param SQuotaAdjusterSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SQuotaAdjusterSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enablement: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SQuotaAdjusterSettingsArgs.__new__(SQuotaAdjusterSettingsArgs)

            if enablement is None and not opts.urn:
                raise TypeError("Missing required property 'enablement'")
            __props__.__dict__["enablement"] = enablement
            __props__.__dict__["parent"] = parent
            __props__.__dict__["effective_container"] = None
            __props__.__dict__["effective_enablement"] = None
            __props__.__dict__["inherited"] = None
            __props__.__dict__["inherited_from"] = None
        super(SQuotaAdjusterSettings, __self__).__init__(
            'gcp:cloudquota/sQuotaAdjusterSettings:SQuotaAdjusterSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            effective_container: Optional[pulumi.Input[_builtins.str]] = None,
            effective_enablement: Optional[pulumi.Input[_builtins.str]] = None,
            enablement: Optional[pulumi.Input[_builtins.str]] = None,
            inherited: Optional[pulumi.Input[_builtins.bool]] = None,
            inherited_from: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None) -> 'SQuotaAdjusterSettings':
        """
        Get an existing SQuotaAdjusterSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] effective_container: The resource container that determines if the quota adjuster is set for this project.
        :param pulumi.Input[_builtins.str] effective_enablement: Based on the effective container`s setting above, determines Whether this resource container has the quota adjuster enabled.
        :param pulumi.Input[_builtins.str] enablement: Required. The configured value of the enablement at the given resource.
               Possible values are: `ENABLED`, `DISABLED`.
        :param pulumi.Input[_builtins.bool] inherited: Indicates whether the setting is inherited or explicitly specified.
        :param pulumi.Input[_builtins.str] inherited_from: The resource container from which the setting is inherited. This refers to the  nearest ancestor with enablement set (either ENABLED or DISABLED).
               The value can be `organizations/{organization_id}`, `folders/{folder_id}`, or can be `default` if no ancestor exists with enablement set.
               The value will be empty when `enablement` is specified on this resource container.
        :param pulumi.Input[_builtins.str] parent: The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SQuotaAdjusterSettingsState.__new__(_SQuotaAdjusterSettingsState)

        __props__.__dict__["effective_container"] = effective_container
        __props__.__dict__["effective_enablement"] = effective_enablement
        __props__.__dict__["enablement"] = enablement
        __props__.__dict__["inherited"] = inherited
        __props__.__dict__["inherited_from"] = inherited_from
        __props__.__dict__["parent"] = parent
        return SQuotaAdjusterSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="effectiveContainer")
    def effective_container(self) -> pulumi.Output[_builtins.str]:
        """
        The resource container that determines if the quota adjuster is set for this project.
        """
        return pulumi.get(self, "effective_container")

    @_builtins.property
    @pulumi.getter(name="effectiveEnablement")
    def effective_enablement(self) -> pulumi.Output[_builtins.str]:
        """
        Based on the effective container`s setting above, determines Whether this resource container has the quota adjuster enabled.
        """
        return pulumi.get(self, "effective_enablement")

    @_builtins.property
    @pulumi.getter
    def enablement(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The configured value of the enablement at the given resource.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement")

    @_builtins.property
    @pulumi.getter
    def inherited(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the setting is inherited or explicitly specified.
        """
        return pulumi.get(self, "inherited")

    @_builtins.property
    @pulumi.getter(name="inheritedFrom")
    def inherited_from(self) -> pulumi.Output[_builtins.str]:
        """
        The resource container from which the setting is inherited. This refers to the  nearest ancestor with enablement set (either ENABLED or DISABLED).
        The value can be `organizations/{organization_id}`, `folders/{folder_id}`, or can be `default` if no ancestor exists with enablement set.
        The value will be empty when `enablement` is specified on this resource container.
        """
        return pulumi.get(self, "inherited_from")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        The parent of the quota preference. Allowed parent format is "projects/[project-id / number]".
        """
        return pulumi.get(self, "parent")

