# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainMappingArgs', 'DomainMapping']

@pulumi.input_type
class DomainMappingArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 spec: pulumi.Input['DomainMappingSpecArgs'],
                 metadata: Optional[pulumi.Input['DomainMappingMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainMapping resource.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input['DomainMappingSpecArgs'] spec: The spec for this DomainMapping.
               Structure is documented below.
        :param pulumi.Input['DomainMappingMetadataArgs'] metadata: Metadata associated with this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Input['DomainMappingSpecArgs']:
        """
        The spec for this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['DomainMappingSpecArgs']):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['DomainMappingMetadataArgs']]:
        """
        Metadata associated with this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['DomainMappingMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DomainMappingState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input['DomainMappingMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['DomainMappingSpecArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainMapping resources.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input['DomainMappingMetadataArgs'] metadata: Metadata associated with this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['DomainMappingSpecArgs'] spec: The spec for this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusArgs']]] statuses: (Output)
               Status of the condition, one of True, False, Unknown.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['DomainMappingMetadataArgs']]:
        """
        Metadata associated with this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['DomainMappingMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['DomainMappingSpecArgs']]:
        """
        The spec for this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['DomainMappingSpecArgs']]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusArgs']]]]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingStatusArgs']]]]):
        pulumi.set(self, "statuses", value)


@pulumi.type_token("gcp:cloudrun/domainMapping:DomainMapping")
class DomainMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['DomainMappingMetadataArgs', 'DomainMappingMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['DomainMappingSpecArgs', 'DomainMappingSpecArgsDict']]] = None,
                 __props__=None):
        """
        Resource to hold the state and status of a user's domain mapping.

        To get more information about DomainMapping, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/projects.locations.domainmappings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/mapping-custom-domains)

        ## Example Usage

        ### Cloud Run Domain Mapping Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "namespace": "my-project-name",
            },
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            })
        default_domain_mapping = gcp.cloudrun.DomainMapping("default",
            location="us-central1",
            name="verified-domain.com",
            metadata={
                "namespace": "my-project-name",
            },
            spec={
                "route_name": default.name,
            })
        ```

        ## Import

        DomainMapping can be imported using any of these accepted formats:

        * `locations/{{location}}/namespaces/{{project}}/domainmappings/{{name}}`

        * `{{location}}/{{project}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DomainMapping can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default locations/{{location}}/namespaces/{{project}}/domainmappings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default {{location}}/{{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[Union['DomainMappingMetadataArgs', 'DomainMappingMetadataArgsDict']] metadata: Metadata associated with this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DomainMappingSpecArgs', 'DomainMappingSpecArgsDict']] spec: The spec for this DomainMapping.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource to hold the state and status of a user's domain mapping.

        To get more information about DomainMapping, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/projects.locations.domainmappings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/mapping-custom-domains)

        ## Example Usage

        ### Cloud Run Domain Mapping Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "namespace": "my-project-name",
            },
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            })
        default_domain_mapping = gcp.cloudrun.DomainMapping("default",
            location="us-central1",
            name="verified-domain.com",
            metadata={
                "namespace": "my-project-name",
            },
            spec={
                "route_name": default.name,
            })
        ```

        ## Import

        DomainMapping can be imported using any of these accepted formats:

        * `locations/{{location}}/namespaces/{{project}}/domainmappings/{{name}}`

        * `{{location}}/{{project}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DomainMapping can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default locations/{{location}}/namespaces/{{project}}/domainmappings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default {{location}}/{{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/domainMapping:DomainMapping default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DomainMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['DomainMappingMetadataArgs', 'DomainMappingMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['DomainMappingSpecArgs', 'DomainMappingSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainMappingArgs.__new__(DomainMappingArgs)

            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["statuses"] = None
        super(DomainMapping, __self__).__init__(
            'gcp:cloudrun/domainMapping:DomainMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['DomainMappingMetadataArgs', 'DomainMappingMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[Union['DomainMappingSpecArgs', 'DomainMappingSpecArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainMappingStatusArgs', 'DomainMappingStatusArgsDict']]]]] = None) -> 'DomainMapping':
        """
        Get an existing DomainMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[Union['DomainMappingMetadataArgs', 'DomainMappingMetadataArgsDict']] metadata: Metadata associated with this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['DomainMappingSpecArgs', 'DomainMappingSpecArgsDict']] spec: The spec for this DomainMapping.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainMappingStatusArgs', 'DomainMappingStatusArgsDict']]]] statuses: (Output)
               Status of the condition, one of True, False, Unknown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainMappingState.__new__(_DomainMappingState)

        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["spec"] = spec
        __props__.__dict__["statuses"] = statuses
        return DomainMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.DomainMappingMetadata']:
        """
        Metadata associated with this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output['outputs.DomainMappingSpec']:
        """
        The spec for this DomainMapping.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.DomainMappingStatus']]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "statuses")

