# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'NotebookExecutionDataformRepositorySource',
    'NotebookExecutionDirectNotebookSource',
    'NotebookExecutionGcsNotebookSource',
    'RuntimeNotebookRuntimeTemplateRef',
    'RuntimeTemplateDataPersistentDiskSpec',
    'RuntimeTemplateEncryptionSpec',
    'RuntimeTemplateEucConfig',
    'RuntimeTemplateIamBindingCondition',
    'RuntimeTemplateIamMemberCondition',
    'RuntimeTemplateIdleShutdownConfig',
    'RuntimeTemplateMachineSpec',
    'RuntimeTemplateNetworkSpec',
    'RuntimeTemplateShieldedVmConfig',
    'RuntimeTemplateSoftwareConfig',
    'RuntimeTemplateSoftwareConfigEnv',
    'RuntimeTemplateSoftwareConfigPostStartupScriptConfig',
    'ScheduleCreateNotebookExecutionJobRequest',
    'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob',
    'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource',
    'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobGcsNotebookSource',
]

@pulumi.output_type
class NotebookExecutionDataformRepositorySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataformRepositoryResourceName":
            suggest = "dataform_repository_resource_name"
        elif key == "commitSha":
            suggest = "commit_sha"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookExecutionDataformRepositorySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookExecutionDataformRepositorySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookExecutionDataformRepositorySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataform_repository_resource_name: _builtins.str,
                 commit_sha: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataform_repository_resource_name: The resource name of the Dataform Repository.
        :param _builtins.str commit_sha: The commit SHA to read repository with. If unset, the file will be read at HEAD.
        """
        pulumi.set(__self__, "dataform_repository_resource_name", dataform_repository_resource_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)

    @_builtins.property
    @pulumi.getter(name="dataformRepositoryResourceName")
    def dataform_repository_resource_name(self) -> _builtins.str:
        """
        The resource name of the Dataform Repository.
        """
        return pulumi.get(self, "dataform_repository_resource_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[_builtins.str]:
        """
        The commit SHA to read repository with. If unset, the file will be read at HEAD.
        """
        return pulumi.get(self, "commit_sha")


@pulumi.output_type
class NotebookExecutionDirectNotebookSource(dict):
    def __init__(__self__, *,
                 content: _builtins.str):
        """
        :param _builtins.str content: The base64-encoded contents of the input notebook file.
        """
        pulumi.set(__self__, "content", content)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The base64-encoded contents of the input notebook file.
        """
        return pulumi.get(self, "content")


@pulumi.output_type
class NotebookExecutionGcsNotebookSource(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 generation: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The Cloud Storage uri pointing to the ipynb file.
        :param _builtins.str generation: The version of the Cloud Storage object to read. If unset, the current version of the object is read. See https://cloud.google.com/storage/docs/metadata#generation-number.
        """
        pulumi.set(__self__, "uri", uri)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The Cloud Storage uri pointing to the ipynb file.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.str]:
        """
        The version of the Cloud Storage object to read. If unset, the current version of the object is read. See https://cloud.google.com/storage/docs/metadata#generation-number.
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class RuntimeNotebookRuntimeTemplateRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookRuntimeTemplate":
            suggest = "notebook_runtime_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeNotebookRuntimeTemplateRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeNotebookRuntimeTemplateRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeNotebookRuntimeTemplateRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_runtime_template: _builtins.str):
        """
        :param _builtins.str notebook_runtime_template: The resource name of the NotebookRuntimeTemplate based on which a NotebookRuntime will be created.
        """
        pulumi.set(__self__, "notebook_runtime_template", notebook_runtime_template)

    @_builtins.property
    @pulumi.getter(name="notebookRuntimeTemplate")
    def notebook_runtime_template(self) -> _builtins.str:
        """
        The resource name of the NotebookRuntimeTemplate based on which a NotebookRuntime will be created.
        """
        return pulumi.get(self, "notebook_runtime_template")


@pulumi.output_type
class RuntimeTemplateDataPersistentDiskSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateDataPersistentDiskSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateDataPersistentDiskSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateDataPersistentDiskSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: Optional[_builtins.str] = None,
                 disk_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str disk_size_gb: The disk size of the runtime in GB. If specified, the diskType must also be specified. The minimum size is 10GB and the maximum is 65536GB.
        :param _builtins.str disk_type: The type of the persistent disk.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.str]:
        """
        The disk size of the runtime in GB. If specified, the diskType must also be specified. The minimum size is 10GB and the maximum is 65536GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        The type of the persistent disk.
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class RuntimeTemplateEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The Cloud KMS encryption key (customer-managed encryption key) used to protect the runtime.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The Cloud KMS encryption key (customer-managed encryption key) used to protect the runtime.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class RuntimeTemplateEucConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eucDisabled":
            suggest = "euc_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateEucConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateEucConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateEucConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 euc_disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool euc_disabled: Disable end user credential access for the runtime.
        """
        if euc_disabled is not None:
            pulumi.set(__self__, "euc_disabled", euc_disabled)

    @_builtins.property
    @pulumi.getter(name="eucDisabled")
    def euc_disabled(self) -> Optional[_builtins.bool]:
        """
        Disable end user credential access for the runtime.
        """
        return pulumi.get(self, "euc_disabled")


@pulumi.output_type
class RuntimeTemplateIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RuntimeTemplateIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RuntimeTemplateIdleShutdownConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeout":
            suggest = "idle_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateIdleShutdownConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateIdleShutdownConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateIdleShutdownConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str idle_timeout: The duration after which the runtime is automatically shut down. An input of 0s disables the idle shutdown feature, and a valid range is [10m, 24h].
        """
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[_builtins.str]:
        """
        The duration after which the runtime is automatically shut down. An input of 0s disables the idle shutdown feature, and a valid range is [10m, 24h].
        """
        return pulumi.get(self, "idle_timeout")


@pulumi.output_type
class RuntimeTemplateMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[_builtins.int] = None,
                 accelerator_type: Optional[_builtins.str] = None,
                 machine_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int accelerator_count: The number of accelerators used by the runtime.
        :param _builtins.str accelerator_type: The type of hardware accelerator used by the runtime. If specified, acceleratorCount must also be specified.
        :param _builtins.str machine_type: The Compute Engine machine type selected for the runtime.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[_builtins.int]:
        """
        The number of accelerators used by the runtime.
        """
        return pulumi.get(self, "accelerator_count")

    @_builtins.property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[_builtins.str]:
        """
        The type of hardware accelerator used by the runtime. If specified, acceleratorCount must also be specified.
        """
        return pulumi.get(self, "accelerator_type")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The Compute Engine machine type selected for the runtime.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class RuntimeTemplateNetworkSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInternetAccess":
            suggest = "enable_internet_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateNetworkSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateNetworkSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateNetworkSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_internet_access: Optional[_builtins.bool] = None,
                 network: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable_internet_access: Enable public internet access for the runtime.
        :param _builtins.str network: The name of the VPC that this runtime is in.
        :param _builtins.str subnetwork: The name of the subnetwork that this runtime is in.
        """
        if enable_internet_access is not None:
            pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @_builtins.property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> Optional[_builtins.bool]:
        """
        Enable public internet access for the runtime.
        """
        return pulumi.get(self, "enable_internet_access")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The name of the VPC that this runtime is in.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The name of the subnetwork that this runtime is in.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class RuntimeTemplateShieldedVmConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableSecureBoot":
            suggest = "enable_secure_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateShieldedVmConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateShieldedVmConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateShieldedVmConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_secure_boot: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_secure_boot: Enables secure boot for the runtime.
        """
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[_builtins.bool]:
        """
        Enables secure boot for the runtime.
        """
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class RuntimeTemplateSoftwareConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStartupScriptConfig":
            suggest = "post_startup_script_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateSoftwareConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateSoftwareConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateSoftwareConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 envs: Optional[Sequence['outputs.RuntimeTemplateSoftwareConfigEnv']] = None,
                 post_startup_script_config: Optional['outputs.RuntimeTemplateSoftwareConfigPostStartupScriptConfig'] = None):
        """
        :param Sequence['RuntimeTemplateSoftwareConfigEnvArgs'] envs: Environment variables to be passed to the container.
               Structure is documented below.
        :param 'RuntimeTemplateSoftwareConfigPostStartupScriptConfigArgs' post_startup_script_config: (Optional, Deprecated)
               Post startup script config.
               Structure is documented below.
               
               > **Warning:** `post_startup_script_config` is deprecated and will be removed in a future major release. New resource creation with this field is unavailable at this time.
        """
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if post_startup_script_config is not None:
            pulumi.set(__self__, "post_startup_script_config", post_startup_script_config)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.RuntimeTemplateSoftwareConfigEnv']]:
        """
        Environment variables to be passed to the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="postStartupScriptConfig")
    @_utilities.deprecated("""`post_startup_script_config` is deprecated and will be removed in a future major release. New resource creation with this field is unavailable at this time.""")
    def post_startup_script_config(self) -> Optional['outputs.RuntimeTemplateSoftwareConfigPostStartupScriptConfig']:
        """
        (Optional, Deprecated)
        Post startup script config.
        Structure is documented below.

        > **Warning:** `post_startup_script_config` is deprecated and will be removed in a future major release. New resource creation with this field is unavailable at this time.
        """
        return pulumi.get(self, "post_startup_script_config")


@pulumi.output_type
class RuntimeTemplateSoftwareConfigEnv(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the environment variable. Must be a valid C identifier.
        :param _builtins.str value: Variables that reference a $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the environment variable. Must be a valid C identifier.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Variables that reference a $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuntimeTemplateSoftwareConfigPostStartupScriptConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStartupScript":
            suggest = "post_startup_script"
        elif key == "postStartupScriptBehavior":
            suggest = "post_startup_script_behavior"
        elif key == "postStartupScriptUrl":
            suggest = "post_startup_script_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeTemplateSoftwareConfigPostStartupScriptConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeTemplateSoftwareConfigPostStartupScriptConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeTemplateSoftwareConfigPostStartupScriptConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_startup_script: Optional[_builtins.str] = None,
                 post_startup_script_behavior: Optional[_builtins.str] = None,
                 post_startup_script_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str post_startup_script: Post startup script to run after runtime is started.
        :param _builtins.str post_startup_script_behavior: Post startup script behavior that defines download and execution behavior.
               Possible values are: `RUN_ONCE`, `RUN_EVERY_START`, `DOWNLOAD_AND_RUN_EVERY_START`.
        :param _builtins.str post_startup_script_url: Post startup script url to download. Example: https://bucket/script.sh.
        """
        if post_startup_script is not None:
            pulumi.set(__self__, "post_startup_script", post_startup_script)
        if post_startup_script_behavior is not None:
            pulumi.set(__self__, "post_startup_script_behavior", post_startup_script_behavior)
        if post_startup_script_url is not None:
            pulumi.set(__self__, "post_startup_script_url", post_startup_script_url)

    @_builtins.property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> Optional[_builtins.str]:
        """
        Post startup script to run after runtime is started.
        """
        return pulumi.get(self, "post_startup_script")

    @_builtins.property
    @pulumi.getter(name="postStartupScriptBehavior")
    def post_startup_script_behavior(self) -> Optional[_builtins.str]:
        """
        Post startup script behavior that defines download and execution behavior.
        Possible values are: `RUN_ONCE`, `RUN_EVERY_START`, `DOWNLOAD_AND_RUN_EVERY_START`.
        """
        return pulumi.get(self, "post_startup_script_behavior")

    @_builtins.property
    @pulumi.getter(name="postStartupScriptUrl")
    def post_startup_script_url(self) -> Optional[_builtins.str]:
        """
        Post startup script url to download. Example: https://bucket/script.sh.
        """
        return pulumi.get(self, "post_startup_script_url")


@pulumi.output_type
class ScheduleCreateNotebookExecutionJobRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookExecutionJob":
            suggest = "notebook_execution_job"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleCreateNotebookExecutionJobRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleCreateNotebookExecutionJobRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleCreateNotebookExecutionJobRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 notebook_execution_job: 'outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob'):
        """
        :param 'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobArgs' notebook_execution_job: The NotebookExecutionJob to create.
               Structure is documented below.
        """
        pulumi.set(__self__, "notebook_execution_job", notebook_execution_job)

    @_builtins.property
    @pulumi.getter(name="notebookExecutionJob")
    def notebook_execution_job(self) -> 'outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob':
        """
        The NotebookExecutionJob to create.
        Structure is documented below.
        """
        return pulumi.get(self, "notebook_execution_job")


@pulumi.output_type
class ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "gcsOutputUri":
            suggest = "gcs_output_uri"
        elif key == "notebookRuntimeTemplateResourceName":
            suggest = "notebook_runtime_template_resource_name"
        elif key == "dataformRepositorySource":
            suggest = "dataform_repository_source"
        elif key == "executionTimeout":
            suggest = "execution_timeout"
        elif key == "executionUser":
            suggest = "execution_user"
        elif key == "gcsNotebookSource":
            suggest = "gcs_notebook_source"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 gcs_output_uri: _builtins.str,
                 notebook_runtime_template_resource_name: _builtins.str,
                 dataform_repository_source: Optional['outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource'] = None,
                 execution_timeout: Optional[_builtins.str] = None,
                 execution_user: Optional[_builtins.str] = None,
                 gcs_notebook_source: Optional['outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobGcsNotebookSource'] = None,
                 service_account: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: Required. The display name of the Notebook Execution.
        :param _builtins.str gcs_output_uri: The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        :param _builtins.str notebook_runtime_template_resource_name: The NotebookRuntimeTemplate to source compute configuration from.
        :param 'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySourceArgs' dataform_repository_source: The Dataform Repository containing the input notebook.
               Structure is documented below.
        :param _builtins.str execution_timeout: Max running time of the execution job in seconds (default 86400s / 24 hrs). A duration in seconds with up to nine fractional digits, ending with "s". Example: "3.5s".
        :param _builtins.str execution_user: The user email to run the execution as.
        :param 'ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobGcsNotebookSourceArgs' gcs_notebook_source: The Cloud Storage uri for the input notebook.
               Structure is documented below.
        :param _builtins.str service_account: The service account to run the execution as.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gcs_output_uri", gcs_output_uri)
        pulumi.set(__self__, "notebook_runtime_template_resource_name", notebook_runtime_template_resource_name)
        if dataform_repository_source is not None:
            pulumi.set(__self__, "dataform_repository_source", dataform_repository_source)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if execution_user is not None:
            pulumi.set(__self__, "execution_user", execution_user)
        if gcs_notebook_source is not None:
            pulumi.set(__self__, "gcs_notebook_source", gcs_notebook_source)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Required. The display name of the Notebook Execution.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="gcsOutputUri")
    def gcs_output_uri(self) -> _builtins.str:
        """
        The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        """
        return pulumi.get(self, "gcs_output_uri")

    @_builtins.property
    @pulumi.getter(name="notebookRuntimeTemplateResourceName")
    def notebook_runtime_template_resource_name(self) -> _builtins.str:
        """
        The NotebookRuntimeTemplate to source compute configuration from.
        """
        return pulumi.get(self, "notebook_runtime_template_resource_name")

    @_builtins.property
    @pulumi.getter(name="dataformRepositorySource")
    def dataform_repository_source(self) -> Optional['outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource']:
        """
        The Dataform Repository containing the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "dataform_repository_source")

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[_builtins.str]:
        """
        Max running time of the execution job in seconds (default 86400s / 24 hrs). A duration in seconds with up to nine fractional digits, ending with "s". Example: "3.5s".
        """
        return pulumi.get(self, "execution_timeout")

    @_builtins.property
    @pulumi.getter(name="executionUser")
    def execution_user(self) -> Optional[_builtins.str]:
        """
        The user email to run the execution as.
        """
        return pulumi.get(self, "execution_user")

    @_builtins.property
    @pulumi.getter(name="gcsNotebookSource")
    def gcs_notebook_source(self) -> Optional['outputs.ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobGcsNotebookSource']:
        """
        The Cloud Storage uri for the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_notebook_source")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        The service account to run the execution as.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataformRepositoryResourceName":
            suggest = "dataform_repository_resource_name"
        elif key == "commitSha":
            suggest = "commit_sha"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobDataformRepositorySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataform_repository_resource_name: _builtins.str,
                 commit_sha: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataform_repository_resource_name: The resource name of the Dataform Repository.
        :param _builtins.str commit_sha: The commit SHA to read repository with. If unset, the file will be read at HEAD.
        """
        pulumi.set(__self__, "dataform_repository_resource_name", dataform_repository_resource_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)

    @_builtins.property
    @pulumi.getter(name="dataformRepositoryResourceName")
    def dataform_repository_resource_name(self) -> _builtins.str:
        """
        The resource name of the Dataform Repository.
        """
        return pulumi.get(self, "dataform_repository_resource_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[_builtins.str]:
        """
        The commit SHA to read repository with. If unset, the file will be read at HEAD.
        """
        return pulumi.get(self, "commit_sha")


@pulumi.output_type
class ScheduleCreateNotebookExecutionJobRequestNotebookExecutionJobGcsNotebookSource(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 generation: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The Cloud Storage uri pointing to the ipynb file. Format: gs://bucket/notebook_file.ipynb
        :param _builtins.str generation: The version of the Cloud Storage object to read. If unset, the current version of the object is read. See https://cloud.google.com/storage/docs/metadata#generation-number.
        """
        pulumi.set(__self__, "uri", uri)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The Cloud Storage uri pointing to the ipynb file. Format: gs://bucket/notebook_file.ipynb
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.str]:
        """
        The version of the Cloud Storage object to read. If unset, the current version of the object is read. See https://cloud.google.com/storage/docs/metadata#generation-number.
        """
        return pulumi.get(self, "generation")


