# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, archive_size_bytes=None, creation_timestamp=None, description=None, disk_size_gb=None, family=None, filter=None, id=None, image_encryption_key_sha256=None, image_id=None, label_fingerprint=None, labels=None, licenses=None, most_recent=None, name=None, project=None, self_link=None, source_disk=None, source_disk_encryption_key_sha256=None, source_disk_id=None, source_image_id=None, status=None):
        if archive_size_bytes and not isinstance(archive_size_bytes, int):
            raise TypeError("Expected argument 'archive_size_bytes' to be a int")
        pulumi.set(__self__, "archive_size_bytes", archive_size_bytes)
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_size_gb and not isinstance(disk_size_gb, int):
            raise TypeError("Expected argument 'disk_size_gb' to be a int")
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if family and not isinstance(family, str):
            raise TypeError("Expected argument 'family' to be a str")
        pulumi.set(__self__, "family", family)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_encryption_key_sha256 and not isinstance(image_encryption_key_sha256, str):
            raise TypeError("Expected argument 'image_encryption_key_sha256' to be a str")
        pulumi.set(__self__, "image_encryption_key_sha256", image_encryption_key_sha256)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if licenses and not isinstance(licenses, list):
            raise TypeError("Expected argument 'licenses' to be a list")
        pulumi.set(__self__, "licenses", licenses)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if source_disk and not isinstance(source_disk, str):
            raise TypeError("Expected argument 'source_disk' to be a str")
        pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_encryption_key_sha256 and not isinstance(source_disk_encryption_key_sha256, str):
            raise TypeError("Expected argument 'source_disk_encryption_key_sha256' to be a str")
        pulumi.set(__self__, "source_disk_encryption_key_sha256", source_disk_encryption_key_sha256)
        if source_disk_id and not isinstance(source_disk_id, str):
            raise TypeError("Expected argument 'source_disk_id' to be a str")
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        if source_image_id and not isinstance(source_image_id, str):
            raise TypeError("Expected argument 'source_image_id' to be a str")
        pulumi.set(__self__, "source_image_id", source_image_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="archiveSizeBytes")
    def archive_size_bytes(self) -> _builtins.int:
        """
        The size of the image tar.gz archive stored in Google Cloud Storage in bytes.
        """
        return pulumi.get(self, "archive_size_bytes")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> _builtins.str:
        """
        The creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An optional description of this image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The size of the image when restored onto a persistent disk in gigabytes.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        The family name of the image.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageEncryptionKeySha256")
    def image_encryption_key_sha256(self) -> _builtins.str:
        """
        The [RFC 4648 base64](https://tools.ietf.org/html/rfc4648#section-4)
        encoded SHA-256 hash of the [customer-supplied encryption key](https://cloud.google.com/compute/docs/disks/customer-supplied-encryption)
        that protects this image.
        """
        return pulumi.get(self, "image_encryption_key_sha256")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The unique identifier for the image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> _builtins.str:
        """
        A fingerprint for the labels being applied to this image.
        """
        return pulumi.get(self, "label_fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def licenses(self) -> Sequence[_builtins.str]:
        """
        A list of applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @_builtins.property
    @pulumi.getter(name="mostRecent")
    def most_recent(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "most_recent")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI of the image.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> _builtins.str:
        """
        The URL of the source disk used to create this image.
        """
        return pulumi.get(self, "source_disk")

    @_builtins.property
    @pulumi.getter(name="sourceDiskEncryptionKeySha256")
    def source_disk_encryption_key_sha256(self) -> _builtins.str:
        """
        The [RFC 4648 base64](https://tools.ietf.org/html/rfc4648#section-4)
        encoded SHA-256 hash of the [customer-supplied encryption key](https://cloud.google.com/compute/docs/disks/customer-supplied-encryption)
        that protects this image.
        """
        return pulumi.get(self, "source_disk_encryption_key_sha256")

    @_builtins.property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> _builtins.str:
        """
        The ID value of the disk used to create this image.
        """
        return pulumi.get(self, "source_disk_id")

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> _builtins.str:
        """
        The ID value of the image used to create this image.
        """
        return pulumi.get(self, "source_image_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the image. Possible values are **FAILED**, **PENDING**, or **READY**.
        """
        return pulumi.get(self, "status")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            archive_size_bytes=self.archive_size_bytes,
            creation_timestamp=self.creation_timestamp,
            description=self.description,
            disk_size_gb=self.disk_size_gb,
            family=self.family,
            filter=self.filter,
            id=self.id,
            image_encryption_key_sha256=self.image_encryption_key_sha256,
            image_id=self.image_id,
            label_fingerprint=self.label_fingerprint,
            labels=self.labels,
            licenses=self.licenses,
            most_recent=self.most_recent,
            name=self.name,
            project=self.project,
            self_link=self.self_link,
            source_disk=self.source_disk,
            source_disk_encryption_key_sha256=self.source_disk_encryption_key_sha256,
            source_disk_id=self.source_disk_id,
            source_image_id=self.source_image_id,
            status=self.status)


def get_image(family: Optional[_builtins.str] = None,
              filter: Optional[_builtins.str] = None,
              most_recent: Optional[_builtins.bool] = None,
              name: Optional[_builtins.str] = None,
              project: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Get information about a Google Compute Image. Check that your service account has the `compute.imageUser` role if you want to share [custom images](https://cloud.google.com/compute/docs/images/sharing-images-across-projects) from another project. If you want to use [public images][pubimg], do not forget to specify the dedicated project. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/images) and its [API](https://cloud.google.com/compute/docs/reference/latest/images).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_image = gcp.compute.get_image(family="debian-11",
        project="debian-cloud")
    default = gcp.compute.Instance("default", boot_disk={
        "initialize_params": {
            "image": my_image.self_link,
        },
    })
    ```


    :param _builtins.str family: The family name of the image.
    :param _builtins.bool most_recent: A boolean to indicate either to take to most recent image if your filter
           returns more than one image.
    :param _builtins.str name: , `family` or `filter` - (Required) The name of a specific image or a family.
           Exactly one of `name`, `family` or `filter` must be specified. If `name` is specified, it will fetch
           the corresponding image. If `family` is specified, it will return the latest image
           that is part of an image family and is not deprecated. If you specify `filter`, your
           filter must return exactly one image unless you use `most_recent`.
           Filter syntax can be found [here](https://cloud.google.com/compute/docs/reference/rest/v1/images/list) in the filter section.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it is not
           provided, the provider project is used. If you are using a
           [public base image][pubimg], be sure to specify the correct Image Project.
    """
    __args__ = dict()
    __args__['family'] = family
    __args__['filter'] = filter
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        archive_size_bytes=pulumi.get(__ret__, 'archive_size_bytes'),
        creation_timestamp=pulumi.get(__ret__, 'creation_timestamp'),
        description=pulumi.get(__ret__, 'description'),
        disk_size_gb=pulumi.get(__ret__, 'disk_size_gb'),
        family=pulumi.get(__ret__, 'family'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        image_encryption_key_sha256=pulumi.get(__ret__, 'image_encryption_key_sha256'),
        image_id=pulumi.get(__ret__, 'image_id'),
        label_fingerprint=pulumi.get(__ret__, 'label_fingerprint'),
        labels=pulumi.get(__ret__, 'labels'),
        licenses=pulumi.get(__ret__, 'licenses'),
        most_recent=pulumi.get(__ret__, 'most_recent'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        self_link=pulumi.get(__ret__, 'self_link'),
        source_disk=pulumi.get(__ret__, 'source_disk'),
        source_disk_encryption_key_sha256=pulumi.get(__ret__, 'source_disk_encryption_key_sha256'),
        source_disk_id=pulumi.get(__ret__, 'source_disk_id'),
        source_image_id=pulumi.get(__ret__, 'source_image_id'),
        status=pulumi.get(__ret__, 'status'))
def get_image_output(family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     most_recent: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Get information about a Google Compute Image. Check that your service account has the `compute.imageUser` role if you want to share [custom images](https://cloud.google.com/compute/docs/images/sharing-images-across-projects) from another project. If you want to use [public images][pubimg], do not forget to specify the dedicated project. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/images) and its [API](https://cloud.google.com/compute/docs/reference/latest/images).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_image = gcp.compute.get_image(family="debian-11",
        project="debian-cloud")
    default = gcp.compute.Instance("default", boot_disk={
        "initialize_params": {
            "image": my_image.self_link,
        },
    })
    ```


    :param _builtins.str family: The family name of the image.
    :param _builtins.bool most_recent: A boolean to indicate either to take to most recent image if your filter
           returns more than one image.
    :param _builtins.str name: , `family` or `filter` - (Required) The name of a specific image or a family.
           Exactly one of `name`, `family` or `filter` must be specified. If `name` is specified, it will fetch
           the corresponding image. If `family` is specified, it will return the latest image
           that is part of an image family and is not deprecated. If you specify `filter`, your
           filter must return exactly one image unless you use `most_recent`.
           Filter syntax can be found [here](https://cloud.google.com/compute/docs/reference/rest/v1/images/list) in the filter section.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it is not
           provided, the provider project is used. If you are using a
           [public base image][pubimg], be sure to specify the correct Image Project.
    """
    __args__ = dict()
    __args__['family'] = family
    __args__['filter'] = filter
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        archive_size_bytes=pulumi.get(__response__, 'archive_size_bytes'),
        creation_timestamp=pulumi.get(__response__, 'creation_timestamp'),
        description=pulumi.get(__response__, 'description'),
        disk_size_gb=pulumi.get(__response__, 'disk_size_gb'),
        family=pulumi.get(__response__, 'family'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        image_encryption_key_sha256=pulumi.get(__response__, 'image_encryption_key_sha256'),
        image_id=pulumi.get(__response__, 'image_id'),
        label_fingerprint=pulumi.get(__response__, 'label_fingerprint'),
        labels=pulumi.get(__response__, 'labels'),
        licenses=pulumi.get(__response__, 'licenses'),
        most_recent=pulumi.get(__response__, 'most_recent'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        self_link=pulumi.get(__response__, 'self_link'),
        source_disk=pulumi.get(__response__, 'source_disk'),
        source_disk_encryption_key_sha256=pulumi.get(__response__, 'source_disk_encryption_key_sha256'),
        source_disk_id=pulumi.get(__response__, 'source_disk_id'),
        source_image_id=pulumi.get(__response__, 'source_image_id'),
        status=pulumi.get(__response__, 'status')))
