# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityPolicyResult',
    'AwaitableGetSecurityPolicyResult',
    'get_security_policy',
    'get_security_policy_output',
]

@pulumi.output_type
class GetSecurityPolicyResult:
    """
    A collection of values returned by getSecurityPolicy.
    """
    def __init__(__self__, adaptive_protection_configs=None, advanced_options_configs=None, description=None, fingerprint=None, id=None, name=None, project=None, recaptcha_options_configs=None, rules=None, self_link=None, type=None):
        if adaptive_protection_configs and not isinstance(adaptive_protection_configs, list):
            raise TypeError("Expected argument 'adaptive_protection_configs' to be a list")
        pulumi.set(__self__, "adaptive_protection_configs", adaptive_protection_configs)
        if advanced_options_configs and not isinstance(advanced_options_configs, list):
            raise TypeError("Expected argument 'advanced_options_configs' to be a list")
        pulumi.set(__self__, "advanced_options_configs", advanced_options_configs)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if recaptcha_options_configs and not isinstance(recaptcha_options_configs, list):
            raise TypeError("Expected argument 'recaptcha_options_configs' to be a list")
        pulumi.set(__self__, "recaptcha_options_configs", recaptcha_options_configs)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="adaptiveProtectionConfigs")
    def adaptive_protection_configs(self) -> Sequence['outputs.GetSecurityPolicyAdaptiveProtectionConfigResult']:
        return pulumi.get(self, "adaptive_protection_configs")

    @_builtins.property
    @pulumi.getter(name="advancedOptionsConfigs")
    def advanced_options_configs(self) -> Sequence['outputs.GetSecurityPolicyAdvancedOptionsConfigResult']:
        return pulumi.get(self, "advanced_options_configs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="recaptchaOptionsConfigs")
    def recaptcha_options_configs(self) -> Sequence['outputs.GetSecurityPolicyRecaptchaOptionsConfigResult']:
        return pulumi.get(self, "recaptcha_options_configs")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSecurityPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetSecurityPolicyResult(GetSecurityPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyResult(
            adaptive_protection_configs=self.adaptive_protection_configs,
            advanced_options_configs=self.advanced_options_configs,
            description=self.description,
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            project=self.project,
            recaptcha_options_configs=self.recaptcha_options_configs,
            rules=self.rules,
            self_link=self.self_link,
            type=self.type)


def get_security_policy(name: Optional[_builtins.str] = None,
                        project: Optional[_builtins.str] = None,
                        self_link: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyResult:
    """
    To get more information about Google Compute Security Policy, see:

    * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/armor/docs/configure-security-policies)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    sp1 = gcp.compute.get_security_policy(name="my-policy",
        project="my-project")
    sp2 = gcp.compute.get_security_policy(self_link="https://www.googleapis.com/compute/v1/projects/my-project/global/securityPolicies/my-policy")
    ```


    :param _builtins.str name: The name of the security policy. Provide either this or a `self_link`.
    :param _builtins.str project: The project in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str self_link: The self_link of the security policy. Provide either this or a `name`
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult).value

    return AwaitableGetSecurityPolicyResult(
        adaptive_protection_configs=pulumi.get(__ret__, 'adaptive_protection_configs'),
        advanced_options_configs=pulumi.get(__ret__, 'advanced_options_configs'),
        description=pulumi.get(__ret__, 'description'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        recaptcha_options_configs=pulumi.get(__ret__, 'recaptcha_options_configs'),
        rules=pulumi.get(__ret__, 'rules'),
        self_link=pulumi.get(__ret__, 'self_link'),
        type=pulumi.get(__ret__, 'type'))
def get_security_policy_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               self_link: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyResult]:
    """
    To get more information about Google Compute Security Policy, see:

    * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/securityPolicies)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/armor/docs/configure-security-policies)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    sp1 = gcp.compute.get_security_policy(name="my-policy",
        project="my-project")
    sp2 = gcp.compute.get_security_policy(self_link="https://www.googleapis.com/compute/v1/projects/my-project/global/securityPolicies/my-policy")
    ```


    :param _builtins.str name: The name of the security policy. Provide either this or a `self_link`.
    :param _builtins.str project: The project in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str self_link: The self_link of the security policy. Provide either this or a `name`
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['selfLink'] = self_link
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getSecurityPolicy:getSecurityPolicy', __args__, opts=opts, typ=GetSecurityPolicyResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyResult(
        adaptive_protection_configs=pulumi.get(__response__, 'adaptive_protection_configs'),
        advanced_options_configs=pulumi.get(__response__, 'advanced_options_configs'),
        description=pulumi.get(__response__, 'description'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        recaptcha_options_configs=pulumi.get(__response__, 'recaptcha_options_configs'),
        rules=pulumi.get(__response__, 'rules'),
        self_link=pulumi.get(__response__, 'self_link'),
        type=pulumi.get(__response__, 'type')))
