# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionBackendServiceArgs', 'RegionBackendService']

@pulumi.input_type
class RegionBackendServiceArgs:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']] = None,
                 consistent_hash: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_policy: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']] = None,
                 ha_policy: Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input['RegionBackendServiceIapArgs']] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 outlier_detection: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']] = None,
                 subsetting: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a RegionBackendService resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs'] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input['RegionBackendServiceDynamicForwardingArgs'] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input['RegionBackendServiceFailoverPolicyArgs'] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceHaPolicyArgs'] ha_policy: Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
               The backends of this regional backend service must only specify zonal network endpoint groups
               (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
               be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
               requires customers to be responsible for tracking backend endpoint health and electing a
               leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
               haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
               Passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input['RegionBackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input['RegionBackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input['RegionBackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs'] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceSubsettingArgs'] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if connection_tracking_policy is not None:
            pulumi.set(__self__, "connection_tracking_policy", connection_tracking_policy)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_forwarding is not None:
            pulumi.set(__self__, "dynamic_forwarding", dynamic_forwarding)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)
        if ha_policy is not None:
            pulumi.set(__self__, "ha_policy", ha_policy)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if ip_address_selection_policy is not None:
            pulumi.set(__self__, "ip_address_selection_policy", ip_address_selection_policy)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if strong_session_affinity_cookie is not None:
            pulumi.set(__self__, "strong_session_affinity_cookie", strong_session_affinity_cookie)
        if subsetting is not None:
            pulumi.set(__self__, "subsetting", subsetting)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @connection_tracking_policy.setter
    def connection_tracking_policy(self, value: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]):
        pulumi.set(self, "connection_tracking_policy", value)

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @dynamic_forwarding.setter
    def dynamic_forwarding(self, value: Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']]):
        pulumi.set(self, "dynamic_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cdn", value)

    @_builtins.property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]):
        pulumi.set(self, "failover_policy", value)

    @_builtins.property
    @pulumi.getter(name="haPolicy")
    def ha_policy(self) -> Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']]:
        """
        Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
        The backends of this regional backend service must only specify zonal network endpoint groups
        (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
        be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
        requires customers to be responsible for tracking backend endpoint health and electing a
        leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
        haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
        Passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "ha_policy")

    @ha_policy.setter
    def ha_policy(self, value: Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']]):
        pulumi.set(self, "ha_policy", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['RegionBackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['RegionBackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @ip_address_selection_policy.setter
    def ip_address_selection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_selection_policy", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @strong_session_affinity_cookie.setter
    def strong_session_affinity_cookie(self, value: Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']]):
        pulumi.set(self, "strong_session_affinity_cookie", value)

    @_builtins.property
    @pulumi.getter
    def subsetting(self) -> Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "subsetting")

    @subsetting.setter
    def subsetting(self, value: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]):
        pulumi.set(self, "subsetting", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.input_type
class _RegionBackendServiceState:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']] = None,
                 consistent_hash: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_policy: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 generated_id: Optional[pulumi.Input[_builtins.int]] = None,
                 ha_policy: Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input['RegionBackendServiceIapArgs']] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 outlier_detection: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']] = None,
                 subsetting: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RegionBackendService resources.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs'] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input['RegionBackendServiceDynamicForwardingArgs'] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input['RegionBackendServiceFailoverPolicyArgs'] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[_builtins.int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input['RegionBackendServiceHaPolicyArgs'] ha_policy: Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
               The backends of this regional backend service must only specify zonal network endpoint groups
               (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
               be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
               requires customers to be responsible for tracking backend endpoint health and electing a
               leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
               haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
               Passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input['RegionBackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input['RegionBackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input['RegionBackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs'] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input['RegionBackendServiceSubsettingArgs'] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if connection_tracking_policy is not None:
            pulumi.set(__self__, "connection_tracking_policy", connection_tracking_policy)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_forwarding is not None:
            pulumi.set(__self__, "dynamic_forwarding", dynamic_forwarding)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if generated_id is not None:
            pulumi.set(__self__, "generated_id", generated_id)
        if ha_policy is not None:
            pulumi.set(__self__, "ha_policy", ha_policy)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if ip_address_selection_policy is not None:
            pulumi.set(__self__, "ip_address_selection_policy", ip_address_selection_policy)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if strong_session_affinity_cookie is not None:
            pulumi.set(__self__, "strong_session_affinity_cookie", strong_session_affinity_cookie)
        if subsetting is not None:
            pulumi.set(__self__, "subsetting", subsetting)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['RegionBackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['RegionBackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @_builtins.property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @connection_tracking_policy.setter
    def connection_tracking_policy(self, value: Optional[pulumi.Input['RegionBackendServiceConnectionTrackingPolicyArgs']]):
        pulumi.set(self, "connection_tracking_policy", value)

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['RegionBackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionBackendServiceCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @dynamic_forwarding.setter
    def dynamic_forwarding(self, value: Optional[pulumi.Input['RegionBackendServiceDynamicForwardingArgs']]):
        pulumi.set(self, "dynamic_forwarding", value)

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cdn", value)

    @_builtins.property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input['RegionBackendServiceFailoverPolicyArgs']]):
        pulumi.set(self, "failover_policy", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @generated_id.setter
    def generated_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "generated_id", value)

    @_builtins.property
    @pulumi.getter(name="haPolicy")
    def ha_policy(self) -> Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']]:
        """
        Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
        The backends of this regional backend service must only specify zonal network endpoint groups
        (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
        be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
        requires customers to be responsible for tracking backend endpoint health and electing a
        leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
        haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
        Passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "ha_policy")

    @ha_policy.setter
    def ha_policy(self, value: Optional[pulumi.Input['RegionBackendServiceHaPolicyArgs']]):
        pulumi.set(self, "ha_policy", value)

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_checks", value)

    @_builtins.property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['RegionBackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['RegionBackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @ip_address_selection_policy.setter
    def ip_address_selection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_selection_policy", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RegionBackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['RegionBackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @strong_session_affinity_cookie.setter
    def strong_session_affinity_cookie(self, value: Optional[pulumi.Input['RegionBackendServiceStrongSessionAffinityCookieArgs']]):
        pulumi.set(self, "strong_session_affinity_cookie", value)

    @_builtins.property
    @pulumi.getter
    def subsetting(self) -> Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "subsetting")

    @subsetting.setter
    def subsetting(self, value: Optional[pulumi.Input['RegionBackendServiceSubsettingArgs']]):
        pulumi.set(self, "subsetting", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.type_token("gcp:compute/regionBackendService:RegionBackendService")
class RegionBackendService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceBackendArgs', 'RegionBackendServiceBackendArgsDict']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[Union['RegionBackendServiceCdnPolicyArgs', 'RegionBackendServiceCdnPolicyArgsDict']]] = None,
                 circuit_breakers: Optional[pulumi.Input[Union['RegionBackendServiceCircuitBreakersArgs', 'RegionBackendServiceCircuitBreakersArgsDict']]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input[Union['RegionBackendServiceConnectionTrackingPolicyArgs', 'RegionBackendServiceConnectionTrackingPolicyArgsDict']]] = None,
                 consistent_hash: Optional[pulumi.Input[Union['RegionBackendServiceConsistentHashArgs', 'RegionBackendServiceConsistentHashArgsDict']]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceCustomMetricArgs', 'RegionBackendServiceCustomMetricArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input[Union['RegionBackendServiceDynamicForwardingArgs', 'RegionBackendServiceDynamicForwardingArgsDict']]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_policy: Optional[pulumi.Input[Union['RegionBackendServiceFailoverPolicyArgs', 'RegionBackendServiceFailoverPolicyArgsDict']]] = None,
                 ha_policy: Optional[pulumi.Input[Union['RegionBackendServiceHaPolicyArgs', 'RegionBackendServiceHaPolicyArgsDict']]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input[Union['RegionBackendServiceIapArgs', 'RegionBackendServiceIapArgsDict']]] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['RegionBackendServiceLogConfigArgs', 'RegionBackendServiceLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 outlier_detection: Optional[pulumi.Input[Union['RegionBackendServiceOutlierDetectionArgs', 'RegionBackendServiceOutlierDetectionArgsDict']]] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input[Union['RegionBackendServiceStrongSessionAffinityCookieArgs', 'RegionBackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
                 subsetting: Optional[pulumi.Input[Union['RegionBackendServiceSubsettingArgs', 'RegionBackendServiceSubsettingArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        A Region Backend Service defines a regionally-scoped group of virtual
        machines that will serve traffic for load balancing.

        > **Note:** Recreating a `compute.RegionBackendService` that references other dependent resources like `compute.InstanceGroup` will give a `resourceInUseByAnotherResource` error, when decreasing the number of other dependent resources.
        Use `lifecycle.create_before_destroy` on the dependent resources to avoid this type of error as shown in the Dynamic Backend Count example.

        To get more information about RegionBackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/latest/regionBackendServices)
        * How-to Guides
            * [Internal TCP/UDP Load Balancing](https://cloud.google.com/compute/docs/load-balancing/internal/)

        ## Example Usage

        ### Region Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="rbs-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=default_health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        ```
        ### Region Backend Service External Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="tf-test-region-service-external",
            region="us-central1",
            protocol="HTTP",
            load_balancing_scheme="EXTERNAL",
            iap={
                "enabled": True,
                "oauth2_client_id": "abc",
                "oauth2_client_secret": "xyz",
            })
        ```
        ### Region Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            name="rbs-health-check",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=default_region_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
            },
            load_balancing_scheme="EXTERNAL",
            protocol="HTTP")
        ```
        ### Region Backend Service Ilb Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Region Backend Service External

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="TCP",
            load_balancing_scheme="EXTERNAL")
        ```
        ### Region Backend Service External Weighted

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            locality_lb_policy="WEIGHTED_MAGLEV")
        ```
        ### Region Backend Service Ilb Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            protocol="HTTP",
            circuit_breakers={
                "max_connections": 10,
            },
            consistent_hash={
                "http_cookie": {
                    "ttl": {
                        "seconds": 11,
                        "nanos": 1111,
                    },
                    "name": "mycookie",
                },
            },
            outlier_detection={
                "consecutive_errors": 2,
            })
        ```
        ### Region Backend Service Ilb Stateful Session Affinity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="STRONG_COOKIE_AFFINITY",
            protocol="HTTP",
            strong_session_affinity_cookie={
                "ttl": {
                    "seconds": 11,
                    "nanos": 1111,
                },
                "name": "mycookie",
            })
        ```
        ### Region Backend Service Balancing Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="rbs-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="rbs-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-region-service",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="rbs-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="rbs-health-check",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            })
        default = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="region-service",
            protocol="H2C",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        ```
        ### Region Backend Service Connection Tracking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 22,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP",
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            connection_tracking_policy={
                "tracking_mode": "PER_SESSION",
                "connection_persistence_on_unhealthy_backends": "NEVER_PERSIST",
                "idle_timeout_sec": 60,
                "enable_strong_affinity": True,
            })
        ```
        ### Region Backend Service Ip Address Selection Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTP",
            ip_address_selection_policy="IPV6_ONLY")
        ```
        ### Region Backend Service Ilb Custom Metrics

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="network-endpoint",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="WEIGHTED_ROUND_ROBIN",
            custom_metrics=[{
                "name": "orca.application_utilization",
                "dry_run": False,
            }],
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "CUSTOM_METRICS",
                "custom_metrics": [
                    {
                        "name": "orca.cpu_utilization",
                        "max_utilization": 0.9,
                        "dry_run": True,
                    },
                    {
                        "name": "orca.named_metrics.foo",
                        "dry_run": False,
                    },
                ],
            }])
        ```
        ### Region Backend Service Dynamic Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            load_balancing_scheme="EXTERNAL_MANAGED",
            dynamic_forwarding={
                "ip_port_selection": {
                    "enabled": True,
                },
            })
        ```
        ### Region Backend Service Ha Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="rbs-net")
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            protocol="UDP",
            load_balancing_scheme="EXTERNAL",
            network=default.id,
            ha_policy={
                "fast_ip_move": "GARP_RA",
            },
            connection_draining_timeout_sec=0)
        ```
        ### Region Backend Service Ha Policy Manual Leader

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="rbs-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="rbs-subnet",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default.id)
        my_image = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        endpoint_instance = gcp.compute.Instance("endpoint-instance",
            network_interfaces=[{
                "access_configs": [{}],
                "subnetwork": default_subnetwork.id,
            }],
            name="rbs-instance",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            })
        neg = gcp.compute.NetworkEndpointGroup("neg",
            name="rbs-neg",
            network_endpoint_type="GCE_VM_IP",
            network=default.id,
            subnetwork=default_subnetwork.id,
            zone="us-central1-a")
        endpoint = gcp.compute.NetworkEndpoint("endpoint",
            network_endpoint_group=neg.name,
            instance=endpoint_instance.name,
            ip_address=endpoint_instance.network_interfaces[0].network_ip)
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            protocol="UDP",
            load_balancing_scheme="EXTERNAL",
            network=default.id,
            backends=[{
                "group": neg.self_link,
                "balancing_mode": "CONNECTION",
            }],
            ha_policy={
                "fast_ip_move": "GARP_RA",
                "leader": {
                    "backend_group": neg.self_link,
                    "network_endpoint": {
                        "instance": endpoint_instance.name,
                    },
                },
            },
            connection_draining_timeout_sec=0)
        ```

        ## Import

        RegionBackendService can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/backendServices/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionBackendService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default projects/{{project}}/regions/{{region}}/backendServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceBackendArgs', 'RegionBackendServiceBackendArgsDict']]]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceCdnPolicyArgs', 'RegionBackendServiceCdnPolicyArgsDict']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceCircuitBreakersArgs', 'RegionBackendServiceCircuitBreakersArgsDict']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[Union['RegionBackendServiceConnectionTrackingPolicyArgs', 'RegionBackendServiceConnectionTrackingPolicyArgsDict']] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceConsistentHashArgs', 'RegionBackendServiceConsistentHashArgsDict']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceCustomMetricArgs', 'RegionBackendServiceCustomMetricArgsDict']]]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Union['RegionBackendServiceDynamicForwardingArgs', 'RegionBackendServiceDynamicForwardingArgsDict']] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input[Union['RegionBackendServiceFailoverPolicyArgs', 'RegionBackendServiceFailoverPolicyArgsDict']] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceHaPolicyArgs', 'RegionBackendServiceHaPolicyArgsDict']] ha_policy: Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
               The backends of this regional backend service must only specify zonal network endpoint groups
               (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
               be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
               requires customers to be responsible for tracking backend endpoint health and electing a
               leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
               haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
               Passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input[Union['RegionBackendServiceIapArgs', 'RegionBackendServiceIapArgsDict']] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input[Union['RegionBackendServiceLogConfigArgs', 'RegionBackendServiceLogConfigArgsDict']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input[Union['RegionBackendServiceOutlierDetectionArgs', 'RegionBackendServiceOutlierDetectionArgsDict']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input[Union['RegionBackendServiceStrongSessionAffinityCookieArgs', 'RegionBackendServiceStrongSessionAffinityCookieArgsDict']] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceSubsettingArgs', 'RegionBackendServiceSubsettingArgsDict']] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegionBackendServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Region Backend Service defines a regionally-scoped group of virtual
        machines that will serve traffic for load balancing.

        > **Note:** Recreating a `compute.RegionBackendService` that references other dependent resources like `compute.InstanceGroup` will give a `resourceInUseByAnotherResource` error, when decreasing the number of other dependent resources.
        Use `lifecycle.create_before_destroy` on the dependent resources to avoid this type of error as shown in the Dynamic Backend Count example.

        To get more information about RegionBackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/latest/regionBackendServices)
        * How-to Guides
            * [Internal TCP/UDP Load Balancing](https://cloud.google.com/compute/docs/load-balancing/internal/)

        ## Example Usage

        ### Region Backend Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_health_check = gcp.compute.HealthCheck("default",
            name="rbs-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=default_health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP")
        ```
        ### Region Backend Service External Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="tf-test-region-service-external",
            region="us-central1",
            protocol="HTTP",
            load_balancing_scheme="EXTERNAL",
            iap={
                "enabled": True,
                "oauth2_client_id": "abc",
                "oauth2_client_secret": "xyz",
            })
        ```
        ### Region Backend Service Cache

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            name="rbs-health-check",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=default_region_health_check.id,
            enable_cdn=True,
            cdn_policy={
                "cache_mode": "CACHE_ALL_STATIC",
                "default_ttl": 3600,
                "client_ttl": 7200,
                "max_ttl": 10800,
                "negative_caching": True,
                "signed_url_cache_max_age_sec": 7200,
            },
            load_balancing_scheme="EXTERNAL",
            protocol="HTTP")
        ```
        ### Region Backend Service Ilb Round Robin

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="ROUND_ROBIN")
        ```
        ### Region Backend Service External

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="TCP",
            load_balancing_scheme="EXTERNAL")
        ```
        ### Region Backend Service External Weighted

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            locality_lb_policy="WEIGHTED_MAGLEV")
        ```
        ### Region Backend Service Ilb Ring Hash

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="HTTP_COOKIE",
            protocol="HTTP",
            circuit_breakers={
                "max_connections": 10,
            },
            consistent_hash={
                "http_cookie": {
                    "ttl": {
                        "seconds": 11,
                        "nanos": 1111,
                    },
                    "name": "mycookie",
                },
            },
            outlier_detection={
                "consecutive_errors": 2,
            })
        ```
        ### Region Backend Service Ilb Stateful Session Affinity

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="RING_HASH",
            session_affinity="STRONG_COOKIE_AFFINITY",
            protocol="HTTP",
            strong_session_affinity_cookie={
                "ttl": {
                    "seconds": 11,
                    "nanos": 1111,
                },
                "name": "mycookie",
            })
        ```
        ### Region Backend Service Balancing Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_network = gcp.compute.Network("default",
            name="rbs-net",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="rbs-net-default",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id)
        instance_template = gcp.compute.InstanceTemplate("instance_template",
            name="template-region-service",
            machine_type="e2-medium",
            network_interfaces=[{
                "network": default_network.id,
                "subnetwork": default_subnetwork.id,
            }],
            disks=[{
                "source_image": debian_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ])
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            name="rbs-rigm",
            versions=[{
                "instance_template": instance_template.id,
                "name": "primary",
            }],
            base_instance_name="internal-glb",
            target_size=1)
        default_region_health_check = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="rbs-health-check",
            http_health_check={
                "port_specification": "USE_SERVING_PORT",
            })
        default = gcp.compute.RegionBackendService("default",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": rigm.instance_group,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }],
            region="us-central1",
            name="region-service",
            protocol="H2C",
            timeout_sec=10,
            health_checks=default_region_health_check.id)
        ```
        ### Region Backend Service Connection Tracking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 22,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=health_check.id,
            connection_draining_timeout_sec=10,
            session_affinity="CLIENT_IP",
            protocol="TCP",
            load_balancing_scheme="EXTERNAL",
            connection_tracking_policy={
                "tracking_mode": "PER_SESSION",
                "connection_persistence_on_unhealthy_backends": "NEVER_PERSIST",
                "idle_timeout_sec": 60,
                "enable_strong_affinity": True,
            })
        ```
        ### Region Backend Service Ip Address Selection Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("health_check",
            name="rbs-health-check",
            region="us-central1",
            tcp_health_check={
                "port": 80,
            })
        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            health_checks=health_check.id,
            load_balancing_scheme="EXTERNAL_MANAGED",
            protocol="HTTP",
            ip_address_selection_policy="IPV6_ONLY")
        ```
        ### Region Backend Service Ilb Custom Metrics

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        # Zonal NEG with GCE_VM_IP_PORT
        default_network_endpoint_group = gcp.compute.NetworkEndpointGroup("default",
            name="network-endpoint",
            network=default.id,
            default_port=90,
            zone="us-central1-a",
            network_endpoint_type="GCE_VM_IP_PORT")
        health_check = gcp.compute.HealthCheck("health_check",
            name="rbs-health-check",
            http_health_check={
                "port": 80,
            })
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            health_checks=health_check.id,
            load_balancing_scheme="INTERNAL_MANAGED",
            locality_lb_policy="WEIGHTED_ROUND_ROBIN",
            custom_metrics=[{
                "name": "orca.application_utilization",
                "dry_run": False,
            }],
            backends=[{
                "group": default_network_endpoint_group.id,
                "balancing_mode": "CUSTOM_METRICS",
                "custom_metrics": [
                    {
                        "name": "orca.cpu_utilization",
                        "max_utilization": 0.9,
                        "dry_run": True,
                    },
                    {
                        "name": "orca.named_metrics.foo",
                        "dry_run": False,
                    },
                ],
            }])
        ```
        ### Region Backend Service Dynamic Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionBackendService("default",
            name="region-service",
            region="us-central1",
            load_balancing_scheme="EXTERNAL_MANAGED",
            dynamic_forwarding={
                "ip_port_selection": {
                    "enabled": True,
                },
            })
        ```
        ### Region Backend Service Ha Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="rbs-net")
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            protocol="UDP",
            load_balancing_scheme="EXTERNAL",
            network=default.id,
            ha_policy={
                "fast_ip_move": "GARP_RA",
            },
            connection_draining_timeout_sec=0)
        ```
        ### Region Backend Service Ha Policy Manual Leader

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="rbs-net",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="rbs-subnet",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default.id)
        my_image = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        endpoint_instance = gcp.compute.Instance("endpoint-instance",
            network_interfaces=[{
                "access_configs": [{}],
                "subnetwork": default_subnetwork.id,
            }],
            name="rbs-instance",
            machine_type="e2-medium",
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            })
        neg = gcp.compute.NetworkEndpointGroup("neg",
            name="rbs-neg",
            network_endpoint_type="GCE_VM_IP",
            network=default.id,
            subnetwork=default_subnetwork.id,
            zone="us-central1-a")
        endpoint = gcp.compute.NetworkEndpoint("endpoint",
            network_endpoint_group=neg.name,
            instance=endpoint_instance.name,
            ip_address=endpoint_instance.network_interfaces[0].network_ip)
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            region="us-central1",
            name="region-service",
            protocol="UDP",
            load_balancing_scheme="EXTERNAL",
            network=default.id,
            backends=[{
                "group": neg.self_link,
                "balancing_mode": "CONNECTION",
            }],
            ha_policy={
                "fast_ip_move": "GARP_RA",
                "leader": {
                    "backend_group": neg.self_link,
                    "network_endpoint": {
                        "instance": endpoint_instance.name,
                    },
                },
            },
            connection_draining_timeout_sec=0)
        ```

        ## Import

        RegionBackendService can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/backendServices/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionBackendService can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default projects/{{project}}/regions/{{region}}/backendServices/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionBackendService:RegionBackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionBackendServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionBackendServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceBackendArgs', 'RegionBackendServiceBackendArgsDict']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[Union['RegionBackendServiceCdnPolicyArgs', 'RegionBackendServiceCdnPolicyArgsDict']]] = None,
                 circuit_breakers: Optional[pulumi.Input[Union['RegionBackendServiceCircuitBreakersArgs', 'RegionBackendServiceCircuitBreakersArgsDict']]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_tracking_policy: Optional[pulumi.Input[Union['RegionBackendServiceConnectionTrackingPolicyArgs', 'RegionBackendServiceConnectionTrackingPolicyArgsDict']]] = None,
                 consistent_hash: Optional[pulumi.Input[Union['RegionBackendServiceConsistentHashArgs', 'RegionBackendServiceConsistentHashArgsDict']]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceCustomMetricArgs', 'RegionBackendServiceCustomMetricArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_forwarding: Optional[pulumi.Input[Union['RegionBackendServiceDynamicForwardingArgs', 'RegionBackendServiceDynamicForwardingArgsDict']]] = None,
                 enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_policy: Optional[pulumi.Input[Union['RegionBackendServiceFailoverPolicyArgs', 'RegionBackendServiceFailoverPolicyArgsDict']]] = None,
                 ha_policy: Optional[pulumi.Input[Union['RegionBackendServiceHaPolicyArgs', 'RegionBackendServiceHaPolicyArgsDict']]] = None,
                 health_checks: Optional[pulumi.Input[_builtins.str]] = None,
                 iap: Optional[pulumi.Input[Union['RegionBackendServiceIapArgs', 'RegionBackendServiceIapArgsDict']]] = None,
                 ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['RegionBackendServiceLogConfigArgs', 'RegionBackendServiceLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 outlier_detection: Optional[pulumi.Input[Union['RegionBackendServiceOutlierDetectionArgs', 'RegionBackendServiceOutlierDetectionArgsDict']]] = None,
                 port_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 strong_session_affinity_cookie: Optional[pulumi.Input[Union['RegionBackendServiceStrongSessionAffinityCookieArgs', 'RegionBackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
                 subsetting: Optional[pulumi.Input[Union['RegionBackendServiceSubsettingArgs', 'RegionBackendServiceSubsettingArgsDict']]] = None,
                 timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionBackendServiceArgs.__new__(RegionBackendServiceArgs)

            __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
            __props__.__dict__["backends"] = backends
            __props__.__dict__["cdn_policy"] = cdn_policy
            __props__.__dict__["circuit_breakers"] = circuit_breakers
            __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
            __props__.__dict__["connection_tracking_policy"] = connection_tracking_policy
            __props__.__dict__["consistent_hash"] = consistent_hash
            __props__.__dict__["custom_metrics"] = custom_metrics
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamic_forwarding"] = dynamic_forwarding
            __props__.__dict__["enable_cdn"] = enable_cdn
            __props__.__dict__["failover_policy"] = failover_policy
            __props__.__dict__["ha_policy"] = ha_policy
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["iap"] = iap
            __props__.__dict__["ip_address_selection_policy"] = ip_address_selection_policy
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["locality_lb_policy"] = locality_lb_policy
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["outlier_detection"] = outlier_detection
            __props__.__dict__["port_name"] = port_name
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["strong_session_affinity_cookie"] = strong_session_affinity_cookie
            __props__.__dict__["subsetting"] = subsetting
            __props__.__dict__["timeout_sec"] = timeout_sec
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["generated_id"] = None
            __props__.__dict__["self_link"] = None
        super(RegionBackendService, __self__).__init__(
            'gcp:compute/regionBackendService:RegionBackendService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_cookie_ttl_sec: Optional[pulumi.Input[_builtins.int]] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceBackendArgs', 'RegionBackendServiceBackendArgsDict']]]]] = None,
            cdn_policy: Optional[pulumi.Input[Union['RegionBackendServiceCdnPolicyArgs', 'RegionBackendServiceCdnPolicyArgsDict']]] = None,
            circuit_breakers: Optional[pulumi.Input[Union['RegionBackendServiceCircuitBreakersArgs', 'RegionBackendServiceCircuitBreakersArgsDict']]] = None,
            connection_draining_timeout_sec: Optional[pulumi.Input[_builtins.int]] = None,
            connection_tracking_policy: Optional[pulumi.Input[Union['RegionBackendServiceConnectionTrackingPolicyArgs', 'RegionBackendServiceConnectionTrackingPolicyArgsDict']]] = None,
            consistent_hash: Optional[pulumi.Input[Union['RegionBackendServiceConsistentHashArgs', 'RegionBackendServiceConsistentHashArgsDict']]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceCustomMetricArgs', 'RegionBackendServiceCustomMetricArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_forwarding: Optional[pulumi.Input[Union['RegionBackendServiceDynamicForwardingArgs', 'RegionBackendServiceDynamicForwardingArgsDict']]] = None,
            enable_cdn: Optional[pulumi.Input[_builtins.bool]] = None,
            failover_policy: Optional[pulumi.Input[Union['RegionBackendServiceFailoverPolicyArgs', 'RegionBackendServiceFailoverPolicyArgsDict']]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            generated_id: Optional[pulumi.Input[_builtins.int]] = None,
            ha_policy: Optional[pulumi.Input[Union['RegionBackendServiceHaPolicyArgs', 'RegionBackendServiceHaPolicyArgsDict']]] = None,
            health_checks: Optional[pulumi.Input[_builtins.str]] = None,
            iap: Optional[pulumi.Input[Union['RegionBackendServiceIapArgs', 'RegionBackendServiceIapArgsDict']]] = None,
            ip_address_selection_policy: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancing_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            locality_lb_policy: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['RegionBackendServiceLogConfigArgs', 'RegionBackendServiceLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            outlier_detection: Optional[pulumi.Input[Union['RegionBackendServiceOutlierDetectionArgs', 'RegionBackendServiceOutlierDetectionArgsDict']]] = None,
            port_name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
            strong_session_affinity_cookie: Optional[pulumi.Input[Union['RegionBackendServiceStrongSessionAffinityCookieArgs', 'RegionBackendServiceStrongSessionAffinityCookieArgsDict']]] = None,
            subsetting: Optional[pulumi.Input[Union['RegionBackendServiceSubsettingArgs', 'RegionBackendServiceSubsettingArgsDict']]] = None,
            timeout_sec: Optional[pulumi.Input[_builtins.int]] = None) -> 'RegionBackendService':
        """
        Get an existing RegionBackendService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceBackendArgs', 'RegionBackendServiceBackendArgsDict']]]] backends: The set of backends that serve this RegionBackendService.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceCdnPolicyArgs', 'RegionBackendServiceCdnPolicyArgsDict']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceCircuitBreakersArgs', 'RegionBackendServiceCircuitBreakersArgsDict']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
               and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[Union['RegionBackendServiceConnectionTrackingPolicyArgs', 'RegionBackendServiceConnectionTrackingPolicyArgsDict']] connection_tracking_policy: Connection Tracking configuration for this BackendService.
               This is available only for Layer 4 Internal Load Balancing and
               Network Load Balancing.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceConsistentHashArgs', 'RegionBackendServiceConsistentHashArgsDict']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing.
               This field only applies when all of the following are true -
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionBackendServiceCustomMetricArgs', 'RegionBackendServiceCustomMetricArgsDict']]]] custom_metrics: List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Union['RegionBackendServiceDynamicForwardingArgs', 'RegionBackendServiceDynamicForwardingArgsDict']] dynamic_forwarding: Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
               feature which together with Service Extension allows customized and complex routing logic.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] enable_cdn: If true, enable Cloud CDN for this RegionBackendService.
        :param pulumi.Input[Union['RegionBackendServiceFailoverPolicyArgs', 'RegionBackendServiceFailoverPolicyArgsDict']] failover_policy: Policy for failovers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[_builtins.int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Union['RegionBackendServiceHaPolicyArgs', 'RegionBackendServiceHaPolicyArgsDict']] ha_policy: Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
               The backends of this regional backend service must only specify zonal network endpoint groups
               (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
               be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
               requires customers to be responsible for tracking backend endpoint health and electing a
               leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
               haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
               Passthrough Network Load Balancers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] health_checks: The set of URLs to HealthCheck resources for health checking
               this RegionBackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
        :param pulumi.Input[Union['RegionBackendServiceIapArgs', 'RegionBackendServiceIapArgsDict']] iap: Settings for enabling Cloud Identity Aware Proxy.
               If OAuth client is not set, Google-managed OAuth client is used.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] ip_address_selection_policy: Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
               Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        :param pulumi.Input[_builtins.str] load_balancing_scheme: Indicates what kind of load balancing this regional backend service
               will be used for. A backend service created for one type of load
               balancing cannot be used with the other(s). For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `INTERNAL`.
               Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        :param pulumi.Input[_builtins.str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
               * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
               is selected in round robin order.
               * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
               hosts and picks the host which has fewer active requests.
               * `RING_HASH`: The ring/modulo hash load balancer implements consistent
               hashing to backends. The algorithm has the property that the
               addition/removal of a host from a set of N hosts only affects
               1/N of the requests.
               * `RANDOM`: The load balancer selects a random healthy host.
               * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
               connection metadata, i.e., connections are opened
               to the same address as the destination address of
               the incoming connection before the connection
               was redirected to the load balancer.
               * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
               Maglev is not as stable as ring hash but has faster table lookup
               build times and host selection times. For more information about
               Maglev, refer to https://ai.google/research/pubs/pub44824
               * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
               reported weights. Only applicable to loadBalancingScheme
               EXTERNAL. If set, the Backend Service must
               configure a non legacy HTTP-based Health Check, and
               health check replies are expected to contain
               non-standard HTTP response header field
               X-Load-Balancing-Endpoint-Weight to specify the
               per-instance weights. If set, Load Balancing is weight
               based on the per-instance weights reported in the last
               processed health check replies, as long as every
               instance either reported a valid weight or had
               UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
               equal-weight.
               * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
               from Backend reported Custom Metrics. If set, the Backend Service
               responses are expected to contain non-standard HTTP response header field
               X-Endpoint-Load-Metrics. The reported metrics
               to use for computing the weights are specified via the
               backends[].customMetrics fields.
               locality_lb_policy is applicable to either:
               * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
               and loadBalancingScheme set to INTERNAL_MANAGED.
               * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
               Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
               Network Load Balancing. The default is MAGLEV.
               If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
               or RING_HASH, session affinity settings will not take effect.
               Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
               by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
               field set to true.
               Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        :param pulumi.Input[Union['RegionBackendServiceLogConfigArgs', 'RegionBackendServiceLogConfigArgsDict']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network: The URL of the network to which this backend service belongs.
               This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input[Union['RegionBackendServiceOutlierDetectionArgs', 'RegionBackendServiceOutlierDetectionArgsDict']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the `load_balancing_scheme` is set
               to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port_name: A named port on a backend instance group representing the port for
               communication to the backend VMs in that group. Required when the
               loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
               and the backends are instance groups. The named port must be defined on each
               backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
               default of "http" if not given.
               Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
               or GRPC. Refer to the documentation for the load balancers or for Traffic Director
               for more information.
               Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        :param pulumi.Input[_builtins.str] region: The Region in which the created backend service should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        :param pulumi.Input[Union['RegionBackendServiceStrongSessionAffinityCookieArgs', 'RegionBackendServiceStrongSessionAffinityCookieArgsDict']] strong_session_affinity_cookie: Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
               Structure is documented below.
        :param pulumi.Input[Union['RegionBackendServiceSubsettingArgs', 'RegionBackendServiceSubsettingArgsDict']] subsetting: Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer.
               For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
               The default is 30 seconds.
               The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionBackendServiceState.__new__(_RegionBackendServiceState)

        __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
        __props__.__dict__["backends"] = backends
        __props__.__dict__["cdn_policy"] = cdn_policy
        __props__.__dict__["circuit_breakers"] = circuit_breakers
        __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
        __props__.__dict__["connection_tracking_policy"] = connection_tracking_policy
        __props__.__dict__["consistent_hash"] = consistent_hash
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["custom_metrics"] = custom_metrics
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamic_forwarding"] = dynamic_forwarding
        __props__.__dict__["enable_cdn"] = enable_cdn
        __props__.__dict__["failover_policy"] = failover_policy
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["generated_id"] = generated_id
        __props__.__dict__["ha_policy"] = ha_policy
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["iap"] = iap
        __props__.__dict__["ip_address_selection_policy"] = ip_address_selection_policy
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["locality_lb_policy"] = locality_lb_policy
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["outlier_detection"] = outlier_detection
        __props__.__dict__["port_name"] = port_name
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["security_policy"] = security_policy
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["strong_session_affinity_cookie"] = strong_session_affinity_cookie
        __props__.__dict__["subsetting"] = subsetting
        __props__.__dict__["timeout_sec"] = timeout_sec
        return RegionBackendService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @_builtins.property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[Sequence['outputs.RegionBackendServiceBackend']]]:
        """
        The set of backends that serve this RegionBackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> pulumi.Output['outputs.RegionBackendServiceCdnPolicy']:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @_builtins.property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceCircuitBreakers']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the `load_balancing_scheme` is set to INTERNAL_MANAGED
        and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @_builtins.property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @_builtins.property
    @pulumi.getter(name="connectionTrackingPolicy")
    def connection_tracking_policy(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceConnectionTrackingPolicy']]:
        """
        Connection Tracking configuration for this BackendService.
        This is available only for Layer 4 Internal Load Balancing and
        Network Load Balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "connection_tracking_policy")

    @_builtins.property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceConsistentHash']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing.
        This field only applies when all of the following are true -
        """
        return pulumi.get(self, "consistent_hash")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.RegionBackendServiceCustomMetric']]]:
        """
        List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_metrics")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dynamicForwarding")
    def dynamic_forwarding(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceDynamicForwarding']]:
        """
        Dynamic forwarding configuration. This field is used to configure the backend service with dynamic forwarding
        feature which together with Service Extension allows customized and complex routing logic.
        Structure is documented below.
        """
        return pulumi.get(self, "dynamic_forwarding")

    @_builtins.property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, enable Cloud CDN for this RegionBackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @_builtins.property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceFailoverPolicy']]:
        """
        Policy for failovers.
        Structure is documented below.
        """
        return pulumi.get(self, "failover_policy")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @_builtins.property
    @pulumi.getter(name="haPolicy")
    def ha_policy(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceHaPolicy']]:
        """
        Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding.
        The backends of this regional backend service must only specify zonal network endpoint groups
        (NEGs) of type GCE_VM_IP. Note that haPolicy is not for load balancing, and therefore cannot
        be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy
        requires customers to be responsible for tracking backend endpoint health and electing a
        leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks.
        haPolicy can only be specified for External Passthrough Network Load Balancers and Internal
        Passthrough Network Load Balancers.
        Structure is documented below.
        """
        return pulumi.get(self, "ha_policy")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The set of URLs to HealthCheck resources for health checking
        this RegionBackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def iap(self) -> pulumi.Output['outputs.RegionBackendServiceIap']:
        """
        Settings for enabling Cloud Identity Aware Proxy.
        If OAuth client is not set, Google-managed OAuth client is used.
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @_builtins.property
    @pulumi.getter(name="ipAddressSelectionPolicy")
    def ip_address_selection_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies preference of traffic to the backend (from the proxy and from the client for proxyless gRPC).
        Possible values are: `IPV4_ONLY`, `PREFER_IPV6`, `IPV6_ONLY`.
        """
        return pulumi.get(self, "ip_address_selection_policy")

    @_builtins.property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates what kind of load balancing this regional backend service
        will be used for. A backend service created for one type of load
        balancing cannot be used with the other(s). For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `INTERNAL`.
        Possible values are: `EXTERNAL`, `EXTERNAL_MANAGED`, `INTERNAL`, `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @_builtins.property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        * `ROUND_ROBIN`: This is a simple policy in which each healthy backend
        is selected in round robin order.
        * `LEAST_REQUEST`: An O(1) algorithm which selects two random healthy
        hosts and picks the host which has fewer active requests.
        * `RING_HASH`: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects
        1/N of the requests.
        * `RANDOM`: The load balancer selects a random healthy host.
        * `ORIGINAL_DESTINATION`: Backend host is selected based on the client
        connection metadata, i.e., connections are opened
        to the same address as the destination address of
        the incoming connection before the connection
        was redirected to the load balancer.
        * `MAGLEV`: used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup
        build times and host selection times. For more information about
        Maglev, refer to https://ai.google/research/pubs/pub44824
        * `WEIGHTED_MAGLEV`: Per-instance weighted Load Balancing via health check
        reported weights. Only applicable to loadBalancingScheme
        EXTERNAL. If set, the Backend Service must
        configure a non legacy HTTP-based Health Check, and
        health check replies are expected to contain
        non-standard HTTP response header field
        X-Load-Balancing-Endpoint-Weight to specify the
        per-instance weights. If set, Load Balancing is weight
        based on the per-instance weights reported in the last
        processed health check replies, as long as every
        instance either reported a valid weight or had
        UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains
        equal-weight.
        * `WEIGHTED_ROUND_ROBIN`: Per-endpoint weighted round-robin Load Balancing using weights computed
        from Backend reported Custom Metrics. If set, the Backend Service
        responses are expected to contain non-standard HTTP response header field
        X-Endpoint-Load-Metrics. The reported metrics
        to use for computing the weights are specified via the
        backends[].customMetrics fields.
        locality_lb_policy is applicable to either:
        * A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C,
        and loadBalancingScheme set to INTERNAL_MANAGED.
        * A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        * A regional backend service with loadBalancingScheme set to EXTERNAL (External Network
        Load Balancing). Only MAGLEV and WEIGHTED_MAGLEV values are possible for External
        Network Load Balancing. The default is MAGLEV.
        If session_affinity is not NONE, and locality_lb_policy is not set to MAGLEV, WEIGHTED_MAGLEV,
        or RING_HASH, session affinity settings will not take effect.
        Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced
        by a URL map that is bound to target gRPC proxy that has validate_for_proxyless
        field set to true.
        Possible values are: `ROUND_ROBIN`, `LEAST_REQUEST`, `RING_HASH`, `RANDOM`, `ORIGINAL_DESTINATION`, `MAGLEV`, `WEIGHTED_MAGLEV`, `WEIGHTED_ROUND_ROBIN`.
        """
        return pulumi.get(self, "locality_lb_policy")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.RegionBackendServiceLogConfig']:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the network to which this backend service belongs.
        This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceOutlierDetection']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the `load_balancing_scheme` is set
        to INTERNAL_MANAGED and the `protocol` is set to HTTP, HTTPS, HTTP2 or H2C.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @_builtins.property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[_builtins.str]:
        """
        A named port on a backend instance group representing the port for
        communication to the backend VMs in that group. Required when the
        loadBalancingScheme is EXTERNAL, EXTERNAL_MANAGED, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
        and the backends are instance groups. The named port must be defined on each
        backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
        default of "http" if not given.
        Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
        """
        return pulumi.get(self, "port_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP
        or GRPC. Refer to the documentation for the load balancers or for Traffic Director
        for more information.
        Possible values are: `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, `UDP`, `GRPC`, `UNSPECIFIED`, `H2C`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region in which the created backend service should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[_builtins.str]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are: `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, `HTTP_COOKIE`, `CLIENT_IP_NO_DESTINATION`, `STRONG_COOKIE_AFFINITY`.
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter(name="strongSessionAffinityCookie")
    def strong_session_affinity_cookie(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceStrongSessionAffinityCookie']]:
        """
        Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
        Structure is documented below.
        """
        return pulumi.get(self, "strong_session_affinity_cookie")

    @_builtins.property
    @pulumi.getter
    def subsetting(self) -> pulumi.Output[Optional['outputs.RegionBackendServiceSubsetting']]:
        """
        Subsetting configuration for this BackendService. Currently this is applicable only for Internal TCP/UDP load balancing and Internal HTTP(S) load balancing.
        Structure is documented below.
        """
        return pulumi.get(self, "subsetting")

    @_builtins.property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[_builtins.int]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer.
        For more information see, [Backend service settings](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices).
        The default is 30 seconds.
        The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

