# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionNetworkFirewallPolicyWithRulesArgs', 'RegionNetworkFirewallPolicyWithRules']

@pulumi.input_type
class RegionNetworkFirewallPolicyWithRulesArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegionNetworkFirewallPolicyWithRules resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] name: User-provided name of the Network firewall policy.
               The name should be unique in the project in which the firewall policy is created.
               The name must be 1-63 characters long, and comply with RFC1035. Specifically,
               the name must be 1-63 characters long and match the regular expression a-z?
               which means the first character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Policy type is used to determine which resources (networks) the policy can be associated with.
               A policy can be associated with a network only if the network has the matching policyType in its network profile.
               Different policy types may support some of the Firewall Rules features.
               Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of this resource.
        """
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided name of the Network firewall policy.
        The name should be unique in the project in which the firewall policy is created.
        The name must be 1-63 characters long, and comply with RFC1035. Specifically,
        the name must be 1-63 characters long and match the regular expression a-z?
        which means the first character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy type is used to determine which resources (networks) the policy can be associated with.
        A policy can be associated with a network only if the network has the matching policyType in its network profile.
        Different policy types may support some of the Firewall Rules features.
        Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of this resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RegionNetworkFirewallPolicyWithRulesState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 predefined_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_tuple_count: Optional[pulumi.Input[_builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionNetworkFirewallPolicyWithRules resources.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of the resource. This field is used internally during updates of this resource.
        :param pulumi.Input[_builtins.str] name: User-provided name of the Network firewall policy.
               The name should be unique in the project in which the firewall policy is created.
               The name must be 1-63 characters long, and comply with RFC1035. Specifically,
               the name must be 1-63 characters long and match the regular expression a-z?
               which means the first character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] policy_type: Policy type is used to determine which resources (networks) the policy can be associated with.
               A policy can be associated with a network only if the network has the matching policyType in its network profile.
               Different policy types may support some of the Firewall Rules features.
               Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        :param pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs']]] predefined_rules: A list of firewall policy pre-defined rules.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of this resource.
        :param pulumi.Input[_builtins.int] rule_tuple_count: Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        :param pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if predefined_rules is not None:
            pulumi.set(__self__, "predefined_rules", predefined_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_tuple_count is not None:
            pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint of the resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided name of the Network firewall policy.
        The name should be unique in the project in which the firewall policy is created.
        The name must be 1-63 characters long, and comply with RFC1035. Specifically,
        the name must be 1-63 characters long and match the regular expression a-z?
        which means the first character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy type is used to determine which resources (networks) the policy can be associated with.
        A policy can be associated with a network only if the network has the matching policyType in its network profile.
        Different policy types may support some of the Firewall Rules features.
        Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter(name="predefinedRules")
    def predefined_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs']]]]:
        """
        A list of firewall policy pre-defined rules.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_rules")

    @predefined_rules.setter
    def predefined_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs']]]]):
        pulumi.set(self, "predefined_rules", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of this resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        """
        return pulumi.get(self, "rule_tuple_count")

    @rule_tuple_count.setter
    def rule_tuple_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rule_tuple_count", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]]]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionNetworkFirewallPolicyWithRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link_with_id", value)


@pulumi.type_token("gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules")
class RegionNetworkFirewallPolicyWithRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesRuleArgs', 'RegionNetworkFirewallPolicyWithRulesRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        The Compute NetworkFirewallPolicy with rules resource

        ## Example Usage

        ### Compute Region Network Firewall Policy With Rules Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        address_group1 = gcp.networksecurity.AddressGroup("address_group_1",
            name="address-group",
            parent=project.id,
            description="Regional address group",
            location="us-west2",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        secure_tag_key1 = gcp.tags.TagKey("secure_tag_key_1",
            description="Tag key",
            parent=project.id,
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "network": f"{project.name}/default",
            })
        secure_tag_value1 = gcp.tags.TagValue("secure_tag_value_1",
            description="Tag value",
            parent=secure_tag_key1.id,
            short_name="tag-value")
        primary = gcp.compute.RegionNetworkFirewallPolicyWithRules("primary",
            name="fw-policy",
            region="us-west2",
            description="Terraform test",
            rules=[
                {
                    "description": "tcp rule",
                    "priority": 1000,
                    "enable_logging": True,
                    "action": "allow",
                    "direction": "EGRESS",
                    "match": {
                        "dest_ip_ranges": ["11.100.0.1/32"],
                        "dest_fqdns": [
                            "www.yyy.com",
                            "www.zzz.com",
                        ],
                        "dest_region_codes": [
                            "HK",
                            "IN",
                        ],
                        "dest_threat_intelligences": [
                            "iplist-search-engines-crawlers",
                            "iplist-tor-exit-nodes",
                        ],
                        "dest_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                            "ports": [
                                "8080",
                                "7070",
                            ],
                        }],
                    },
                    "target_secure_tags": [{
                        "name": secure_tag_value1.id,
                    }],
                },
                {
                    "description": "udp rule",
                    "rule_name": "test-rule",
                    "priority": 2000,
                    "enable_logging": False,
                    "action": "deny",
                    "direction": "INGRESS",
                    "disabled": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "src_fqdns": [
                            "www.abc.com",
                            "www.def.com",
                        ],
                        "src_region_codes": [
                            "US",
                            "CA",
                        ],
                        "src_threat_intelligences": [
                            "iplist-known-malicious-ips",
                            "iplist-public-clouds",
                        ],
                        "src_address_groups": [address_group1.id],
                        "src_secure_tags": [{
                            "name": secure_tag_value1.id,
                        }],
                        "layer4_configs": [{
                            "ip_protocol": "udp",
                        }],
                    },
                },
            ])
        ```
        ### Compute Region Network Firewall Policy With Rules Roce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.RegionNetworkFirewallPolicyWithRules("policy",
            name="rnf-policy",
            description="Terraform test",
            policy_type="RDMA_ROCE_POLICY",
            rules=[{
                "description": "deny all rule",
                "priority": 1000,
                "enable_logging": True,
                "action": "deny",
                "direction": "INGRESS",
                "match": {
                    "src_ip_ranges": ["0.0.0.0/0"],
                    "layer4_configs": [{
                        "ip_protocol": "all",
                    }],
                },
            }])
        ```

        ## Import

        RegionNetworkFirewallPolicyWithRules can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/firewallPolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionNetworkFirewallPolicyWithRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default projects/{{project}}/regions/{{region}}/firewallPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] name: User-provided name of the Network firewall policy.
               The name should be unique in the project in which the firewall policy is created.
               The name must be 1-63 characters long, and comply with RFC1035. Specifically,
               the name must be 1-63 characters long and match the regular expression a-z?
               which means the first character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] policy_type: Policy type is used to determine which resources (networks) the policy can be associated with.
               A policy can be associated with a network only if the network has the matching policyType in its network profile.
               Different policy types may support some of the Firewall Rules features.
               Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesRuleArgs', 'RegionNetworkFirewallPolicyWithRulesRuleArgsDict']]]] rules: A list of firewall policy rules.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionNetworkFirewallPolicyWithRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Compute NetworkFirewallPolicy with rules resource

        ## Example Usage

        ### Compute Region Network Firewall Policy With Rules Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        address_group1 = gcp.networksecurity.AddressGroup("address_group_1",
            name="address-group",
            parent=project.id,
            description="Regional address group",
            location="us-west2",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        secure_tag_key1 = gcp.tags.TagKey("secure_tag_key_1",
            description="Tag key",
            parent=project.id,
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "network": f"{project.name}/default",
            })
        secure_tag_value1 = gcp.tags.TagValue("secure_tag_value_1",
            description="Tag value",
            parent=secure_tag_key1.id,
            short_name="tag-value")
        primary = gcp.compute.RegionNetworkFirewallPolicyWithRules("primary",
            name="fw-policy",
            region="us-west2",
            description="Terraform test",
            rules=[
                {
                    "description": "tcp rule",
                    "priority": 1000,
                    "enable_logging": True,
                    "action": "allow",
                    "direction": "EGRESS",
                    "match": {
                        "dest_ip_ranges": ["11.100.0.1/32"],
                        "dest_fqdns": [
                            "www.yyy.com",
                            "www.zzz.com",
                        ],
                        "dest_region_codes": [
                            "HK",
                            "IN",
                        ],
                        "dest_threat_intelligences": [
                            "iplist-search-engines-crawlers",
                            "iplist-tor-exit-nodes",
                        ],
                        "dest_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                            "ports": [
                                "8080",
                                "7070",
                            ],
                        }],
                    },
                    "target_secure_tags": [{
                        "name": secure_tag_value1.id,
                    }],
                },
                {
                    "description": "udp rule",
                    "rule_name": "test-rule",
                    "priority": 2000,
                    "enable_logging": False,
                    "action": "deny",
                    "direction": "INGRESS",
                    "disabled": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "src_fqdns": [
                            "www.abc.com",
                            "www.def.com",
                        ],
                        "src_region_codes": [
                            "US",
                            "CA",
                        ],
                        "src_threat_intelligences": [
                            "iplist-known-malicious-ips",
                            "iplist-public-clouds",
                        ],
                        "src_address_groups": [address_group1.id],
                        "src_secure_tags": [{
                            "name": secure_tag_value1.id,
                        }],
                        "layer4_configs": [{
                            "ip_protocol": "udp",
                        }],
                    },
                },
            ])
        ```
        ### Compute Region Network Firewall Policy With Rules Roce

        ```python
        import pulumi
        import pulumi_gcp as gcp

        policy = gcp.compute.RegionNetworkFirewallPolicyWithRules("policy",
            name="rnf-policy",
            description="Terraform test",
            policy_type="RDMA_ROCE_POLICY",
            rules=[{
                "description": "deny all rule",
                "priority": 1000,
                "enable_logging": True,
                "action": "deny",
                "direction": "INGRESS",
                "match": {
                    "src_ip_ranges": ["0.0.0.0/0"],
                    "layer4_configs": [{
                        "ip_protocol": "all",
                    }],
                },
            }])
        ```

        ## Import

        RegionNetworkFirewallPolicyWithRules can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/firewallPolicies/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionNetworkFirewallPolicyWithRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default projects/{{project}}/regions/{{region}}/firewallPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionNetworkFirewallPolicyWithRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionNetworkFirewallPolicyWithRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesRuleArgs', 'RegionNetworkFirewallPolicyWithRulesRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionNetworkFirewallPolicyWithRulesArgs.__new__(RegionNetworkFirewallPolicyWithRulesArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["network_firewall_policy_id"] = None
            __props__.__dict__["predefined_rules"] = None
            __props__.__dict__["rule_tuple_count"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["self_link_with_id"] = None
        super(RegionNetworkFirewallPolicyWithRules, __self__).__init__(
            'gcp:compute/regionNetworkFirewallPolicyWithRules:RegionNetworkFirewallPolicyWithRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            predefined_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs', 'RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rule_tuple_count: Optional[pulumi.Input[_builtins.int]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesRuleArgs', 'RegionNetworkFirewallPolicyWithRulesRuleArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            self_link_with_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionNetworkFirewallPolicyWithRules':
        """
        Get an existing RegionNetworkFirewallPolicyWithRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint of the resource. This field is used internally during updates of this resource.
        :param pulumi.Input[_builtins.str] name: User-provided name of the Network firewall policy.
               The name should be unique in the project in which the firewall policy is created.
               The name must be 1-63 characters long, and comply with RFC1035. Specifically,
               the name must be 1-63 characters long and match the regular expression a-z?
               which means the first character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] policy_type: Policy type is used to determine which resources (networks) the policy can be associated with.
               A policy can be associated with a network only if the network has the matching policyType in its network profile.
               Different policy types may support some of the Firewall Rules features.
               Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgs', 'RegionNetworkFirewallPolicyWithRulesPredefinedRuleArgsDict']]]] predefined_rules: A list of firewall policy pre-defined rules.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of this resource.
        :param pulumi.Input[_builtins.int] rule_tuple_count: Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionNetworkFirewallPolicyWithRulesRuleArgs', 'RegionNetworkFirewallPolicyWithRulesRuleArgsDict']]]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[_builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionNetworkFirewallPolicyWithRulesState.__new__(_RegionNetworkFirewallPolicyWithRulesState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["predefined_rules"] = predefined_rules
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_tuple_count"] = rule_tuple_count
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["self_link_with_id"] = self_link_with_id
        return RegionNetworkFirewallPolicyWithRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint of the resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        User-provided name of the Network firewall policy.
        The name should be unique in the project in which the firewall policy is created.
        The name must be 1-63 characters long, and comply with RFC1035. Specifically,
        the name must be 1-63 characters long and match the regular expression a-z?
        which means the first character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Policy type is used to determine which resources (networks) the policy can be associated with.
        A policy can be associated with a network only if the network has the matching policyType in its network profile.
        Different policy types may support some of the Firewall Rules features.
        Possible values are: `VPC_POLICY`, `RDMA_ROCE_POLICY`.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="predefinedRules")
    def predefined_rules(self) -> pulumi.Output[Sequence['outputs.RegionNetworkFirewallPolicyWithRulesPredefinedRule']]:
        """
        A list of firewall policy pre-defined rules.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_rules")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of this resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> pulumi.Output[_builtins.int]:
        """
        Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        """
        return pulumi.get(self, "rule_tuple_count")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.RegionNetworkFirewallPolicyWithRulesRule']]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[_builtins.str]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

