# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionSecurityPolicyRuleInitArgs', 'RegionSecurityPolicyRule']

@pulumi.input_type
class RegionSecurityPolicyRuleInitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 region: pulumi.Input[_builtins.str],
                 security_policy: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']] = None,
                 network_match: Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']] = None,
                 preconfigured_waf_config: Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']] = None,
                 preview: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_options: Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']] = None):
        """
        The set of arguments for constructing a RegionSecurityPolicyRule resource.
        :param pulumi.Input[_builtins.str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[_builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[_builtins.str] region: The Region in which the created Region Security Policy rule should reside.
        :param pulumi.Input[_builtins.str] security_policy: The name of the security policy this rule belongs to.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['RegionSecurityPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs'] network_match: A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
               The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
               Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
               Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
               For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
               Example:
               networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
               The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
               Structure is documented below.
        :param pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs'] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs'] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_policy", security_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if network_match is not None:
            pulumi.set(__self__, "network_match", network_match)
        if preconfigured_waf_config is not None:
            pulumi.set(__self__, "preconfigured_waf_config", preconfigured_waf_config)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rate_limit_options is not None:
            pulumi.set(__self__, "rate_limit_options", rate_limit_options)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The Region in which the created Region Security Policy rule should reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the security policy this rule belongs to.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="networkMatch")
    def network_match(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']]:
        """
        A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
        The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
        Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
        Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
        For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
        Example:
        networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
        The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
        Structure is documented below.
        """
        return pulumi.get(self, "network_match")

    @network_match.setter
    def network_match(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']]):
        pulumi.set(self, "network_match", value)

    @_builtins.property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @preconfigured_waf_config.setter
    def preconfigured_waf_config(self, value: Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']]):
        pulumi.set(self, "preconfigured_waf_config", value)

    @_builtins.property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preview", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @rate_limit_options.setter
    def rate_limit_options(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']]):
        pulumi.set(self, "rate_limit_options", value)


@pulumi.input_type
class _RegionSecurityPolicyRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']] = None,
                 network_match: Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']] = None,
                 preconfigured_waf_config: Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']] = None,
                 preview: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_options: Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionSecurityPolicyRule resources.
        :param pulumi.Input[_builtins.str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['RegionSecurityPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs'] network_match: A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
               The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
               Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
               Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
               For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
               Example:
               networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
               The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
               Structure is documented below.
        :param pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs'] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[_builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs'] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The Region in which the created Region Security Policy rule should reside.
        :param pulumi.Input[_builtins.str] security_policy: The name of the security policy this rule belongs to.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if network_match is not None:
            pulumi.set(__self__, "network_match", network_match)
        if preconfigured_waf_config is not None:
            pulumi.set(__self__, "preconfigured_waf_config", preconfigured_waf_config)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rate_limit_options is not None:
            pulumi.set(__self__, "rate_limit_options", rate_limit_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="networkMatch")
    def network_match(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']]:
        """
        A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
        The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
        Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
        Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
        For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
        Example:
        networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
        The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
        Structure is documented below.
        """
        return pulumi.get(self, "network_match")

    @network_match.setter
    def network_match(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleNetworkMatchArgs']]):
        pulumi.set(self, "network_match", value)

    @_builtins.property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @preconfigured_waf_config.setter
    def preconfigured_waf_config(self, value: Optional[pulumi.Input['RegionSecurityPolicyRulePreconfiguredWafConfigArgs']]):
        pulumi.set(self, "preconfigured_waf_config", value)

    @_builtins.property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preview", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @rate_limit_options.setter
    def rate_limit_options(self, value: Optional[pulumi.Input['RegionSecurityPolicyRuleRateLimitOptionsArgs']]):
        pulumi.set(self, "rate_limit_options", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created Region Security Policy rule should reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security policy this rule belongs to.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy", value)


@pulumi.type_token("gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule")
class RegionSecurityPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleMatchArgs', 'RegionSecurityPolicyRuleMatchArgsDict']]] = None,
                 network_match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleNetworkMatchArgs', 'RegionSecurityPolicyRuleNetworkMatchArgsDict']]] = None,
                 preconfigured_waf_config: Optional[pulumi.Input[Union['RegionSecurityPolicyRulePreconfiguredWafConfigArgs', 'RegionSecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
                 preview: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_options: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleRateLimitOptionsArgs', 'RegionSecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A rule for the RegionSecurityPolicy.

        To get more information about RegionSecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionSecurityPolicies/addRule)
        * How-to Guides
            * [Creating region security policy rules](https://cloud.google.com/armor/docs/configure-security-policies)

        ## Example Usage

        ### Region Security Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policyruletest",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule Multiple Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policywithmultiplerules",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule_one = gcp.compute.RegionSecurityPolicyRule("policy_rule_one",
            region="us-west2",
            security_policy=default.name,
            description="new rule one",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        policy_rule_two = gcp.compute.RegionSecurityPolicyRule("policy_rule_two",
            region="us-west2",
            security_policy=default.name,
            description="new rule two",
            priority=101,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": [
                        "192.168.0.0/16",
                        "10.0.0.0/8",
                    ],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule Default Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policywithdefaultrule",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        default_rule = gcp.compute.RegionSecurityPolicyRule("default_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            action="deny",
            priority=2147483647,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["*"],
                },
            })
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule With Preconfigured Waf Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="asia-southeast1",
            name="policyruletest",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="asia-southeast1",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            preconfigured_waf_config={
                "exclusions": [
                    {
                        "request_uris": [{
                            "operator": "STARTS_WITH",
                            "value": "/admin",
                        }],
                        "target_rule_set": "rce-stable",
                    },
                    {
                        "request_query_params": [
                            {
                                "operator": "CONTAINS",
                                "value": "password",
                            },
                            {
                                "operator": "STARTS_WITH",
                                "value": "freeform",
                            },
                            {
                                "operator": "EQUALS",
                                "value": "description",
                            },
                        ],
                        "target_rule_set": "xss-stable",
                        "target_rule_ids": [
                            "owasp-crs-v030001-id941330-xss",
                            "owasp-crs-v030001-id941340-xss",
                        ],
                    },
                ],
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule With Network Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # First activate advanced network DDoS protection for the desired region
        policyddosprotection = gcp.compute.RegionSecurityPolicy("policyddosprotection",
            region="us-west2",
            name="policyddosprotection",
            description="policy for activating network DDoS protection for the desired region",
            type="CLOUD_ARMOR_NETWORK",
            ddos_protection_config={
                "ddos_protection": "ADVANCED_PREVIEW",
            })
        edge_sec_service = gcp.compute.NetworkEdgeSecurityService("edge_sec_service",
            region="us-west2",
            name="edgesecservice",
            description="linking policy to edge security service",
            security_policy=policyddosprotection.self_link)
        # Add the desired policy and custom rule.
        policynetworkmatch = gcp.compute.RegionSecurityPolicy("policynetworkmatch",
            region="us-west2",
            name="policyfornetworkmatch",
            description="region security policy for network match",
            type="CLOUD_ARMOR_NETWORK",
            user_defined_fields=[{
                "name": "SIG1_AT_0",
                "base": "TCP",
                "offset": 8,
                "size": 2,
                "mask": "0x8F00",
            }],
            opts = pulumi.ResourceOptions(depends_on=[edge_sec_service]))
        policy_rule_network_match = gcp.compute.RegionSecurityPolicyRule("policy_rule_network_match",
            region="us-west2",
            security_policy=policynetworkmatch.name,
            description="custom rule for network match",
            priority=100,
            network_match={
                "src_ip_ranges": ["10.10.0.0/16"],
                "user_defined_fields": [{
                    "name": "SIG1_AT_0",
                    "values": ["0x8F00"],
                }],
            },
            action="allow",
            preview=True)
        ```

        ## Import

        RegionSecurityPolicyRule can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/securityPolicies/{{security_policy}}/priority/{{priority}}`

        * `{{project}}/{{region}}/{{security_policy}}/{{priority}}`

        * `{{region}}/{{security_policy}}/{{priority}}`

        * `{{security_policy}}/{{priority}}`

        When using the `pulumi import` command, RegionSecurityPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default projects/{{project}}/regions/{{region}}/securityPolicies/{{security_policy}}/priority/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{project}}/{{region}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{region}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{security_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleMatchArgs', 'RegionSecurityPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleNetworkMatchArgs', 'RegionSecurityPolicyRuleNetworkMatchArgsDict']] network_match: A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
               The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
               Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
               Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
               For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
               Example:
               networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
               The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
               Structure is documented below.
        :param pulumi.Input[Union['RegionSecurityPolicyRulePreconfiguredWafConfigArgs', 'RegionSecurityPolicyRulePreconfiguredWafConfigArgsDict']] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[_builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleRateLimitOptionsArgs', 'RegionSecurityPolicyRuleRateLimitOptionsArgsDict']] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The Region in which the created Region Security Policy rule should reside.
        :param pulumi.Input[_builtins.str] security_policy: The name of the security policy this rule belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionSecurityPolicyRuleInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A rule for the RegionSecurityPolicy.

        To get more information about RegionSecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionSecurityPolicies/addRule)
        * How-to Guides
            * [Creating region security policy rules](https://cloud.google.com/armor/docs/configure-security-policies)

        ## Example Usage

        ### Region Security Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policyruletest",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule Multiple Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policywithmultiplerules",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule_one = gcp.compute.RegionSecurityPolicyRule("policy_rule_one",
            region="us-west2",
            security_policy=default.name,
            description="new rule one",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        policy_rule_two = gcp.compute.RegionSecurityPolicyRule("policy_rule_two",
            region="us-west2",
            security_policy=default.name,
            description="new rule two",
            priority=101,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": [
                        "192.168.0.0/16",
                        "10.0.0.0/8",
                    ],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule Default Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="us-west2",
            name="policywithdefaultrule",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        default_rule = gcp.compute.RegionSecurityPolicyRule("default_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            action="deny",
            priority=2147483647,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["*"],
                },
            })
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="us-west2",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule With Preconfigured Waf Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionSecurityPolicy("default",
            region="asia-southeast1",
            name="policyruletest",
            description="basic region security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.RegionSecurityPolicyRule("policy_rule",
            region="asia-southeast1",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            preconfigured_waf_config={
                "exclusions": [
                    {
                        "request_uris": [{
                            "operator": "STARTS_WITH",
                            "value": "/admin",
                        }],
                        "target_rule_set": "rce-stable",
                    },
                    {
                        "request_query_params": [
                            {
                                "operator": "CONTAINS",
                                "value": "password",
                            },
                            {
                                "operator": "STARTS_WITH",
                                "value": "freeform",
                            },
                            {
                                "operator": "EQUALS",
                                "value": "description",
                            },
                        ],
                        "target_rule_set": "xss-stable",
                        "target_rule_ids": [
                            "owasp-crs-v030001-id941330-xss",
                            "owasp-crs-v030001-id941340-xss",
                        ],
                    },
                ],
            },
            action="allow",
            preview=True)
        ```
        ### Region Security Policy Rule With Network Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # First activate advanced network DDoS protection for the desired region
        policyddosprotection = gcp.compute.RegionSecurityPolicy("policyddosprotection",
            region="us-west2",
            name="policyddosprotection",
            description="policy for activating network DDoS protection for the desired region",
            type="CLOUD_ARMOR_NETWORK",
            ddos_protection_config={
                "ddos_protection": "ADVANCED_PREVIEW",
            })
        edge_sec_service = gcp.compute.NetworkEdgeSecurityService("edge_sec_service",
            region="us-west2",
            name="edgesecservice",
            description="linking policy to edge security service",
            security_policy=policyddosprotection.self_link)
        # Add the desired policy and custom rule.
        policynetworkmatch = gcp.compute.RegionSecurityPolicy("policynetworkmatch",
            region="us-west2",
            name="policyfornetworkmatch",
            description="region security policy for network match",
            type="CLOUD_ARMOR_NETWORK",
            user_defined_fields=[{
                "name": "SIG1_AT_0",
                "base": "TCP",
                "offset": 8,
                "size": 2,
                "mask": "0x8F00",
            }],
            opts = pulumi.ResourceOptions(depends_on=[edge_sec_service]))
        policy_rule_network_match = gcp.compute.RegionSecurityPolicyRule("policy_rule_network_match",
            region="us-west2",
            security_policy=policynetworkmatch.name,
            description="custom rule for network match",
            priority=100,
            network_match={
                "src_ip_ranges": ["10.10.0.0/16"],
                "user_defined_fields": [{
                    "name": "SIG1_AT_0",
                    "values": ["0x8F00"],
                }],
            },
            action="allow",
            preview=True)
        ```

        ## Import

        RegionSecurityPolicyRule can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/securityPolicies/{{security_policy}}/priority/{{priority}}`

        * `{{project}}/{{region}}/{{security_policy}}/{{priority}}`

        * `{{region}}/{{security_policy}}/{{priority}}`

        * `{{security_policy}}/{{priority}}`

        When using the `pulumi import` command, RegionSecurityPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default projects/{{project}}/regions/{{region}}/securityPolicies/{{security_policy}}/priority/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{project}}/{{region}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{region}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule default {{security_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionSecurityPolicyRuleInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionSecurityPolicyRuleInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleMatchArgs', 'RegionSecurityPolicyRuleMatchArgsDict']]] = None,
                 network_match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleNetworkMatchArgs', 'RegionSecurityPolicyRuleNetworkMatchArgsDict']]] = None,
                 preconfigured_waf_config: Optional[pulumi.Input[Union['RegionSecurityPolicyRulePreconfiguredWafConfigArgs', 'RegionSecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
                 preview: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit_options: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleRateLimitOptionsArgs', 'RegionSecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionSecurityPolicyRuleInitArgs.__new__(RegionSecurityPolicyRuleInitArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["match"] = match
            __props__.__dict__["network_match"] = network_match
            __props__.__dict__["preconfigured_waf_config"] = preconfigured_waf_config
            __props__.__dict__["preview"] = preview
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["rate_limit_options"] = rate_limit_options
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if security_policy is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy'")
            __props__.__dict__["security_policy"] = security_policy
        super(RegionSecurityPolicyRule, __self__).__init__(
            'gcp:compute/regionSecurityPolicyRule:RegionSecurityPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleMatchArgs', 'RegionSecurityPolicyRuleMatchArgsDict']]] = None,
            network_match: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleNetworkMatchArgs', 'RegionSecurityPolicyRuleNetworkMatchArgsDict']]] = None,
            preconfigured_waf_config: Optional[pulumi.Input[Union['RegionSecurityPolicyRulePreconfiguredWafConfigArgs', 'RegionSecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
            preview: Optional[pulumi.Input[_builtins.bool]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            rate_limit_options: Optional[pulumi.Input[Union['RegionSecurityPolicyRuleRateLimitOptionsArgs', 'RegionSecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_policy: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionSecurityPolicyRule':
        """
        Get an existing RegionSecurityPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleMatchArgs', 'RegionSecurityPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleNetworkMatchArgs', 'RegionSecurityPolicyRuleNetworkMatchArgsDict']] network_match: A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
               The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
               Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
               Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
               For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
               Example:
               networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
               The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
               Structure is documented below.
        :param pulumi.Input[Union['RegionSecurityPolicyRulePreconfiguredWafConfigArgs', 'RegionSecurityPolicyRulePreconfiguredWafConfigArgsDict']] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[_builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RegionSecurityPolicyRuleRateLimitOptionsArgs', 'RegionSecurityPolicyRuleRateLimitOptionsArgsDict']] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The Region in which the created Region Security Policy rule should reside.
        :param pulumi.Input[_builtins.str] security_policy: The name of the security policy this rule belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionSecurityPolicyRuleState.__new__(_RegionSecurityPolicyRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["match"] = match
        __props__.__dict__["network_match"] = network_match
        __props__.__dict__["preconfigured_waf_config"] = preconfigured_waf_config
        __props__.__dict__["preview"] = preview
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["rate_limit_options"] = rate_limit_options
        __props__.__dict__["region"] = region
        __props__.__dict__["security_policy"] = security_policy
        return RegionSecurityPolicyRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Output[Optional['outputs.RegionSecurityPolicyRuleMatch']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="networkMatch")
    def network_match(self) -> pulumi.Output[Optional['outputs.RegionSecurityPolicyRuleNetworkMatch']]:
        """
        A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced.
        The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields').
        Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds.
        Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all.
        For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet.
        Example:
        networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff"
        The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive
        Structure is documented below.
        """
        return pulumi.get(self, "network_match")

    @_builtins.property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> pulumi.Output[Optional['outputs.RegionSecurityPolicyRulePreconfiguredWafConfig']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @_builtins.property
    @pulumi.getter
    def preview(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> pulumi.Output[Optional['outputs.RegionSecurityPolicyRuleRateLimitOptions']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region in which the created Region Security Policy rule should reside.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security policy this rule belongs to.
        """
        return pulumi.get(self, "security_policy")

